/*
 * Common async queue handling code for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

/* exported types */

enum node_cfm_number {
	ID_Get_Device_Name_CFM,
	ID_HF_Dial_CFM,
	ID_HF_Redial_CFM,
	ID_HF_Mem_Dial_CFM,
	ID_HF_Terminate_Call_CFM,
	ID_HF_Terminate_All_CFM,
	ID_HF_Audio_Transfer_CFM,
	ID_HF_Send_DTMF_CFM,
	ID_HF_Incoming_Call_Act_CFM,
	ID_HF_Release_Inactive_Call_CFM,
	ID_HF_Release_Active_Call_CFM,
	ID_HF_Swap_Call_CFM,
	ID_HF_Add_Call_CFM,
	ID_HF_Release_Spec_Call_CFM,
	ID_HF_Hold_Excep_Call_CFM,
	ID_HF_Exp_Call_Trans_CFM,
	ID_HF_Subscriber_CFM,
	ID_HF_Manufacturer_ID_CFM,
	ID_HF_Model_ID_CFM,
	ID_HF_Revision_ID_CFM,
	ID_HF_Voice_Recognition_Activation_CFM,
	ID_APPL_SIRI_XAPL_CFM,
	ID_APPL_SIRI_NrStat_CFM,
	ID_APPL_SIRI_EFM_CFM,
	ID_HF_Release_Waiting_Call,
	ID_AVP_Ctrl_Cmd_CFM,
	ID_AVP_Get_Capabilities_CFM,
	ID_AVP_List_Attr_CFM,
	ID_AVP_List_Val_CFM,
	ID_AVP_Set_Val_CFM,
	ID_AVP_Set_Player_CFM,
	ID_AVP_Get_Metadata_Attr_CFM,
	ID_AVP_Get_Folder_Item_CFM,
	ID_AVP_Get_Media_Player_Item_CFM,
	ID_AVP_Get_Media_Player_Item_IND,	/* FIXME: not a CFM */
	ID_AVP_Change_Path_CFM,
	ID_AVP_Play_Item_CFM,
	ID_PBDL_Get_Capabilities_CFM,
	ID_PBDL_Prepare_CFM,
	ID_PBDL_Start_CFM,
	ID_PBDL_Stop_CFM,
	ID_PBDL_Complete_CFM,
	ID_MAP_Get_Capabilities_CFM,
	ID_MAP_Start_CFM,
	ID_MAP_Stop_CFM,
	ID_MAP_Chg_Instance_CFM,
	ID_MAP_Update_Inbox_CFM,
	ID_MAP_List_Folder_CFM,
	ID_MAP_List_Msg_CFM,
	ID_MAP_Read_Msg_CFM,
	ID_MAP_Upload_CFM,
	ID_MAP_Set_Msg_Status_CFM,
	ID_MAP_Abort_CFM,
	ID_NAP_Create_Device_CFM,
	ID_NAP_Destroy_Device_CFM,
	ID_validation_test_mode_CFM,
	ID_validation_link_quality_CFM,
	ID_total
};

struct async_queue_list {
	/* holds the node async queue list (aql)*/
	GSList *node_aql;
};

/* record of node queue entry */
struct node_queue_entry {
	struct async_queue_list *queue_info;
	enum node_cfm_number cfm_id;
	DBusGMethodInvocation *context;
	GSource *gsource_info;
};


/* exported functions */
extern void utils_async_queue_initialise(struct async_queue_list *queue_info);

extern void utils_async_queue_destroy(struct async_queue_list *queue_info);

extern void utils_async_queue_add_list_entry(struct async_queue_list *queue_info,
						DBusGMethodInvocation *context,
						enum node_cfm_number cfm_id);

extern DBusGMethodInvocation *utils_async_queue_find_list_entry(
					struct async_queue_list *queue_info,
					enum node_cfm_number cfm_id);


