/*
 * node_agent.h
 * Agent node handling for the D-bus Bluetooth Daemon.
 * The Bluetooth daemon is a client, not the server, of the agent node.
 *
 * Author: Andy Lowe <alowe@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

#ifndef _NODE_AGENT_H
#define _NODE_AGENT_H

#define AGENT_SERVICE_NAME "com.alps.bt.Agent"
#define AGENT_SERVICE_OBJECT_PATH "/"
#define AGENT_SERVICE_INTERFACE "com.alps.bt.Agent"

extern int create_agent_dbus_proxy(DBusGConnection * bus);
extern void do_agent_callback_wrapper(callback_data * data);
extern void do_agent_ssp_numeric_confirm_ind_wrapper(callback_data *data);
extern void do_agent_connection_request_ind_wrapper(callback_data *data);

#endif /* ifndef _NODE_AGENT_H */
