/*
 * dummy bt_appl handling for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

#ifdef USE_DUMMY_API

enum function_number {
	/* Manager functions */
	FUNC_Initialization_REQ,
	FUNC_Shutdown_REQ,
	FUNC_Set_Configuration_REQ,
	FUNC_Read_Configuration_REQ,

	/* Adapter functions */
	FUNC_Start_Connection_REQ,
	FUNC_Start_Wait_Connection_REQ,
	FUNC_Stop_Wait_Connection_REQ,
	FUNC_Set_Local_Name_REQ,
	FUNC_Set_Mode_REQ,
	FUNC_Set_SSP_Mode_REQ,
	FUNC_Start_Pairing_REQ,
	FUNC_Stop_Pairing_REQ,
	FUNC_Set_Serial_Device_Param_REQ,
	FUNC_NAP_Create_Device_REQ,
	FUNC_NAP_Destroy_Device_REQ,
	FUNC_Service_Search_REQ,
	FUNC_SSP_Numeric_Confirm_RES,
	FUNC_Connection_Request_RES,

	/* Device functions */
	FUNC_Get_Device_Name_REQ,
	FUNC_Disconnection_REQ,
	FUNC_Get_Local_Role_REQ,
	FUNC_Set_Local_Role_REQ,
	FUNC_Get_Call_Status_REQ,
	FUNC_Get_Phone_Status_REQ,
	FUNC_HF_Dial_REQ,
	FUNC_HF_Redial_REQ,
	FUNC_HF_Mem_Dial_REQ,
	FUNC_HF_Terminate_Call_REQ,
	FUNC_HF_Terminate_All_REQ,
	FUNC_HF_Audio_Transfer_REQ,
	FUNC_HF_Send_DTMF_REQ,
	FUNC_HF_Incoming_Call_Act_REQ,
	FUNC_HF_Release_Inactive_Call_REQ,
	FUNC_HF_Release_Active_Call_REQ,
	FUNC_HF_Swap_Call_REQ,
	FUNC_HF_Add_Call_REQ,
	FUNC_HF_Release_Spec_Call_REQ,
	FUNC_HF_Hold_Excep_Call_REQ,
	FUNC_HF_Exp_Call_Trans_REQ,
	FUNC_HF_Subscriber_REQ,
	FUNC_HF_Manufacturer_ID_REQ,
	FUNC_HF_Model_ID_REQ,
	FUNC_HF_Revision_ID_REQ,
	FUNC_HF_Voice_Recognition_Activation_REQ,
	FUNC_AVP_Ctrl_Cmd_REQ,
	FUNC_AVP_Get_Capabilities_REQ,
	FUNC_AVP_List_Attr_REQ,
	FUNC_AVP_List_Val_REQ,
	FUNC_AVP_Set_Val_REQ,
	FUNC_AVP_Config_Notify_REQ,
	FUNC_AVP_Set_Player_REQ,
	FUNC_AVP_Get_Metadata_Attr_REQ,
	FUNC_AVP_Get_Folder_Item_REQ,
	FUNC_AVP_Get_Media_Player_Item_REQ,
	FUNC_AVP_Play_Item_REQ,
	FUNC_AVP_Change_Path_REQ,
	FUNC_PBDL_Get_Capabilities_REQ,
	FUNC_PBDL_Prepare_REQ,
	FUNC_PBDL_Start_REQ,
	FUNC_PBDL_Stop_REQ,
	FUNC_PBDL_Complete_REQ,
	FUNC_MAP_Get_Capabilities_REQ,
	FUNC_MAP_Start_REQ,
	FUNC_MAP_Stop_REQ,
	FUNC_MAP_Chg_Instance_REQ,
	FUNC_MAP_Update_Inbox_REQ,
	FUNC_MAP_List_Folder_REQ,
	FUNC_MAP_List_Msg_REQ,
	FUNC_MAP_Read_Msg_REQ,
	FUNC_MAP_Set_Msg_Status_REQ,
	FUNC_MAP_Abort_REQ,
	FUNC_MAP_Upload_REQ,
	FUNC_MAP_Upload_RES,

	/* Validation functions */
	FUNC_TestMode_REQ,
	FUNC_LinkQuality_REQ,

	/* miscellaneous functions */
	FUNC_register_alps_callbacks,

	FUNC_total
};

extern gchar *dummy_get_func_name(enum function_number func_id);

extern gboolean dummy_get_dummy_state(enum function_number func_id);

extern guint32 dummy_get_return_code(enum function_number func_id);

extern void dummy_init_scenarios(void);

extern void dummy_change_dummy_api_settings(enum function_number func_id, gboolean use_dummy_api, BTHRESULT return_code);

extern BTHRESULT register_alps_callbacks_DUMMY(void);

/* Test node */
extern void dummy_use_all_dummy_api_functions(gboolean use_dummy_api);

/* Manager node */
extern BTHRESULT BT_APPL_Initialization_REQ_DUMMY(OUT u16 *pusVersion,OUT BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_Shutdown_REQ_DUMMY(void);

extern BTHRESULT BT_APPL_Set_Configuration_REQ_DUMMY(IN u16 usConfigId,IN u16 usConfigDataLen,IN u8 *pucConfigData);

extern BTHRESULT BT_APPL_Read_Configuration_REQ_DUMMY(IN u16 usConfigId,OUT u16 *pusConfigDataLen,OUT u8 *pucConfigData);

/* Adapter node */
extern BTHRESULT BT_APPL_Start_Connection_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR,IN u8 ucService);

extern BTHRESULT BT_APPL_Start_Wait_Connection_REQ_DUMMY(void);

extern BTHRESULT BT_APPL_Stop_Wait_Connection_REQ_DUMMY(void);

extern BTHRESULT BT_APPL_Set_Local_Name_REQ_DUMMY(IN u8 ucNameLen,IN const u8 *pucName);

extern BTHRESULT BT_APPL_Set_Mode_REQ_DUMMY(IN u8 ucDiscoverable,IN u8 ucConnectable);

extern BTHRESULT BT_APPL_Set_SSP_Mode_REQ_DUMMY(IN u8 ucSSPMode);

extern BTHRESULT BT_APPL_Start_Pairing_REQ_DUMMY(void);

extern BTHRESULT BT_APPL_Stop_Pairing_REQ_DUMMY(void);

extern BTHRESULT BT_APPL_Set_Serial_Device_Param_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucService, IN u8 ucServiceHandle);

extern BTHRESULT BT_APPL_Service_Search_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucServiceType);

extern BTHRESULT BT_APPL_SSP_Numeric_Confirm_RES_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucAccept);

extern BTHRESULT BT_APPL_Connection_Request_RES_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucService, IN u8 ucAccept);

/* Device node */
extern BTHRESULT BT_APPL_Get_Device_Name_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_Disconnection_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucService);

extern BTHRESULT BT_APPL_Get_Local_Role_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, OUT u8 *pucRole);

extern BTHRESULT BT_APPL_Set_Local_Role_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucRole);

extern BTHRESULT BT_APPL_Get_Call_Status_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucSpecCall);

extern BTHRESULT BT_APPL_Get_Phone_Status_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Dial_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucLength, IN const u8* pucPHNNumber);

extern BTHRESULT BT_APPL_HF_Redial_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Mem_Dial_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u16 usMemIndex);

extern BTHRESULT BT_APPL_HF_Terminate_Call_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Terminate_All_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Audio_Transfer_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucAudioTransDir);

extern BTHRESULT BT_APPL_HF_Send_DTMF_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucDTMFIndex);

extern BTHRESULT BT_APPL_HF_Incoming_Call_Act_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR,IN u8 ucAction);

extern BTHRESULT BT_APPL_HF_Release_Inactive_Call_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Release_Active_Call_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Swap_Call_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Add_Call_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Release_Spec_Call_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucIndex);

extern BTHRESULT BT_APPL_HF_Hold_Excep_Call_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucIndex);

extern BTHRESULT BT_APPL_HF_Exp_Call_Trans_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Subscriber_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Manufacturer_ID_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Model_ID_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Revision_ID_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_HF_Voice_Recognition_Activation_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucActivation);

extern BTHRESULT BT_APPL_AVP_Ctrl_Cmd_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucCommand, IN u8 ucStatusFlag);

extern BTHRESULT BT_APPL_AVP_Get_Capabilities_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucCapabilityId);

extern BTHRESULT BT_APPL_AVP_List_Attr_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_AVP_List_Val_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucSettingAttributeId);

extern BTHRESULT BT_APPL_AVP_Set_Val_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucMode, IN u8 ucValue);

extern BTHRESULT BT_APPL_AVP_Config_Notify_REQ_DUMMY(IN u16 usEventId);

extern BTHRESULT BT_APPL_AVP_Set_Player_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u16 usPlayerId, IN u8 ucPlayer);

extern BTHRESULT BT_APPL_AVP_Change_Path_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucDirection, IN u8 aucFolderUid[]);

extern BTHRESULT BT_APPL_AVP_Get_Metadata_Attr_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucScope, IN u8 aucUid[], IN u8 ucNumAttributes, IN u32 aulAttributes[]);

extern BTHRESULT BT_APPL_AVP_Get_Folder_Item_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucScope, IN u32 ulStartItem, IN u32 ulEndItem, IN u8 ucNumAttributes, IN const u32 aulAttributes[]);

extern BTHRESULT BT_APPL_AVP_Get_Media_Player_Item_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u16 usMaxNumber);

extern BTHRESULT BT_APPL_AVP_Play_Item_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucScope, IN const u8 aucUid[]);

extern BTHRESULT BT_APPL_PBDL_Get_Capabilities_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_PBDL_Prepare_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_PBDL_Start_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u32 ulFilter, IN u8 ucPBType, IN u8 ucAction, IN u8 ucVersion);

extern BTHRESULT BT_APPL_PBDL_Stop_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucAction);

extern BTHRESULT BT_APPL_PBDL_Complete_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucCompMode);

extern BTHRESULT BT_APPL_MAP_Get_Capabilities_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_MAP_Start_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 unInstanceNum, IN const InstanceInfoPtr_t pstInstanceInfo);

extern BTHRESULT BT_APPL_MAP_Stop_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_MAP_Chg_Instance_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN const u8* pucServiceName, IN u8 ucMsgType);

extern BTHRESULT BT_APPL_MAP_Update_Inbox_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN const u8* pucServiceName);

extern BTHRESULT BT_APPL_MAP_List_Folder_REQ_DUMMY(IN const BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN const u8* pucServiceName, IN ListFolderParamPtr_t pstParam);

extern BTHRESULT BT_APPL_MAP_List_Msg_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN u8* pucServiceName, IN ListMsgParamPtr_t pstParam);

extern BTHRESULT BT_APPL_MAP_Read_Msg_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN u8* pucServiceName, IN u8 ucHandleLen, IN const u8* pucHandle, IN u8 ucAttachment);

extern BTHRESULT BT_APPL_MAP_Set_Msg_Status_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN u8* pucServiceName, IN u8 ucHandleLen, IN const u8* pucHandle, IN u8 ucMsgStatus);

extern BTHRESULT BT_APPL_MAP_Abort_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN u8* pucServiceName);

extern BTHRESULT BT_APPL_MAP_Upload_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN u8* pucServiceName, IN UploadParamPtr_t pstParam);

extern BTHRESULT BT_APPL_MAP_Upload_RES_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucServiceNameLen, IN u8* pucServiceName, IN u8 ucDataFlag, IN u16 usLength, IN u8* pucData);

extern BTHRESULT BT_APPL_Create_Device_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucService);

extern BTHRESULT BT_APPL_Destroy_Device_REQ_DUMMY(IN BD_ADDRESS aucBD_ADDR, IN u8 ucService);

/* Validation node */
extern BTHRESULT BT_APPL_TestMode_REQ_DUMMY(IN u8 ucEnable, IN u8 ucTestMode, IN u8 ucRole, IN const BD_ADDRESS aucBD_ADDR);

extern BTHRESULT BT_APPL_LinkQuality_REQ_DUMMY(IN u8 ucTestMode);

/* callback dummy functions */
extern BTHRESULT BT_APPL_Phone_Status_IND_Callback_DUMMY(
						const BD_ADDRESS bd_addr,
						PhoneStatus_t *phone_status);

extern BTHRESULT BT_APPL_HF_Voice_Recognition_Activation_CFM_Callback_DUMMY(
						const BD_ADDRESS bd_addr,
						u8 activation,
						u8 status);

extern BTHRESULT BT_APPL_HF_Voice_Recognition_Activation_IND_Callback_DUMMY(
						const BD_ADDRESS bd_addr,
						u8 activation);

extern BTHRESULT BT_APPL_Get_Device_Name_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 name_len,
						IN const u8 * name);

extern BTHRESULT BT_APPL_AVP_Get_Metadata_Attr_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 status,
						IN u8 num_attributes,
						IN u16 size,
						IN u8 data[]);

extern BTHRESULT BT_APPL_AVP_Get_Media_Player_Item_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 status,
						IN u16 num_items);

extern BTHRESULT BT_APPL_AVP_Get_Media_Player_Item_IND_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 status,
						IN u16 size,
						IN u8 data[]);

extern BTHRESULT BT_APPL_PBDL_Get_Capabilities_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 status,
						IN u8 type);

extern BTHRESULT BT_APPL_PBDL_Prepare_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
					    	IN u8 type);

extern BTHRESULT BT_APPL_PBDL_Start_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 status,
						IN u16 pb_number,
						IN u8 new_missed_call);

extern BTHRESULT BT_APPL_PBDL_Stop_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
					 	IN u8 status);

extern BTHRESULT BT_APPL_PBDL_Complete_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 status);

extern BTHRESULT BT_APPL_Authentication_IND_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr);

extern BTHRESULT BT_APPL_TestMode_CFM_Callback_DUMMY(IN u8 status);

extern BTHRESULT BT_APPL_LinkQuality_CFM_Callback_DUMMY(IN u8 status,
							IN s8 rssi,
							IN u8 link_quality);

extern BTHRESULT BT_APPL_MAP_Get_Capabilities_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
						IN u8 status,
						IN MsgCapabilityPtr_t msg_capability);

extern BTHRESULT BT_APPL_MAP_Start_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
					IN u8 status);

extern BTHRESULT BT_APPL_MAP_Stop_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
					IN u8 status);

extern BTHRESULT BT_APPL_MAP_Chg_Instance_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
					IN u8 status);

extern BTHRESULT BT_APPL_MAP_Update_Inbox_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
						IN u8 service_name_len,
						IN const u8* service_name,
						IN u8 status);

extern BTHRESULT BT_APPL_MAP_List_Folder_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
						IN u8 service_name_len,
						IN const u8* service_name,
						IN u8 status,
						IN u8 accessible,
						IN u32 folder_num);

extern BTHRESULT BT_APPL_MAP_List_Msg_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
						IN u8 service_name_len,
						IN const u8* service_name,
						IN u8 status,
						IN u32 message_num);

extern BTHRESULT BT_APPL_MAP_Read_Msg_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
						IN u8 service_name_len,
						IN const u8* service_name,
						IN u8 status,
						IN const ReadMsgInfoPtr_t msg_info);

extern BTHRESULT BT_APPL_MAP_Set_Msg_Status_CFM_Callback_DUMMY(
						IN const BD_ADDRESS bd_addr,
						IN u8 service_name_len,
						IN const u8* service_name,
						IN u8 status);

extern BTHRESULT BT_APPL_MAP_Abort_CFM_Callback_DUMMY(IN const BD_ADDRESS bd_addr,
						IN u8 service_name_len,
						IN const u8* service_name,
						IN u8 status);

#endif
