/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * Generic configuration settings for the Bosch i.MX6 boards.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/* List of supported boards */
#define CONFIG_BOARD_VRNS_B1_MX6Q
#define CONFIG_BOARD_VRNS_B1_MX6S
#define CONFIG_BOARD_VRNS_B2_MX6Q
#define CONFIG_BOARD_VRNS_B2_MX6S
#define CONFIG_BOARD_VRNS_B2_MX6Q_1GB
#define CONFIG_BOARD_VRNS_B2_MX6S_1GB
#define CONFIG_BOARD_MY16_A_MX6DL
#define CONFIG_BOARD_MY16_B1B3_MX6DL
#define CONFIG_BOARD_ICAMA1
#define CONFIG_BOARD_ICAMB1_MX6D
#define CONFIG_BOARD_ICAMB2_MX6D
#define CONFIG_BOARD_ICAMC1_MX6D
#define CONFIG_BOARD_ICAMC3_MX6D
#define CONFIG_BOARD_VWMIBA
#define CONFIG_BOARD_VWMIBB0
#define CONFIG_BOARD_VWMIBB
#define CONFIG_BOARD_VWMIBC0
#define CONFIG_BOARD_JACC2_B
#define CONFIG_BOARD_JACC2_B2
#define CONFIG_BOARD_JACC2_B3
#define CONFIG_BOARD_JACC2_C
#define CONFIG_BOARD_JACC2_D
#define CONFIG_BOARD_JACM6_B0
#define CONFIG_BOARD_PSARCCA2A
#define CONFIG_BOARD_PSARCCB1
#define CONFIG_BOARD_PSARCCB2
#define CONFIG_BOARD_PSARCCB3
#define CONFIG_BOARD_SUZUKISLNA1
#define CONFIG_BOARD_SUZUKISLNC
#define CONFIG_BOARD_NISSAN_AIVI_A
#define CONFIG_BOARD_ENA_A

#define CONFIG_MX6
#define CONFIG_DISPLAY_CPUINFO
#define CONFIG_DISPLAY_BOARDINFO

#include <asm/arch/imx-regs.h>
#include <asm/arch/system.h>
#include <asm/imx-common/gpio.h>

#define CONFIG_CMDLINE_TAG
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_INITRD_TAG

/* Size of malloc() pool */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + 2 * 1024 * 1024)

#define CONFIG_ARCH_CPU_INIT
#define CONFIG_BOARD_POSTCLK_INIT
#define CONFIG_BOARD_EARLY_INIT_F
#define CONFIG_MXC_GPIO

#define CONFIG_MXC_UART
#define CONFIG_MXC_UART_BASE		(((ocram *)IRAM_BASE_ADDR)->board->uart)

#define CONFIG_BOARD_LATE_INIT

/* OCOTP Configs */
#define CONFIG_CMD_IMXOTP
#ifdef CONFIG_CMD_IMXOTP
#define CONFIG_IMX_OTP
#define IMX_OTP_ADDR_MAX		0x7F
#define IMX_OTP_DATA_ERROR_VAL		0xBADABADA
//#define IMX_OTPWRITE_ENABLED
#endif

/* Secure boot support */
#define CONFIG_SECURE_BOOT

/* MMC Configs */
#define CONFIG_FSL_ESDHC
#define CONFIG_FSL_USDHC
#define CONFIG_SYS_FSL_ESDHC_ADDR	0
#define CONFIG_SYS_FSL_USDHC_NUM	2

#define CONFIG_MMC
#define CONFIG_CMD_MMC
#define CONFIG_GENERIC_MMC
#define CONFIG_BOUNCE_BUFFER
#define CONFIG_CMD_PING
#define CONFIG_CMD_DHCP
#define CONFIG_CMD_NET

/* USB Configs */
#define CONFIG_CMD_USB
#define CONFIG_USB_EHCI
#define CONFIG_USB_EHCI_MX6
#define CONFIG_USB_HOST_ETHER
#define CONFIG_USB_ETHER_ASIX
#define CONFIG_EHCI_HCD_INIT_AFTER_RESET
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_USB_EHCI_MAX_ROOT_PORTS	1
#define CONFIG_MXC_USB_PORTSC		(PORT_PTS_UTMI | PORT_PTS_PTW)
#define CONFIG_MXC_USB_PWR_ACTIVE_HIGH

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE
#define CONFIG_CONS_INDEX		1
#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{9600, 19200, 38400, 57600, 115200}

/* Ethernet */
#define CONFIG_CMD_NET
#define CONFIG_CMD_PING
#define CONFIG_CMD_UDPSEND
#define CONFIG_FEC_MXC
#define CONFIG_MII
#define IMX_FEC_BASE			ENET_BASE_ADDR
#define CONFIG_FEC_XCV_TYPE		RGMII
#define CONFIG_ETHPRIME			"FEC"
#define CONFIG_FEC_MXC_PHYADDR	0 /* not used */
#define CONFIG_UDP_CHECKSUM

/* Phy */
#define CONFIG_PHY_GIGE

/* Command definition */
#include <config_cmd_default.h>

/* Parallel NOR */
#define CONFIG_CMD_FLASH
/* Serial SPI NOR */
#define CONFIG_CMD_SF

/* Parallel NOR */
#ifdef CONFIG_CMD_FLASH
#define CONFIG_SYS_FLASH_CFI	/* Flash memory is CFI compliant */
#define CONFIG_FLASH_CFI_DRIVER	/* Use drivers/cfi_flash.c */
#define CONFIG_SYS_FLASH_BASE		WEIM_ARB_BASE_ADDR	/* Base address mapping */
#define CONFIG_SYS_FLASH_CFI_WIDTH	FLASH_CFI_16BIT
#define CONFIG_SYS_MAX_FLASH_BANKS	1	/* from Datasheet/Schematics */
#define CONFIG_SYS_MAX_FLASH_SECT	1024	/* from Datasheet */
#define CONFIG_SYS_FLASH_USE_BUFFER_WRITE


/* MTD Command for mtdparts */
#define CONFIG_CMD_MTDPARTS
#define CONFIG_MTD_DEVICE
#define CONFIG_FLASH_CFI_MTD
#define CONFIG_MTD_PARTITIONS
#else /* CONFIG_CMD_FLASH */
#define CONFIG_SYS_NO_FLASH
#endif /* CONFIG_CMD_FLASH */

/* Serial NOR */
#ifdef CONFIG_CMD_SF
#define CONFIG_SPI_FLASH
#define CONFIG_SPI_FLASH_STMICRO
#define CONFIG_SPI_FLASH_WINBOND
#define CONFIG_SPI_FLASH_SPANSION
#define CONFIG_SPI_FLASH_SST
#define CONFIG_MXC_SPI
#define CONFIG_SF_DEFAULT_BUS	(((sf_spi *)((ocram *)IRAM_BASE_ADDR)->board->sf)->bus)
#define CONFIG_SF_DEFAULT_CS	(((sf_spi *)((ocram *)IRAM_BASE_ADDR)->board->sf)->cs)
#define CONFIG_SF_DEFAULT_SPEED	15000000
#define CONFIG_SF_DEFAULT_MODE	(SPI_MODE_0)
#endif

#undef CONFIG_CMD_IMLS

#define CONFIG_BOOTDELAY		1

#define CONFIG_TIMER_MX6_HCLK
#define CONFIG_PRINT_STARTTIME
/* #define CONF_SHOW_TIMESTAMPS */
/* #define CONFIG_TIMESTAMP */
/* #define CONFIG_CMD_TIME */

#define CONFIG_LOADADDR			0x10800000
#define CONFIG_SYS_TEXT_BASE		0x17800000


/* sha256 calculation command */
#define CONFIG_CMD_HASH
#define CONFIG_SHA256
#define CONFIG_HASH_VERIFY



/*
 * The boot ROM code copies U-Boot already into the RAM at
 * address CONFIG_SYS_TEXT_BASE.  To improve the boot time,
 * skip the relocation (i.e. the copy RAM -> RAM).
 *
 * ATTENTION: Please read
 *
 * http://lists.denx.de/pipermail/u-boot/2012-February/117140.html
 *
 * why you normally don't want this!
 */
#define CONFIG_SYS_SKIP_ARM_RELOCATION

#define	CONFIG_EXTRA_ENV_SETTINGS					\
	"dtbaddr=0x11ff0000\0"						\
	"baudrate=115200n8\0"						\
	"fdt_high=0xffffffff\0"						\
	"verify=no\0"							\
	"xtargs=ip=off\0"						\
	"mmcdev=0\0"							\
	"kernelargs=setenv bootargs console=${console},${baudrate} "	\
		"root=${mmcroot} ${cpucount} printk.time=1 "		\
		"${xtargs} consoleblank=0 lpj=7905280 "		\
		"oops=panic panic=1\0"		\
	"envsize=" __stringify(CONFIG_ENV_SIZE) "\0"

#define CONFIG_BOOTCOMMAND						\
	"run gen3boot;"

/* Miscellaneous configurable options */
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "

#define CONFIG_SYS_PROMPT		"U-Boot > "

#define CONFIG_AUTO_COMPLETE
#define CONFIG_SYS_CBSIZE		256

/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE + 40)
#define CONFIG_SYS_MAXARGS		16
#define CONFIG_SYS_BARGSIZE		CONFIG_SYS_CBSIZE

#define CONFIG_SYS_MEMTEST_START	0x10000000
#define CONFIG_SYS_MEMTEST_END		0x10010000

#define CONFIG_SYS_LOAD_ADDR		CONFIG_LOADADDR
#define CONFIG_SYS_HZ			1000

#define CONFIG_CMDLINE_EDITING
#define CONFIG_STACKSIZE		(128 * 1024)

#define CONFIG_USE_ARCH_MEMSET
#define CONFIG_USE_ARCH_MEMCPY
#define CONFIG_USE_ARCH_MEMMOVE

/* Physical Memory Map */
#define CONFIG_NR_DRAM_BANKS		1
#define PHYS_SDRAM			MMDC0_ARB_BASE_ADDR

#define CONFIG_PRAM			4096	/* reserve 4MB */

#define CONFIG_SYS_SDRAM_BASE		PHYS_SDRAM
#define CONFIG_SYS_INIT_RAM_ADDR	IRAM_BASE_ADDR
#define CONFIG_SYS_INIT_RAM_SIZE	IRAM_SIZE

#define CONFIG_SYS_INIT_SP_OFFSET	\
	(CONFIG_SYS_INIT_RAM_SIZE - GENERATED_GBL_DATA_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR		\
	(CONFIG_SYS_INIT_RAM_ADDR + CONFIG_SYS_INIT_SP_OFFSET)

/* FLASH and environment organization
 *
 * U-Boot1 (SD) flash map:
 *	384k - 768k		U-Boot
 *	768k - 896k		SD/SF/NOR U-Boot environment
 * U-Boot2 (SD) flash map:
 *	896k  - 1280k		U-Boot
 *	1280k - 1408k		SD/SF/NOR U-Boot environment
 */
#define CONFIG_SYS_MONITOR_BASE		(CONFIG_SYS_FLASH_BASE + \
						(3 * 128 * 1024))
#define CONFIG_SYS_MONITOR_LEN		(3 * 128 * 1024)

#define CONFIG_ENV_IS_DYNAMIC
#define CONFIG_ENV_IS_IN_FLASH
#define CONFIG_ENV_IS_IN_SPI_FLASH
#define CONFIG_ENV_IS_IN_MMC

#define CONFIG_ENV_OFFSET		\
			(CONFIG_SYS_MONITOR_LEN + \
			(CONFIG_SYS_MONITOR_BASE - CONFIG_SYS_FLASH_BASE))
#define CONFIG_ENV_BACKUP_OFFSET	0x80000

#define CONFIG_ENV_SECT_SIZE	0x20000 /* 128kB */
#define CONFIG_ENV_SIZE			CONFIG_ENV_SECT_SIZE

/* MMC environment settings */
#define CONFIG_SYS_MMC_ENV_DEV		0

/* Serial NOR FLASH environment settings */
#define CONFIG_ENV_SPI_BUS		CONFIG_SF_DEFAULT_BUS
#define CONFIG_ENV_SPI_CS		CONFIG_SF_DEFAULT_CS
#define CONFIG_ENV_SPI_MODE		CONFIG_SF_DEFAULT_MODE
#define CONFIG_ENV_SPI_MAX_HZ		CONFIG_SF_DEFAULT_SPEED

/* Parallel NOR FLASH environment settings */
#define CONFIG_ENV_ADDR			(CONFIG_SYS_FLASH_BASE + CONFIG_ENV_OFFSET)

#define CONFIG_OF_LIBFDT

#ifndef CONFIG_SYS_DCACHE_OFF
#define CONFIG_CMD_CACHE

/* LZ77 decompression support */
#define CONFIG_LZ77
#define CONFIG_CMD_ASIL_MEMORY_TEST

#endif

#ifndef CONFIG_SYS_L2CACHE_OFF
#define CONFIG_SYS_L2_PL310
#define CONFIG_SYS_PL310_BASE	L2_PL310_BASE
#endif

#endif                         /* __CONFIG_H */
