/*
 * (C) Copyright 2015
 * Carsten Resch Bosch CarMultimedia GmbH, Carsten.Resch@de.bosch.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "cmd_asil_mem_test.h"

#define CR_M	(1 << 0)	/* MMU enable				*/
#define CR_A	(1 << 1)	/* Alignment abort enable		*/
#define CR_C	(1 << 2)	/* Dcache enable			*/
#define CR_W	(1 << 3)	/* Write buffer enable			*/
#define CR_Z	(1 << 11)	/* Implementation defined		*/
#define CR_I	(1 << 12)	/* ICache enable			*/
#define CR_V	(1 << 13)	/* Vectors relocated to 0xffff0000	*/

#define DCACHE_LINE_SIZE	0x20			/* 8 words, 32 bytes */
#define DCACHE_SET_SIZE		(256 * DCACHE_LINE_SIZE)	/* 256 sets */

/********************************************************
	definition for special func register during test
*********************************************************/
#define R_START_ADDR          r11    /* holds the start_addr */
#define R_END_ADDR            r10    /* end addr of current block */
#define R_ERR_CNT             r12    /* holds the error counter */
#define R_ORG_SP              r9     /* stores the SP */
/* overlapping registers */
#define R_PATTERN_RAM         r8     /* RAM area containing the test pattern */
#define R_PATTERN_CMP         r8     /* pattern compare reg */
#define R_DO_BACKUP           r8

.globl do_test_mem_area
do_test_mem_area:
	push	{r1-r12, lr}
	mov     R_ORG_SP, sp   /* Save the old stack pointer */
	mov     r11, #IRAM_BASE_ADDR
	add     r11, r11, #ASIL_TEST_BACKUP_RAM_OFFSET
	sub     r11, r11, #0x10
	mov     sp, r11       /* Set stackpointer for IRAM stack */
	sub     sp, sp, #12
	mov     R_START_ADDR,  r0       /* load start_addr */
	mov     R_END_ADDR, r1          /* load end_addr */
	mov     R_DO_BACKUP, r2
	str     R_DO_BACKUP,  [sp, #4]  /* Store 'do_backup' flag on stack */
	str     r0, [sp, #8]            /* put start addr on stack */
	mov     R_ERR_CNT, #0          /* init error counter */
	/* The test performs these steps (step 1 and 6 are optional):
		1) Save RAM Area if 'do_backup' is set
		2) Write pattern1 to RAM
		 2.1) flush d-cache
		3) verify pattern1
		4) Write pattern2 to RAM
		 4.1) flush d-cache
		5) verify pattern2
		6) Restore RAM Area if 'do_backup' is set
		 6.1) flush d-cache
	*/
	cmp    R_DO_BACKUP, #0
	beq    store_ram_done
	mov    R_PATTERN_RAM, #DEFAULT_ASIL_MEMTEST_START
store_ram:
        ldmia  R_START_ADDR!, {r0-r7}
	stmia  R_PATTERN_RAM!, {r0-r7}
	cmp    R_START_ADDR, R_END_ADDR
	blo    store_ram
store_ram_done:
/***********************************************/
/*	Test with Patter 1                     */
/***********************************************/
	mov    R_PATTERN_RAM, #ASIL_TEST_SRAM_BASE /* load pattern RAM Addr */
	add    R_PATTERN_RAM, R_PATTERN_RAM, #ASIL_TEST_PATTER1_OFFSET
	ldmia  R_PATTERN_RAM!,  {r0-r7} /* preload r0-r7 with pattern */
	/* reset the start_addr */
	ldr    R_START_ADDR, [sp, #8]

fill_patter1:
        stmia  R_START_ADDR!, {r0-r7}
	cmp    R_START_ADDR, R_END_ADDR
	blo    fill_patter1
	/* reset the start_addr */
	ldr    R_START_ADDR, [sp, #8]
	mov    R_PATTERN_CMP, r0 /* r0 contains test pattern */
	bl     asil_test_dcache_flush
	bl     verify_pattern

/***********************************************/
/*	Test with Patter 2                     */
/***********************************************/
	mov    R_PATTERN_RAM, #ASIL_TEST_SRAM_BASE /* load pattern RAM Addr */
	add    R_PATTERN_RAM, R_PATTERN_RAM, #ASIL_TEST_PATTER2_OFFSET
	ldmia  R_PATTERN_RAM!,  {r0-r7} /* preload r0-r7 with pattern */
	/* reset the start_addr */
	ldr    R_START_ADDR, [sp, #8]

fill_patter2:
        stmia  R_START_ADDR!, {r0-r7}
	cmp    R_START_ADDR, R_END_ADDR
	blo    fill_patter2
	/* reset the start_addr */
	ldr    R_START_ADDR, [sp, #8]
	mov    R_PATTERN_CMP, r0 /* r0 contains test pattern */
	bl     asil_test_dcache_flush
	bl     verify_pattern

	/* reset the start_addr */
	ldr    R_START_ADDR, [sp, #8]
	ldr    R_DO_BACKUP,  [sp, #4]
	cmp    R_DO_BACKUP, #0
	beq    restore_ram_done
	mov    R_PATTERN_RAM, #DEFAULT_ASIL_MEMTEST_START
restore_ram:
        ldmia  R_PATTERN_RAM!, {r0-r7}
	stmia  R_START_ADDR!, {r0-r7}
	cmp    R_START_ADDR, R_END_ADDR
	blo    restore_ram
	bl     asil_test_dcache_flush
restore_ram_done:
	mov     r0, R_ERR_CNT
done:
	mov     sp, R_ORG_SP
	pop	{r1-r12, lr}
	bx	lr


asil_test_dcache_flush:
	push	{r0-r4, lr}
	mcr     p15, 0, r0, c7, c5, 4
	mov	r0, #DCACHE_SET_SIZE
	mov	r1, #0				/* associativity 4 */
	mcr	p15, 0, r1, c7, c10, 5		/* data memory barrier */
	mov	r2, #0x40000000
	mov	r3, #0x80000000
	mov	r4, #0xc0000000

d_inv_loop:
		/* DCCISW, clean and invalidate dcache by set / way */
	mcr	p15, 0, r1, c7, c14, 2
		/* DCCISW, clean and invalidate dcache by set / way */
	mcr	p15, 0, r2, c7, c14, 2
		/* DCCISW, clean and invalidate dcache by set / way */
	mcr	p15, 0, r3, c7, c14, 2
		/* DCCISW, clean and invalidate dcache by set / way */
	mcr	p15, 0, r4, c7, c14, 2
	add	r1, r1, #DCACHE_LINE_SIZE
	add	r2, r2, #DCACHE_LINE_SIZE
	add	r3, r3, #DCACHE_LINE_SIZE
	add	r4, r4, #DCACHE_LINE_SIZE
	cmp     r1, r0
	bne     d_inv_loop

	/* invalidate entire branch predictor array */
	mcr	p15, 0, r0, c7, c5, 6

	/* invalidate unified TLB */
	mcr	p15, 0, r0, c8, c7, 0

	mcr     p15, 0, r0, c7, c10, 4		/* DSB */

	pop	{r0-r4, pc}

store_error_res:
	push {r4-r6}
	/* Calculate the address in error-array */
	/* based on error counter */
	/* addr = (old_err_cnt) * 12 (bytes per entry) */
	/*  old_err_cnt: err_cnt before increment */
	mov  r6, R_ERR_CNT
	add  R_ERR_CNT, R_ERR_CNT, #1 /* inc error count */
	mov  r5, #12
	mul  r6, r6, r5 /* err_cnt * 12 */
	mov  r4, #IRAM_BASE_ADDR
	add  r4, r4, #ERROR_ARRAY_ADDR_OFFSET
	add  r4, r4, r6
	/* r1 contains a neg. offset to 'R_START_ADDR' */
	/* Failed addr = R_START_ADDR - r1 */
	str  r1, [r4, #0]
	/* R_PATTERN_CMP contains the expected pattern */
	str  R_PATTERN_CMP, [r4, #4]
	/* r0 contains the read pattern */
	str  r0, [r4, #8]
	pop  {r4-r6}
	bx   lr

verify_pattern:
	push {lr}
verify_patter_loop:
        ldmia  R_START_ADDR!, {r0-r7}
	/*********************************************/
	cmp    r0, R_PATTERN_CMP        /* verify R0 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	/*mov    r0,r0*/                /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #32    /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	/*********************************************/
	cmp    r1, R_PATTERN_CMP        /* verify R1 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	mov    r0,r1                    /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #28    /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	/*********************************************/
	cmp    r2, R_PATTERN_CMP        /* verify R2 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	mov    r0,r2                    /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #24    /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	/*********************************************/
	cmp    r3, R_PATTERN_CMP        /* verify R3 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	mov    r0,r3                    /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #20    /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	/*********************************************/
	cmp    r4, R_PATTERN_CMP        /* verify R4 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	mov    r0,r4                /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #16    /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	/*********************************************/
	cmp    r5, R_PATTERN_CMP        /* verify R5 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	mov    r0,r5                    /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #12    /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	/*********************************************/
	cmp    r6, R_PATTERN_CMP        /* verify R6 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	mov    r0,r6                    /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #8    /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	/*********************************************/
	cmp    r7, R_PATTERN_CMP        /* verify R7 */
	pushne {r0,r1}                  /* on error:	 push r1 */
	mov    r0,r7                    /* r0 -> fault pattern */
	subne  r1, R_START_ADDR, #4     /* r1 -> fault addr*/
	blne   store_error_res          /* jump to store res in err array */
	popne  {r0,r1}                  /* on error:	 pop r1 */
	cmp    R_ERR_CNT, #ASIL_TEST_MAX_NUM_ERRORS /* stop test after MAX_NUM*/
	bge    verify_end
	cmp    R_START_ADDR, R_END_ADDR
	blo    verify_patter_loop
verify_end:
	pop {lr}
	bx lr

.global _end_test_mem_area
_end_test_mem_area:
	.balignl 16,0xdeadbeef
