/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>

#ifdef CONFIG_BOARD_VWMIBB0
static const dcd_config dcd_vwmibb0_solo[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E0790, 0x00000001},
	{0x020E0798, 0x00000001},
	{0x020E07A8, 0x00000001},
	{0x020E07AC, 0x00000001},
	{0x020E0870, 0x00000001},
	{0x020E0874, 0x00000001},
	{0x020E0878, 0x00000002},
	{0x020E087C, 0x00000001},
	{0x020E0074, 0x00000004},
	{0x020E0078, 0x00000004},
	{0x020E007C, 0x00000004},
	{0x020E0080, 0x00000004},
	{0x020E0084, 0x00000002},
	{0x020E0088, 0x00000002},
	{0x020E004C, 0x00000002},
	{0x020E0054, 0x00000000},
	{0x020E0058, 0x00000000},
	{0x020E005C, 0x00000000},
	{0x020E0060, 0x00000000},
	{0x020E0064, 0x00000000},
	{0x020E0068, 0x00000000},
	{0x020E006C, 0x00000000},
	{0x020E0070, 0x00000000},
	{0x020E008C, 0x00000000},
	{0x020E0090, 0x00000000},
	{0x020E0094, 0x00000000},
	{0x020E0098, 0x00000000},
	{0x020E009C, 0x00000000},
	{0x020E00A4, 0x00000000},
	{0x020E00A8, 0x00000000},
	{0x020E00AC, 0x00000005},
	{0x020E00A0, 0x00000000},
	{0x020E00B0, 0x00000002},
	{0x020E00B4, 0x00000002},
	{0x020E00E0, 0x00000002},
	{0x020E0100, 0x00000000},
	{0x020E0104, 0x00000000},
	{0x020E0108, 0x00000000},
	{0x020E010C, 0x00000000},
	{0x020E00B8, 0x00000000},
	{0x020E00BC, 0x00000000},
	{0x020E00C0, 0x00000000},
	{0x020E00C4, 0x00000000},
	{0x020E00C8, 0x00000000},
	{0x020E00CC, 0x00000000},
	{0x020E00D0, 0x00000000},
	{0x020E00D4, 0x00000000},
	{0x020E00D8, 0x00000000},
	{0x020E00DC, 0x00000000},
	{0x020E00E4, 0x00000000},
	{0x020E00E8, 0x00000000},
	{0x020E00EC, 0x00000000},
	{0x020E00F0, 0x00000000},
	{0x020E0134, 0x00000005},
	{0x020E0138, 0x00000005},
	{0x020E0140, 0x00000005},
	{0x020E0144, 0x00000000},
	{0x020E0148, 0x00000000},
	{0x020E014C, 0x00000000},
	{0x020E0150, 0x00000000},
	{0x020E0154, 0x00000005},
	{0x020E0158, 0x00000001},
	{0x020E015C, 0x00000001},
	{0x020E0160, 0x00000000},
	{0x020E0164, 0x00000000},
	{0x020E0168, 0x00000000},
	{0x020E016C, 0x00000000},
	{0x020E0170, 0x00000000},
	{0x020E0174, 0x00000002},
	{0x020E0178, 0x00000000},
	{0x020E017C, 0x00000000},
	{0x020E0180, 0x00000000},
	{0x020E01D0, 0x00000000},
	{0x020E01E4, 0x00000002},
	{0x020E01E8, 0x00000002},
	{0x020E01FC, 0x00000002},
	{0x020E0204, 0x00000002},
	{0x020E0210, 0x00000003},
	{0x020E0224, 0x00000005},
	{0x020E0228, 0x00000006},
	{0x020E022C, 0x00000005},
	{0x020E0230, 0x00000016},
	{0x020E0234, 0x00000005},
	{0x020E0240, 0x00000005},
	{0x020E0214, 0x00000016},
	{0x020E021C, 0x00000000},
	{0x020E0244, 0x00000004},
	{0x020E0248, 0x00000004},
	{0x020E0250, 0x00000014},
	{0x020E0254, 0x00000002},
	{0x020E0258, 0x00000004},
	{0x020E025C, 0x00000004},
	{0x020E0260, 0x00000005},
	{0x020E0264, 0x00000014},
	{0x020E0268, 0x00000002},
	{0x020E027C, 0x00000002},
	{0x020E0284, 0x00000005},
	{0x020E0288, 0x00000005},
	{0x020E028C, 0x00000005},
	{0x020E0290, 0x00000005},
	{0x020E0294, 0x00000005},
	{0x020E0298, 0x00000005},
	{0x020E029C, 0x00000005},
	{0x020E02A0, 0x00000005},
	{0x020E02DC, 0x00000000},
	{0x020E02E0, 0x00000000},
	{0x020E02E4, 0x00000000},
	{0x020E02E8, 0x00000000},
	{0x020E02EC, 0x00000000},
	{0x020E02F0, 0x00000000},
	{0x020E02F4, 0x00000005},
	{0x020E02F8, 0x00000005},
	{0x020E02FC, 0x00000003},
	{0x020E0300, 0x00000003},
	{0x020E0304, 0x00000003},
	{0x020E0308, 0x00000003},
	{0x020E030C, 0x00000000},
	{0x020E0310, 0x00000000},
	{0x020E0314, 0x00000000},
	{0x020E0318, 0x00000000},
	{0x020E031C, 0x00000000},
	{0x020E0320, 0x00000000},
	{0x020E0324, 0x00000000},
	{0x020E0328, 0x00000000},
	{0x020E032C, 0x00000000},
	{0x020E0330, 0x00000000},
	{0x020E0334, 0x00000000},
	{0x020E0338, 0x00000000},
	{0x020E033C, 0x00000000},
	{0x020E0340, 0x00000001},
	{0x020E0344, 0x00000001},
	{0x020E0348, 0x00000001},
	{0x020E034C, 0x00000001},
	{0x020E0350, 0x00000002},
	{0x020E0354, 0x00000002},
	{0x020E0358, 0x00000002},
	{0x020E035C, 0x00000002},
	{0x020E03B0, 0x0001A090},
	{0x020E03B8, 0x0001A090},
	{0x020E03BC, 0x0001A090},
	{0x020E03B4, 0x0001A090},
	{0x020E0414, 0x0001A090},
	{0x020E0418, 0x0001A090},
	{0x020E041C, 0x0001A090},
	{0x020E0420, 0x0001A090},
	{0x020E03CC, 0x0001A090},
	{0x020E03D0, 0x0001A090},
	{0x020E03D4, 0x0001A090},
	{0x020E03D8, 0x0001A090},
	{0x020E03DC, 0x0001A090},
	{0x020E03E0, 0x0001A090},
	{0x020E03E4, 0x0001A090},
	{0x020E03E8, 0x0001A090},
	{0x020E03EC, 0x0001A090},
	{0x020E03F0, 0x0001A090},
	{0x020E03F8, 0x0001A090},
	{0x020E03FC, 0x0001A090},
	{0x020E0400, 0x0001A090},
	{0x020E0404, 0x0001A090},
	{0x020E0608, 0x000130B0},
	{0x020E065C, 0x000130B0},
	{0x020E0900, 0x00000004},
	{0x020E0904, 0x00000006},
	{0x020E0914, 0x00000003},
	{0x020E091C, 0x00000003},
	{0x020E0924, 0x00000001},
	{0x020E0920, 0x00000001},
	{0x020E0928, 0x00000001},
	{0x020E0934, 0x00000001},
	{0x020E0938, 0x00000001},
        /*GPIO settings*/
	{0x0209C000, 0x18000000},
	{0x0209C004, 0x38800E01},
	{0x020A0000, 0x00000005},
	{0x020A0004, 0x410000FD},
	{0x020A4000, 0x00100000},
	{0x020A4004, 0x00100000},
	{0x020A8000, 0x07000000},
	{0x020A8004, 0x07100C00},
	{0x020AC000, 0x20000000},
	{0x020AC004, 0x20000000},
	{0x020B0000, 0x00000000},
	{0x020B0004, 0x00004900},
	{0x020B4000, 0x00000000},
	{0x020B4004, 0x00000000},
	{END_OF_TABLE},
};

static const env_entry board_env_vwmiba[] = {
                {"cpucount", "nosmp"},
		{"console", "ttymxc3"},
                {0, 0}
};

static const sf_spi sf_spi_vwmiba = {
		.bus = 3,
		.cs = (0|(IMX_GPIO_NR(3, 20)<<8)), /* GPIO port 3, pin 20 */
};

#define VWMIB_B0_GPIO_SD_MPWR		IMX_GPIO_NR(4, 20)

static void board_init_vwmibb0(void)
{
	/* switch on eMMC/SD power */
	gpio_direction_output(VWMIB_B0_GPIO_SD_MPWR, 1);
}

static const struct sw_opt_gpio sw_opt_gpio_vwmibb0 = {
	.sw_opt = { IMX_GPIO_NR(1,  8), IMX_GPIO_NR(4, 5) },
};

const board_config board_data_vwmibb0 = {
	.name = "MX6S-VWMIBB0",
	.dcd = dcd_vwmibb0_solo,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 * The mx6svwmibb0 build will use the hard coded defines from
	 * include/configs/mx6svwmibb0.h, instead.
	*/
	.env = board_env_vwmiba,
	.ram_size = 512u * 1024 * 1024,
	.board_init = board_init_vwmibb0,
	.sf = &sf_spi_vwmiba,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_SPI_FLASH,
	.sw_opt = &sw_opt_gpio_vwmibb0,	
};
#endif
