/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>

#if defined(CONFIG_BOARD_VRNS_B2_MX6Q) || \
	defined(CONFIG_BOARD_VRNS_B2_MX6Q_1GB) || \
	defined(CONFIG_BOARD_VRNS_B2_MX6S) || \
	defined(CONFIG_BOARD_VRNS_B2_MX6S_1GB)

#define VRNS_B2_GPIO_USB_OTG_PPON	IMX_GPIO_NR(2, 1)

static void board_usb_otg_init_vrnsb2(void)
{
	/* switch on USB OTG power
	 * VRNS B2 and JAC C2 B use wrong USB power controller
	 * power must be on to enable USB data path */
	gpio_direction_output(VRNS_B2_GPIO_USB_OTG_PPON, 1);
}

#define VRNSB2_GPIO_SD_MPWR		IMX_GPIO_NR(4, 20)
#define VRNSB2_GPIO_PWR_IMX_EMMC_OFF	IMX_GPIO_NR(6, 11)
#define VRNSB2_GPIO_DISP_STBYB		IMX_GPIO_NR(2, 07)
#define VRNSB2_GPIO_ADR_RESET		IMX_GPIO_NR(2, 24)
#define VRNSB2_GPIO_USB_OTG_PPON	IMX_GPIO_NR(2,  1)

static void board_init_vrnsb2(void)
{
	/* switch off USB OTG power */
	gpio_direction_output(VRNSB2_GPIO_USB_OTG_PPON, 0);

	/* switch on eMMC/SD power */
	gpio_direction_output(VRNSB2_GPIO_SD_MPWR, 1);
	gpio_direction_output(VRNSB2_GPIO_PWR_IMX_EMMC_OFF, 0);

	/* ADR3 Reset off */
	gpio_direction_output(VRNSB2_GPIO_ADR_RESET, 1);

	/* display standby disable */
	gpio_direction_output(VRNSB2_GPIO_DISP_STBYB, 1);
}
#endif

#if defined(CONFIG_BOARD_VRNS_B2_MX6Q) || defined(CONFIG_BOARD_VRNS_B2_MX6Q_1GB)
static const dcd_config dcd_vrnsb2[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E004C, 0x00000003},
	{0x020E0050, 0x00000003},
	{0x020E0054, 0x00000003},
	{0x020E0088, 0x00000005},
	{0x020E0090, 0x00000000},
	{0x020E0094, 0x00000000},
	{0x020E0098, 0x00000000},
	{0x020E009C, 0x00000000},
	{0x020E00A0, 0x00000000},
	{0x020E00A4, 0x00000000},
	{0x020E00A8, 0x00000000},
	{0x020E00AC, 0x00000000},
	{0x020E00B4, 0x00000000},
	{0x020E00B8, 0x00000000},
	{0x020E00BC, 0x00000000},
	{0x020E00C0, 0x00000000},
	{0x020E00C4, 0x00000000},
	{0x020E00C8, 0x00000000},
	{0x020E00CC, 0x00000000},
	{0x020E00D0, 0x00000000},
	{0x020E00FC, 0x00000005},
	{0x020E0108, 0x00000005},
	{0x020E010C, 0x00000005},
	{0x020E0110, 0x00000005},
	{0x020E0158, 0x00000005},
	{0x020E015C, 0x00000000},
	{0x020E0160, 0x00000000},
	{0x020E0164, 0x00000000},
	{0x020E0168, 0x00000000},
	{0x020E0170, 0x00000000},
	{0x020E0174, 0x00000000},
	{0x020E0178, 0x00000000},
	{0x020E017C, 0x00000000},
	{0x020E0180, 0x00000000},
	{0x020E0184, 0x00000000},
	{0x020E0188, 0x00000000},
	{0x020E018C, 0x00000000},
	{0x020E0190, 0x00000000},
	{0x020E0194, 0x00000000},
	{0x020E0198, 0x00000000},
	{0x020E019C, 0x00000000},
	{0x020E01A0, 0x00000000},
	{0x020E01A4, 0x00000000},
	{0x020E01A8, 0x00000000},
	{0x020E01AC, 0x00000000},
	{0x020E01B0, 0x00000000},
	{0x020E01B4, 0x00000000},
	{0x020E01B8, 0x00000000},
	{0x020E01BC, 0x00000000},
	{0x020E01C0, 0x00000000},
	{0x020E01C4, 0x00000000},
	{0x020E01C8, 0x00000000},
	{0x020E01CC, 0x00000000},
	{0x020E01DC, 0x00000002},
	{0x020E01E0, 0x00000002},
	{0x020E01F0, 0x00000002},
	{0x020E01F4, 0x00000002},
	{0x020E01F8, 0x00000004},
	{0x020E01FC, 0x00000004},
	{0x020E0200, 0x00000004},
	{0x020E0204, 0x00000004},
	{0x020E0210, 0x00000014},
	{0x020E0214, 0x00000014},
	{0x020E0224, 0x00000003},
	{0x020E023C, 0x00000006},
	{0x020E0248, 0x00000006},
	{0x020E0250, 0x00000000},
	{0x020E0258, 0x00000000},
	{0x020E025C, 0x00000000},
	{0x020E0260, 0x00000000},
	{0x020E0264, 0x00000000},
	{0x020E0268, 0x00000002},
	{0x020E026C, 0x00000002},
	{0x020E0270, 0x00000002},
	{0x020E0278, 0x00000002},
	{0x020E027C, 0x00000002},
	{0x020E0280, 0x00000002},
	{0x020E0288, 0x00000000},
	{0x020E028C, 0x00000000},
	{0x020E0290, 0x00000000},
	{0x020E0294, 0x00000000},
	{0x020E0298, 0x00000000},
	{0x020E029C, 0x00000000},
	{0x020E02A0, 0x00000000},
	{0x020E02A4, 0x00000000},
	{0x020E02A8, 0x00000000},
	{0x020E02AC, 0x00000000},
	{0x020E02B0, 0x00000000},
	{0x020E02B4, 0x00000000},
	{0x020E02B8, 0x00000000},
	{0x020E02BC, 0x00000000},
	{0x020E02C0, 0x00000000},
	{0x020E02C4, 0x00000000},
	{0x020E02C8, 0x00000000},
	{0x020E02CC, 0x00000000},
	{0x020E02EC, 0x00000002},
	{0x020E02F4, 0x00000000},
	{0x020E02F8, 0x00000000},
	{0x020E031C, 0x00000001},
	{0x020E0320, 0x00000001},
	{0x020E0324, 0x00000001},
	{0x020E0328, 0x00000001},
	{0x020E032C, 0x00000002},
	{0x020E0330, 0x00000002},
	{0x020E0334, 0x00000002},
	{0x020E0338, 0x00000002},
	{0x020E033C, 0x00000000},
	{0x020E0340, 0x00000000},
	{0x020E0344, 0x00000000},
	{0x020E0348, 0x00000000},
	{0x020E034C, 0x00000000},
	{0x020E0350, 0x00000000},
	{0x020E035C, 0x00000003},
	{0x020E03A4, 0x0001B0B9},
	{0x020E03A8, 0x0001B0B9},
	{0x020E03AC, 0x0001B0B9},
	{0x020E03B0, 0x0001B0B9},
	{0x020E03B4, 0x0001B0B9},
	{0x020E03B8, 0x0001B0B8},
	{0x020E03BC, 0x000130B9},
	{0x020E03C0, 0x0001B0B9},
	{0x020E03C8, 0x0001B0B8},
	{0x020E03CC, 0x0001B0B9},
	{0x020E03D0, 0x0001B0B9},
	{0x020E03D4, 0x0001B0B8},
	{0x020E03D8, 0x0001B0B8},
	{0x020E03DC, 0x0001B0B9},
	{0x020E03E0, 0x0001B0B9},
	{0x020E03E4, 0x000130B9},
	{0x020E03E8, 0x0001B0B9},
	{0x020E03EC, 0x0001B0B9},
	{0x020E03F0, 0x0001B0B9},
	{0x020E03F4, 0x0001B0B9},
	{0x020E03F8, 0x0001B0B9},
	{0x020E03FC, 0x0001B0B9},
	{0x020E0400, 0x0001B0B9},
	{0x020E0404, 0x0001B0B9},
	{0x020E0408, 0x0001B0B9},
	{0x020E0410, 0x00003070},
	{0x020E0414, 0x0001B0B9},
	{0x020E0418, 0x0001B0B9},
	{0x020E0428, 0x0001B0B9},
	{0x020E042C, 0x0001B0B9},
	{0x020E0430, 0x0001B0B9},
	{0x020E0434, 0x0001B0B9},
	{0x020E0438, 0x0001B0B9},
	{0x020E043C, 0x0001B0B9},
	{0x020E0440, 0x0001B0B9},
	{0x020E0444, 0x0001B0B9},
	{0x020E0448, 0x0001B0B9},
	{0x020E044C, 0x0001B0B9},
	{0x020E0450, 0x0001B0B9},
	{0x020E0454, 0x0001B0B9},
	{0x020E0458, 0x0001B0B9},
	{0x020E045C, 0x0001B0B9},
	{0x020E0460, 0x0001B0B9},
	{0x020E0464, 0x0001B0B9},
	{0x020E0468, 0x0001B0B9},
	{0x020E0480, 0x000130B0},
	{0x020E0484, 0x00001011},
	{0x020E0488, 0x00001011},
	{0x020E048C, 0x00001011},
	{0x020E0490, 0x00001011},
	{0x020E0494, 0x00001011},
	{0x020E0498, 0x00001011},
	{0x020E049C, 0x00001011},
	{0x020E04A0, 0x00001011},
	{0x020E04A4, 0x00001011},
	{0x020E04A8, 0x00001011},
	{0x020E04AC, 0x00001011},
	{0x020E04B0, 0x00001011},
	{0x020E04B4, 0x00001011},
	{0x020E04B8, 0x00001011},
	{0x020E04BC, 0x00001011},
	{0x020E04C0, 0x00001011},
	{0x020E04C4, 0x00001011},
	{0x020E04C8, 0x00001011},
	{0x020E04CC, 0x00001011},
	{0x020E04D0, 0x00001011},
	{0x020E04D4, 0x00001011},
	{0x020E04D8, 0x00001011},
	{0x020E04DC, 0x00001011},
	{0x020E04E0, 0x00001011},
	{0x020E04F8, 0x000130B0},
	{0x020E04FC, 0x000130B0},
	{0x020E05EC, 0x0001B0B0},
	{0x020E05F0, 0x0000F088},
	{0x020E05F4, 0x0001B080},
	{0x020E05FC, 0x00013090},
	{0x020E0600, 0x000130B0},
	{0x020E061C, 0x0000F088},
	{0x020E0690, 0x0000B0F9},
	{0x020E0694, 0x0000B0F9},
	{0x020E0698, 0x0000B0F9},
	{0x020E069C, 0x0000B0F9},
	{0x020E06A0, 0x0000B0F9},
	{0x020E06A4, 0x0000B0F9},
	{0x020E06A8, 0x0000B0F9},
	{0x020E06AC, 0x0000B0B9},
	{0x020E06B0, 0x0000B0F9},
	{0x020E06B4, 0x0000B0F9},
	{0x020E06CC, 0x000130B0},
	{0x020E06D8, 0x000130B0},
	{0x020E06E8, 0x000130B0},
	{0x020E06F0, 0x000130B0},
	{0x020E06F4, 0x000130B0},
	{0x020E06F8, 0x000130B0},
	{0x020E06FC, 0x000130B0},
	{0x020E0700, 0x000130B0},
	{0x020E0724, 0x0000B0F9},
	{0x020E0728, 0x0000B0F9},
	{0x020E072C, 0x0000B0F9},
	{0x020E0730, 0x0000B0F9},
	{0x020E0734, 0x0000B0F9},
	{0x020E0738, 0x0000B0F9},
	{0x020E07B4, 0x00000001},
	{0x020E07C4, 0x00000001},
	{0x020E07C8, 0x00000001},
	{0x020E07F8, 0x00000003},
	{0x020E0814, 0x00000002},
	{0x020E08A0, 0x00000001},
	{0x020E08A4, 0x00000001},
	{0x020E08A8, 0x00000002},
	{0x020E08AC, 0x00000001},
	{0x020E0924, 0x00000004},
	{0x020E0928, 0x00000006},
	{0x020E0938, 0x00000001},
	/* NOR/WEIM controller settings (TODO: timing!!!) */
	{0x021B8000, 0x00020101}, /* WEIM_CS0_xCRn */
	{0x021B8004, 0x00000000},
	{0x021B8008, 0x10002100},
	{0x021B800C, 0x00008000},
	{0x021B8010, 0x10000440},
	{0x021B8014, 0x00000000},
	{0x021B8090, 0x00000000}, /* WEIM_WCR */
	{0x020E0004, 0x48400005}, /* IOMUXC_IOMUXC_GPR1: CS0 = 128 MB */
	{END_OF_TABLE},
};

#ifdef CONFIG_BOARD_VRNS_B2_MX6Q
static const env_entry board_env_vrnsb2q[] = {
	{"kerneladdr", "0x08100000"},
	{"dtbsrc", "0x080B0000"},
	{"dtbsize", "0x8000"},
	{"cpucount", ""},
	{"console", "ttymxc3"},
	{"loadkernel", "echo Starting kernel from parallel flash ..."},
	{"loaddtb", "cp.b ${dtbsrc} ${dtbaddr} ${dtbsize}"},
	{"gen3boot", "echo Booting from parallel NOR ...; "	\
		"run kernelargs; "				\
		"run loaddtb; "					\
		"bootm ${kerneladdr} - ${dtbaddr}"},
	{0, 0}
};

const board_config board_data_vrnsb2q = {
	.name = "MX6Q-VRNS-B2",
	.dcd = dcd_vrnsb2,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 * The mx6xvrnsb2 builds will use the hard coded defines from
	 * include/configs/mx6vrnsb3.h, instead.
	 */
	.env = board_env_vrnsb2q,
	.ram_size = 512u * 1024 * 1024,
	.board_init = board_init_vrnsb2,
	.board_usb_otg_init = board_usb_otg_init_vrnsb2,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_FLASH,
};
#endif

#ifdef CONFIG_BOARD_VRNS_B2_MX6Q_1GB
static const env_entry board_env_vrnsb2q_1gb[] = {
	{"kerneladdr", "0x08100000"},
	{"dtbsrc", "0x080D8000"},
	{"dtbsize", "0x8000"},
	{"cpucount", ""},
	{"console", "ttymxc3"},
	{"loadkernel", "echo Starting kernel from parallel flash ..."},
	{"loaddtb", "cp.b ${dtbsrc} ${dtbaddr} ${dtbsize}"},
	{"gen3boot", "echo Booting from parallel NOR ...; "	\
		"run kernelargs; "				\
		"run loaddtb; "					\
		"bootm ${kerneladdr} - ${dtbaddr}"},
	{0, 0}
};

const board_config board_data_vrnsb2q_1gb = {
	.name = "MX6Q-VRNS-B2 1GB",
	.dcd = dcd_vrnsb2,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 * The mx6xvrnsb2 builds will use the hard coded defines from
	 * include/configs/mx6vrnsb3.h, instead.
	 */
	.env = board_env_vrnsb2q_1gb,
	.ram_size = 1u * 1024 * 1024 * 1024,
	.board_init = board_init_vrnsb2,
	.board_usb_otg_init = board_usb_otg_init_vrnsb2,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_FLASH,
};
#endif
#endif

#if defined(CONFIG_BOARD_VRNS_B2_MX6S) || defined(CONFIG_BOARD_VRNS_B2_MX6S_1GB)
static const dcd_config dcd_vrnsb2_solo[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E004C, 0x00000002},
	{0x020E0054, 0x00000000},
	{0x020E0058, 0x00000000},
	{0x020E005C, 0x00000000},
	{0x020E0060, 0x00000000},
	{0x020E0064, 0x00000000},
	{0x020E0068, 0x00000000},
	{0x020E006C, 0x00000000},
	{0x020E0070, 0x00000000},
	{0x020E0074, 0x00000002},
	{0x020E0078, 0x00000002},
	{0x020E007C, 0x00000002},
	{0x020E0084, 0x00000002},
	{0x020E0088, 0x00000002},
	{0x020E008C, 0x00000000},
	{0x020E0090, 0x00000000},
	{0x020E0094, 0x00000000},
	{0x020E0098, 0x00000000},
	{0x020E009C, 0x00000000},
	{0x020E00A0, 0x00000000},
	{0x020E00A4, 0x00000000},
	{0x020E00A8, 0x00000000},
	{0x020E00B0, 0x00000000},
	{0x020E00B4, 0x00000000},
	{0x020E00B8, 0x00000000},
	{0x020E00BC, 0x00000000},
	{0x020E00C0, 0x00000000},
	{0x020E00C4, 0x00000000},
	{0x020E00C8, 0x00000000},
	{0x020E00CC, 0x00000000},
	{0x020E00D0, 0x00000000},
	{0x020E00D4, 0x00000000},
	{0x020E00D8, 0x00000000},
	{0x020E00DC, 0x00000000},
	{0x020E00E0, 0x00000000},
	{0x020E00E4, 0x00000000},
	{0x020E00E8, 0x00000000},
	{0x020E00EC, 0x00000000},
	{0x020E00F0, 0x00000000},
	{0x020E00F4, 0x00000000},
	{0x020E00F8, 0x00000000},
	{0x020E00FC, 0x00000000},
	{0x020E0100, 0x00000000},
	{0x020E0104, 0x00000000},
	{0x020E0108, 0x00000000},
	{0x020E010C, 0x00000000},
	{0x020E0134, 0x00000005},
	{0x020E0138, 0x00000005},
	{0x020E0140, 0x00000005},
	{0x020E0144, 0x00000000},
	{0x020E0148, 0x00000000},
	{0x020E014C, 0x00000000},
	{0x020E0150, 0x00000000},
	{0x020E0154, 0x00000000},
	{0x020E0158, 0x00000000},
	{0x020E015C, 0x00000000},
	{0x020E0160, 0x00000000},
	{0x020E0164, 0x00000000},
	{0x020E0168, 0x00000000},
	{0x020E016C, 0x00000000},
	{0x020E0170, 0x00000000},
	{0x020E0174, 0x00000000},
	{0x020E0178, 0x00000000},
	{0x020E017C, 0x00000000},
	{0x020E0180, 0x00000000},
	{0x020E01C4, 0x00000005},
	{0x020E01C8, 0x00000005},
	{0x020E01D4, 0x00000005},
	{0x020E01E4, 0x00000002},
	{0x020E01E8, 0x00000002},
	{0x020E01FC, 0x00000002},
	{0x020E0204, 0x00000002},
	{0x020E0210, 0x00000003},
	{0x020E0214, 0x00000006},
	{0x020E021C, 0x00000000},
	{0x020E0230, 0x00000006},
	{0x020E0244, 0x00000004},
	{0x020E0248, 0x00000004},
	{0x020E0250, 0x00000014},
	{0x020E0258, 0x00000004},
	{0x020E025C, 0x00000004},
	{0x020E0264, 0x00000014},
	{0x020E027C, 0x00000002},
	{0x020E02DC, 0x00000000},
	{0x020E02E0, 0x00000000},
	{0x020E02E4, 0x00000000},
	{0x020E02E8, 0x00000000},
	{0x020E02EC, 0x00000000},
	{0x020E02F0, 0x00000000},
	{0x020E02FC, 0x00000003},
	{0x020E0300, 0x00000003},
	{0x020E0304, 0x00000003},
	{0x020E0308, 0x00000003},
	{0x020E030C, 0x00000000},
	{0x020E0310, 0x00000000},
	{0x020E0314, 0x00000000},
	{0x020E0318, 0x00000000},
	{0x020E031C, 0x00000000},
	{0x020E0320, 0x00000000},
	{0x020E0324, 0x00000000},
	{0x020E0328, 0x00000000},
	{0x020E032C, 0x00000000},
	{0x020E0330, 0x00000000},
	{0x020E0338, 0x00000000},
	{0x020E033C, 0x00000000},
	{0x020E0340, 0x00000001},
	{0x020E0344, 0x00000001},
	{0x020E0348, 0x00000001},
	{0x020E034C, 0x00000001},
	{0x020E0350, 0x00000002},
	{0x020E0354, 0x00000002},
	{0x020E0358, 0x00000002},
	{0x020E035C, 0x00000002},
	{0x020E03C0, 0x000130B0},
	{0x020E03C4, 0x00001011},
	{0x020E03C8, 0x00001011},
	{0x020E03CC, 0x00001011},
	{0x020E03D0, 0x00001011},
	{0x020E03D4, 0x00001011},
	{0x020E03D8, 0x00001011},
	{0x020E03DC, 0x00001011},
	{0x020E03E0, 0x00001011},
	{0x020E03E4, 0x00001011},
	{0x020E03E8, 0x00001011},
	{0x020E03EC, 0x00001011},
	{0x020E03F0, 0x00001011},
	{0x020E03F4, 0x00001011},
	{0x020E03F8, 0x00001011},
	{0x020E03FC, 0x00001011},
	{0x020E0400, 0x00001011},
	{0x020E0404, 0x00001011},
	{0x020E0408, 0x00001011},
	{0x020E040C, 0x00001011},
	{0x020E0410, 0x00001011},
	{0x020E0414, 0x00001011},
	{0x020E0418, 0x00001011},
	{0x020E041C, 0x00001011},
	{0x020E0420, 0x00001011},
	{0x020E04E0, 0x0001B0B9},
	{0x020E04E4, 0x0001B0B9},
	{0x020E04E8, 0x0001B0B9},
	{0x020E04EC, 0x0001B0B9},
	{0x020E04F0, 0x0001B0B9},
	{0x020E04F4, 0x0001B0B9},
	{0x020E04F8, 0x0001B0B9},
	{0x020E04FC, 0x0001B0B9},
	{0x020E0500, 0x0001B0B9},
	{0x020E0510, 0x00003070},
	{0x020E0514, 0x0001B0B9},
	{0x020E0518, 0x0001B0B9},
	{0x020E051C, 0x0001B0B9},
	{0x020E0520, 0x0001B0B9},
	{0x020E0524, 0x0001B0B9},
	{0x020E0528, 0x0001B0B8},
	{0x020E052C, 0x000130B9},
	{0x020E0530, 0x0001B0B9},
	{0x020E0534, 0x0001B0B8},
	{0x020E0538, 0x0001B0B9},
	{0x020E053C, 0x0001B0B9},
	{0x020E0540, 0x0001B0B8},
	{0x020E0544, 0x0001B0B8},
	{0x020E0548, 0x0001B0B9},
	{0x020E054C, 0x0001B0B9},
	{0x020E0550, 0x000130B9},
	{0x020E0554, 0x0001B0B9},
	{0x020E0558, 0x0001B0B9},
	{0x020E055C, 0x0001B0B9},
	{0x020E0560, 0x0001B0B9},
	{0x020E0564, 0x0001B0B9},
	{0x020E0568, 0x0001B0B9},
	{0x020E056C, 0x0001B0B9},
	{0x020E0570, 0x0001B0B9},
	{0x020E0574, 0x0001B0B9},
	{0x020E0578, 0x0001B0B9},
	{0x020E057C, 0x0001B0B9},
	{0x020E0580, 0x0001B0B9},
	{0x020E0584, 0x0001B0B9},
	{0x020E0588, 0x0001B0B9},
	{0x020E058C, 0x0001B0B9},
	{0x020E0590, 0x0001B0B9},
	{0x020E05A8, 0x0001B0B9},
	{0x020E05AC, 0x0001B0B9},
	{0x020E05B0, 0x0001B0B9},
	{0x020E05C8, 0x000130B0},
	{0x020E05D0, 0x000130B0},
	{0x020E05DC, 0x0000F088},
	{0x020E05E0, 0x0001B080},
	{0x020E05E8, 0x0000F088},
	{0x020E05F8, 0x00013090},
	{0x020E0604, 0x000130B0},
	{0x020E0650, 0x0001B0B0},
	{0x020E065C, 0x000130B0},
	{0x020E0668, 0x000130B0},
	{0x020E0670, 0x000130B0},
	{0x020E0678, 0x000130B0},
	{0x020E067C, 0x000130B0},
	{0x020E0680, 0x000130B0},
	{0x020E0684, 0x000130B0},
	{0x020E0688, 0x000130B0},
	{0x020E06C4, 0x0000B0F9},
	{0x020E06C8, 0x0000B0F9},
	{0x020E06CC, 0x0000B0F9},
	{0x020E06D0, 0x0000B0F9},
	{0x020E06D4, 0x0000B0F9},
	{0x020E06D8, 0x0000B0F9},
	{0x020E06F4, 0x0000B0F9},
	{0x020E06F8, 0x0000B0F9},
	{0x020E06FC, 0x0000B0F9},
	{0x020E0700, 0x0000B0B9},
	{0x020E0704, 0x0000B0F9},
	{0x020E0708, 0x0000B0F9},
	{0x020E070C, 0x0000B0F9},
	{0x020E0710, 0x0000B0F9},
	{0x020E0714, 0x0000B0F9},
	{0x020E0718, 0x0000B0F9},
	{0x020E0790, 0x00000001},
	{0x020E0798, 0x00000001},
	{0x020E07A8, 0x00000001},
	{0x020E07AC, 0x00000001},
	{0x020E0870, 0x00000001},
	{0x020E0874, 0x00000001},
	{0x020E0878, 0x00000002},
	{0x020E087C, 0x00000001},
	{0x020E0900, 0x00000004},
	{0x020E0904, 0x00000006},
	{0x020E0914, 0x00000003},
	{0x020E091C, 0x00000003},
	{0x020E0928, 0x00000001},
	{0x020E0934, 0x00000001},
	/* NOR/WEIM controller settings (TODO: timing!!!) */
	{0x021B8000, 0x00020101},	/* WEIM_CS0_xCRn */
	{0x021B8004, 0x00000000},
	{0x021B8008, 0x10002100},
	{0x021B800C, 0x00008000},
	{0x021B8010, 0x10000440},
	{0x021B8014, 0x00000000},
	{0x021B8090, 0x00000000},	/* WEIM_WCR */
	{0x020E0004, 0x48400005},	/* IOMUXC_IOMUXC_GPR1: CS0 = 128 MB */
	{END_OF_TABLE},
};

#ifdef CONFIG_BOARD_VRNS_B2_MX6S
static const env_entry board_env_vrnsb2s[] = {
	{"kerneladdr", "0x08100000"},
	{"dtbsrc", "0x080C8000"},
	{"dtbsize", "0x8000"},
	{"cpucount", "nosmp"},
	{"console", "ttymxc3"},
	{"loadkernel", "echo Starting kernel from parallel flash ..."},
	{"loaddtb", "cp.b ${dtbsrc} ${dtbaddr} ${dtbsize}"},
	{"gen3boot", "echo Booting from parallel NOR ...; "	\
		"run kernelargs; "				\
		"run loaddtb; "					\
		"bootm ${kerneladdr} - ${dtbaddr}"},
	{0, 0}
};

const board_config board_data_vrnsb2s = {
	.name = "MX6S-VRNS-B2",
	.dcd = dcd_vrnsb2_solo,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 * The mx6xvrnsb2 builds will use the hard coded defines from
	 * include/configs/mx6vrnsb3.h, instead.
	 */
	.env = board_env_vrnsb2s,
	.ram_size = 512u * 1024 * 1024,
	.board_init = board_init_vrnsb2,
	.board_usb_otg_init = board_usb_otg_init_vrnsb2,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_FLASH,
};
#endif

#ifdef CONFIG_BOARD_VRNS_B2_MX6S_1GB
static const env_entry board_env_vrnsb2s_1gb[] = {
	{"kerneladdr", "0x08100000"},
	{"dtbsrc", "0x080E0000"},
	{"dtbsize", "0x8000"},
	{"cpucount", "nosmp"},
	{"console", "ttymxc3"},
	{"loadkernel", "echo Starting kernel from parallel flash ..."},
	{"loaddtb", "cp.b ${dtbsrc} ${dtbaddr} ${dtbsize}"},
	{"gen3boot", "echo Booting from parallel NOR ...; "	\
		"run kernelargs; "				\
		"run loaddtb; "					\
		"bootm ${kerneladdr} - ${dtbaddr}"},
	{0, 0}
};

const board_config board_data_vrnsb2s_1gb = {
	.name = "MX6S-VRNS-B2 1GB",
	.dcd = dcd_vrnsb2_solo,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 * The mx6xvrnsb2 builds will use the hard coded defines from
	 * include/configs/mx6vrnsb3.h, instead.
	 */
	.env = board_env_vrnsb2s_1gb,
	.ram_size = 1u * 1024 * 1024 * 1024,
	.board_init = board_init_vrnsb2,
	.board_usb_otg_init = board_usb_otg_init_vrnsb2,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_FLASH,
};
#endif
#endif
