/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/io.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/mx6x_pins.h>
#include <asm/arch/sys_proto.h>
#include <asm/imx-common/iomux-v3.h>
#include <asm/errno.h>
#include <asm/gpio.h>

#ifdef CONFIG_CMD_SF
#include <imx_spi.h>
#endif

#ifdef CONFIG_CMD_MMC
#include <mmc.h>
#include <fsl_esdhc.h>
#include <asm/arch/clock.h>
#endif

#ifdef CONFIG_IMX_ECSPI
#include <spi.h>
#include <imx_spi.h>
#endif

DECLARE_GLOBAL_DATA_PTR;

int dram_init(void)
{
	gd->ram_size = get_ram_size((void *)PHYS_SDRAM, PHYS_SDRAM_SIZE);

	return 0;
}

#ifdef CONFIG_USB_EHCI_MX6
int board_ehci_hcd_init(int port)
{
	return 0;
}
#endif

static void setup_misc_iomux(void)
{
	/* switch on SD card */
	gpio_direction_output(116, 1);	/* GPIO 4-20, SD_MPWR */

	/*
	 * activate ADR3
	 * ADR_RESET
	 */
	gpio_direction_output(101, 0);	/* GPIO 4-5, ADR_RESET */
	/* ADR_BOOT_SELECT0 = 0 */
	gpio_direction_output(9, 0);	/* GPIO 1-9, ADR_BOOT_SELECT0 */
	/* ADR_BOOT_SELECT1 = 0 */
	gpio_direction_output(1, 0);	/* GPIO 1-1, ADR_BOOT_SELECT1 */
	/* ADR_RESET disable */
	udelay(10000);
	gpio_set_value(101, 1);		/* GPIO 4-5, ADR_RESET */

	/* Display standby disable */
	gpio_direction_output(39, 1);	/* GPIO 2-7, DISP_STBYB */
}

#ifdef CONFIG_CMD_MMC
struct fsl_esdhc_cfg usdhc_cfg[2] = {
	{USDHC1_BASE_ADDR},
	{USDHC3_BASE_ADDR}
};

int board_mmc_getcd(struct mmc *mmc)
{
	struct fsl_esdhc_cfg *cfg = (struct fsl_esdhc_cfg *)mmc->priv;
	int ret;

	if (cfg->esdhc_base == USDHC1_BASE_ADDR) {
		gpio_direction_input(4); /* SD card slot: GPIO1_4 */
		ret = !gpio_get_value(4);
	} else
		ret = 1; /* eMMC: Card is always inserted */

	return ret;
}

int usdhc_gpio_init(bd_t *bis)
{
	s32 status = 0;
	u32 index = 0;

	usdhc_cfg[0].sdhc_clk = mxc_get_clock(MXC_ESDHC_CLK);
	usdhc_cfg[1].sdhc_clk = mxc_get_clock(MXC_ESDHC3_CLK);

	for (index = 0; index < CONFIG_SYS_FSL_USDHC_NUM; ++index)
		status |= fsl_esdhc_initialize(bis, &usdhc_cfg[index]);

	return status;
}

int board_mmc_init(bd_t *bis)
{
	if (!usdhc_gpio_init(bis))
		return 0;
	else
		return -1;
}
#endif

extern const dcd_config dcd_vrnsa2[];

int board_early_init_f(void)
{
	/* Fixme: Later to be done based on the board ID */
	const dcd_config * dcd = dcd_vrnsa2;

	dcd_init(dcd);

	return 0;
}

int board_init(void)
{
	setup_misc_iomux();

	/* address of boot parameters */
	gd->bd->bi_boot_params = PHYS_SDRAM + 0x100;

	return 0;
}

int checkboard(void)
{
	ocram * config = (ocram *)IRAM_BASE_ADDR;

	printf("Board: MX6D-VRNS-A2(PCB%d)\n", CONFIG_VRNS_A2SAMPLE);

	printf("Board ID: 0x%04x (#%d)\n", config->boardid, config->idcount);

	return 0;
}
