/*
 * Copyright (C) 2013 Mentor Graphics, Inc. All Rights Reserved.
 *
 *  fsl_asrc.h  --  ALSA SoC ASRC Platform Driver
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 */

#include <linux/mxc_asrc_core_internal.h>
#include <linux/list.h>
#include "imx-pcm.h"

#ifndef _FSL_ASRC_H
#define _FSL_ASRC_H

#ifdef __KERNEL__

#define FE_STREAM_DIRECTION(s) ((s) == SNDRV_PCM_STREAM_PLAYBACK ? \
		SECTION_INPUT : SECTION_OUTPUT)
#define BE_STREAM_DIRECTION(s) ((s) == SNDRV_PCM_STREAM_PLAYBACK ? \
		SECTION_OUTPUT : SECTION_INPUT)

#define MAX_STREAM_NAME_SIZE		64
#define FSL_ASRC_PCM_DMA_PRIORITY	DMA_PRIO_HIGH
#define FSL_ASRC_DMABUF_SIZE		IMX_SSI_DMABUF_SIZE
#define FSL_ASRC_PERIOD_BYTES_MIN	128
#define FSL_ASRC_PERIOD_BYTES_MAX	65535
#define FSL_ASRC_PERIOD_MIN		2
#define FSL_ASRC_PERIOD_MAX		255
#define FSL_ASRC_WATERMARK		DEFAULT_FIFO_PERIOD

#define FSL_ASRC_P2P_FORMATS		(ASRC_SUPPORTED_INPUT_FORMATS &\
					 ASRC_SUPPORTED_OUTPUT_FORMATS)

#define FSL_ASRC_VALUE_INT_DIRECTIONAL(xname, xmax, xget, xput, xstream) \
{	.iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, \
	.info = fsl_asrc_no_pcm_info, \
	.get = xget, \
	.put = xput, \
	.private_value = xmax, \
	.subdevice = xstream}

#define FSL_ASRC_DAPM_ENUM_EXT_DIRECTIONAL(xname, xenum, xget, xput, xstream) \
{	.iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, \
	.info = snd_soc_info_enum_double, \
	.get = xget, \
	.put = xput, \
	.private_value = (unsigned long)&xenum, \
	.subdevice = xstream}

/* one entry per open section */
struct section_table_entry {
	unsigned int uid;
	char *stream_name;
	char *ideal_clock_name;
	enum asrc_pair_index pair_idx;
	struct asrc_section_params *params;
	struct imx_pcm_dma_params dma_params;
	struct snd_pcm_hardware pcm_hw;
	enum asrc_section_direction direction;
	int stream_direction;
	struct list_head list_item;
};

struct fsl_asrc_private {
	struct list_head section_list;
	spinlock_t data_lock;
};

int fsl_asrc_request_pair(struct fsl_asrc_core_private *,
		const char const *streamname,
		enum asrc_section_direction direction, unsigned char mask,
		int stream_direction);
int fsl_asrc_set_period(const char const *streamname,
		enum asrc_section_direction direction,
		unsigned char *period,
		int stream_direction);
int fsl_asrc_set_filters(const char const *streamname,
		enum asrc_section_direction direction,
		enum filter_settings settings,
		int stream_direction);
struct snd_pcm_hardware *
fsl_asrc_get_capabilities(const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
struct imx_pcm_dma_params *
fsl_asrc_get_dma_params(const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
int fsl_asrc_set_setup(const char const *streamname,
		enum asrc_section_direction direction,
		struct section_config *config,
		int stream_direction);
int fsl_asrc_set_be_clock_reference(
		const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
int fsl_asrc_set_fe_clock_reference(
		const char const *streamname,
		enum asrc_section_direction direction,
		int ideal_clk_idx,
		int stream_direction);
int fsl_asrc_prepare(const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
int fsl_asrc_configure_asrc(const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
int fsl_asrc_start_conversion(const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
int fsl_asrc_stop_conversion(const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
int fsl_asrc_cleanup(const char const *streamname,
		enum asrc_section_direction direction,
		int stream_direction);
const char const **fsl_asrc_fetch_clock_list(
		struct fsl_asrc_core_private *, int *);
int fsl_asrc_add_controls(struct snd_card *card, struct device *dev,
	const struct snd_kcontrol_new *controls, int num_controls,
	const char *prefix, void *data);
int fsl_asrc_adjust_burst_per_watermark(int user_burst,
					int user_watermark, int section);
int fsl_asrc_no_pcm_info(struct snd_kcontrol *kcontrol,
	struct snd_ctl_elem_info *uinfo);
int fsl_asrc_clear_xrun_callback(const char const *streamname,
	enum asrc_section_direction direction,
	int stream_direction);
int fsl_asrc_set_xrun_callback(const char const *streamname,
	enum asrc_section_direction direction,
	int stream_direction,
	void (*func)(void *), void *arg);

#endif /* __KERNEL__ */

#endif /* _FSL_ASRC_H */
