/*
 *   Copyright (c) 2012 Robert Bosch GmbH, Hildesheim
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#ifndef AF_INC_H
#define AF_INC_H

#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/list.h>
#include <linux/rcupdate.h>
#include "linux/inc.h"

#undef PDEBUG             /* undef it, just in case */
#ifdef DEBUG
#define PDEBUG(fmt, args...)\
	pr_debug("af_inc: %s: " fmt, __func__, ## args)
#else
#define PDEBUG(fmt, args...) /* not debugging: nothing */
#endif

#undef PERR             /* undef it, just in case */
#define PERR(fmt, args...)\
	pr_err("af_inc: %s: " fmt, __func__, ## args)
#undef PERRMEM             /* undef it, just in case */
#define PERRMEM(fmt, args...)\
	pr_alert("af_inc: %s: " fmt, __func__, ## args)

struct inc_sock {
	struct sock sk;
	int bound;
	__be32 inet_saddr;
	__be16 inet_sport;

	__be32 inet_conaddr;
	__be16 inet_conport;
	struct notifier_block notifier;
	struct remote_peer *peer;
	char nonagle; /*dummy tcp options*/
};

#define INC_PORT_ANY 0
#define INC_AUTOBIND_PORT_MIN 0xf0fc
#define INC_AUTOBIND_PORT_MAX 0xf0fe

/**
 * struct inc_proto - protocol structure
 * @type:       type argument in socket() syscall, e.g. SOCK_DGRAM.
 * @protocol:   protocol number in socket() syscall.
 * @ops:        pointer to struct proto_ops for sock->ops.
 * @prot:       pointer to struct proto structure.
 */
struct inc_proto {
	int type;
	int protocol;
	const struct proto_ops *ops;
	struct proto *prot;
};

extern wait_queue_head_t *inc_lookup_waitq(int ifindex, __be16 port);

extern int inc_lookup_add(struct sock *sk, __be32 addr, __be16 port,
		bool accepted);
extern int inc_lookup_rm(struct sock *sk);

void inc_channel_setstate(int ifindex, __be16 port, int newstate);
int inc_channel_getstate(int ifindex, __be16 port);

struct sock *inc_new(struct net *net, struct socket *sock,
			int protocol, struct proto *prot);

int inc_proto_register(const struct inc_proto *cp);
void inc_proto_unregister(const struct inc_proto *cp);

int inc_send(struct sk_buff *skb, int loop);
int inc_ioctl(struct socket *sock, unsigned int cmd, unsigned long arg);

#endif /* AF_INC_H */
