/*
 * uapi/linux/errmem.h
 *
 * Copyright (C) 2013 Advanced Driver Information Technology GmbH
 * Written by Kai Tomerius (ktomerius@de.adit-jv.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _UAPI___ERRMEM_H__
#define _UAPI___ERRMEM_H__

#define ERRMEM_VERSION          0x201 /* v2.01 */
#define ERRMEM_MINOR            0xee
#define ERRMEM_MAGIC_IOC        0xee

#define IOCTL_ERRMEM_VERSION                                              \
	_IOR(ERRMEM_MAGIC_IOC, 0,  unsigned long)
#define IOCTL_ERRMEM_GET_NUMBER_OF_SLOTS                                  \
	_IOR(ERRMEM_MAGIC_IOC, 1,  unsigned)
#define IOCTL_ERRMEM_GET_SLOTSIZE                                         \
	_IOR(ERRMEM_MAGIC_IOC, 2,  unsigned)
#define IOCTL_ERRMEM_GET_USED_SLOTS                                       \
	_IOR(ERRMEM_MAGIC_IOC, 3,  unsigned)
#define IOCTL_ERRMEM_ACKNOWLEDGE                                          \
	_IOW(ERRMEM_MAGIC_IOC, 4,  unsigned)
#define IOCTL_ERRMEM_FLUSH                                                \
	_IO(ERRMEM_MAGIC_IOC, 5)
#define IOCTL_ERRMEM_GET_WATERMARK_LOW                                    \
	_IOR(ERRMEM_MAGIC_IOC, 6,  unsigned)
#define IOCTL_ERRMEM_SET_WATERMARK_LOW                                    \
	_IOW(ERRMEM_MAGIC_IOC, 7,  unsigned)
#define IOCTL_ERRMEM_GET_WATERMARK_HIGH                                   \
	_IOR(ERRMEM_MAGIC_IOC, 8,  unsigned)
#define IOCTL_ERRMEM_SET_WATERMARK_HIGH                                   \
	_IOW(ERRMEM_MAGIC_IOC, 9,  unsigned)
#define IOCTL_ERRMEM_GET_KERNEL_MSG_LEVEL                                 \
	_IOR(ERRMEM_MAGIC_IOC, 10, unsigned)
#define IOCTL_ERRMEM_SET_KERNEL_MSG_LEVEL                                 \
	_IOW(ERRMEM_MAGIC_IOC, 11, unsigned)
#define IOCTL_ERRMEM_WRITE                                                \
	_IOW(ERRMEM_MAGIC_IOC, 12, struct errmem_message)
#define IOCTL_ERRMEM_READ                                                 \
	_IOR(ERRMEM_MAGIC_IOC, 13, struct errmem_message)
#define IOCTL_ERRMEM_SET_READ_SIZE                                        \
	_IOW(ERRMEM_MAGIC_IOC, 14, unsigned)
#define IOCTL_ERRMEM_SET_EPOCH_MS                                         \
	_IOW(ERRMEM_MAGIC_IOC, 15, unsigned long long)

/* Message for type declaration, actual size can be different */
#define ERRMEM_MAX_ENTRY_LENGTH 256

/* Errmem status flags of messages read */
/* see llrb.h, #define LLRB_SLOT_... */
#define ERRMEM_FLAG_OK          0x000
#define ERRMEM_FLAG_DROPPED     0x001 /* some data has been dropped */
#define ERRMEM_FLAG_BUSY        0x002 /* temporary access conflict */
#define ERRMEM_FLAG_INCOMPLETE  0x004 /* incomplete message */
#define ERRMEM_FLAG_OUTDATED    0x008 /* outdated (out-of-order) message */
#define ERRMEM_FLAG_CRC_ERROR   0x010 /* message with bad crc */
#define ERRMEM_FLAG_ANY_ERROR   0x01f /* any of the above flags */
#define ERRMEM_FLAG_RESTART     0x020 /* ring buffer has been restarted */
#define ERRMEM_FLAG_INITIALIZED 0x040 /* ring buffer has been initialized */

/*
 * Errmem message types
 */
enum errmem_entry_type {
	ERRMEM_TYPE_TRACE = 0,
	ERRMEM_TYPE_ASCII
};

/*
 * Errmem internal fields, used between driver and daemon
 */
struct errmem_internal {
	unsigned seqnum;
	unsigned local_clock[2];
	unsigned offset;
	unsigned flags;
	unsigned crc;
	unsigned storage;
};

/*
 * Messages read with IOCTL_ERRMEM_READ
 * message[] can be of arbitrary length
 */
struct errmem_message {
	enum errmem_entry_type type;
	struct errmem_internal internal;

	unsigned short length;
	unsigned char message[ERRMEM_MAX_ENTRY_LENGTH];
};


#endif /* _UAPI__ERRMEM_H__ */
