/*
 * Copyright (C) 2014 Advanced Driver Information Technology GmbH
 * Written by Norbert Uetrecht <nuetrecht@de.adit-jv.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _UAPI_CAAM_EE_H
#define _UAPI_CAAM_EE_H

#include <linux/kernel.h>

#define CAAM_SET_SESSION_KEY \
	_IOW('l', 0, struct caam_ee_session_key_data *)
#define CAAM_WRAP_BLOB \
	_IOWR('l', 1, struct caam_ee_ioctl_params *)
#define CAAM_UNWRAP_BLOB \
	_IOWR('l', 2, struct caam_ee_ioctl_params *)
#define CAAM_ENCRYPT_BLOCK \
	_IOWR('l', 3, struct caam_ee_ioctl_params *)
#define CAAM_DECRYPT_BLOCK \
	_IOWR('l', 4, struct caam_ee_ioctl_params *)
#define CAAM_VERIFY_HMAC \
	_IOW('l', 5, struct caam_ee_ioctl_params *)

/* caam_ee IOCTL flag mappings*/
#define CAAM_ENCODE_MASK         0x3F
#define CAAM_ENCODE_3DES_128     0
#define CAAM_ENCODE_3DES_192     1
#define CAAM_ENCODE_AES_128      2
#define CAAM_ENCODE_AES_192      3
#define CAAM_ENCODE_AES_256      4
#define CAAM_ENCODE_DES_64       5

#define CAAM_OP_MASK             0xC0
#define CAAM_OP_SINGLE           (0 << 6)
#define CAAM_OP_MULTI_INIT       (1 << 6)
#define CAAM_OP_MULTI_UPDATE     (2 << 6)
#define CAAM_OP_MULTI_FINALIZE   (3 << 6)

#define CAAM_WRAP_MASK           0x300
#define CAAM_WRAP_ECB            (0 << 8)
#define CAAM_WRAP_CCM            (1 << 8)

#define CAAM_HMAC_MASK           0xfc00
#define CAAM_ENCODE_MD5          (0 << 10)
#define CAAM_ENCODE_SHA_1        (1 << 10)
#define CAAM_ENCODE_SHA_224      (2 << 10)
#define CAAM_ENCODE_SHA_256      (3 << 10)
#define CAAM_ENCODE_SHA_384      (4 << 10)
#define CAAM_ENCODE_SHA_512      (5 << 10)

struct caam_ee_params {
	uint8_t  *buf;      /* Pointer to buffer containing data */
	uint32_t len;       /* Number of bytes of valid data in *buf */
	uint8_t  *auxbuf;   /* Pointer to auxiliary buffer */
	uint32_t auxlen;    /* Length of auxbuf */
	uint32_t flags;
};

struct caam_ee_session_key_data {
	uint32_t key_id;
};


#endif /* _UAPI_CAAM_EE_H */
