/*
 * Copyright (C) 2009-2013 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __MXS_PHY_H
#define __MXS_PHY_H

#define HW_USBPHY_CTRL				0x30
#define HW_USBPHY_CTRL_SET			0x34
#define HW_USBPHY_CTRL_CLR			0x38

#define BM_USBPHY_CTRL_SFTRST				BIT(31)
#define BM_USBPHY_CTRL_CLKGATE				BIT(30)
#define BM_USBPHY_CTRL_UTMI_SUSPENDM		BIT(29)
#define BM_USBPHY_CTRL_HOST_FORCE_LS_SE0	BIT(28)
#define BM_USBPHY_CTRL_OTG_ID_VALUE			BIT(27)
#define BM_USBPHY_CTRL_ENAUTOSET_USBCLKS	BIT(26)
#define BM_USBPHY_CTRL_ENAUTOCLR_USBCLKGATE	BIT(25)
#define BM_USBPHY_CTRL_FSDLL_RST_EN			BIT(24)
#define BM_USBPHY_CTRL_ENVBUSCHG_WKUP		BIT(23)
#define BM_USBPHY_CTRL_ENIDCHG_WKUP			BIT(22)
#define BM_USBPHY_CTRL_ENDPDMCHG_WKUP		BIT(21)
#define BM_USBPHY_CTRL_ENAUTOCLR_PHY_PWD	BIT(20)
#define BM_USBPHY_CTRL_ENAUTOCLR_CLKGATE	BIT(19)
#define BM_USBPHY_CTRL_ENAUTO_PWRON_PLL		BIT(18)
#define BM_USBPHY_CTRL_WAKEUP_IRQ			BIT(17)
#define BM_USBPHY_CTRL_ENIRQWAKEUP			BIT(16)
#define BM_USBPHY_CTRL_ENUTMILEVEL3			BIT(15)
#define BM_USBPHY_CTRL_ENUTMILEVEL2			BIT(14)
#define BM_USBPHY_CTRL_DATA_ON_LRADC		BIT(13)
#define BM_USBPHY_CTRL_DEVPLUGIN_IRQ		BIT(12)
#define BM_USBPHY_CTRL_ENIRQDEVPLUGIN		BIT(11)
#define BM_USBPHY_CTRL_RESUME_IRQ			BIT(10)
#define BM_USBPHY_CTRL_ENIRQRESUMEDETECT	BIT(9)
#define BM_USBPHY_CTRL_RESUMEIRQSTICKY		BIT(8)
#define BM_USBPHY_CTRL_ENOTGIDDETECT		BIT(7)
#define BM_USBPHY_CTRL_OTG_ID_CHG_IRQ		BIT(6)
#define BM_USBPHY_CTRL_DEVPLUGIN_POLARITY	BIT(5)
#define BM_USBPHY_CTRL_ENDEVPLUGINDETECT	BIT(4)
#define BM_USBPHY_CTRL_HOSTDISCONDETECT_IRQ	BIT(3)
#define BM_USBPHY_CTRL_ENIRQHOSTDISCON		BIT(2)
#define BM_USBPHY_CTRL_ENHOSTDISCONDETECT	BIT(1)
#define BM_USBPHY_CTRL_ENOTG_ID_CHG_IRQ		BIT(0)

#define HW_USBPHY_PWD   (0x00000000)
#define HW_USBPHY_PWD_SET   (0x00000004)
#define HW_USBPHY_PWD_CLR   (0x00000008)
#define HW_USBPHY_PWD_TOG   (0x0000000c)

#define BP_USBPHY_PWD_RSVD2      21
#define BM_USBPHY_PWD_RSVD2 0xFFE00000
#define BF_USBPHY_PWD_RSVD2(v) \
	    (((v) << 21) & BM_USBPHY_PWD_RSVD2)
#define BM_USBPHY_PWD_RXPWDRX 0x00100000
#define BM_USBPHY_PWD_RXPWDDIFF 0x00080000
#define BM_USBPHY_PWD_RXPWD1PT1 0x00040000
#define BM_USBPHY_PWD_RXPWDENV 0x00020000
#define BP_USBPHY_PWD_RSVD1      13
#define BM_USBPHY_PWD_RSVD1 0x0001E000
#define BF_USBPHY_PWD_RSVD1(v)  \
	    (((v) << 13) & BM_USBPHY_PWD_RSVD1)
#define BM_USBPHY_PWD_TXPWDV2I 0x00001000
#define BM_USBPHY_PWD_TXPWDIBIAS 0x00000800
#define BM_USBPHY_PWD_TXPWDFS 0x00000400
#define BP_USBPHY_PWD_RSVD0      0
#define BM_USBPHY_PWD_RSVD0 0x000003FF
#define BF_USBPHY_PWD_RSVD0(v)  \
	    (((v) << 0) & BM_USBPHY_PWD_RSVD0)

#define HW_USBPHY_DEBUG (0x00000050)
#define HW_USBPHY_DEBUG_SET (0x00000054)
#define HW_USBPHY_DEBUG_CLR (0x00000058)
#define HW_USBPHY_DEBUG_TOG (0x0000005c)
#define BM_USBPHY_DEBUG_CLKGATE 0x40000000

#define HW_USBPHY_IP	(0x00000090)
#define HW_USBPHY_IP_SET	(0x00000094)
#define HW_USBPHY_IP_CLR	(0x00000098)
#define HW_USBPHY_IP_TOG	(0x0000009c)
#define HW_USBPHY_IC_FIX_ENABLED	BIT(17)
#define HW_USBPHY_IC_FIX_ENABLED_6SL	BIT(18)

#define HW_ANADIG_ANA_MISC0 (0x00000150)
#define HW_ANADIG_ANA_MISC0_SET (0x00000154)
#define HW_ANADIG_ANA_MISC0_CLR (0x00000158)
#define HW_ANADIG_ANA_MISC0_TOG (0x0000015c)
#define BM_ANADIG_ANA_MISC0_STOP_MODE_CONFIG 0x00001000

#define HW_ANADIG_USB1_LOOPBACK (0x000001e0)
#define HW_ANADIG_USB1_LOOPBACK_SET (0x000001e4)
#define HW_ANADIG_USB1_LOOPBACK_CLR (0x000001e8)
#define HW_ANADIG_USB1_LOOPBACK_TOG (0x000001ec)
#define BM_ANADIG_USB1_LOOPBACK_UTMI_DIG_TST1 0x00000004
#define BM_ANADIG_USB1_LOOPBACK_TSTI_TX_EN 0x00000020

#define BM_ANADIG_USB1_PLL_480_CTRL_EN_USB_CLKS 0x00000040

#define HW_ANADIG_USB1_PLL_480_CTRL_SET	(0x00000014)
#define HW_ANADIG_USB1_PLL_480_CTRL_CLR	(0x00000018)

#define MX6_USB_ANALOG_DIGPROG  0x260
#define MX6SL_USB_ANALOG_DIGPROG  0x280

#define IMX_CHIP_REVISION_1_0		0x10
#define IMX_CHIP_REVISION_1_1		0x11
#define IMX_CHIP_REVISION_1_2		0x12
#define IMX_CHIP_REVISION_1_X		0x19
#define IMX_CHIP_REVISION_UNKNOWN	0xff

extern void mxs_phy_enable_regulator(struct usb_phy *phy, bool enable);
extern void mxs_phy_disconnect_line(struct usb_phy *phy, bool enable);

#endif	/* __MXS_PHY_n*/
