/*
 * Copyright 2008-2012 Freescale Semiconductor, Inc. All Rights Reserved.
 * Copyright (C) 2012 Mentor Graphics, Inc. All Rights Reserved.
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
#ifndef __MXC_ASRC_H__
#define __MXC_ASRC_H__

#include <linux/mxc_asrc_core_internal.h>
#include <uapi/linux/mxc_asrc.h>

#define ASRC_DEVICE_NAME	"mxc_asrc"

#define SECTION_INVALID		-1
#define ACTIVE				1
#define INACTIVE			0

struct dma_block {
	unsigned int length;
	unsigned int periods;
	unsigned int frames_period;
	unsigned char *dma_vaddr;
	dma_addr_t dma_paddr;
};

struct section_dma {
	struct dma_chan *channel;
	struct dma_block dma;
	struct dma_async_tx_descriptor *desc;
};

/* One of these structures per open file descriptor */
struct asrc_section_private {
	struct fsl_asrc_private *private;
	int uid;
	enum asrc_section_direction direction;
	struct asrc_section_params *section_params;
	struct asrc_section_capabilities capabilities;
	struct section_dma section_dma;
	struct section_buffer_config buffer_config;
	struct section_sync sync;
	wait_queue_head_t wait_queue;
	spinlock_t sect_lock;
};

struct fsl_asrc_private {
	struct fsl_asrc_core_private *asrc_core_private;
	struct {
		enum asrc_pair_index pair_idx;
		int uid;
		int usage[SECTION_CNT];
		struct device *section_dev[SECTION_CNT];
		struct asrc_section_private *section[SECTION_CNT];
	} manager[ASRC_PAIR_NUM];
	struct device *dev;
	struct cdev cdev;
	spinlock_t data_lock;
};

#endif				/* __MXC_ASRC_H__ */
