/*
 * linux/inc_ports.h
 *
 * Definitions for Inter Node Communication - ports
 *
 *   Copyright (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef INC_PORTS_H
#define INC_PORTS_H

#define PORT_OFFSET			0xC700

#define SPM_PORT			(0x01 | PORT_OFFSET)
#define PORT_EXTENDER_GPIO_PORT		(0x02 | PORT_OFFSET)
#define PORT_EXTENDER_ADC_PORT		(0x03 | PORT_OFFSET)
#define PD_NET_PORT			(0x04 | PORT_OFFSET)
#define DIA_UDD_PORT			(0x05 | PORT_OFFSET)
#define SENSORS_PORT			(0x06 | PORT_OFFSET)
#define DLT_PORT			(0x07 | PORT_OFFSET)
#define GNSS_PORT			(0x08 | PORT_OFFSET)
#define WDG_PORT			(0x09 | PORT_OFFSET)
#define PORT_EXTENDER_PWM_PORT		(0x0A | PORT_OFFSET)
#define DOWNLOAD_PORT			(0x0B | PORT_OFFSET)
#define THERMAL_MANAGEMENT_PORT		(0x0C | PORT_OFFSET)
#define SUPPLY_MANGEMENT_PORT		(0x0D | PORT_OFFSET)
#define NET_CTRL_PORT			(0x0E | PORT_OFFSET)
#define NET_BROADCAST_PORT		(0x0F | PORT_OFFSET)
#define NET_TP0_PORT			(0x10 | PORT_OFFSET)
#define NET_TP1_PORT			(0x11 | PORT_OFFSET)
#define NET_TP2_PORT			(0x12 | PORT_OFFSET)
#define NET_TP3_PORT			(0x13 | PORT_OFFSET)
#define INPUT_DEVICE_PORT		(0x14 | PORT_OFFSET)
#define DIA_EVENTMEMORY_PORT		(0x15 | PORT_OFFSET)
#define DIA_APP_PORT			(0x16 | PORT_OFFSET)
#define AUDIO_ROUTER_PORT		(0x17 | PORT_OFFSET)
#define CONNECTION_MASTER_PROXY_PORT	(0x18 | PORT_OFFSET)
#define CONNECTION_MASTER_PLUGIN_PORT	(0x19 | PORT_OFFSET)
#define STREAM_MANAGER_PORT		(0x1A | PORT_OFFSET)
#define DIMMING_PORT			(0x1B | PORT_OFFSET)
#define VEHICLE_DATA_SERVER_PORT	(0x1C | PORT_OFFSET)
#define NET_TP4_PORT			(0x1D | PORT_OFFSET)
#define NET_TP5_PORT			(0x1E | PORT_OFFSET)
#define NET_TP6_PORT			(0x1F | PORT_OFFSET)
#define BAP_00_PORT			(0x20 | PORT_OFFSET)
#define BAP_01_PORT			(0x21 | PORT_OFFSET)
#define BAP_02_PORT			(0x22 | PORT_OFFSET)
#define BAP_03_PORT			(0x23 | PORT_OFFSET)
#define EARLY_AUDIO_PORT		(0x24 | PORT_OFFSET)
#define ADR3CTRL_PORT			(0x25 | PORT_OFFSET)
#define TTFIS_PORT			(0x26 | PORT_OFFSET)
#define SECURITY_PORT			(0x27 | PORT_OFFSET)
#define RTC_PORT			(0x28 | PORT_OFFSET)
#define AMPLIFIER_EXTERNAL_PORT		(0x29 | PORT_OFFSET)
#define GNSS_FW_UPDATE_PORT             (0x2A | PORT_OFFSET)
#define EARLY_APP_PORT                  (0x2B | PORT_OFFSET)
#define ERROR_MEMORY_PORT               (0x2C | PORT_OFFSET)
#define ENGINEERING_MENU_PORT           (0x2D | PORT_OFFSET)

#endif /* INC_PORTS_H */
