/*
 * Copyright 2013 Mentor Graphics, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __DTS_IMX6DQ_SYSCLK_ESAI_H
#define __DTS_IMX6DQ_SYSCLK_ESAI_H

/* ESAI System Clock Directions */
#define SYSCLK_ESAI_DIR_IN		0
#define SYSCLK_ESAI_DIR_OUT		1

/* ESAI System Clock IDs */
#define SYSCLK_ESAI_FSYS		0
#define SYSCLK_ESAI_EXTAL		1
#define SYSCLK_ESAI_EXTAL_DIVS		2
#define SYSCLK_ESAI_HCK			3
#define SYSCLK_ESAI_FSYS_DIVS		4

/* ESAI System Clock Dividers
In synchronous mode only tx dividers are needed
In asynchronous mode tx and rx dividers are needed
we are distinguishing between rx and tx internally */
#define SYSCLK_ESAI_DIV_PSR		0
#define SYSCLK_ESAI_DIV_PM		1
#define SYSCLK_ESAI_DIV_FP		2

#define SYSCLK_ESAI_DIV_PSR_DIVBY_8	0
#define SYSCLK_ESAI_DIV_PSR_DIVBY_1	1
#define SYSCLK_ESAI_DIV_PM_DIVBY(X)	(X-1)

#define SYSCLK_ESAI_DIV_PM_MIN		0
#define SYSCLK_ESAI_DIV_PM_MAX		255

#endif /* __DTS_IMX6DQ_SYSCLK_ESAI_H */
