/*
 * Copyright 2012 Freescale Semiconductor, Inc.
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

enum ci_usb_wakeup_events {
	CI_USB_WAKEUP_EVENT_NONE,
	CI_USB_WAKEUP_EVENT_GADGET,
	CI_USB_WAKEUP_EVENT_HOST,
	CI_USB_WAKEUP_EVENT_OTG,
};

/* Used to set SoC specific callbacks */
struct usbmisc_ops {
	/* It's called once when probe a usb device */
	int (*init)(struct device *dev);
	int (*post)(struct device *dev);
	/* set usb wakeup enable/disable */
	/* To know if current interrupt is wakeup interrupt */
	int (*is_wakeup_intr)(struct device *dev);
	int (*set_wakeup)(struct device *dev,
			enum ci_usb_wakeup_events wakeup_event);
};

struct usbmisc_usb_device {
	struct device *dev; /* usb controller device */
	int index;

	int disable_oc:1; /* over current detect disabled */
	int invert_oc:1; /* invert polarity of over current detect */
	int invert_power:1; /* vbus power control active high */
	/* wakeup event for which operation mode, gadget/host/otg */
	enum ci_usb_wakeup_events wakeup_event;
};

const struct usbmisc_ops *usbmisc_get_ops(void);
#define IMX_WAKEUP_INTR_PENDING		1
#define CI_VBUS_STABLE_TIMEOUT		5000 /*milliseconds*/
