/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_wifi_sme_prim.h"
#include "csr_wifi_sme_lib.h"

static void CsrWifiSmeBlacklistReqFreeContents(CsrWifiSmeBlacklistReq *message)
{
    CsrPmemFree(message->setAddresses);
    message->setAddresses = NULL;
}

static void CsrWifiSmeConnectReqFreeContents(CsrWifiSmeConnectReq *message)
{
    CsrPmemFree(message->connectionConfig.mlmeAssociateReqInformationElements);
    message->connectionConfig.mlmeAssociateReqInformationElements = NULL;
    CsrPmemFree(message->connectionConfig.mibValues);
    message->connectionConfig.mibValues = NULL;
}

static void CsrWifiSmeGetReqFreeContents(CsrWifiSmeGetReq *message)
{
    CsrPmemFree(message->values);
    message->values = NULL;
}

static void CsrWifiSmeSetReqFreeContents(CsrWifiSmeSetReq *message)
{
    CsrPmemFree(message->values);
    message->values = NULL;
}

static void CsrWifiSmeMulticastAddressReqFreeContents(CsrWifiSmeMulticastAddressReq *message)
{
    CsrPmemFree(message->setAddresses);
    message->setAddresses = NULL;
}

static void CsrWifiSmePmkidReqFreeContents(CsrWifiSmePmkidReq *message)
{
    CsrPmemFree(message->setPmkids);
    message->setPmkids = NULL;
}

static void CsrWifiSmeScanFullReqFreeContents(CsrWifiSmeScanFullReq *message)
{
    CsrPmemFree(message->ssid);
    message->ssid = NULL;
    CsrPmemFree(message->channelInfoList);
    message->channelInfoList = NULL;
    CsrPmemFree(message->probeIe);
    message->probeIe = NULL;
}

static void CsrWifiSmeTspecReqFreeContents(CsrWifiSmeTspecReq *message)
{
    CsrPmemFree(message->tspec);
    message->tspec = NULL;
    CsrPmemFree(message->tclas);
    message->tclas = NULL;
}

static void CsrWifiSmeWifiFlightmodeReqFreeContents(CsrWifiSmeWifiFlightmodeReq *message)
{
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < message->mibFilesCount; i1++)
        {
            CsrPmemFree(message->mibFiles[i1].data);
            message->mibFiles[i1].data = NULL;
        }
    }
    CsrPmemFree(message->mibFiles);
    message->mibFiles = NULL;
}

static void CsrWifiSmeWifiOnReqFreeContents(CsrWifiSmeWifiOnReq *message)
{
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < message->mibFilesCount; i1++)
        {
            CsrPmemFree(message->mibFiles[i1].data);
            message->mibFiles[i1].data = NULL;
        }
    }
    CsrPmemFree(message->mibFiles);
    message->mibFiles = NULL;
}

static void CsrWifiSmeCloakedSsidsSetReqFreeContents(CsrWifiSmeCloakedSsidsSetReq *message)
{
    CsrPmemFree(message->cloakedSsids.cloakedSsids);
    message->cloakedSsids.cloakedSsids = NULL;
}

/*----------------------------------------------------------------------------*
 *  NAME
 *      CsrWifiSmeFreeDownstreamMessageContents
 *
 *  DESCRIPTION
 *
 *
 *  PARAMETERS
 *      eventClass: only the value CSR_WIFI_SME_PRIM will be handled
 *      message:    the message to free
 *----------------------------------------------------------------------------*/
void CsrWifiSmeFreeDownstreamMessageContents(CsrUint16 eventClass, void *message)
{
    CsrWifiFsmEvent *evt = (CsrWifiFsmEvent *) message;
    if (evt && (eventClass == CSR_WIFI_SME_PRIM))
    {
        switch (evt->type)
        {
            case CSR_WIFI_SME_BLACKLIST_REQ:
                CsrWifiSmeBlacklistReqFreeContents((CsrWifiSmeBlacklistReq *) message);
                break;
            case CSR_WIFI_SME_CONNECT_REQ:
                CsrWifiSmeConnectReqFreeContents((CsrWifiSmeConnectReq *) message);
                break;
            case CSR_WIFI_SME_GET_REQ:
                CsrWifiSmeGetReqFreeContents((CsrWifiSmeGetReq *) message);
                break;
            case CSR_WIFI_SME_SET_REQ:
                CsrWifiSmeSetReqFreeContents((CsrWifiSmeSetReq *) message);
                break;
            case CSR_WIFI_SME_MULTICAST_ADDRESS_REQ:
                CsrWifiSmeMulticastAddressReqFreeContents((CsrWifiSmeMulticastAddressReq *) message);
                break;
            case CSR_WIFI_SME_PMKID_REQ:
                CsrWifiSmePmkidReqFreeContents((CsrWifiSmePmkidReq *) message);
                break;
            case CSR_WIFI_SME_SCAN_FULL_REQ:
                CsrWifiSmeScanFullReqFreeContents((CsrWifiSmeScanFullReq *) message);
                break;
            case CSR_WIFI_SME_TSPEC_REQ:
                CsrWifiSmeTspecReqFreeContents((CsrWifiSmeTspecReq *) message);
                break;
            case CSR_WIFI_SME_WIFI_FLIGHTMODE_REQ:
                CsrWifiSmeWifiFlightmodeReqFreeContents((CsrWifiSmeWifiFlightmodeReq *) message);
                break;
            case CSR_WIFI_SME_WIFI_ON_REQ:
                CsrWifiSmeWifiOnReqFreeContents((CsrWifiSmeWifiOnReq *) message);
                break;
            case CSR_WIFI_SME_CLOAKED_SSIDS_SET_REQ:
                CsrWifiSmeCloakedSsidsSetReqFreeContents((CsrWifiSmeCloakedSsidsSetReq *) message);
                break;
            default:
                break;
        }
    }
}
