/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_wifi_nme_ap_prim.h"
#include "csr_wifi_nme_ap_lib.h"

static void CsrWifiNmeApStartReqFreeContents(CsrWifiNmeApStartReq *message)
{
    switch (message->apCredentials.authType)
    {
        case CSR_WIFI_SME_AP_AUTH_TYPE_PERSONAL:
            switch (message->apCredentials.nmeAuthType.authTypePersonal.pskOrPassphrase)
            {
                case CSR_WIFI_NME_AP_CREDENTIAL_TYPE_PASSPHRASE:
                    CsrPmemFree(message->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.passphrase);
                    message->apCredentials.nmeAuthType.authTypePersonal.authPers_credentials.passphrase.passphrase = NULL;
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    CsrPmemFree(message->macAddressList);
    message->macAddressList = NULL;
    CsrPmemFree(message->values);
    message->values = NULL;
}

/*----------------------------------------------------------------------------*
 *  NAME
 *      CsrWifiNmeApFreeDownstreamMessageContents
 *
 *  DESCRIPTION
 *
 *
 *  PARAMETERS
 *      eventClass: only the value CSR_WIFI_NME_AP_PRIM will be handled
 *      message:    the message to free
 *----------------------------------------------------------------------------*/
void CsrWifiNmeApFreeDownstreamMessageContents(CsrUint16 eventClass, void *message)
{
    CsrWifiFsmEvent *evt = (CsrWifiFsmEvent *) message;
    if (evt && (eventClass == CSR_WIFI_NME_AP_PRIM))
    {
        switch (evt->type)
        {
            case CSR_WIFI_NME_AP_START_REQ:
                CsrWifiNmeApStartReqFreeContents((CsrWifiNmeApStartReq *) message);
                break;
            default:
                break;
        }
    }
}
