/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/*
 * ---------------------------------------------------------------------------
 *  FILE:     csr_wifi_hip_unifi_udi.h
 *
 *  PURPOSE:
 *      Declarations and definitions for the UniFi Debug Interface.
 *
 * ---------------------------------------------------------------------------
 */
#ifndef CSR_WIFI_HIP_UNIFI_UDI_H__
#define CSR_WIFI_HIP_UNIFI_UDI_H__

#include "csr_synergy.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "csr_wifi_hip_unifi.h"
#include "csr_wifi_hip_signals.h"


/*
 * Support for tracing the wire protocol.
 */

typedef void (*udi_func_t)(void *ospriv, CsrUint8 *sigdata,
                           CsrUint32 signal_len,
                           const CsrWifiHipBulkDataParam *bulkdata,
                           CsrWifiHipLogUdiDirection direction);

CsrResult unifi_set_udi_hook(card_t *card, udi_func_t udi_fn);
CsrResult unifi_remove_udi_hook(card_t *card, udi_func_t udi_fn);


/*
 * Function to print current status info to a string.
 * This is used in the linux /proc interface and might be useful
 * in other systems.
 */
CsrInt32 unifi_print_status(card_t *card, CsrCharString *str, CsrInt32 *remain);

#define UNIFI_SNPRINTF_RET(buf_p, remain, written)                  \
    do {                                                            \
        if (written >= remain) {                                    \
            if (remain >= 2) {                                      \
                buf_p[remain - 2] = '\n';                           \
                buf_p[remain - 1] = 0;                              \
            }                                                       \
            buf_p += remain;                                        \
            remain = 0;                                             \
        } else if (written > 0) {                                   \
            buf_p += written;                                       \
            remain -= written;                                      \
        }                                                           \
    } while (0)


#ifdef __cplusplus
}
#endif

#endif /* __CSR_WIFI_HIP_UNIFI_UDI_H__ */
