/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#ifndef CSR_WIFI_SME_AP_PRIM_H__
#define CSR_WIFI_SME_AP_PRIM_H__

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_prim_defs.h"
#include "csr_sched.h"
#include "csr_wifi_common.h"
#include "csr_result.h"
#include "csr_wifi_fsm_event.h"
#include "csr_wifi_sme_prim.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef CSR_WIFI_AP_ENABLE
#error CSR_WIFI_AP_ENABLE MUST be defined inorder to use csr_wifi_sme_ap_prim.h
#endif

#define CSR_WIFI_SME_AP_PRIM                                            (0x0407)

typedef CsrPrim CsrWifiSmeApPrim;


/*******************************************************************************

  NAME
    CsrWifiSmeApAccessType

  DESCRIPTION
    Allow or deny STAs based on MAC address

 VALUES
    CSR_WIFI_AP_ACCESS_TYPE_NONE  - None
    CSR_WIFI_AP_ACCESS_TYPE_ALLOW - Allow only if MAC address is from the list
    CSR_WIFI_AP_ACCESS_TYPE_DENY  - Disallow if MAC address is from the list

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeApAccessType;
#define CSR_WIFI_AP_ACCESS_TYPE_NONE    ((CsrWifiSmeApAccessType) 0x00)
#define CSR_WIFI_AP_ACCESS_TYPE_ALLOW   ((CsrWifiSmeApAccessType) 0x01)
#define CSR_WIFI_AP_ACCESS_TYPE_DENY    ((CsrWifiSmeApAccessType) 0x02)

/*******************************************************************************

  NAME
    CsrWifiSmeApAuthSupport

  DESCRIPTION
    Define bits for AP authentication support

 VALUES
    CSR_WIFI_SME_RSN_AUTH_WPAPSK  - RSN WPA-PSK Support
    CSR_WIFI_SME_RSN_AUTH_WPA2PSK - RSN WPA2-PSK Support
    CSR_WIFI_SME_AUTH_WAPIPSK     - WAPI-PSK Support

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeApAuthSupport;
#define CSR_WIFI_SME_RSN_AUTH_WPAPSK    ((CsrWifiSmeApAuthSupport) 0x01)
#define CSR_WIFI_SME_RSN_AUTH_WPA2PSK   ((CsrWifiSmeApAuthSupport) 0x02)
#define CSR_WIFI_SME_AUTH_WAPIPSK       ((CsrWifiSmeApAuthSupport) 0x04)

/*******************************************************************************

  NAME
    CsrWifiSmeApAuthType

  DESCRIPTION
    Definition of the SME AP Authentication Options

 VALUES
    CSR_WIFI_SME_AP_AUTH_TYPE_OPEN_SYSTEM
                   - Open  authentication
    CSR_WIFI_SME_AP_AUTH_TYPE_PERSONAL
                   - Personal authentication using a passphrase or a pre-shared
                     key.
    CSR_WIFI_SME_AP_AUTH_TYPE_WEP
                   - WEP authentication. This can be either open or shared key

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeApAuthType;
#define CSR_WIFI_SME_AP_AUTH_TYPE_OPEN_SYSTEM   ((CsrWifiSmeApAuthType) 0x00)
#define CSR_WIFI_SME_AP_AUTH_TYPE_PERSONAL      ((CsrWifiSmeApAuthType) 0x01)
#define CSR_WIFI_SME_AP_AUTH_TYPE_WEP           ((CsrWifiSmeApAuthType) 0x02)

/*******************************************************************************

  NAME
    CsrWifiSmeApType

  DESCRIPTION
    Definition of AP types

 VALUES
    CSR_WIFI_AP_TYPE_LEGACY - Legacy AP
    CSR_WIFI_AP_TYPE_P2P    - P2P Group Owner(GO)

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeApType;
#define CSR_WIFI_AP_TYPE_LEGACY   ((CsrWifiSmeApType) 0x00)
#define CSR_WIFI_AP_TYPE_P2P      ((CsrWifiSmeApType) 0x01)


/*******************************************************************************

  NAME
    CsrWifiSmeApAuthSupportMask

  DESCRIPTION
    See CsrWifiSmeApAuthSupport for bit definitions

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeApAuthSupportMask;


/*******************************************************************************

  NAME
    CsrWifiSmeApP2pOperatingChanEntry

  DESCRIPTION

  MEMBERS
    operatingClass        - Channel operating class
    operatingChannelCount - Number of channels in this entry
    operatingChannel      - List of channels

*******************************************************************************/
typedef struct
{
    CsrUint8  operatingClass;
    CsrUint8  operatingChannelCount;
    CsrUint8 *operatingChannel;
} CsrWifiSmeApP2pOperatingChanEntry;

/*******************************************************************************

  NAME
    CsrWifiSmeApP2pOperatingChanList

  DESCRIPTION
    This structure contains the lists of P2P operating channels

  MEMBERS
    country               - Country
    channelEntryListCount - Number of entries
    channelEntryList      - List of entries

*******************************************************************************/
typedef struct
{
    CsrUint8                           country[3];
    CsrUint8                           channelEntryListCount;
    CsrWifiSmeApP2pOperatingChanEntry *channelEntryList;
} CsrWifiSmeApP2pOperatingChanList;

/*******************************************************************************

  NAME
    CsrWifiSmeApAuthPers

  DESCRIPTION

  MEMBERS
    authSupport        -
    encryptionModeMask -

*******************************************************************************/
typedef struct
{
    CsrWifiSmeApAuthSupportMask authSupport;
    CsrWifiSmeEncryptionMask    encryptionModeMask;
} CsrWifiSmeApAuthPers;

/*******************************************************************************

  NAME
    CsrWifiSmeApCredentials

  DESCRIPTION

  MEMBERS
    authType                    -
    smeAuthType                 -
    smeAuthTypeopenSystemEmpty  -
    smeAuthTypeauthwep          -
    smeAuthTypeauthPers         -

*******************************************************************************/
typedef struct
{
    CsrWifiSmeApAuthType authType;
    union
    {
        CsrWifiSmeEmpty      openSystemEmpty;
        CsrWifiSmeWepAuth    authwep;
        CsrWifiSmeApAuthPers authPers;
    } smeAuthType;
} CsrWifiSmeApCredentials;


/* Downstream */
#define CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST            (0x0000)

#define CSR_WIFI_SME_AP_BEACONING_START_REQ               ((CsrWifiSmeApPrim) (0x0000 + CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_BEACONING_STOP_REQ                ((CsrWifiSmeApPrim) (0x0001 + CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_WPS_REGISTRATION_STARTED_REQ      ((CsrWifiSmeApPrim) (0x0002 + CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_WPS_REGISTRATION_FINISHED_REQ     ((CsrWifiSmeApPrim) (0x0003 + CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_STA_DISCONNECT_REQ                ((CsrWifiSmeApPrim) (0x0004 + CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST))


#define CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_HIGHEST           (0x0004 + CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST)

/* Upstream */
#define CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST              (0x0000 + CSR_PRIM_UPSTREAM)

#define CSR_WIFI_SME_AP_BEACONING_START_CFM               ((CsrWifiSmeApPrim) (0x0000 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_BEACONING_STOP_CFM                ((CsrWifiSmeApPrim) (0x0001 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_STA_NOTIFY_IND                    ((CsrWifiSmeApPrim) (0x0002 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_STA_CONNECT_START_IND             ((CsrWifiSmeApPrim) (0x0003 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_WPS_REGISTRATION_STARTED_CFM      ((CsrWifiSmeApPrim) (0x0004 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_WPS_REGISTRATION_FINISHED_CFM     ((CsrWifiSmeApPrim) (0x0005 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_STA_DISCONNECT_CFM                ((CsrWifiSmeApPrim) (0x0006 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))
#define CSR_WIFI_SME_AP_ERROR_IND                         ((CsrWifiSmeApPrim) (0x0007 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST))

#define CSR_WIFI_SME_AP_PRIM_UPSTREAM_HIGHEST             (0x0007 + CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST)

#define CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_COUNT             (CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_HIGHEST + 1 - CSR_WIFI_SME_AP_PRIM_DOWNSTREAM_LOWEST)
#define CSR_WIFI_SME_AP_PRIM_UPSTREAM_COUNT               (CSR_WIFI_SME_AP_PRIM_UPSTREAM_HIGHEST + 1 - CSR_WIFI_SME_AP_PRIM_UPSTREAM_LOWEST)

/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStartReq

  DESCRIPTION
    This primitive requests the SME to start AP or GO functionality

  MEMBERS
    common              - Common header for use with the CsrWifiFsm Module
    interfaceTag        -
    groupFormation      - Set to FALSE, if Not in a group fomration phase, set
                          to TRUE , during group formation phase. During group
                          formation, NOA should not be applied.
    apType              - apType : Legacy AP or P2PGO
    cloakSsid           - cloakSsid flag.
    ssid                - ssid.
    apCredentials       - AP security credeitals used to advertise in beacon
                          /probe response
    accessType          - Specifies whether the MAC addresses from the list
                          should be allowed or denied
    macAddressListCount - Number of MAC addresses
    macAddressList      - List of MAC addresses
    valuesLength        - Length of values
    values              - Encoded Psids, Indexes and Data

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent         common;
    CsrUint16               interfaceTag;
    CsrBool                 groupFormation;
    CsrWifiSmeApType        apType;
    CsrBool                 cloakSsid;
    CsrWifiSsid             ssid;
    CsrWifiSmeApCredentials apCredentials;
    CsrWifiSmeApAccessType  accessType;
    CsrUint8                macAddressListCount;
    CsrWifiMacAddress      *macAddressList;
    CsrUint32               valuesLength;
    CsrUint8               *values;
} CsrWifiSmeApBeaconingStartReq;

/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStopReq

  DESCRIPTION
    This primitive requests the SME to STOP AP or P2PGO operation

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
} CsrWifiSmeApBeaconingStopReq;

/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationStartedReq

  DESCRIPTION
    This primitive tells SME that WPS registration procedure has started

  MEMBERS
    common                   - Common header for use with the CsrWifiFsm Module
    interfaceTag             -
    SelectedDevicePasswordId -
    SelectedconfigMethod     -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent         common;
    CsrUint16               interfaceTag;
    CsrWifiSmeWpsDpid       SelectedDevicePasswordId;
    CsrWifiSmeWpsConfigType SelectedconfigMethod;
} CsrWifiSmeApWpsRegistrationStartedReq;

/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationFinishedReq

  DESCRIPTION
    This primitive tells SME that WPS registration procedure has finished

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
} CsrWifiSmeApWpsRegistrationFinishedReq;

/*******************************************************************************

  NAME
    CsrWifiSmeApStaDisconnectReq

  DESCRIPTION
    This primitive tells SME to deauth ot disassociate a particular station
    within BSS

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   -
    deauthReason   -
    disassocReason -
    peerMacaddress -
    keepBlocking   - If TRUE, the station is blocked. If FALSE and the station
                     is connected, disconnect the station. If FALSE and the
                     station is not connected, no action is taken.

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrWifiSmeIEEE80211Reason deauthReason;
    CsrWifiSmeIEEE80211Reason disassocReason;
    CsrWifiMacAddress         peerMacaddress;
    CsrBool                   keepBlocking;
} CsrWifiSmeApStaDisconnectReq;

/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStartCfm

  DESCRIPTION
    This primitive confirms the completion of the request along with the
    status

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      -
    status            -
    secIeLength       -
    secIe             -
    errorValuesLength - Length of errorValues
    errorValues       - Encoded Psids, Indexes and Status Code

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
    CsrUint16       secIeLength;
    CsrUint8       *secIe;
    CsrUint32       errorValuesLength;
    CsrUint8       *errorValues;
} CsrWifiSmeApBeaconingStartCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeApBeaconingStopCfm

  DESCRIPTION
    This primitive confirms AP or P2PGO operation is terminated

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag -
    status       -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiSmeApBeaconingStopCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeApStaNotifyInd

  DESCRIPTION
    This primitive indicates that a station has joined or a previously joined
    station has left the BSS/group

  MEMBERS
    common            - Common header for use with the CsrWifiFsm Module
    interfaceTag      -
    mediaStatus       -
    peerMacAddress    -
    peerDeviceAddress -
    disassocReason    -
    deauthReason      -
    WpsRegistration   -
    secIeLength       -
    secIe             -
    groupKeyId        -
    seqNumber         -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent           common;
    CsrUint16                 interfaceTag;
    CsrWifiSmeMediaStatus     mediaStatus;
    CsrWifiMacAddress         peerMacAddress;
    CsrWifiMacAddress         peerDeviceAddress;
    CsrWifiSmeIEEE80211Reason disassocReason;
    CsrWifiSmeIEEE80211Reason deauthReason;
    CsrWifiSmeWpsRegistration WpsRegistration;
    CsrUint8                  secIeLength;
    CsrUint8                 *secIe;
    CsrUint8                  groupKeyId;
    CsrUint16                 seqNumber[8];
} CsrWifiSmeApStaNotifyInd;

/*******************************************************************************

  NAME
    CsrWifiSmeApStaConnectStartInd

  DESCRIPTION
    This primitive indicates that a stations request to join the group/BSS is
    accepted

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   -
    peerMacAddress -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrWifiMacAddress peerMacAddress;
} CsrWifiSmeApStaConnectStartInd;

/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationStartedCfm

  DESCRIPTION
    A confirm for UNIFI_MGT_AP_WPS_REGISTRATION_STARTED.request

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag -
    status       -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiSmeApWpsRegistrationStartedCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeApWpsRegistrationFinishedCfm

  DESCRIPTION
    A confirm for UNIFI_MGT_AP_WPS_REGISTRATION_FINISHED.request

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag -
    status       -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       interfaceTag;
    CsrResult       status;
} CsrWifiSmeApWpsRegistrationFinishedCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeApStaDisconnectCfm

  DESCRIPTION
    This primitive confirms the station is disconnected

  MEMBERS
    common         - Common header for use with the CsrWifiFsm Module
    interfaceTag   -
    status         -
    peerMacaddress -

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent   common;
    CsrUint16         interfaceTag;
    CsrResult         status;
    CsrWifiMacAddress peerMacaddress;
} CsrWifiSmeApStaDisconnectCfm;

/*******************************************************************************

  NAME
    CsrWifiSmeApErrorInd

  DESCRIPTION
    This primitve is sent by SME to indicate some error in AP operationi
    after AP operations were started successfully and continuing the AP
    operation may lead to undesired behaviour. It is the responsibility of
    the upper layers to stop AP operation if needed

  MEMBERS
    common       - Common header for use with the CsrWifiFsm Module
    interfaceTag - Range 0-1
    apType       -
    status       - Contains the error status

*******************************************************************************/
typedef struct
{
    CsrWifiFsmEvent  common;
    CsrUint16        interfaceTag;
    CsrWifiSmeApType apType;
    CsrResult        status;
} CsrWifiSmeApErrorInd;


#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_SME_AP_PRIM_H__ */
