/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#ifndef CSR_WIFI_MIB_H__
#define CSR_WIFI_MIB_H__

#include "csr_synergy.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "csr_types.h"
#include "csr_result.h"
#include "csr_wifi_common.h"

#define CSR_WIFI_MIB_MAX_INDEXES 2

#define CsrWifiMibType CsrUint8
#define CSR_WIFI_MIB_TYPE_BOOL    0
#define CSR_WIFI_MIB_TYPE_UINT    1
#define CSR_WIFI_MIB_TYPE_INT     2
#define CSR_WIFI_MIB_TYPE_OCTET   3
#define CSR_WIFI_MIB_TYPE_NONE    4

typedef struct
{
    CsrWifiMibType type;
    union
    {
        CsrBool          boolValue;
        CsrInt32         intValue;
        CsrUint32        uintValue;
        CsrWifiDataBlock octetValue;
    } u;
} CsrWifiMibValue;

typedef struct
{
    CsrUint16       psid;
    CsrUint16       index[CSR_WIFI_MIB_MAX_INDEXES];     /* 0 = no Index */
    CsrWifiMibValue value;
} CsrWifiMibEntry;

typedef struct
{
    CsrUint16 psid;
    CsrUint16 index[CSR_WIFI_MIB_MAX_INDEXES]; /* 0 = no Index */
} CsrWifiMibGetEntry;

/*******************************************************************************

  NAME
    CsrResult

  DESCRIPTION
    Encoded Status for mib errors

 VALUES
    CSR_WIFI_SME_MIB_STATUS_UNKNOWN_PSID
                   -
    CSR_WIFI_SME_MIB_STATUS_INVALID_INDEX
                   -
    CSR_WIFI_SME_MIB_STATUS_OUT_OF_RANGE
                   -
    CSR_WIFI_SME_MIB_STATUS_WRITE_ONLY
                   -
    CSR_WIFI_SME_MIB_STATUS_READ_ONLY
                   -
    CSR_WIFI_SME_MIB_STATUS_UNKNOWN_INTERFACE_TAG
                   -
    CSR_WIFI_SME_MIB_STATUS_INVALID_NUMBER_OF_INDICES
                   -
    CSR_WIFI_SME_MIB_STATUS_ERROR
                   -
    CSR_WIFI_SME_MIB_STATUS_UNSUPPORTED_ON_INTERFACE
                   -
    CSR_WIFI_SME_MIB_STATUS_UNAVAILABLE
                   -
    CSR_WIFI_SME_MIB_STATUS_NOT_FOUND
                   -
    CSR_WIFI_SME_MIB_STATUS_INCOMPATIBLE
                   -
    CSR_WIFI_SME_MIB_STATUS_OUT_OF_MEMORY
                   -
    CSR_WIFI_SME_MIB_STATUS_TO_MANY_REQUESTED_VARIABLES
                   -
    CSR_WIFI_SME_MIB_STATUS_NOT_TRIED
                   - The no mib value sets were attempted.

*******************************************************************************/
#define CSR_WIFI_SME_MIB_STATUS_UNKNOWN_PSID                ((CsrResult) 0x0001)
#define CSR_WIFI_SME_MIB_STATUS_INVALID_INDEX               ((CsrResult) 0x0002)
#define CSR_WIFI_SME_MIB_STATUS_OUT_OF_RANGE                ((CsrResult) 0x0003)
#define CSR_WIFI_SME_MIB_STATUS_WRITE_ONLY                  ((CsrResult) 0x0004)
#define CSR_WIFI_SME_MIB_STATUS_READ_ONLY                   ((CsrResult) 0x0005)
#define CSR_WIFI_SME_MIB_STATUS_UNKNOWN_INTERFACE_TAG       ((CsrResult) 0x0006)
#define CSR_WIFI_SME_MIB_STATUS_INVALID_NUMBER_OF_INDICES   ((CsrResult) 0x0007)
#define CSR_WIFI_SME_MIB_STATUS_ERROR                       ((CsrResult) 0x0008)
#define CSR_WIFI_SME_MIB_STATUS_UNSUPPORTED_ON_INTERFACE    ((CsrResult) 0x0009)
#define CSR_WIFI_SME_MIB_STATUS_UNAVAILABLE                 ((CsrResult) 0x000A)
#define CSR_WIFI_SME_MIB_STATUS_NOT_FOUND                   ((CsrResult) 0x000B)
#define CSR_WIFI_SME_MIB_STATUS_INCOMPATIBLE                ((CsrResult) 0x000C)
#define CSR_WIFI_SME_MIB_STATUS_OUT_OF_MEMORY               ((CsrResult) 0x000D)
#define CSR_WIFI_SME_MIB_STATUS_TO_MANY_REQUESTED_VARIABLES ((CsrResult) 0x000E)
#define CSR_WIFI_SME_MIB_STATUS_NOT_TRIED                   ((CsrResult) 0x000F)

/*******************************************************************************

  NAME
    CsrWifiSmeCoexScheme

  DESCRIPTION
    Options for the coexistence signaling
    Same as MibValues

 VALUES
    CSR_WIFI_SME_COEX_SCHEME_DISABLED
                   - The coexistence signaling is disabled
    CSR_WIFI_SME_COEX_SCHEME_CSR
                   - Basic CSR coexistence signaling
    CSR_WIFI_SME_COEX_SCHEME_CSR_CHANNEL
                   - Full CSR coexistence signaling
    CSR_WIFI_SME_COEX_SCHEME_PTA
                   - Packet Traffic Arbitrator coexistence signaling

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeCoexScheme;
#define CSR_WIFI_SME_COEX_SCHEME_DISABLED      ((CsrWifiSmeCoexScheme) 0x00)
#define CSR_WIFI_SME_COEX_SCHEME_CSR           ((CsrWifiSmeCoexScheme) 0x01)
#define CSR_WIFI_SME_COEX_SCHEME_CSR_CHANNEL   ((CsrWifiSmeCoexScheme) 0x02)
#define CSR_WIFI_SME_COEX_SCHEME_PTA           ((CsrWifiSmeCoexScheme) 0x03)

/*******************************************************************************

  NAME
    CsrWifiSmeTrafficType

  DESCRIPTION
    Identifies the type of traffic going on on the connection.

 VALUES
    CSR_WIFI_SME_TRAFFIC_TYPE_OCCASIONAL
                   - During the last 30 seconds there were fewer than 20 packets
                     per seconds in each second in both directions
    CSR_WIFI_SME_TRAFFIC_TYPE_BURSTY
                   - During the last 30 seconds there was at least one second
                     during which more than 20 packets were received in either
                     direction
    CSR_WIFI_SME_TRAFFIC_TYPE_PERIODIC
                   - During the last 5 seconds there were at least 10 packets
                     received each second and a defined period for the traffic
                     can be recognized
    CSR_WIFI_SME_TRAFFIC_TYPE_CONTINUOUS
                   - During the last 5 seconds there were at least 20 packets
                     received each second in either direction

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeTrafficType;
#define CSR_WIFI_SME_TRAFFIC_TYPE_OCCASIONAL   ((CsrWifiSmeTrafficType) 0x00)
#define CSR_WIFI_SME_TRAFFIC_TYPE_BURSTY       ((CsrWifiSmeTrafficType) 0x01)
#define CSR_WIFI_SME_TRAFFIC_TYPE_PERIODIC     ((CsrWifiSmeTrafficType) 0x02)
#define CSR_WIFI_SME_TRAFFIC_TYPE_CONTINUOUS   ((CsrWifiSmeTrafficType) 0x03)


/*******************************************************************************

  NAME
    CsrWifiSmeD3AutoScanMode

  DESCRIPTION
    Autonomous scan status while in D3 suspended period

 VALUES
    CSR_WIFI_SME_D3AUTO_SCAN_MODE_PSON
                   - Autonomous scan stays on
    CSR_WIFI_SME_D3AUTO_SCAN_MODE_PSOFF
                   - Autonomous scan is switched off
    CSR_WIFI_SME_D3AUTO_SCAN_MODE_PSAUTO
                   - Automatically select autoscanning behaviour.
                     CURRENTLY NOT SUPPORTED

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeD3AutoScanMode;
#define CSR_WIFI_SME_D3AUTO_SCAN_MODE_PSON     ((CsrWifiSmeD3AutoScanMode) 0x00)
#define CSR_WIFI_SME_D3AUTO_SCAN_MODE_PSOFF    ((CsrWifiSmeD3AutoScanMode) 0x01)
#define CSR_WIFI_SME_D3AUTO_SCAN_MODE_PSAUTO   ((CsrWifiSmeD3AutoScanMode) 0x02)


/*******************************************************************************

  NAME
    CsrWifiSmePowerSaveLevel

  DESCRIPTION
    Power Save Level options as defined in the IEEE 802.11 standards
    First 3 values are set to match the mlme PowerManagementMode

 VALUES
    CSR_WIFI_SME_POWER_SAVE_LEVEL_LOW  - No power save: the driver will remain
                                         active at all times
    CSR_WIFI_SME_POWER_SAVE_LEVEL_HIGH - Enter power save after all packets in
                                         the queues are transmitted and received
    CSR_WIFI_SME_POWER_SAVE_LEVEL_MED  - Enter power save after all packets in
                                         the queues are transmitted and received
                                         and a further configurable delay
                                         (default 1s) has elapsed
    CSR_WIFI_SME_POWER_SAVE_LEVEL_AUTO - The SME will decide when to enter power
                                         save mode according to the traffic
                                         analysis

*******************************************************************************/
typedef CsrUint8 CsrWifiSmePowerSaveLevel;
#define CSR_WIFI_SME_POWER_SAVE_LEVEL_LOW    ((CsrWifiSmePowerSaveLevel) 0x00)
#define CSR_WIFI_SME_POWER_SAVE_LEVEL_HIGH   ((CsrWifiSmePowerSaveLevel) 0x01)
#define CSR_WIFI_SME_POWER_SAVE_LEVEL_MED    ((CsrWifiSmePowerSaveLevel) 0x02)
#define CSR_WIFI_SME_POWER_SAVE_LEVEL_AUTO   ((CsrWifiSmePowerSaveLevel) 0x03)


/*******************************************************************************

  NAME
    CsrWifiSmeHostPowerMode

  DESCRIPTION
    Defines the power mode

 VALUES
    CSR_WIFI_SME_HOST_POWER_MODE_ACTIVE
                   - Host device is running on external power.
    CSR_WIFI_SME_HOST_POWER_MODE_POWER_SAVE
                   - Host device is running on (internal) battery power.
    CSR_WIFI_SME_HOST_POWER_MODE_FULL_POWER_SAVE
                   - For future use.

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeHostPowerMode;
#define CSR_WIFI_SME_HOST_POWER_MODE_ACTIVE            ((CsrWifiSmeHostPowerMode) 0x00)
#define CSR_WIFI_SME_HOST_POWER_MODE_POWER_SAVE        ((CsrWifiSmeHostPowerMode) 0x01)
#define CSR_WIFI_SME_HOST_POWER_MODE_FULL_POWER_SAVE   ((CsrWifiSmeHostPowerMode) 0x02)


/*******************************************************************************

  NAME
    CsrWifiSme80211dTrustLevel

  DESCRIPTION
    Level of trust for the information coming from the network

 VALUES
    CSR_WIFI_SME_80211D_TRUST_LEVEL_STRICT
                   - Start with passive scanning and only accept country IE for
                     updating channel lists
    CSR_WIFI_SME_80211D_TRUST_LEVEL_ADJUNCT
                   - As above plus accept adjunct technology location
                     information
    CSR_WIFI_SME_80211D_TRUST_LEVEL_BSS
                   - As above accept plus receiving channel from infrastructure
                     networks
    CSR_WIFI_SME_80211D_TRUST_LEVEL_IBSS
                   - As above accept plus receiving channel from the ad hoc
                     networks
    CSR_WIFI_SME_80211D_TRUST_LEVEL_MIB
                   - Start with active scanning with list of active channels
                     from the MIB and accept as above
    CSR_WIFI_SME_80211D_TRUST_LEVEL_DISABLED
                   - Start with active scanning with list of active channels
                     from the MIB and ignore any channel information from the
                     network

*******************************************************************************/
typedef CsrUint8 CsrWifiSme80211dTrustLevel;
#define CSR_WIFI_SME_80211D_TRUST_LEVEL_STRICT     ((CsrWifiSme80211dTrustLevel) 0x01)
#define CSR_WIFI_SME_80211D_TRUST_LEVEL_ADJUNCT    ((CsrWifiSme80211dTrustLevel) 0x02)
#define CSR_WIFI_SME_80211D_TRUST_LEVEL_BSS        ((CsrWifiSme80211dTrustLevel) 0x03)
#define CSR_WIFI_SME_80211D_TRUST_LEVEL_IBSS       ((CsrWifiSme80211dTrustLevel) 0x04)
#define CSR_WIFI_SME_80211D_TRUST_LEVEL_MIB        ((CsrWifiSme80211dTrustLevel) 0x05)
#define CSR_WIFI_SME_80211D_TRUST_LEVEL_DISABLED   ((CsrWifiSme80211dTrustLevel) 0x06)


/*******************************************************************************

  NAME
    CsrWifiSmeRegulatoryDomain

  DESCRIPTION
    Indicates the regulatory domain as defined in IEEE 802.11 standards

 VALUES
    CSR_WIFI_SME_REGULATORY_DOMAIN_OTHER
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_FCC
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_IC
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_ETSI
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_SPAIN
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_FRANCE
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_JAPAN
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_JAPANBIS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_CHINA
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_CHINABIS
                   - See IEEE 802.11 Standard
    CSR_WIFI_SME_REGULATORY_DOMAIN_NONE
                   - See IEEE 802.11 Standard

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeRegulatoryDomain;
#define CSR_WIFI_SME_REGULATORY_DOMAIN_OTHER      ((CsrWifiSmeRegulatoryDomain) 0x00)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_FCC        ((CsrWifiSmeRegulatoryDomain) 0x10)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_IC         ((CsrWifiSmeRegulatoryDomain) 0x20)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_ETSI       ((CsrWifiSmeRegulatoryDomain) 0x30)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_SPAIN      ((CsrWifiSmeRegulatoryDomain) 0x31)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_FRANCE     ((CsrWifiSmeRegulatoryDomain) 0x32)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_JAPAN      ((CsrWifiSmeRegulatoryDomain) 0x40)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_JAPANBIS   ((CsrWifiSmeRegulatoryDomain) 0x41)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_CHINA      ((CsrWifiSmeRegulatoryDomain) 0x50)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_CHINABIS   ((CsrWifiSmeRegulatoryDomain) 0x51)
#define CSR_WIFI_SME_REGULATORY_DOMAIN_NONE       ((CsrWifiSmeRegulatoryDomain) 0xFF)

/*******************************************************************************

  NAME
    CsrWifiSmeMfpMode

  DESCRIPTION
    Enums to control Management Frame Protection - 802.11w

 VALUES
    CSR_WIFI_SME_MFP_DISABLED - MFP disabled
    CSR_WIFI_SME_MFP_OPTIONAL - MFP optional
    CSR_WIFI_SME_MFP_REQUIRED - MFP required

*******************************************************************************/
typedef CsrUint8 CsrWifiSmeMfpMode;
#define CSR_WIFI_SME_MFP_DISABLED   ((CsrWifiSmeMfpMode) 0x00)
#define CSR_WIFI_SME_MFP_OPTIONAL   ((CsrWifiSmeMfpMode) 0x01)
#define CSR_WIFI_SME_MFP_REQUIRED   ((CsrWifiSmeMfpMode) 0x02)

/*******************************************************************************

  NAME
    CsrWifiSmePsidEnableStrictRules

  DESCRIPTION
    Enums to Strict Rules

 VALUES
    CSR_WIFI_STRICT_RULES_DRAFTN_ENABLE -
    CSR_WIFI_STRICT_RULES_WEP_WITH_WSC2_ALLOWED -
    CSR_WIFI_STRICT_RULES_REUSE_4W_HANDSHAKE_NONCE -
    CSR_WIFI_STRICT_RULES_ENABLE_CMANR_TEST_MODE -
    CSR_WIFI_STRICT_RULES_AP_WPS_CERT_MODE_ENABLE
                   - Enable the AP WPS Certification checks for allowed security
                     combinations with WSC2.0.
                     WSC2.0 + WEP and WSC2.0 + WPA will not be allowed.
    CSR_WIFI_STRICT_RULES_ENABLE_AP_P2P_CONCURRENT_MODE_CHECK
                   - Enable the concurrent mode operation checks for allowed combinations
                     with AP and P2P
    CSR_WIFI_STRICT_RULES_P2P_CERT_MODE_ENABLE
                   - Enable the P2P Certification checks to modify the values of config
                     methods in WSC IE and delay between two Tx BA attempts
*******************************************************************************/
typedef CsrUint32 CsrWifiStrictRules;
#define CSR_WIFI_STRICT_RULES_DRAFTN_ENABLE                 ((CsrWifiStrictRules) 0x00000001)
#define CSR_WIFI_STRICT_RULES_WEP_WITH_WSC2_ALLOWED         ((CsrWifiStrictRules) 0x00000002)
#define CSR_WIFI_STRICT_RULES_REUSE_4W_HANDSHAKE_NONCE      ((CsrWifiStrictRules) 0x00000004)
#define CSR_WIFI_STRICT_RULES_ENABLE_CMANR_TEST_MODE        ((CsrWifiStrictRules) 0x00000008)
#define CSR_WIFI_STRICT_RULES_AP_WPS_CERT_MODE_ENABLE       ((CsrWifiStrictRules) 0x00000010)
#define CSR_WIFI_STRICT_RULES_P2P_CERT_MODE_ENABLE          ((CsrWifiStrictRules) 0x00000020)

#define CsrWifiStrictRulesDraftNEnabled(strictRules)           (((strictRules[0]) & CSR_WIFI_STRICT_RULES_DRAFTN_ENABLE) ? TRUE : FALSE)
#define CsrWifiStrictRulesWepWithWsc2Allowed(strictRules)      (((strictRules[0]) & CSR_WIFI_STRICT_RULES_WEP_WITH_WSC2_ALLOWED) ? TRUE : FALSE)
#define CsrWifiStrictRulesReuse4wHandshakeNonce(strictRules)   (((strictRules[0]) & CSR_WIFI_STRICT_RULES_REUSE_4W_HANDSHAKE_NONCE) ? TRUE : FALSE)
#define CsrWifiStrictRulesEnableCmanrTestMode(strictRules)     (((strictRules[0]) & CSR_WIFI_STRICT_RULES_ENABLE_CMANR_TEST_MODE) ? TRUE : FALSE)
#define CsrWifiStrictRulesEnableApWpsCertMode(strictRules)     (((strictRules[0]) & CSR_WIFI_STRICT_RULES_AP_WPS_CERT_MODE_ENABLE) ? TRUE : FALSE)
#define CsrWifiStrictRulesEnableP2pCertMode(strictRules)       (((strictRules[0]) & CSR_WIFI_STRICT_RULES_P2P_CERT_MODE_ENABLE) ? TRUE : FALSE)

/*******************************************************************************

  NAME
    CsrWifiMibEncodeGet Functions

  DESCRIPTION
    For use when getting data from the Wifi Stack.
    These functions append the encoded data to the "buffer".

    index == 0 where there is no index required

  EXAMPLE
    {
        static const CsrWifiMibGetEntry getValues[] = {
            { PSID1, { 0, 0 } },
            { PSID2, { 3, 0 } },
        };
        CsrWifiDataBlock buffer;
        CsrWifiMibEncodeGetList(&buffer,
                                sizeof(getValues) / sizeof(CsrWifiMibGetEntry),
                                getValues);

        # Send the Get Request to the Wifi Stack
        CsrWifiSmeGetReqSend(MYTASKQID, 0xFFFF, buffer->dataLength, buffer->data);
    }
    or
    {
        CsrWifiDataBlock buffer = {0, NULL};
        CsrWifiMibEncodeGet(&buffer, PSID1, 0);
        CsrWifiMibEncodeGet(&buffer, PSID2, 3);

        # Send the Get Request to the Wifi Stack
        CsrWifiSmeGetReqSend(MYTASKQID, 0xFFFF, buffer.dataLength, buffer.data);
    }
  RETURN
    CsrResult: See CSR_WIFI_SME_MIB_STATUS_*

*******************************************************************************/
void CsrWifiMibEncodeGet(CsrWifiDataBlock *buffer, CsrUint16 psid, CsrUint16 index);
void CsrWifiMibEncodeGetList(CsrWifiDataBlock *buffer, CsrUint16 psidsLength, const CsrWifiMibGetEntry *psids);


/*******************************************************************************

  NAME
    CsrWifiMibdEncode Functions

  DESCRIPTION
    For use when getting data from the Wifi Stack.

    index == 0 where there is no index required

  EXAMPLE
    {
        static const CsrWifiMibGetEntry getValues[] = {
            { PSID1, { 0, 0 } },
            { PSID2, { 3, 0 } },
        };
        CsrWifiDataBlock buffer = rxMibData; # Buffer with encoded Mib Data

        getValues = CsrWifiMibDecodeGetList(&buffer,
                                        sizeof(getValues) / sizeof(CsrWifiMibGetEntry),
                                        getValues);

        print("PSID1 = %d\n", getValues[0].u.uintValue);
        print("PSID2.3 = %s\n", getValues[1].u.boolValue?"TRUE":"FALSE");

        CsrPmemFree(getValues);

    }
    or
    {
        CsrUint8* buffer = rxMibData; # Buffer with encoded Mib Data
        CsrSize offset=0;
        CsrWifiMibEntry value;

        offset += CsrWifiMibDecode(&buffer[offset], &value);
        print("PSID1 = %d\n", value.u.uintValue);

        offset += CsrWifiMibDecode(&buffer[offset], &value);
        print("PSID2.3 = %s\n", value.u.boolValue?"TRUE":"FALSE");

    }

*******************************************************************************/
CsrSize CsrWifiMibDecode(CsrUint8 *buffer, CsrWifiMibEntry *value);
CsrWifiMibValue *CsrWifiMibDecodeGetList(CsrWifiDataBlock *buffer, CsrUint16 psidsLength, const CsrWifiMibGetEntry *psids);


/*******************************************************************************

  NAME
    CsrWifiMibEncode Functions

  DESCRIPTION
    For use when setting data in the Wifi Stack.
    These functions append the encoded data to the "buffer".

    index == 0 where there is no index required

  EXAMPLE
    {
        CsrUint8 octets[2] = {0x00, 0x01};
        CsrWifiDataBlock buffer = {0, NULL};
        CsrWifiMibEncodeBool(&buffer, PSID1, TRUE, 0);                     # Boolean set with no index
        CsrWifiMibEncodeInt(&buffer, PSID2, -1234, 1);                     # Signed Integer set with on index 1
        CsrWifiMibEncodeUint(&buffer, PSID2, 1234, 3);                     # Unsigned Integer set with on index 3
        CsrWifiMibEncodeOctet(&buffer, PSID3, sizeof(octets), octets, 0);  # Octet set with no index

        # Send the Set Request to the Wifi Stack
        CsrWifiSmeSetReqSend(MYTASKQID, 0xFFFF, buffer->dataLength, buffer->data);
    }
    or
    {
        # Unsigned Integer set with on index 3
        CsrWifiDataBlock buffer = {0, NULL};
        CsrWifiMibEntry value;
        value.psid = psid;
        value.index[0] = 3;
        value.index[1] = 0;
        value.value.type = CSR_WIFI_MIB_TYPE_UINT;
        value.value.u.uintValue = 1234;
        CsrWifiMibEncode(buffer, &value);

        # Send the Set Request to the Wifi Stack
        CsrWifiSmeSetReqSend(MYTASKQID, 0xFFFF, buffer->dataLength, buffer->data);
    }
  RETURN
    CsrResult: See CSR_WIFI_SME_MIB_STATUS_*

*******************************************************************************/
CsrResult CsrWifiMibEncode(CsrWifiDataBlock *buffer, CsrWifiMibEntry *value);
CsrResult CsrWifiMibEncodeBool(CsrWifiDataBlock *buffer, CsrUint16 psid, CsrBool value, CsrUint16 index);
CsrResult CsrWifiMibEncodeInt(CsrWifiDataBlock *buffer, CsrUint16 psid, CsrInt32 value, CsrUint16 index);
CsrResult CsrWifiMibEncodeUint(CsrWifiDataBlock *buffer, CsrUint16 psid, CsrUint32 value, CsrUint16 index);
CsrResult CsrWifiMibEncodeOctet(CsrWifiDataBlock *buffer, CsrUint16 psid, CsrSize dataLength, const CsrUint8 *data, CsrUint16 index);


/*******************************************************************************

  NAME
    CsrWifiMib Low level Encode/Decode functions

*******************************************************************************/
CsrSize CsrWifiMibEncodeUint32(CsrUint8 *buffer, CsrUint32 value);
CsrSize CsrWifiMibEncodeInt32(CsrUint8 *buffer, CsrInt32 signedValue);
CsrSize CsrWifiMibEncodeOctetString(CsrUint8 *buffer, CsrWifiDataBlock *octetValue);

CsrSize CsrWifiMibDecodeUint32(CsrUint8 *buffer, CsrUint32 *value);
CsrSize CsrWifiMibDecodeInt32(CsrUint8 *buffer, CsrInt32 *value);
CsrSize CsrWifiMibDecodeOctetString(CsrUint8 *buffer, CsrWifiDataBlock *octetValue);


/*******************************************************************************

  NAME
    CsrWifiMib Helper Functions

*******************************************************************************/

/* Initialise the CsrWifiMib logging */
#ifdef CSR_LOG_ENABLE
void CsrWifiMibLogTextRegister(void);
#else
#define CsrWifiMibLogTextRegister()
#endif

/* Find a the offset to psid data in an encoded buffer
   {
        CsrWifiDataBlock buffer = rxMibData;                 # Buffer with encoded Mib Data
        CsrWifiMibGetEntry value = {PSID1, {0x01, 0x00}};   # Find value for PSID1.1
        CsrUint8* mibdata = CsrWifiMibFind(&buffer, &value);
        if(mibdata) {print("Mib Data for PSID1.1 Found\n");
    }
 */
CsrUint8 *CsrWifiMibFind(CsrWifiDataBlock *buffer, const CsrWifiMibGetEntry *entry);

/* Append data to a Buffer */
void CsrWifiMibBufferAppend(CsrWifiDataBlock *dst, CsrSize bufferLength, CsrUint8 *buffer);


/*******************************************************************************

  PSID Definitions

*******************************************************************************/


/*******************************************************************************
  NAME          : CsrWifiSmePsidMacAddress
  PSID          : 32768 (0x8000)
  PER INTERFACE?: YES
  TYPE          : CsrWifiMacAddress
  MIN           : 6
  MAX           : 6
  DEFAULT       : {{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}}
  DESCRIPTION   :
    Returns the interfaces currently assigned MAC address.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_MAC_ADDRESS 0x8000

/*******************************************************************************
  NAME          : CsrWifiSmePsidDot11CountryString
  PSID          : 32771 (0x8003)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 3
  MAX           : 3
  DEFAULT       : 'U','S',' '
  DESCRIPTION   :
    Country code as specified by IEEE 802.11 standard Default Country is US
    with all Environments, Code=US, Environment= space
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_DOT11_COUNTRY_STRING 0x8003

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanDisableAutonomousScans
  PSID          : 32772 (0x8004)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Enables or disables the autonomous scan
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_DISABLE_AUTONOMOUS_SCANS 0x8004

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanMaxResults
  PSID          : 32773 (0x8005)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 128
  DEFAULT       : 0
  DESCRIPTION   :
    Maximum number of results to be cached in the SME
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_MAX_RESULTS 0x8005

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanHighRssiThreshold
  PSID          : 32774 (0x8006)
  PER INTERFACE?: NO
  TYPE          : CsrInt8
  UNITS         : dBm
  MIN           : -128
  MAX           : 127
  DEFAULT       : -128
  DESCRIPTION   :
    High received signal strength indication threshold for an AP above which
    the system will report scan indications
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_HIGH_RSSI_THRESHOLD 0x8006

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanLowRssiThreshold
  PSID          : 32775 (0x8007)
  PER INTERFACE?: NO
  TYPE          : CsrInt8
  UNITS         : dBm
  MIN           : -128
  MAX           : 127
  DEFAULT       : 127
  DESCRIPTION   :
    Low received signal strength indication threshold for an AP below which
    the system will report scan indications
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_LOW_RSSI_THRESHOLD 0x8007

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanDeltaRssiThreshold
  PSID          : 32776 (0x8008)
  PER INTERFACE?: NO
  TYPE          : CsrInt8
  UNITS         : dBm
  MIN           : 0
  MAX           : 127
  DEFAULT       : 3
  DESCRIPTION   :
    Minimum difference for received signal strength indication for an AP
    which trigger a scan indication to be sent.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_DELTA_RSSI_THRESHOLD 0x8008

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanHighSnrThreshold
  PSID          : 32777 (0x8009)
  PER INTERFACE?: NO
  TYPE          : CsrInt8
  UNITS         : dB
  MIN           : -128
  MAX           : 127
  DEFAULT       : -128
  DESCRIPTION   :
    High Signal to Noise Ratio threshold for an AP above which the system
    will report scan indications
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_HIGH_SNR_THRESHOLD 0x8009

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanLowSnrThreshold
  PSID          : 32778 (0x800A)
  PER INTERFACE?: NO
  TYPE          : CsrInt8
  UNITS         : dB
  MIN           : -128
  MAX           : 127
  DEFAULT       : 127
  DESCRIPTION   :
    Low Signal to Noise Ratio threshold for an AP below which the system will
    report scan indications
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_LOW_SNR_THRESHOLD 0x800A

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanDeltaSnrThreshold
  PSID          : 32779 (0x800B)
  PER INTERFACE?: NO
  TYPE          : CsrInt8
  UNITS         : dB
  MIN           : 0
  MAX           : 127
  DEFAULT       : 3
  DESCRIPTION   :
    Minimum difference for Signal to Noise Ratio for an AP which trigger a
    scan indication to be sent.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_DELTA_SNR_THRESHOLD 0x800B

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanIntervalSeconds
  PSID          : 32780 (0x800C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 15,60,150,0
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    All the channels will be scanned once in this time interval.
    If connected, the channel scans are spread across the interval.
    If disconnected, all the channels will be scanned together
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_INTERVAL_SECONDS 0x800C

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanValiditySeconds
  PSID          : 32781 (0x800D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 29,119,299,119
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    How long the scan result are cached
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_VALIDITY_SECONDS 0x800D

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanMinActiveChannelTimeTu
  PSID          : 32782 (0x800E)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 30,30,30,30
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Minimum time of listening on a channel being actively scanned before
    leaving if no probe responses or beacon frames have been received
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_MIN_ACTIVE_CHANNEL_TIME_TU 0x800E

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanMaxActiveChannelTimeTu
  PSID          : 32783 (0x800F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 50,50,50,50
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Maximum time of listening on a channel being actively scanned
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_MAX_ACTIVE_CHANNEL_TIME_TU 0x800F

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanMinPassiveChannelTimeTu
  PSID          : 32784 (0x8010)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 210,210,210,210
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Maximum time of listening on a channel being passively scanned
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_MIN_PASSIVE_CHANNEL_TIME_TU 0x8010

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanMaxPassiveChannelTimeTu
  PSID          : 32785 (0x8011)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 210,210,210,210
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Minimum time of listening on a channel being passive scanned before
    leaving if no beacon frames have been received
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_MAX_PASSIVE_CHANNEL_TIME_TU 0x8011

/*******************************************************************************
  NAME          : CsrWifiSmePsidHostPowerMode
  PSID          : 32786 (0x8012)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 2
  DEFAULT       : CSR_WIFI_SME_HOST_POWER_MODE_POWER_SAVE
  DESCRIPTION   :
    The wireless manager application should use the powerMode parameter to
    inform the SME of the host power state.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_HOST_POWER_MODE 0x8012

/*******************************************************************************
  NAME          : CsrWifiSmePsidPowerSaveLevel
  PSID          : 32787 (0x8013)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 3
  DEFAULT       : CSR_WIFI_SME_POWER_SAVE_LEVEL_AUTO
  DESCRIPTION   :
    Power Save Level option
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_POWER_SAVE_LEVEL 0x8013

/*******************************************************************************
  NAME          : CsrWifiSmePsidPowerListenIntervalTu
  PSID          : 32788 (0x8014)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 500
  DESCRIPTION   :
    Interval for waking to receive beacon frames
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_POWER_LISTEN_INTERVAL_TU 0x8014

/*******************************************************************************
  NAME          : CsrWifiSmePsidPowerRxDtims
  PSID          : 32789 (0x8015)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  UNITS         : TU
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    If TRUE, wake for DTIM every beacon period, to allow the reception
    broadcast packets
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_POWER_RX_DTIMS 0x8015

/*******************************************************************************
  NAME          : CsrWifiSmePsidPowerD3AutoScanMode
  PSID          : 32790 (0x8016)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : CSR_WIFI_SME_D3AUTO_SCAN_MODE_PSOFF
  DESCRIPTION   :
    Defines whether the autonomous scanning will be turned off or will stay
    on during a D3 suspended period
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_POWER_D3_AUTO_SCAN_MODE 0x8016

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentSsid
  PSID          : 32794 (0x801A)
  PER INTERFACE?: YES
  TYPE          : SSID
  MIN           : 0
  MAX           : 32
  DEFAULT       : {{0},0}
  DESCRIPTION   :
    Service set identifier
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_SSID 0x801A

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentBssid
  PSID          : 32795 (0x801B)
  PER INTERFACE?: YES
  TYPE          : CsrWifiMacAddress
  MIN           : 6
  MAX           : 6
  DEFAULT       : {{0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
  DESCRIPTION   :
    BSS identifier
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_BSSID 0x801B

/*******************************************************************************
  NAME          : CsrWifiSmePsid80211dTrustLevel
  PSID          : 32796 (0x801C)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 6
  DEFAULT       : CSR_WIFI_SME_80211D_TRUST_LEVEL_DISABLED
  DESCRIPTION   :
    Level of trust of the information coming from the network
 *******************************************************************************/
#define CSR_WIFI_SME_PSID80211D_TRUST_LEVEL 0x801C

/*******************************************************************************
  NAME          : CsrWifiSmePsid80211dCountryCode
  PSID          : 32797 (0x801D)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 2
  MAX           : 2
  DEFAULT       : 0x00, 0x00
  DESCRIPTION   :
    Country code as specified by IEEE 802.11 standard
 *******************************************************************************/
#define CSR_WIFI_SME_PSID80211D_COUNTRY_CODE 0x801D

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentChannelInfo
  PSID          : 32798 (0x801E)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Channel number
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_CHANNEL_INFO 0x801E

/*******************************************************************************
  NAME          : CsrWifiSmePsidEnableStrictRules
  PSID          : 32799 (0x801F)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0x00000001
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 1
  DESCRIPTION   :
    Strict rules for conformance and workarounds
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ENABLE_STRICT_RULES 0x801F

/*******************************************************************************
  NAME          : CsrWifiSmePsidBasicCapabilities
  PSID          : 32801 (0x8021)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 5
  MAX           : 5
  DEFAULT       : 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
  DESCRIPTION   :
    Specifies the user defined basic capabilities
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_BASIC_CAPABILITIES 0x8021

/*******************************************************************************
  NAME          : CsrWifiSmePsidExtendedCapabilities
  PSID          : 32802 (0x8022)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 7
  MAX           : 7
  DEFAULT       : 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
  DESCRIPTION   :
    Specifies the user defined extended capabilities
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_EXTENDED_CAPABILITIES 0x8022

/*******************************************************************************
  NAME          : CsrWifiSmePsidHtCapabilities
  PSID          : 32803 (0x8023)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 6
  MAX           : 8
  DEFAULT       : 0x30, 0x01, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00
  DESCRIPTION   :
    Specifies the user defined HT capabilities
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_HT_CAPABILITIES 0x8023

/*******************************************************************************
  NAME          : CsrWifiSmePsidSupportedMCS
  PSID          : 32804 (0x8024)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 4
  MAX           : 4
  DEFAULT       : 0xFF, 0x01, 0xFF, 0x01
  DESCRIPTION   :
    Specifies the user defined supported MCS set
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SUPPORTED_MCS 0x8024

/*******************************************************************************
  NAME          : CsrWifiSmePsidRSNCapabilities
  PSID          : 32805 (0x8025)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 4
  MAX           : 4
  DEFAULT       : 0x2F, 0x11, 0x08, 0x04
  DESCRIPTION   :
    Specififes the supported RSN capabilities
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_RSNCAPABILITIES 0x8025

/*******************************************************************************
  NAME          : CsrWifiSmePsidAdHocATIMWindowTu
  PSID          : 32806 (0x8026)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    ATIM window specified for IBSS. Not supported in Wi-Fi 6.x.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_AD_HOC_ATIMWINDOW_TU 0x8026

/*******************************************************************************
  NAME          : CsrWifiSmePsidAdHocBeaconPeriodTu
  PSID          : 32807 (0x8027)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 0xFFFF
  DEFAULT       : 100
  DESCRIPTION   :
    Interval between beacon packets. Not supported in Wi-Fi 6.x.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_AD_HOC_BEACON_PERIOD_TU 0x8027

/*******************************************************************************
  NAME          : CsrWifiSmePsidAdHocJoinOnlyAttempts
  PSID          : 32808 (0x8028)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 1
  DESCRIPTION   :
    Maximum number of attempts to join an ad-hoc network.
    The default value is 1.
    Set to 0 for infinite attempts. Not supported in Wi-Fi 6.x.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_AD_HOC_JOIN_ONLY_ATTEMPTS 0x8028

/*******************************************************************************
  NAME          : CsrWifiSmePsidAdHocJoinAttemptIntervalMs
  PSID          : 32809 (0x8029)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 2000
  DESCRIPTION   :
    Time between scans for joining the requested IBSS. Not supported in Wi-Fi
    6.x.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_AD_HOC_JOIN_ATTEMPT_INTERVAL_MS 0x8029

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionQualityRssiChangeTrigger
  PSID          : 32810 (0x802A)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : dBm
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 10
  DESCRIPTION   :
    Sets the difference of RSSI measurements which triggers reports from the
    Firmware
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_QUALITY_RSSI_CHANGE_TRIGGER 0x802A

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionQualitySnrChangeTrigger
  PSID          : 32811 (0x802B)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : dB
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 10
  DESCRIPTION   :
    Sets the difference of SNR measurements which triggers reports from the
    Firmware
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_QUALITY_SNR_CHANGE_TRIGGER 0x802B

/*******************************************************************************
  NAME          : CsrWifiSmePsidWmmModeMask
  PSID          : 32812 (0x802C)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0xFF
  DESCRIPTION   :
    Mask containing one or more values from CsrWifiSmeWmmMode
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WMM_MODE_MASK 0x802C

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentChannelFrequency
  PSID          : 32813 (0x802D)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : MHz
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Channel frequency
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_CHANNEL_FREQUENCY 0x802D

/*******************************************************************************
  NAME          : CsrWifiSmePsidAllowUnicastUseGroupCipher
  PSID          : 32814 (0x802E)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    If TRUE, it allows the use of the group cipher suite in a RSN IE if no
    pairwise cipher suite is present. If FALSE, then a received RSN IE with
    no pairwise cipher suite is considered invalid.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ALLOW_UNICAST_USE_GROUP_CIPHER 0x802E

/*******************************************************************************
  NAME          : CsrWifiSmePsidAmpMacAddress
  PSID          : 32815 (0x802F)
  PER INTERFACE?: YES
  TYPE          : CsrWifiMacAddress
  MIN           : 6
  MAX           : 6
  DEFAULT       : {{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}}
  DESCRIPTION   :
    Configure the Amp MAC address. If FF:FF:FF:FF:FF:FF is configured then
    the same MAC address assigned on Interface 0 will be used. Read
    CsrWifiSmePsidMacAddress from Interface 1 to read the value in use on the
    Amp interface
 *******************************************************************************/
#ifdef CSR_AMP_ENABLE
#define CSR_WIFI_SME_PSID_AMP_MAC_ADDRESS 0x802F
#endif /* CSR_AMP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgSsid
  PSID          : 32816 (0x8030)
  PER INTERFACE?: YES
  TYPE          : SSID
  MIN           : 0
  MAX           : 32
  DEFAULT       : {{0},0}
  DESCRIPTION   :
    Service Set identifier
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_SSID 0x8030

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgBssid
  PSID          : 32817 (0x8031)
  PER INTERFACE?: YES
  TYPE          : CsrWifiMacAddress
  MIN           : 6
  MAX           : 6
  DEFAULT       : {{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}}
  DESCRIPTION   :
    BSS identifier
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_BSSID 0x8031

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgBssType
  PSID          : 32818 (0x8032)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : CSR_WIFI_SME_BSS_TYPE_INFRASTRUCTURE
  DESCRIPTION   :
    Indicates the type of BSS
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_BSS_TYPE 0x8032

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentAtimWindowTu
  PSID          : 32819 (0x8033)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    ATIM window specified for IBSS
    Restrictions: Connected state only. Not supported in Wi-Fi 6.x.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_ATIM_WINDOW_TU 0x8033

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgPrivacyMode
  PSID          : 32820 (0x8034)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : CSR_WIFI_SME_80211_PRIVACY_MODE_DISABLED
  DESCRIPTION   :
    Specifies whether the privacy mode is enabled or disabled.
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_PRIVACY_MODE 0x8034

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgAuthModeMask
  PSID          : 32821 (0x8035)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Sets the authentication options that the SME can use while associating to
    the AP
    Set mask with values from CsrWifiSmeAuthMode
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_AUTH_MODE_MASK 0x8035

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgEncryptionModeMask
  PSID          : 32822 (0x8036)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Sets the encryption options that the SME can use while associating to the
    AP
    Set mask with values from CsrWifiSmeEncryption
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_ENCRYPTION_MODE_MASK 0x8036

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgAssociateIE
  PSID          : 32823 (0x8037)
  PER INTERFACE?: YES
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : {0, NULL}
  DESCRIPTION   :
    Points to the first byte of the information elements, if any.
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_ASSOCIATE_IE 0x8037

/*******************************************************************************
  NAME          : CsrWifiSmePsidWmmQosInfo
  PSID          : 32824 (0x8038)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0
  DESCRIPTION   :
    This parameter allows the driver's WMM behaviour to be configured.
    To enable support for WMM, use CSR_WIFI_SME_SME_CONFIG_SET_REQ with the
    CSR_WIFI_SME_WMM_MODE_AC_ENABLED bit set in wmmModeMask field in
    smeConfig parameter.
    Set mask with values from CsrWifiSmeWmmQosInfo
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WMM_QOS_INFO 0x8038

/*******************************************************************************
  NAME          : CsrWifiSmePsidAdhocJoinOnly
  PSID          : 32825 (0x8039)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    This parameter is relevant only if bssType is NOT set to
    CSR_WIFI_SME_BSS_TYPE_INFRASTRUCTURE:
    if TRUE the SME will only try to join an ad-hoc network if there is one
    already established;
    if FALSE the SME will try to join an ad-hoc network if there is one
    already established or it will try to establish a new one.
    Not supported in Wi-Fi 6.x.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ADHOC_JOIN_ONLY 0x8039

/*******************************************************************************
  NAME          : CsrWifiSmePsidBeaconingChannelInfo
  PSID          : 32826 (0x803A)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0x5106
  DESCRIPTION   :
    For STA mode, this parameter is relevant only if bssType is NOT set to
    CSR_WIFI_SME_BSS_TYPE_INFRASTRUCTURE:
    This parameter is also used for AP/ P2PGO mode.
    It indicates the channel to be used while joining an ad hoc network or
    functioning as an AP/P2PGO.
    Setting this to 0 causes the SME to select a channel from those permitted
    in the regulatory domain.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_BEACONING_CHANNEL_INFO 0x803A

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsVersion
  PSID          : 32827 (0x803B)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0x20
  MAX           : 0x20
  DEFAULT       : 0x20
  DESCRIPTION   :
    wpsVersion should be 0x20 for WSC2.0
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_VERSION 0x803B

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsUuid
  PSID          : 32828 (0x803C)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 16
  MAX           : 16
  DEFAULT       : 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04
  DESCRIPTION   :
    uuid.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_UUID 0x803C

/*******************************************************************************
  NAME          : CsrWifiSmePsidVendorName
  PSID          : 32829 (0x803D)
  PER INTERFACE?: NO
  TYPE          : CsrCharString*
  MIN           : 1
  MAX           : 65
  DEFAULT       : (CsrCharString*)"CSR"
  DESCRIPTION   :
    Vendor name string. Because it is held as a string the maximum length
    needs to take the null terminator into account.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VENDOR_NAME 0x803D

/*******************************************************************************
  NAME          : CsrWifiSmePsidVendorModelName
  PSID          : 32830 (0x803E)
  PER INTERFACE?: NO
  TYPE          : CsrCharString*
  MIN           : 1
  MAX           : 33
  DEFAULT       : (CsrCharString*)"Wifi"
  DESCRIPTION   :
    Vendor model name string. Because it is held as a string the maximum
    length needs to take the null terminator into account.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VENDOR_MODEL_NAME 0x803E

/*******************************************************************************
  NAME          : CsrWifiSmePsidVendorModelNumber
  PSID          : 32831 (0x803F)
  PER INTERFACE?: NO
  TYPE          : CsrCharString*
  MIN           : 1
  MAX           : 33
  DEFAULT       : (CsrCharString*)CSR_WIFI_VERSION
  DESCRIPTION   :
    Vendor model version string. Because it is held as a string the maximum
    length needs to take the null terminator into account.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VENDOR_MODEL_NUMBER 0x803F

/*******************************************************************************
  NAME          : CsrWifiSmePsidVendorDeviceName
  PSID          : 32832 (0x8040)
  PER INTERFACE?: NO
  TYPE          : CsrCharString*
  MIN           : 1
  MAX           : 33
  DEFAULT       : (CsrCharString*)"Wifi"
  DESCRIPTION   :
    Vendor device name string. Because it is held as a string the maximum
    length needs to take the null terminator into account.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VENDOR_DEVICE_NAME 0x8040

/*******************************************************************************
  NAME          : CsrWifiSmePsidVendorSerialNumber
  PSID          : 32833 (0x8041)
  PER INTERFACE?: NO
  TYPE          : CsrCharString*
  MIN           : 1
  MAX           : 33
  DEFAULT       : (CsrCharString*)"0000"
  DESCRIPTION   :
    Vendor device serial number
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VENDOR_SERIAL_NUMBER 0x8041

/*******************************************************************************
  NAME          : CsrWifiSmePsidSupportedModeCombinations
  PSID          : 32834 (0x8042)
  PER INTERFACE?: NO
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 10243
  DEFAULT       : {0x12, 0x3B, 0x0E,0xC9, 0x27, 0x11, 0x18, 0x30, 0x0A, 0x22, 0x11, 0x09, 0x03}
  DESCRIPTION   :
    Interface mode combinations that are supported in this product

        Encoding mode combinations:
        =================================================================================================================================================

          ================================================================================================================================
          ||Size(T) of supported       - Size(M) of MAC addr           || Supported Modes...........   || MAC address ..............    ||
          ||modes bitmask        [(4b)]- restriction entry       [(4b)]|| Bitmask        ...........[T]|| Restrictions.............. [M]||
          ================================================================================================================================================
          ||Max. number of concurrent  - Number(P) of                  || Size(Q) of entries  - Number(R) of        || Multi instance mode  .......     ||
          ||modes supported      [(4b)]- supported comb. entries [(4b)]|| in octets     [(4b)]- bits per mode [(4b)]|| combinations         .......[P*Q]||
          ================================================================================================================================================

                     a. Length of a field in octets is given within []
                        ========================================================
                           [T] denotes an entry of length T octets
                           [('n'b)] denotes a field of length 'n' bits within an octet
                           ||  denotes the octet boundary

                     b. Size of entries (T, M & Q) in octets should only be 2^N , N = 0,1,2,3..
                        ======================================================================
                           currently 0x01, 0x02 & 0x04 (0 =< N <= 2) are the valid entries mapping to
                           Uint8, Uint16 and Uint32

                     c. Mode order used to encode the MAC address restriction and the  'Multi instance mode combinations'
                        ==============================================================================================================
                           [MSBit...............................................................................................LSBit]
                           | ..(extensions)..|   IBSS   |    0     |    AMP   |  P2P GO  | P2P Client |    0     |    AP   |   STA   |
                                                        (.reserved.)                                  (.reserved.)

                     d. MAC address restriction
                        =======================
                           <2 bits>
                           |  00  | None            |
                           |  01  | Only Universal  |
                           |  10  | Only Local      |
                           |  11  | Any             |

        =================================================================================================================================================

        DEFAULT configuration:
        =====================================================================================
                                                                          | <ENCODED VALUE> |
           A. Supported Modes:  AMP, P2P GO, P2P Client, AP, STA =======  |   => 0x3B       |

           B. MAC Address restrictions
                        =============================
                        |AMP        - Any           |
                        |P2P GO     - Only Local    |
                        |P2P Client - Any           |
                        |AP         - Only Local    |
                        |STA        - Only Universal|
                        =============================
                        Encoded value: |0000<11><10><11>00<10><01>| ===  |   => 0x0E 0xC9  |
                        =============================

          C. Max number of concurrent modes supported : 2   ===========  |    => 0x27      |
             Number of mode combination entries       : 7

          D. Multi instance mode combinations =========================  |                 |
                        ===================================
                        |   P2P Client   |    P2P GO      |              |    => 0x18      |
                        |   AMP          |    P2P GO      |              |    => 0x30      |
                        |   P2P Client   |    AP          |              |    => 0x0A      |
                        |   AMP          |    AP          |              |    => 0x22      |
                        |   STA          |    P2P GO      |              |    => 0x11      |
                        |   STA          |    P2P Client  |              |    => 0x09      |
                        |   STA          |    AP          |              |    => 0x03      |
                        ===================================
        ====================================================================================

 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SUPPORTED_MODE_COMBINATIONS 0x8042

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgMibValues
  PSID          : 32835 (0x8043)
  PER INTERFACE?: YES
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : {0, NULL}
  DESCRIPTION   :
    Mib values, if any, requested in a CsrWifiSmeConnectReq.
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_MIB_VALUES 0x8043

/*******************************************************************************
  NAME          : CsrWifiSmePsidForceCoreDump
  PSID          : 32836 (0x8044)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    When set to TRUE this will trigger a Wifi off and coredump from the FW.
    This value should never be set in a Mib file. Only when the Wifi is ON
    will this cause any behaviour
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_FORCE_CORE_DUMP 0x8044

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsPrimDeviceType
  PSID          : 32839 (0x8047)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 8
  MAX           : 8
  DEFAULT       : 0x00, 0x01, 0x00, 0x50, 0xf2, 0x04, 0x00, 0x01
  DESCRIPTION   :
    Primary WPS device type
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_PRIM_DEVICE_TYPE 0x8047

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsSecondaryDeviceTypeCount
  PSID          : 32840 (0x8048)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0
  DESCRIPTION   :
    Number of secondary device types
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_SECONDARY_DEVICE_TYPE_COUNT 0x8048

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsSecondaryDeviceType
  PSID          : 32841 (0x8049)
  PER INTERFACE?: NO
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 80
  DEFAULT       : {0, NULL}
  DESCRIPTION   :
    list of secondary WPS device types
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_SECONDARY_DEVICE_TYPE 0x8049

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsConfigMethods
  PSID          : 32842 (0x804A)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0x238C
  DESCRIPTION   :
    Supported WPS config methods
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_CONFIG_METHODS 0x804A

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsRFBands
  PSID          : 32843 (0x804B)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0x01
  DESCRIPTION   :
    RfBands.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_RFBANDS 0x804B

/*******************************************************************************
  NAME          : CsrWifiSmePsidWpsOSVersion
  PSID          : 32844 (0x804C)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 4
  MAX           : 4
  DEFAULT       : 0x00, 0x00, 0x00, 0x00
  DESCRIPTION   :
    Os version on which the device is running
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_WPS_OSVERSION 0x804C

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionChipId
  PSID          : 32845 (0x804D)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Chip ID
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_CHIP_ID 0x804D

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionChipVersion
  PSID          : 32846 (0x804E)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Chip version ID
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_CHIP_VERSION 0x804E

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionFirmwareBuild
  PSID          : 32847 (0x804F)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Firmware Rom build number
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_FIRMWARE_BUILD 0x804F

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionFirmwarePatch
  PSID          : 32848 (0x8050)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Firmware Patch build number (if applicable)
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_FIRMWARE_PATCH 0x8050

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionFirmwareHip
  PSID          : 32849 (0x8051)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Firmware HIP protocol version number
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_FIRMWARE_HIP 0x8051

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionRouterBuild
  PSID          : 32850 (0x8052)
  PER INTERFACE?: NO
  TYPE          : CsrCharString*
  MIN           : 0
  MAX           : 255
  DEFAULT       : NULL
  DESCRIPTION   :
    Router build number. Because it is held as a string the maximum length
    needs to take the null terminator into account.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_ROUTER_BUILD 0x8052

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionRouterHip
  PSID          : 32851 (0x8053)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Router HIP protocol version number
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_ROUTER_HIP 0x8053

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionSmeBuild
  PSID          : 32852 (0x8054)
  PER INTERFACE?: NO
  TYPE          : CsrCharString*
  MIN           : 6
  MAX           : 14
  DEFAULT       : (CsrCharString*)CSR_WIFI_VERSION
  DESCRIPTION   :
    SME build number. Because it is held as a string the maximum length needs
    to take the null terminator into account.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_SME_BUILD 0x8054

/*******************************************************************************
  NAME          : CsrWifiSmePsidVersionSmeHip
  PSID          : 32853 (0x8055)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : SME_SUPPORTED_HIP_VERSION
  DESCRIPTION   :
    SME HIP protocol version number
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_VERSION_SME_HIP 0x8055

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgEnableSchemeManagement
  PSID          : 32854 (0x8056)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Enables the Coexistence Management Scheme
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_ENABLE_SCHEME_MANAGEMENT 0x8056
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidPeriodicWakeHost
  PSID          : 32855 (0x8057)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    If TRUE the firmware wakes up the host periodically according to the
    traffic period and latency parameters; the host will then send the data
    to transmit only when woken up.
    If FALSE, the firmware does not wake up the host and the host will send
    the data to transmit to the firmware whenever there is data to transmit
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PERIODIC_WAKE_HOST 0x8057

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgPagingBlackoutDurationMs
  PSID          : 32864 (0x8060)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 90
  DESCRIPTION   :
    Blackout Period when a BT page is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_PAGING_BLACKOUT_DURATION_MS 0x8060
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgPagingBlackoutPeriodMs
  PSID          : 32865 (0x8061)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 102
  DESCRIPTION   :
    Blackout Duration when a BT page is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_PAGING_BLACKOUT_PERIOD_MS 0x8061
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgInquiryBlackoutDurationMs
  PSID          : 32866 (0x8062)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 85
  DESCRIPTION   :
    Blackout Period when a BT Inquiry is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_INQUIRY_BLACKOUT_DURATION_MS 0x8062
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgInquiryBlackoutPeriodMs
  PSID          : 32867 (0x8063)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 102
  DESCRIPTION   :
    Blackout Duration when a BT inquiry is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_INQUIRY_BLACKOUT_PERIOD_MS 0x8063
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexInfoHasTrafficData
  PSID          : 32868 (0x8064)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    TRUE if any Wi-Fi traffic is detected
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_COEX_INFO_HAS_TRAFFIC_DATA 0x8064

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentTrafficType
  PSID          : 32869 (0x8065)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0x00
  MAX           : 0x03
  DEFAULT       : CSR_WIFI_SME_TRAFFIC_TYPE_OCCASIONAL
  DESCRIPTION   :
    Current type of traffic
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_TRAFFIC_TYPE 0x8065

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentPeriodMs
  PSID          : 32870 (0x8066)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Period of the traffic as detected by the traffic analysis.
    If the traffic is not periodic, it is set to 0.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_PERIOD_MS 0x8066

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentPowerSave
  PSID          : 32871 (0x8067)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0x00
  MAX           : 0x03
  DEFAULT       : CSR_WIFI_SME_POWER_SAVE_LEVEL_AUTO
  DESCRIPTION   :
    Current power save level
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_POWER_SAVE 0x8067

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexInfoHasBtDevice
  PSID          : 32874 (0x806A)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    TRUE if there is a Bluetooth device connected
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_COEX_INFO_HAS_BT_DEVICE 0x806A

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexInfoCurrentBlackoutDurationUs
  PSID          : 32875 (0x806B)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : us
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Current blackout duration for protecting Bluetooth
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_COEX_INFO_CURRENT_BLACKOUT_DURATION_US 0x806B

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexInfoCurrentBlackoutPeriodUs
  PSID          : 32876 (0x806C)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : us
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Current blackout period
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_COEX_INFO_CURRENT_BLACKOUT_PERIOD_US 0x806C

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexInfoCurrentBlackoutCount
  PSID          : 32877 (0x806D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Current blackout period
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_COEX_INFO_CURRENT_BLACKOUT_COUNT 0x806D

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingRssiHighThreshold
  PSID          : 32878 (0x806E)
  PER INTERFACE?: YES
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -32768
  MAX           : 32767
  DEFAULT       : -5,-74,-84
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Received Signal Strength Indication upper bound for the usability level
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_RSSI_HIGH_THRESHOLD 0x806E

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingRssiLowThreshold
  PSID          : 32879 (0x806F)
  PER INTERFACE?: YES
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -32768
  MAX           : 32767
  DEFAULT       : -76,-86,-105
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Received Signal Strength Indication lower bound for the usability level
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_RSSI_LOW_THRESHOLD 0x806F

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingSnrHighThreshold
  PSID          : 32880 (0x8070)
  PER INTERFACE?: YES
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -32768
  MAX           : 32767
  DEFAULT       : 30,16,11
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Signal to Noise Ratio upper bound for the usability level
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_SNR_HIGH_THRESHOLD 0x8070

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingSnrLowThreshold
  PSID          : 32881 (0x8071)
  PER INTERFACE?: YES
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -32768
  MAX           : 32767
  DEFAULT       : 14,9,0
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Signal to Noise Ratio lower bound in dB for the usability level
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_SNR_LOW_THRESHOLD 0x8071

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingDisableSmoothRoaming
  PSID          : 32882 (0x8072)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Disable the RSSI/SNR triggers from the Firmware that the SME uses to
    detect the quality of the connection.
    This implicitly disables disableRoamScans
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_DISABLE_SMOOTH_ROAMING 0x8072

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingDisableRoamScans
  PSID          : 32883 (0x8073)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Disables the scanning for the roaming operation
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_DISABLE_ROAM_SCANS 0x8073

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingReconnectLimit
  PSID          : 32884 (0x8074)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0
  DESCRIPTION   :
    Maximum number of times SME may reconnect in the given interval
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_RECONNECT_LIMIT 0x8074

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingReconnectLimitIntervalMs
  PSID          : 32885 (0x8075)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 1
  MAX           : 0xFFFF
  DEFAULT       : 60000
  DESCRIPTION   :
    Interval for maximum number of times SME may reconnect to the same Access
    Point
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_RECONNECT_LIMIT_INTERVAL_MS 0x8075

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingIntervalSeconds
  PSID          : 32886 (0x8076)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 1
  MAX           : 0xFFFF
  DEFAULT       : 3,3,6
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Specifically aimed at improving roaming performance, All the channels
    will be scanned once in this time interval. If connected, the channel
    scans are spread across the interval. If disconnected, all the channels
    will be scanned together
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_INTERVAL_SECONDS 0x8076

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingValiditySeconds
  PSID          : 32887 (0x8077)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 5,5,11
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Specifically aimed at improving roaming performance, How long the scan
    result are cached
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_VALIDITY_SECONDS 0x8077

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingMinActiveChannelTimeTu
  PSID          : 32888 (0x8078)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 10,10,10
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Specifically aimed at improving roaming performance, Minimum time of
    listening on a channel being actively scanned before leaving if no probe
    responses or beacon frames have been received
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_MIN_ACTIVE_CHANNEL_TIME_TU 0x8078

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingMaxActiveChannelTimeTu
  PSID          : 32889 (0x8079)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 30,30,30
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Specifically aimed at improving roaming performance, Maximum time of
    listening on a channel being actively scanned
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_MAX_ACTIVE_CHANNEL_TIME_TU 0x8079

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingMinPassiveChannelTimeTu
  PSID          : 32890 (0x807A)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 210,210,210
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Specifically aimed at improving roaming performance, Minimum time of
    listening on a channel being passive scanned before leaving if no beacon
    frames have been received
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_MIN_PASSIVE_CHANNEL_TIME_TU 0x807A

/*******************************************************************************
  NAME          : CsrWifiSmePsidRoamingMaxPassiveChannelTimeTu
  PSID          : 32891 (0x807B)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 210,210,210
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 3
  DESCRIPTION   :
    Specifically aimed at improving roaming performance, Maximum time of
    listening on a channel being passive scanned before leaving if no beacon
    frames have been received
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_ROAMING_MAX_PASSIVE_CHANNEL_TIME_TU 0x807B

/*******************************************************************************
  NAME          : CsrWifiSmePsidProbeReqJoinMaxRetry
  PSID          : 32894 (0x807E)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 10
  DEFAULT       : 5
  DESCRIPTION   :
    Max number of probe req retries when not connected
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PROBE_REQ_JOIN_MAX_RETRY 0x807E

/*******************************************************************************
  NAME          : CsrWifiSmePsidProbeReqJoinTimeoutMs
  PSID          : 32895 (0x807F)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : ms
  MIN           : 1
  MAX           : 0xFF
  DEFAULT       : 50
  DESCRIPTION   :
    Probe req interval when not connected
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PROBE_REQ_JOIN_TIMEOUT_MS 0x807F

/*******************************************************************************
  NAME          : CsrWifiSmePsidProbeReqConnectedMaxRetry
  PSID          : 32896 (0x8080)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 10
  DEFAULT       : 3
  DESCRIPTION   :
    Max number of probe req retries when connected
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PROBE_REQ_CONNECTED_MAX_RETRY 0x8080

/*******************************************************************************
  NAME          : CsrWifiSmePsidProbeReqConnectedTimeoutMs
  PSID          : 32897 (0x8081)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : ms
  MIN           : 1
  MAX           : 0xFF
  DEFAULT       : 10
  DESCRIPTION   :
    Probe req interval when connected
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PROBE_REQ_CONNECTED_TIMEOUT_MS 0x8081

/*******************************************************************************
  NAME          : CsrWifiSmePsidProbeReqApModeMaxRetry
  PSID          : 32898 (0x8082)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 10
  DEFAULT       : 2
  DESCRIPTION   :
    Max probe req retries when in AP mode
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PROBE_REQ_AP_MODE_MAX_RETRY 0x8082

/*******************************************************************************
  NAME          : CsrWifiSmePsidProbeReqApModeTimeoutMs
  PSID          : 32899 (0x8083)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  UNITS         : ms
  MIN           : 1
  MAX           : 0xFF
  DEFAULT       : 100
  DESCRIPTION   :
    Probe req interval when in AP Mode
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PROBE_REQ_AP_MODE_TIMEOUT_MS 0x8083

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgTimeoutBeaconsIbss
  PSID          : 32900 (0x8084)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : beacon intervals
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 100
  DESCRIPTION   :
    Connection timeout for an IBSS connection
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_TIMEOUT_BEACONS_IBSS 0x8084

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgTimeoutBeaconsInfrastructure
  PSID          : 32901 (0x8085)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : beacon intervals
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 20
  DESCRIPTION   :
    Connection timeout for an Infrastructure connection
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_TIMEOUT_BEACONS_INFRASTRUCTURE 0x8085

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgChannelAvoidanceWidthMhz
  PSID          : 32902 (0x8086)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  UNITS         : Mhz
  MIN           : 1
  MAX           : 0xFF
  DEFAULT       : 40
  DESCRIPTION   :
    BT channel avoidance widthfor BT connection
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_CHANNEL_AVOIDANCE_WIDTH_MHZ 0x8086
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidTrafficEapolLatencyMs
  PSID          : 32903 (0x8087)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 25
  DESCRIPTION   :
    Interface Latency when EAPOL exchange is in progress
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_TRAFFIC_EAPOL_LATENCY_MS 0x8087

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgPagingBlackoutCount
  PSID          : 32904 (0x8088)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Count when a BT page is active (0 = repeating).
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_PAGING_BLACKOUT_COUNT 0x8088
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeAdvertisingScanBlackoutDurationMs
  PSID          : 32905 (0x8089)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0x00
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Duration when a LE BT Scan is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_ADVERTISING_SCAN_BLACKOUT_DURATION_MS 0x8089
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeAdvertisingScanBlackoutPeriodMs
  PSID          : 32906 (0x808A)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Period when a LE BT Scan is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_ADVERTISING_SCAN_BLACKOUT_PERIOD_MS 0x808A
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeAdvertisingScanBlackoutCount
  PSID          : 32907 (0x808B)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Count when a LE BT Scan is active (0 = repeating).
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_ADVERTISING_SCAN_BLACKOUT_COUNT 0x808B
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgInquiryBlackoutCount
  PSID          : 32908 (0x808C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Count when a BT inquiry is active (0 = repeating).
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_INQUIRY_BLACKOUT_COUNT 0x808C
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaAcParamsAifsDelta
  PSID          : 32909 (0x808D)
  PER INTERFACE?: YES
  TYPE          : CsrInt8
  MIN           : -10
  MAX           : 10
  DEFAULT       : 0,0,0,0
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Delta to apply to the Aifs received from the Ap Array index corresponds
    to the ACI. These Deltas will only be applied if the corresponding
    CsrWifiSmePsidStaAcParamsAifs value is not 0x80
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_AC_PARAMS_AIFS_DELTA 0x808D

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionCfgPostConnectPowerScanDelayMs
  PSID          : 32914 (0x8092)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 15000
  DESCRIPTION   :
    Delay Period for scanning before connection
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_CFG_POST_CONNECT_POWER_SCAN_DELAY_MS 0x8092

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentBeaconPeriodTu
  PSID          : 32915 (0x8093)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0x0001
  MAX           : 0xFFFF
  DEFAULT       : 0x100
  DESCRIPTION   :
    Interval between beacon packets
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_BEACON_PERIOD_TU 0x8093

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionInfoAuthMode
  PSID          : 32916 (0x8094)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Authentication mode used for the connection
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_INFO_AUTH_MODE 0x8094

/*******************************************************************************
  NAME          : CsrWifiSmePsidConnectionInfoPairwiseCipher
  PSID          : 32917 (0x8095)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Encryption type for peer to peer communication
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CONNECTION_INFO_PAIRWISE_CIPHER 0x8095

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentGroupCipher
  PSID          : 32918 (0x8096)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Encryption type for broadcast and multicast communication
    Restrictions: Connected state only
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_GROUP_CIPHER 0x8096

/*******************************************************************************
  NAME          : CsrWifiSmePsidOperatingClasses
  PSID          : 32919 (0x8097)
  PER INTERFACE?: NO
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 10243
  DEFAULT       : (Too Large to display)
  DESCRIPTION   :
    Data describing the Operating Classes
    Draft P802.11-REVmb/D12, November 2011:
        Table E-1-Operating classes in the United States
        Table E-2-Operating classes in Europe
        Table E-3-Operating classes in Japan
        Table E-4-Global operating classes

  Format: Multiple entries with the following format:
  | Byte      |  Byte      | Byte | Byte | Byte  | Byte | Byte    | Byte    | Byte  | Byte  | Byte    | Byte    | Byte      | Byte  | Byte   | Byte    | N Bytes
  ===============================================================================================================================================================
  | Non-Global | Global    | Freq | Freq | Freq  | Freq | Indoor  | Channel | Flags | Flags | First   | Last    | Channel   | Max   | Power  | Num of  | Country
  | Operating  | Operating | Msb  |      |       | Lsb  | Outdoor | Spacing | Msb   | Lsb   | Channel | Channel | Increment | Power | Method | Country | Codes
  | Class      | Class     |      |      |       |      |         |         |       |       |         |         |           |       |        | Codes   |
  ===============================================================================================================================================================

       Freq: Channel Starting Frequency (GHz)
        Use : Freq / 10000 value
              So Operating Class 12 in US => Channel Starting Frequency 2.407 => 24070 = 0x5E06 = "0x00 0x00 0x5E 0x06"

       Indoor/Outdoor:
           Indoor             | 0x01
           Outdoor            | 0x02
           Indoor and Outdoor | 0x03
           X or x             | 0x04

       Channel Spacing Mhz:
           One of 5, 10, 20, 25, 40

       Flags: (Draft P802.11-REVmb/D12, November 2011 : Table D-2-Behavior limits sets)
       Note: these flags are currently ignored
           NomadicBehavior                     | 0x0001
           LicenseExemptBehavior               | 0x0002
           PrimaryChannelLowerBehavior         | 0x0004
           PrimaryChannelUpperBehavior         | 0x0008
           CCA-EDBehavior                      | 0x0010
           DFS_50_100_Behavior                 | 0x0020
           ITS_non-mobile_operations           | 0x0040
           ITS_mobile_operations               | 0x0080

       Fisrt Channel:
           Start channel Number

       Last Channel:
           Last channel Number

       Channel Increment:
           Number of gaps between channels
           Except when (lastChannel == FirstChannel) the increment is 1.

       Max Power:
           Maximum allowed Transmit Power Levels

       Power Method:
           0x00  EIRP
           0x01  TPO
           0x02  UNKNOWN

       Num Country Codes:
           The number of 2 byte country codes this Operating class has

       Country Codes:
           List of 2 byte Acsii country codes that use this OC Operating class


  At the moment Only 2.4GHz and channel Spacing= 25 Mhz

  Currently the following entries as commented are entered in the Default field:

           # Default (world safe) using OC = 0 (GOC =255) not defined in IEEE specs
           ## Indoor, Chan 1-11, 20dBm:
           0x00, 0xFF, 0x00, 0x00, 0x5E, 0x06, 0x01, 0x19, 0x00, 0x02, 0x01, 0x0B, 0x01  0x14, 0x00,
           ## Outdoor, Chan 1-9, 20dBm:
           0x00, 0xFF, 0x00, 0x00, 0x5E, 0x06, 0x02, 0x19, 0x00, 0x02, 0x01, 0x09, 0x01  0x14, 0x00,
           ## Outdoor, Chan 10-11, 10dBm:
           0x00, 0xFF, 0x00, 0x00, 0x5E, 0x06, 0x02, 0x19, 0x00, 0x02, 0x0A, 0x0B, 0x01  0x0A, 0x00,

           # Japan "JP":
           ## OC=30, GOC=81, indoor/outdoor, chan 1-13, 23dBm:
           0x1E, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x03, 0x19, 0x00, 0x02, 0x01, 0x0D, 0x01, 0x17, 0x01, 'J', 'P',
           ## OC=31, GOC=82, indoor/outdoor, chan 14, 23dBm:
           0x1F, 0x52, 0x00, 0x00, 0x5E, 0x4C, 0x03, 0x19, 0x00, 0x02, 0x0E, 0x0E, 0x00, 0x17, 0x01, 'J', 'P',

           # OC=12, GOC=81, Canada, United States, Mexico, Paraguay, Taiwan, US Minor Outlining Islands, Brazil:
           ## indoor/outdoor, channel 1-11, 36 dBm:
           0x0C, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x03, 0x19, 0x00, 0x02, 0x01, 0x0B, 0x01  0x24, 0x07, 'C', 'A', 'U', 'S', 'M', 'X', 'P', 'R', 'T', 'W', 'U', 'M', 'B', 'R',

           # OC=4, GOC=81, China "CN":
           ## indoor/outdoor, chan 1-13, 33dBm:
           0x04, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x03, 0x19, 0x00, 0x02, 0x01, 0x0D, 0x01, 0x21, 0x01, 'C', 'N',

           # OC=4, GOC=81, ETSI (and the rest of the world: MiddleEast, Africa, South america, Asia):
           ## indoor/outdoor, chan 1-13, 20dBm:
           0x04, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x03, 0x19, 0x00, 0x02, 0x01, 0x0D, 0x01, 0x14, 0x00,

           # OC=4, GOC=81, France "FR", French Polynesia "PF", French Sth Territories "TF":
           ## indoor, chan 1-13, 20dBm:
           0x04, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x01, 0x19, 0x00, 0x02, 0x01, 0x0D, 0x01, 0x14, 0x03, 'F', 'R', 'P', 'F', 'T', 'F',
           ## outdoor, chan 1-9, 20dBm:
           0x04, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x02, 0x19, 0x00, 0x02, 0x01, 0x09, 0x01, 0x14, 0x03, 'F', 'R', 'P', 'F', 'T', 'F',
           ## outdoor, chan 10-13, 10dBm:
           0x04, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x02, 0x19, 0x00, 0x02, 0x0A, 0x0D, 0x01, 0x0A, 0x03, 'F', 'R', 'P', 'F', 'T', 'F',

           # OC=4, GOC=81, French Guiana "GF", Reunion "RE":
           ## indoor, chan 1-13, 20dBm:
           0x04, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x01, 0x19, 0x00, 0x02, 0x01, 0x0D, 0x01, 0x14, 0x02, 'G', 'F', 'R', 'E',
           ## outdoor, chan 1 and 2 are not allowed.
           ## outdoor, chan 3-13, 20dBm:
           0x04, 0x51, 0x00, 0x00, 0x5E, 0x06, 0x01, 0x19, 0x00, 0x02, 0x03, 0x0D, 0x01, 0x14, 0x02, 'G', 'F', 'R', 'E'

 *******************************************************************************/
#define CSR_WIFI_SME_PSID_OPERATING_CLASSES 0x8097

/*******************************************************************************
  NAME          : CsrWifiSmePsidCurrentOperatingClasses
  PSID          : 32920 (0x8098)
  PER INTERFACE?: YES
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 10243
  DEFAULT       : {0x00 }
  DESCRIPTION   :
    A list of Operating Classes that can be used on the interface Draft
    P802.11-REVmb/D12, November 2011: Table E-1/E2/E3 Operating classes
    and/or 0 : our own defined default< All values given MUST be defined in
    CsrWifiSmePsidOperatingClasses Default: OC 0 (2.4 Ghz 25Mhz Spacing
    Channels 1 -> 11)
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_CURRENT_OPERATING_CLASSES 0x8098

/*******************************************************************************
  NAME          : CsrWifiSmePsidResetMibAfterActivity
  PSID          : 32921 (0x8099)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    After an activty such as STA connection the Host mib entries are reset to
    Wifi on defaults
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_RESET_MIB_AFTER_ACTIVITY 0x8099

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pOpPsEnable
  PSID          : 32922 (0x809A)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Indicates whether opportunistic power save can be used
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_OP_PS_ENABLE 0x809A
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pNoaConfigMethod
  PSID          : 32923 (0x809B)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0
  DESCRIPTION   :
    Notice of Absence configuration method
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_NOA_CONFIG_METHOD 0x809B
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pEnable
  PSID          : 32924 (0x809C)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Indicates whether the device is enabled for P2P
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_ENABLE 0x809C
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApWpsEnable
  PSID          : 32925 (0x809D)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Indicates whether WPS is enabled
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_WPS_ENABLE 0x809D
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pFindTimeLimit
  PSID          : 32926 (0x809E)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 1
  MAX           : 0xFFFF
  DEFAULT       : 60
  DESCRIPTION   :
    Max time to spend trying to discover a particular device or any P2P
    device in find phase. Set to 0xFFFF for indefinitively until cancelled
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_FIND_TIME_LIMIT 0x809E
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pAvailabilityDuration
  PSID          : 32927 (0x809F)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 512
  DEFAULT       : 50
  DESCRIPTION   :
    Availability duration during Device Discovery
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_AVAILABILITY_DURATION 0x809F
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pAvailabilityPeriod
  PSID          : 32928 (0x80A0)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 5000
  DEFAULT       : 100
  DESCRIPTION   :
    Availability Period in during Device Discovery
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_AVAILABILITY_PERIOD 0x80A0
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApBeaconPeriodTu
  PSID          : 32929 (0x80A1)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 0xFFFF
  DEFAULT       : 100
  DESCRIPTION   :
    Beacon interval
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_BEACON_PERIOD_TU 0x80A1
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApCtsProtection
  PSID          : 32930 (0x80A2)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 3
  DEFAULT       : 0
  DESCRIPTION   :
    CTS protection to be used
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_CTS_PROTECTION 0x80A2
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidWmmEnabled
  PSID          : 32931 (0x80A3)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Indicates whether WMM is enabled or not. If set to FALSE, the WMM
    parameters shall be ignored by the receiver
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_WMM_ENABLED 0x80A3
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApPhySupportedBitmap
  PSID          : 32932 (0x80A4)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 15
  DEFAULT       : 14
  DESCRIPTION   :
    Indicates supported physical layers
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_PHY_SUPPORTED_BITMAP 0x80A4
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApDtimPeriod
  PSID          : 32933 (0x80A5)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : beacon intervals
  MIN           : 1
  MAX           : 0xFF
  DEFAULT       : 3
  DESCRIPTION   :
    DTIM period
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_DTIM_PERIOD 0x80A5
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApMaxListenInterval
  PSID          : 32934 (0x80A6)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : beacon intervals
  MIN           : 1
  MAX           : 0xFFFF
  DEFAULT       : 0xFFFF
  DESCRIPTION   :
    Maximum allowed listen interval
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_MAX_LISTEN_INTERVAL 0x80A6
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidAllowNoaWithNonP2pDevices
  PSID          : 32935 (0x80A7)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Indicates if NOA should be allowed if non P2P devices are connected. If
    allowed the non P2P devices may suffer in throughput
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_ALLOW_NOA_WITH_NON_P2P_DEVICES 0x80A7
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pCapability
  PSID          : 32936 (0x80A8)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 6
  DESCRIPTION   :
    Contains P2P capability parameters
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_CAPABILITY 0x80A8
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pDeviceLimit
  PSID          : 32937 (0x80A9)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 8
  DEFAULT       : 1
  DESCRIPTION   :
    Maximum number of devices that can be connected
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_DEVICE_LIMIT 0x80A9
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pGoConfigTimeout
  PSID          : 32938 (0x80AA)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : 10 ms
  MIN           : 10
  MAX           : 0xFF
  DEFAULT       : 15
  DESCRIPTION   :
    Time needed by the device to get configured and  function as a GO
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_GO_CONFIG_TIMEOUT 0x80AA
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pCliConfigTimeout
  PSID          : 32939 (0x80AB)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : 10 ms
  MIN           : 10
  MAX           : 0xFF
  DEFAULT       : 15
  DESCRIPTION   :
    Time needed by the device to get configured and function as a P2P Client
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_CLI_CONFIG_TIMEOUT 0x80AB
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pGroupOwnerIntent
  PSID          : 32940 (0x80AC)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 15
  DEFAULT       : 7
  DESCRIPTION   :
    Group Owner Intent value to be used during GO Negotiation phase of Group
    Formation
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_GROUP_OWNER_INTENT 0x80AC
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApMaxConnections
  PSID          : 32941 (0x80AD)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 8
  DEFAULT       : 8
  DESCRIPTION   :
    Maximum Stations + P2P Clients allowed
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_MAX_CONNECTIONS 0x80AD
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pGroupCapability
  PSID          : 32942 (0x80AE)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 8
  DESCRIPTION   :
    Contains P2P Group capability parameters
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_GROUP_CAPABILITY 0x80AE
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pListenChannelInfo
  PSID          : 32943 (0x80AF)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0x5106
  DESCRIPTION   :
    Listen channel Info (Global Operating Class and channel number) to be
    used for Device Discovery Procedure
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_LISTEN_CHANNEL_INFO 0x80AF
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pCtWindow
  PSID          : 32944 (0x80B0)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 127
  DEFAULT       : 0
  DESCRIPTION   :
    Client Traffic window to be used in terms of number of TUs
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_CT_WINDOW 0x80B0
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApSupportedRatesCount
  PSID          : 32945 (0x80B1)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 20
  DEFAULT       : 12
  DESCRIPTION   :
    Number of supported rates
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_SUPPORTED_RATES_COUNT 0x80B1
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApSupportedRates
  PSID          : 32946 (0x80B2)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 20
  MAX           : 20
  DEFAULT       : 0x82, 0x84, 0x8B, 0x0C, 0x12, 0x96, 0x18, 0x24, 0x30, 0x48, 0x60, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  DESCRIPTION   :
    List of supportedRates. A rate is specied in the units of 500kbps. An
    entry for a basic rate shall have the MSB set to 1
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_SUPPORTED_RATES 0x80B2
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApAcParamsCwMin
  PSID          : 32947 (0x80B3)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 15
  DEFAULT       : 4,4,3,2
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Exponent for the calculation of CWmin. WMM parameter to be used for local
    firmware queue configuration. Array index corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_AC_PARAMS_CW_MIN 0x80B3
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApAcParamsCwMax
  PSID          : 32948 (0x80B4)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 15
  DEFAULT       : 6,10,4,3
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Exponent for the calculation of CWmax. WMM parameter to be used for local
    firmware queue configuration. Array index corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_AC_PARAMS_CW_MAX 0x80B4
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApAcParamsAifs
  PSID          : 32949 (0x80B5)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 0xF
  DEFAULT       : 3,7,1,1
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Arbitration Inter Frame Spacing in terms of number of timeslots. WMM
    parameter to be used for local firmware queue configuration. Array index
    corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_AC_PARAMS_AIFS 0x80B5
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApAcParamsTxopLimit
  PSID          : 32950 (0x80B6)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : 32 us
  MIN           : 0
  MAX           : 0x7FF
  DEFAULT       : 0,0,94,47
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    TXOP Limit, WMM parameter to be used for local firmware queue
    configuration. Array index corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_AC_PARAMS_TXOP_LIMIT 0x80B6
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApAcParamsAdmissionCtrlMandatory
  PSID          : 32951 (0x80B7)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 0
  DEFAULT       : FALSE,FALSE,FALSE,FALSE
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Indicates whether the admission control is mandatory or not. WMM
    parameter to be used for local firmware queue configuration. Array index
    corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_AC_PARAMS_ADMISSION_CTRL_MANDATORY 0x80B7
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidBcAcParamsCwMin
  PSID          : 32952 (0x80B8)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 15
  DEFAULT       : 4,4,3,2
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Exponent for the calculation of CWmin. WMM parameter to be advertised in
    beacon/probe response. Array index corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_BC_AC_PARAMS_CW_MIN 0x80B8
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidBcAcParamsCwMax
  PSID          : 32953 (0x80B9)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 15
  DEFAULT       : 10,10,4,3
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Exponent for the calculation of CWmax. WMM parameter to be advertised in
    beacon/probe response. Array index corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_BC_AC_PARAMS_CW_MAX 0x80B9
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidBcAcParamsAifs
  PSID          : 32954 (0x80BA)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 2
  MAX           : 0xF
  DEFAULT       : 3,7,2,2
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Arbitration Inter Frame Spacing in terms of number of timeslots. WMM
    parameter to be advertised in beacon/probe response. Array index
    corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_BC_AC_PARAMS_AIFS 0x80BA
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidBcAcParamsTxopLimit
  PSID          : 32955 (0x80BB)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : 32 us
  MIN           : 0
  MAX           : 0x7FF
  DEFAULT       : 0,0,94,47
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    TXOP Limit, WMM parameter to be advertised in beacon/probe response.
    Array index corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_BC_AC_PARAMS_TXOP_LIMIT 0x80BB
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidBcAcParamsAdmissionCtrlMandatory
  PSID          : 32956 (0x80BC)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE,FALSE,FALSE,FALSE
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Indicates whether the admission control is mandatory or not. WMM
    parameter to be advertised in beacon/probe response. Array index
    corresponds to the ACI
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_BC_AC_PARAMS_ADMISSION_CTRL_MANDATORY 0x80BC
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidMfpMode
  PSID          : 32957 (0x80BD)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 4
  DEFAULT       : CSR_WIFI_SME_MFP_DISABLED
  DESCRIPTION   :
    Sets the Management Protection frame Mode
 *******************************************************************************/
#ifdef CSR_WIFI_80211_W_ENABLE
#define CSR_WIFI_SME_PSID_MFP_MODE 0x80BD
#endif /* CSR_WIFI_80211_W_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidMfpStatus
  PSID          : 32958 (0x80BE)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Sets the Management Protection frame Mode
 *******************************************************************************/
#ifdef CSR_WIFI_80211_W_ENABLE
#define CSR_WIFI_SME_PSID_MFP_STATUS 0x80BE
#endif /* CSR_WIFI_80211_W_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidTxAntennaLoss
  PSID          : 32961 (0x80C1)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  UNITS         : dBm
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    Difference between power measured at antenna connector and TPO (Total
    Power Output) measured as radiated
    No default values; Must be read from MIB file otherwise failure
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_TX_ANTENNA_LOSS 0x80C1

/*******************************************************************************
  NAME          : CsrWifiSmePsidTxAntennaDirectionalityGain
  PSID          : 32962 (0x80C2)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  UNITS         : dBm
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    Difference between EIRP (Effective Isotropic Radiated Power) and TPO
    (Total Power Output)
    No default values; Must be read from MIB file otherwise failure
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_TX_ANTENNA_DIRECTIONALITY_GAIN 0x80C2

/*******************************************************************************
  NAME          : CsrWifiSmePsidTxSettingsSelectionTable
  PSID          : 32963 (0x80C3)
  PER INTERFACE?: NO
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 10243
  DEFAULT       :
  DESCRIPTION   :
    Power Table and their RSS Index to tell firmware which power to use;
    sequence of (index, power) pairs
    No default values; Must be read from MIB file otherwise failure
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_TX_SETTINGS_SELECTION_TABLE 0x80C3

/*******************************************************************************
  NAME          : CsrWifiSmePsidMinVifDurationTuAssociateReqFrame
  PSID          : 32964 (0x80C4)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 50
  DESCRIPTION   :
    How long to stay on channel after sending the frame
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_MIN_VIF_DURATION_TU_ASSOCIATE_REQ_FRAME 0x80C4

/*******************************************************************************
  NAME          : CsrWifiSmePsidMinVifDurationTuAssociateRspFrame
  PSID          : 32965 (0x80C5)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 50
  DESCRIPTION   :
    How long to stay on channel after sending the frame
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_MIN_VIF_DURATION_TU_ASSOCIATE_RSP_FRAME 0x80C5

/*******************************************************************************
  NAME          : CsrWifiSmePsidMinVifDurationTuAuthenticateFrame
  PSID          : 32966 (0x80C6)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 50
  DESCRIPTION   :
    How long to stay on channel after sending the frame
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_MIN_VIF_DURATION_TU_AUTHENTICATE_FRAME 0x80C6

/*******************************************************************************
  NAME          : CsrWifiSmePsidMinVifDurationTuDeauthenticateFrame
  PSID          : 32967 (0x80C7)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 50
  DESCRIPTION   :
    How long to stay on channel after sending the frame
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_MIN_VIF_DURATION_TU_DEAUTHENTICATE_FRAME 0x80C7

/*******************************************************************************
  NAME          : CsrWifiSmePsidMinVifDurationTuProbeReqFrame
  PSID          : 32968 (0x80C8)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 30
  DESCRIPTION   :
    How long to stay on channel after sending the frame
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_MIN_VIF_DURATION_TU_PROBE_REQ_FRAME 0x80C8

/*******************************************************************************
  NAME          : CsrWifiSmePsidMinVifDurationTuQosActionFrame
  PSID          : 32969 (0x80C9)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 0
  DESCRIPTION   :
    How long to stay on channel after sending the frame
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_MIN_VIF_DURATION_TU_QOS_ACTION_FRAME 0x80C9

/*******************************************************************************
  NAME          : CsrWifiSmePsidPayloadWarningLevel
  PSID          : 32970 (0x80CA)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 30
  MAX           : 0xFFFF
  DEFAULT       : 256
  DESCRIPTION   :
    Sets the warning threshold to indicate when the internal Payload storage
    is exceeded
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PAYLOAD_WARNING_LEVEL 0x80CA

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanDisableInitialFullScan
  PSID          : 32971 (0x80CB)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Enables or disables the initial scan
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_DISABLE_INITIAL_FULL_SCAN 0x80CB

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanDisableInitialApHistoryScan
  PSID          : 32972 (0x80CC)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    Enables or disables the initial scan
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_DISABLE_INITIAL_AP_HISTORY_SCAN 0x80CC

/*******************************************************************************
  NAME          : CsrWifiSmePsidScanDiscardCloakedSsids
  PSID          : 32973 (0x80CD)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    Enables or disables the indication of cloaked scan resuts
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_SCAN_DISCARD_CLOAKED_SSIDS 0x80CD

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pOperatingChannelList
  PSID          : 32974 (0x80CE)
  PER INTERFACE?: YES
  TYPE          : CsrWifiDataBlock
  MIN           : 4
  MAX           : 255
  DEFAULT       : {0x01, 0x51, 0x0B, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B}
  DESCRIPTION   :
 Operating Channel List.
 List of P2p operating channels in the below format:

 Byte 1: Number of operating classes

 Each operating class contains:
 Byte  1: Operating class number
 Byte  2: Number of channels
 Bytes N: Channel number, each 1 byte.
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_OPERATING_CHANNEL_LIST 0x80CE
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaAcParamsCwMin
  PSID          : 32976 (0x80D0)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0x80,0x80,0x80,0x80
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Exponent for the calculation of CWmin. WMM parameter to be used for local
    firmware queue configuration. Array index corresponds to the ACI
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_AC_PARAMS_CW_MIN 0x80D0

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaAcParamsCwMax
  PSID          : 32977 (0x80D1)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0x80,0x80,0x80,0x80
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Exponent for the calculation of CWmax. WMM parameter to be used for local
    firmware queue configuration. Array index corresponds to the ACI
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_AC_PARAMS_CW_MAX 0x80D1

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaAcParamsAifs
  PSID          : 32978 (0x80D2)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 0xFF
  DEFAULT       : 0x80,0x80,0x80,0x80
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Arbitration Inter Frame Spacing in terms of number of timeslots. WMM
    parameter to be used for local firmware queue configuration. Array index
    corresponds to the ACI
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_AC_PARAMS_AIFS 0x80D2

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaAcParamsTxopLimit
  PSID          : 32979 (0x80D3)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  UNITS         : 32 ms
  MIN           : 0
  MAX           : 0xFF
  DEFAULT       : 0x80,0x80,0x80,0x80
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    WMM parameter to be used for local firmware queue configuration array
    index corresponds to the ACI
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_AC_PARAMS_TXOP_LIMIT 0x80D3

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaAcParamsAdmissionCtrlMandatory
  PSID          : 32980 (0x80D4)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE,FALSE,FALSE,FALSE
  INDEX COUNT   : 1
  INDEX MIN     : 1
  INDEX MAX     : 4
  DESCRIPTION   :
    Indicates whether the admission control is mandatory or not. WMM
    parameter to be used for local firmware queue configuration. Array index
    corresponds to the ACI
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_AC_PARAMS_ADMISSION_CTRL_MANDATORY 0x80D4

/*******************************************************************************
  NAME          : CsrWifiSmePsidPacketFiltersActiveHost
  PSID          : 32981 (0x80D5)
  PER INTERFACE?: YES
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 255
  DEFAULT       : {0, NULL}
  DESCRIPTION   :
    Used to set packet filters during the active state of the SME, i.e. not
    suspended. The filters must be formatted in the following format.
    Byte 1 : Specifies whether the filter selects or excludes packets
    matching the filter See the values of CsrWifiSmePacketFilterMode
    Bytes n: filter to be of type:- Traffic Classification (TCLAS)
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PACKET_FILTERS_ACTIVE_HOST 0x80D5

/*******************************************************************************
  NAME          : CsrWifiSmePsidPacketFiltersSuspendedHost
  PSID          : 32982 (0x80D6)
  PER INTERFACE?: YES
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : {0x03, 0x0E, 0x13, 0x00, 0x01, 0x58, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x43, 0x00, 0x11, 0x00}
  DESCRIPTION   :
    Used to set packet filters during the D3 suspended state of the SME. The
    filters must be formatted in the following format.
    Byte 1 : Specifies whether the filter selects or excludes packets
    matching the filter See the values of CsrWifiSmePacketFilterMode
    Bytes n: filter to be of type:- Traffic Classification (TCLAS)
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_PACKET_FILTERS_SUSPENDED_HOST 0x80D6

/*******************************************************************************
  NAME          : CsrWifiSmePsidP2pDeviceAddress
  PSID          : 32983 (0x80D7)
  PER INTERFACE?: NO
  TYPE          : CsrWifiMacAddress
  MIN           : 6
  MAX           : 6
  DEFAULT       : {{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}}
  DESCRIPTION   :
    Returns the P2P Device address that is common across all interfaces.
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_P2P_DEVICE_ADDRESS 0x80D7
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaRxBlockAckEnabled
  PSID          : 32984 (0x80D8)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    Enable or disable Sta Rx BlockAck functionality
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_RX_BLOCK_ACK_ENABLED 0x80D8

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaTxBlockAckEnabled
  PSID          : 32985 (0x80D9)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    Enable or disable Sta Tx BlockAck functionality
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_TX_BLOCK_ACK_ENABLED 0x80D9

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaRxBlockAckWindow
  PSID          : 32986 (0x80DA)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 8
  DEFAULT       : 8
  DESCRIPTION   :
    Specifies the Block ack window
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_RX_BLOCK_ACK_WINDOW 0x80DA

/*******************************************************************************
  NAME          : CsrWifiSmePsidStaTxBlockAckWindow
  PSID          : 32987 (0x80DB)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 8
  DEFAULT       : 8
  DESCRIPTION   :
    Specifies the Block ack window
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_STA_TX_BLOCK_ACK_WINDOW 0x80DB

/*******************************************************************************
  NAME          : CsrWifiSmePsidIPv4Address
  PSID          : 32988 (0x80DC)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 4
  MAX           : 4
  DEFAULT       : 0xFF, 0xFF, 0xFF, 0xFF
  DESCRIPTION   :
    Used to set IPv4 IP Address. Used primarily for Packet filtering.
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_IPV4_ADDRESS 0x80DC

/*******************************************************************************
  NAME          : CsrWifiSmePsidApRxBlockAckEnabled
  PSID          : 32989 (0x80DD)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    Enable or disable AP Rx Block Ack functionality
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_RX_BLOCK_ACK_ENABLED 0x80DD
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApTxBlockAckEnabled
  PSID          : 32990 (0x80DE)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    Enable or disable AP Tx Block Ack functionality
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_TX_BLOCK_ACK_ENABLED 0x80DE
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApRxBlockAckWindow
  PSID          : 32991 (0x80DF)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 8
  DEFAULT       : 8
  DESCRIPTION   :
    Specifies the AP Rx Block Ack window (buffer) size
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_RX_BLOCK_ACK_WINDOW 0x80DF
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApTxBlockAckWindow
  PSID          : 32992 (0x80E0)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 8
  DEFAULT       : 8
  DESCRIPTION   :
    Specifies the AP Tx Block Ack window (buffer) size
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_TX_BLOCK_ACK_WINDOW 0x80E0
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidApRxBlockAckResources
  PSID          : 32993 (0x80E1)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 4
  DEFAULT       : 1
  DESCRIPTION   :
    Specifies the number of AP Rx Block Acks that can be established
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_SME_PSID_AP_RX_BLOCK_ACK_RESOURCES 0x80E1
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidAmpDisable
  PSID          : 32994 (0x80E2)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Enables or disables the AMP
 *******************************************************************************/
#ifdef CSR_AMP_ENABLE
#define CSR_WIFI_SME_PSID_AMP_DISABLE 0x80E2
#endif /* CSR_AMP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidAmpFixedPreferedChannelInfo
  PSID          : 32995 (0x80E3)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0x0000
  MAX           : 0xFFFF
  DEFAULT       : 0x0000
  DESCRIPTION   :
    Forces Amp to connect using the requested channel. 0 allows the Sme to
    auto select the preferred channel. This is mostly usefull in testing so
    you know ahead of time which channel the Amp will be set up on
 *******************************************************************************/
#ifdef CSR_AMP_ENABLE
#define CSR_WIFI_SME_PSID_AMP_FIXED_PREFERED_CHANNEL_INFO 0x80E3
#endif /* CSR_AMP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeAdvertisingScanContinuousBlackoutDurationMs
  PSID          : 33041 (0x8111)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0x00
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Duration when a LE BT Continuous Scan is active. The value '0'
    implies no blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_ADVERTISING_SCAN_CONTINUOUS_BLACKOUT_DURATION_MS 0x8111
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeAdvertisingScanContinuousBlackoutPeriodMs
  PSID          : 33042 (0x8112)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Period when a LE BT Continuous Scan is active. The value '0'
    implies no blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_ADVERTISING_SCAN_CONTINUOUS_BLACKOUT_PERIOD_MS 0x8112
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeConnectionIntervalThreshold
  PSID          : 33043 (0x8113)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0x00
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Period when a LE BT connection exists. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_CONNECTION_INTERVAL_THRESHOLD 0x8113
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeConnectionBlackoutDurationMs
  PSID          : 33044 (0x8114)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0x00
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Duration when a LE BT connection exists. The value '0' implies
    no blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_CONNECTION_BLACKOUT_DURATION_MS 0x8114
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeConnectionBlackoutPeriodMs
  PSID          : 33045 (0x8115)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0x00
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Period when a LE BT connection exists. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_CONNECTION_BLACKOUT_PERIOD_MS 0x8115
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeConnectionContinuousBlackoutDurationMs
  PSID          : 33046 (0x8116)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0x00
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Duration when a LE BT connection exists. The value '0' implies
    no blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_CONNECTION_CONTINUOUS_BLACKOUT_DURATION_MS 0x8116
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgLeConnectionContinuousBlackoutPeriodMs
  PSID          : 33047 (0x8117)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0x00
  MAX           : 0x00418937
  DEFAULT       : 0
  DESCRIPTION   :
    Blackout Period when a LE BT connection exists. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_LE_CONNECTION_CONTINUOUS_BLACKOUT_PERIOD_MS 0x8117
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgObexBlackoutDurationMs
  PSID          : 33048 (0x8118)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 20
  DESCRIPTION   :
    Blackout Period when a BT Obex is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_OBEX_BLACKOUT_DURATION_MS 0x8118
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgObexBlackoutPeriodMs
  PSID          : 33049 (0x8119)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 40
  DESCRIPTION   :
    Blackout Duration when a BT Obex is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_OBEX_BLACKOUT_PERIOD_MS 0x8119
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgScoApMaxBlackoutDurationUs
  PSID          : 33050 (0x811A)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 1250
  DESCRIPTION   :
    Max Blackout Period when a BT SCO  is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_SCO_AP_MAX_BLACKOUT_DURATION_US 0x811A
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgEscoApMaxBlackoutDurationUs
  PSID          : 33051 (0x811B)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 2000
  DESCRIPTION   :
    Max Blackout Period when a BT eSCO  is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_ESCO_AP_MAX_BLACKOUT_DURATION_US 0x811B
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgScoStaMaxBlackoutDurationUs
  PSID          : 33052 (0x811C)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 1250
  DESCRIPTION   :
    Max Blackout Period when a BT SCO  is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_SCO_STA_MAX_BLACKOUT_DURATION_US 0x811C
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgEscoStaMaxBlackoutDurationUs
  PSID          : 33053 (0x811D)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 2500
  DESCRIPTION   :
    Max Blackout Period when a BT eSCO  is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_ESCO_STA_MAX_BLACKOUT_DURATION_US 0x811D
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgUseA2dpAdaptiveDurationModeForAp
  PSID          : 33054 (0x811E)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    TRUE if A2DP for AP is to use adaptive blackouts
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_COEX_CFG_USE_A2DP_ADAPTIVE_DURATION_MODE_FOR_AP 0x811E

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgUseA2dpAdaptiveDurationModeForSta
  PSID          : 33055 (0x811F)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    TRUE if A2DP for STA is to use adaptive blackouts
 *******************************************************************************/
#define CSR_WIFI_SME_PSID_COEX_CFG_USE_A2DP_ADAPTIVE_DURATION_MODE_FOR_STA 0x811F

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpFixedAlgoBrBlackoutDurationMs
  PSID          : 33056 (0x8120)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 30
  DESCRIPTION   :
    Blackout Period when a BT A2dpBr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_FIXED_ALGO_BR_BLACKOUT_DURATION_MS 0x8120
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpFixedAlgoBrBlackoutPeriodMs
  PSID          : 33057 (0x8121)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 45
  DESCRIPTION   :
    Blackout Duration when a BT A2dpBr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_FIXED_ALGO_BR_BLACKOUT_PERIOD_MS 0x8121
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpFixedAlgoEdrBlackoutDurationMs
  PSID          : 33058 (0x8122)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 20
  DESCRIPTION   :
    Blackout Period when a BT A2dpEdr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_FIXED_ALGO_EDR_BLACKOUT_DURATION_MS 0x8122
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpFixedAlgoEdrBlackoutPeriodMs
  PSID          : 33059 (0x8123)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 45
  DESCRIPTION   :
    Blackout Duration when a BT A2dpEdr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_FIXED_ALGO_EDR_BLACKOUT_PERIOD_MS 0x8123
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpAdaptiveAlgoBrBlackoutDurationMs
  PSID          : 33060 (0x8124)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 90
  DESCRIPTION   :
    Blackout Period when a BT A2dpBr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_ADAPTIVE_ALGO_BR_BLACKOUT_DURATION_MS 0x8124
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpAdaptiveAlgoBrBlackoutPeriodMs
  PSID          : 33061 (0x8125)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 105
  DESCRIPTION   :
    Blackout Duration when a BT A2dpBr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_ADAPTIVE_ALGO_BR_BLACKOUT_PERIOD_MS 0x8125
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpAdaptiveAlgoEdrBlackoutDurationMs
  PSID          : 33062 (0x8126)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 90
  DESCRIPTION   :
    Blackout Period when a BT A2dpEdr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_ADAPTIVE_ALGO_EDR_BLACKOUT_DURATION_MS 0x8126
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiSmePsidCoexCfgA2dpAdaptiveAlgoEdrBlackoutPeriodMs
  PSID          : 33063 (0x8127)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0x00418937
  DEFAULT       : 105
  DESCRIPTION   :
    Blackout Duration when a BT A2dpEdr is active. The value '0' implies no
    blackout.
 *******************************************************************************/
#ifdef CSR_WIFI_COEX_ENABLE
#define CSR_WIFI_SME_PSID_COEX_CFG_A2DP_ADAPTIVE_ALGO_EDR_BLACKOUT_PERIOD_MS 0x8127
#endif /* CSR_WIFI_COEX_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiNmePsidApGroupkeyTimeout
  PSID          : 49152 (0xC000)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Access point group key timeout
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_NME_PSID_AP_GROUPKEY_TIMEOUT 0xC000
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiNmePsidApStrictGtkRekey
  PSID          : 49153 (0xC001)
  PER INTERFACE?: YES
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Access point strict GTK rekey flag. If set TRUE, the AP shall rekey GTK
    every time a connected STA leaves BSS
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_NME_PSID_AP_STRICT_GTK_REKEY 0xC001
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiNmePsidApGmkTimeout
  PSID          : 49154 (0xC002)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 0xFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Not supported for Wi-Fi 6.x.
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_NME_PSID_AP_GMK_TIMEOUT 0xC002
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiNmePsidResponseTimeout
  PSID          : 49155 (0xC003)
  PER INTERFACE?: YES
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 100
  MAX           : 0xFFFF
  DEFAULT       : 1500
  DESCRIPTION   :
    Response timeout
 *******************************************************************************/
#define CSR_WIFI_NME_PSID_RESPONSE_TIMEOUT 0xC003

/*******************************************************************************
  NAME          : CsrWifiNmePsidRetransLimit
  PSID          : 49156 (0xC004)
  PER INTERFACE?: YES
  TYPE          : CsrUint8
  MIN           : 3
  MAX           : 0xFF
  DEFAULT       : 3
  DESCRIPTION   :
    Maximum allowed retransmissions
 *******************************************************************************/
#define CSR_WIFI_NME_PSID_RETRANS_LIMIT 0xC004

/*******************************************************************************
  NAME          : CsrWifiNmePsidApSsidSuffix
  PSID          : 49157 (0xC005)
  PER INTERFACE?: NO
  TYPE          : CsrWifiDataBlock
  MIN           : 0
  MAX           : 23
  DEFAULT       : {0, NULL}
  DESCRIPTION   :
    Suffix to be appended to the generated SSID
 *******************************************************************************/
#ifdef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_NME_PSID_AP_SSID_SUFFIX 0xC005
#endif /* CSR_WIFI_AP_ENABLE */

/*******************************************************************************
  NAME          : CsrWifiRouterPsidZeroCopyMode
  PSID          : 57344 (0xE000)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Zero copy means that the HIP does not aggregate (copy) packets into a
    buffer for efficient SDIO use
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_ZERO_COPY_MODE 0xE000

/*******************************************************************************
  NAME          : CsrWifiRouterPsidPollPeriod
  PSID          : 57345 (0xE001)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : ms
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 1
  DESCRIPTION   :
    Interrupt mitigation period
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_POLL_PERIOD 0xE001

/*******************************************************************************
  NAME          : CsrWifiRouterPsidTxWindowSegmentSize
  PSID          : 57346 (0xE002)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    The HIP transmit window can be treated as one segment or two. A single
    segment is the most efficient setting in terms of SDIO. However, by
    setting a segment size of two, packet written to the chip are available
    for transmission over the air sooner at the cost of some extra SDIO
    transactions
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_TX_WINDOW_SEGMENT_SIZE 0xE002

/*******************************************************************************
  NAME          : CsrWifiRouterPsidTxForcePullMode
  PSID          : 57347 (0xE003)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 0
  DESCRIPTION   :
    Not supported for Wi-Fi 6.x.
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_TX_FORCE_PULL_MODE 0xE003

/*******************************************************************************
  NAME          : CsrWifiRouterPsidMparamSlotCount1
  PSID          : 57348 (0xE004)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 64
  DESCRIPTION   :
    The to-host and from-host slot counts
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_MPARAM_SLOT_COUNT1 0xE004

/*******************************************************************************
  NAME          : CsrWifiRouterPsidMparamSlotCount2
  PSID          : 57349 (0xE005)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 0xFFFFFFFF
  DEFAULT       : 120
  DESCRIPTION   :
    The to-host and from-host slot counts
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_MPARAM_SLOT_COUNT2 0xE005

/*******************************************************************************
  NAME          : CsrWifiRouterPsidMinVifDurationEapol
  PSID          : 57350 (0xE006)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 0
  DESCRIPTION   :
    How long to stay on channel after sending an EAPOL frame
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_MIN_VIF_DURATION_EAPOL 0xE006

/*******************************************************************************
  NAME          : CsrWifiRouterPsidMinVifDurationDhcp
  PSID          : 57351 (0xE007)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 0
  DESCRIPTION   :
    How long to stay on channel after sending a DHCP frame
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_MIN_VIF_DURATION_DHCP 0xE007

/*******************************************************************************
  NAME          : CsrWifiRouterPsidMinVifDurationArp
  PSID          : 57352 (0xE008)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : TU
  MIN           : 0
  MAX           : 100
  DEFAULT       : 0
  DESCRIPTION   :
    How long to stay on channel after sending an ARP frame
 *******************************************************************************/
#define CSR_WIFI_ROUTER_PSID_MIN_VIF_DURATION_ARP 0xE008

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RegulatoryClassesImplemented
  PSID          : 38 (0x0026)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    This attribute, when TRUE, indicates that the station implementation is
    capable of supporting regulatory classes. The capability is disabled
    otherwise.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_REGULATORY_CLASSES_IMPLEMENTED 0x0026

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RegulatoryClassesRequired
  PSID          : 39 (0x0027)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    A STA will use the defined regulatory classes procedures if and only if
    this attribute is TRUE. This attribute can be set to TRUE only if
    dot11RegulatoryClassesImplemented is also TRUE.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_REGULATORY_CLASSES_REQUIRED 0x0027

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11PowerCapabilityMax
  PSID          : 112 (0x0070)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -32768
  MAX           : 32767
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_POWER_CAPABILITY_MAX 0x0070

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11PowerCapabilityMin
  PSID          : 113 (0x0071)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -32768
  MAX           : 32767
  DEFAULT       : -100
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_POWER_CAPABILITY_MIN 0x0071

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RtsThreshold
  PSID          : 121 (0x0079)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : octet
  MIN           : 0
  MAX           : 3000
  DEFAULT       : 3000
  DESCRIPTION   :
    This attribute shall indicate the size of an MPDU, below which an RTS/CTS
    handshake shall not be performed, except as RTS/CTS is used as a cross
    modulation protection mechanism as defined in 9.10. An RTS/CTS handshake
    shall be performed at the beginning of any frame exchange sequence where
    the MPDU is of type Data or Management, the MPDU has an individual
    address in the Address1 field, and the length of the MPDU is greater than
    this threshold. (For additional details, refer to Table 21 in 9.7.)
    Setting this attribute to be larger than the maximum MSDU size shall have
    the effect of turning off the RTS/CTS handshake for frames of Data or
    Management type transmitted by this STA. Setting this attribute to zero
    shall have the effect of turning on the RTS/CTS handshake for all frames
    of Data or Management type transmitted by this STA.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RTS_THRESHOLD 0x0079

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11ShortRetryLimit
  PSID          : 122 (0x007A)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 255
  DEFAULT       : 7
  DESCRIPTION   :
    This attribute shall indicate the maximum number of transmission attempts
    of a frame, the length of which is less than or equal to
    dot11RTSThreshold, that shall be made before a failure condition is
    indicated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_SHORT_RETRY_LIMIT 0x007A

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11LongRetryLimit
  PSID          : 123 (0x007B)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 255
  DEFAULT       : 4
  DESCRIPTION   :
    This attribute shall indicate the maximum number of transmission attempts
    of a frame, the length of which is greater than dot11RTSThreshold, that
    shall be made before a failure condition is indicated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_LONG_RETRY_LIMIT 0x007B

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11FragmentationThreshold
  PSID          : 124 (0x007C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 256
  MAX           : 3000
  DEFAULT       : 3000
  DESCRIPTION   :
    This attribute shall specify the current maximum size, in octets, of the
    MPDU that may be delivered to the PHY. An MSDU shall be broken into
    fragments if its size exceeds the value of this attribute after adding
    MAC headers and trailers. An MSDU or MMPDU shall be fragmented when the
    resulting frame has an individual address in the Address1 field, and the
    length of the frame is larger than this threshold. The maximum value of
    this attribute is the lesser of 3000 or the maximum MPDU length of the
    attached PHY.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_FRAGMENTATION_THRESHOLD 0x007C

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11MaxTransmitMsduLifetime
  PSID          : 125 (0x007D)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : TU
  MIN           : 1
  MAX           : 4294967295
  DEFAULT       : 512
  DESCRIPTION   :
    The elapsed time, after the initial transmission of an MSDU, after which
    further attempts to transmit the MSDU shall be terminated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MAX_TRANSMIT_MSDU_LIFETIME 0x007D

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11MaxReceiveLifetime
  PSID          : 126 (0x007E)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : TU
  MIN           : 1
  MAX           : 4294967295
  DEFAULT       : 512
  DESCRIPTION   :
    The elapsed time, after the initial reception of a fragmented MMPDU or
    MSDU, after which further attempts to reassemble the MMPDU or MSDU shall
    be terminated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MAX_RECEIVE_LIFETIME 0x007E

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11QapMissingAckRetryLimit
  PSID          : 138 (0x008A)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 100
  DEFAULT       : 5
  DESCRIPTION   :
    This attribute indicates the number of times the QAP may retry a frame
    for which it does not receive an ACK for a STA in power-save mode after
    receiving a PS-Poll and sending a directed response or after the QAP does
    not receive an ACK to a directed MPDU sent with the EOSP set to 1.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_QAP_MISSING_ACK_RETRY_LIMIT 0x008A

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11EdcaAveragingPeriod
  PSID          : 139 (0x008B)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 1
  MAX           : 100
  DEFAULT       : 5
  DESCRIPTION   :
    This attribute shall indicate the interval over which the Admitted Time
    and the Used Time are computed.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_EDCA_AVERAGING_PERIOD 0x008B

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11TransmittedFragmentCount
  PSID          : 140 (0x008C)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall be incremented for an acknowledged MPDU with an
    individual address in the address 1 field or an MPDU with a multicast
    address in the address 1 field of type Data or Management.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_TRANSMITTED_FRAGMENT_COUNT 0x008C

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11MulticastTransmittedFrameCount
  PSID          : 141 (0x008D)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment only when the multicast bit is set in the
    destination MAC address of a successfully transmitted MSDU. When
    operating as a STA in an ESS, where these frames are directed to the AP,
    this implies having received an acknowledgement to all associated MPDUs.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MULTICAST_TRANSMITTED_FRAME_COUNT 0x008D

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11FailedCount
  PSID          : 142 (0x008E)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when an MSDU is not transmitted successfully
    due to the number of transmit attempts exceeding either the
    dot11ShortRetryLimit or dot11LongRetryLimit.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_FAILED_COUNT 0x008E

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RetryCount
  PSID          : 143 (0x008F)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when an MSDU is successfully transmitted
    after one or more retransmissions.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RETRY_COUNT 0x008F

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11MultipleRetryCount
  PSID          : 144 (0x0090)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when an MSDU is successfully transmitted
    after more than one retransmission.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MULTIPLE_RETRY_COUNT 0x0090

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11FrameDuplicateCount
  PSID          : 145 (0x0091)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when a frame is received that the Sequence
    Control field indicates is a duplicate.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_FRAME_DUPLICATE_COUNT 0x0091

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RtsSuccessCount
  PSID          : 146 (0x0092)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when a CTS is received in response to an
    RTS.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RTS_SUCCESS_COUNT 0x0092

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RtsFailureCount
  PSID          : 147 (0x0093)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when a CTS is not received in response to an
    RTS.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RTS_FAILURE_COUNT 0x0093

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11AckFailureCount
  PSID          : 148 (0x0094)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when an ACK is not received when expected.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_ACK_FAILURE_COUNT 0x0094

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11ReceivedFragmentCount
  PSID          : 149 (0x0095)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall be incremented for each successfully received MPDU of
    type Data or Management.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RECEIVED_FRAGMENT_COUNT 0x0095

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11MulticastReceivedFrameCount
  PSID          : 150 (0x0096)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when a MSDU is received with the multicast
    bit set in the destination MAC address.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MULTICAST_RECEIVED_FRAME_COUNT 0x0096

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11FcsErrorCount
  PSID          : 151 (0x0097)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when an FCS error is detected in a received
    MPDU.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_FCS_ERROR_COUNT 0x0097

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11TransmittedFrameCount
  PSID          : 152 (0x0098)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment for each successfully transmitted MSDU.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_TRANSMITTED_FRAME_COUNT 0x0098

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11WepUndecryptableCount
  PSID          : 153 (0x0099)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This counter shall increment when a frame is received with the WEP
    subfield of the Frame Control field set to one and the WEPOn value for
    the key mapped to the transmitter&apos;s MAC address indicates that the
    frame should not have been encrypted or that frame is discarded due to
    the receiving STA not implementing the privacy option.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_WEP_UNDECRYPTABLE_COUNT 0x0099

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11ResourceTypeIdName
  PSID          : 170 (0x00AA)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 4
  MAX           : 4
  DEFAULT       : RTID
  DESCRIPTION   :
    Contains the name of the Resource Type ID managed object. The attribute
    is read-only and always contains the value RTID. This attribute value
    shall not be used as a naming attribute for any other managed object
    class.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RESOURCE_TYPE_ID_NAME 0x00AA

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11ManufacturerOui
  PSID          : 180 (0x00B4)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 3
  MAX           : 3
  DEFAULT       : { 0X00, 0X02, 0X5B }
  DESCRIPTION   :
    Takes the value of an organisationally unique identifier.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MANUFACTURER_OUI 0x00B4

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11ManufacturerName
  PSID          : 181 (0x00B5)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 128
  DEFAULT       : CSR
  DESCRIPTION   :
    A printable string used to identify the manufacturer of the resource.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MANUFACTURER_NAME 0x00B5

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11ManufacturerProductName
  PSID          : 182 (0x00B6)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 128
  DEFAULT       : UNIFI
  DESCRIPTION   :
    A printable string used to identify the manufacturer&apos;s product name
    of the resource.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MANUFACTURER_PRODUCT_NAME 0x00B6

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11ManufacturerProductVersion
  PSID          : 183 (0x00B7)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 128
  DEFAULT       :
  DESCRIPTION   :
    Printable string used to identify the manufacturer&apos;s product version
    of the resource.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_MANUFACTURER_PRODUCT_VERSION 0x00B7

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsStaAddress
  PSID          : 430 (0x01AE)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The MAC address of the STA to which the statistics in this conceptual row
    belong.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_STA_ADDRESS 0x01AE

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsTkipicvErrors
  PSID          : 433 (0x01B1)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    Counts the number of TKIP ICV errors encountered when decrypting packets
    for the STA.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_TKIPICV_ERRORS 0x01B1

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsTkipLocalMicFailures
  PSID          : 434 (0x01B2)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    Counts the number of MIC failures encountered when checking the integrity
    of packets received from the STA at this entity.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_TKIP_LOCAL_MIC_FAILURES 0x01B2

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsTkipRemoteMicFailures
  PSID          : 435 (0x01B3)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    Counts the number of MIC failures encountered by the STA identified by
    dot11RSNAStatsSTAAddress and reported back to this entity.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_TKIP_REMOTE_MIC_FAILURES 0x01B3

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsCcmpReplays
  PSID          : 436 (0x01B4)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    The number of received CCMP MPDUs discarded by the replay mechanism.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_CCMP_REPLAYS 0x01B4

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsCcmpDecryptErrors
  PSID          : 437 (0x01B5)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    The number of received MPDUs discarded by the CCMP decryption algorithm.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_CCMP_DECRYPT_ERRORS 0x01B5

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsTkipReplays
  PSID          : 438 (0x01B6)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    Counts the number of TKIP replay errors detected.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_TKIP_REPLAYS 0x01B6

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsCmacicvErrors
  PSID          : 439 (0x01B7)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    The number of received MPDUs discarded by the CMAC integrity check
    algorithm.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_CMACICV_ERRORS 0x01B7

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsCmacReplays
  PSID          : 440 (0x01B8)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    The number of received MPDUs discarded by the CMAC replay errors.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_CMAC_REPLAYS 0x01B8

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsRobustMgmtCcmpReplays
  PSID          : 441 (0x01B9)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    The number of received Robust Management frame MPDUs discarded due to
    CCMP replay errors
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_ROBUST_MGMT_CCMP_REPLAYS 0x01B9

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnabipmicErrors
  PSID          : 442 (0x01BA)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    The number of received MMPDUs discarded due to BIP MIC errors.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNABIPMIC_ERRORS 0x01BA

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11PcoFortyMaxDuration
  PSID          : 508 (0x01FC)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 200
  DEFAULT       : 30
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_PCO_FORTY_MAX_DURATION 0x01FC

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11PcoTwentyMaxDuration
  PSID          : 509 (0x01FD)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 200
  DEFAULT       : 30
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_PCO_TWENTY_MAX_DURATION 0x01FD

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11PcoFortyMinDuration
  PSID          : 510 (0x01FE)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 200
  DEFAULT       : 20
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_PCO_FORTY_MIN_DURATION 0x01FE

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11PcoTwentyMinDuration
  PSID          : 511 (0x01FF)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 200
  DEFAULT       : 20
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_PCO_TWENTY_MIN_DURATION 0x01FF

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11FortyMhzIntolerant
  PSID          : 512 (0x0200)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_FORTY_MHZ_INTOLERANT 0x0200

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11EdcaTableAifsn
  PSID          : 572 (0x023C)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 2
  MAX           : 15
  DEFAULT       :
  DESCRIPTION   :
    Changes take effect as soon as practical in the implementation. This
    attribute specifies the number of slots, after a SIFS duration, that the
    STA, for a particular AC, senses the medium idle either before
    transmitting or executing a backoff.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_EDCA_TABLE_AIFSN 0x023C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeConnectionTimeout
  PSID          : 2000 (0x07D0)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : beacon intervals
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 20
  DESCRIPTION   :
    The CSR proprietary signal primitive MLME-CONNECTED.indication is issued
    when a network connection (to an access point or with peer stations in an
    IBSS) is established or lost. A connection is deemed to have occurred
    when a beacon frame for the current BSSID is received, and is
    subsequently lost when no matching beacon is received for the number of
    beacon intervals specified by this attribute. An
    MLME-CONNECTED.indication is also issued following the first
    MLME-RESET.request to indicate that radio calibration has completed, so
    normal operation can begin.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_CONNECTION_TIMEOUT 0x07D0

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeFaultReportLevel
  PSID          : 2001 (0x07D1)
  PER INTERFACE?: NO
  TYPE          : unifiMLMEFaultReportLevel
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute controls the level of fault reporting from the MLME via
    the Debug SAP. The possible values are: 0 - No special fault reports. 1 -
    Detailed MLME interface fault reports.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_FAULT_REPORT_LEVEL 0x07D1

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeScanPowerManagementMode
  PSID          : 2002 (0x07D2)
  PER INTERFACE?: NO
  TYPE          : unifiMLMEScanPowerManagementMode
  MIN           : 0
  MAX           : 255
  DEFAULT       : 1
  DESCRIPTION   :
    UniFi can optionally signal to access points that it is in power save
    (PS) mode prior to performing a scan. This reduces risk of data (or other
    signalling) being lost due to the radio being switched to different
    channels. Use of this mechanism is controlled by this attribute. The
    possible values are: 0 - No power management signalling prior to scan. 1
    - Attempt to notify the AP/GO that UniFi is in power save mode prior to
    starting a scan, subject to unifiMLMEScanPowerManagementLimit. The
    previous state is restored when the scan completes.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_SCAN_POWER_MANAGEMENT_MODE 0x07D2

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeScanPowerManagementLimit
  PSID          : 2004 (0x07D4)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 20000
  DESCRIPTION   :
    This attribute is used if unifiMLMEScanPowerManagementMode is set to 1.
    It determines the minimum scan time beyond which power save is used
    during the scan. Note that for scans longer than the limit the overall
    length of the time taken (from the MLME-SCAN.request to the
    MLME-SCAN.confirm) may be extended by up to the value of
    unifiPowerManagementDelayTimeout.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_SCAN_POWER_MANAGEMENT_LIMIT 0x07D4

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeDataReferenceTimeout
  PSID          : 2005 (0x07D5)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 65534
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the maximum time allowed for the data in data
    references corresponding to MLME primitives to be made available to the
    firmware. The special value 0 specifies an infinite timeout.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_DATA_REFERENCE_TIMEOUT 0x07D5

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeMaxBeaconsUntilScan
  PSID          : 2006 (0x07D6)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : beacon intervals
  MIN           : 0
  MAX           : 65534
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_MAX_BEACONS_UNTIL_SCAN 0x07D6

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeScanProbeInterval
  PSID          : 2007 (0x07D7)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 10
  DESCRIPTION   :
    This attribute specifies the time between transmissions of broadcast
    probe requests on a given channel when performing an active scan. The
    special value 0 specifies that the probe request is only transmitted
    once.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_SCAN_PROBE_INTERVAL 0x07D7

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanHighRssiThreshold
  PSID          : 2008 (0x07D8)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -128
  MAX           : 127
  DEFAULT       : -80
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_HIGH_RSSI_THRESHOLD 0x07D8

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanLowRssiThreshold
  PSID          : 2009 (0x07D9)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -128
  MAX           : 127
  DEFAULT       : -85
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_LOW_RSSI_THRESHOLD 0x07D9

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanDeltaRssiThreshold
  PSID          : 2010 (0x07DA)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : dB
  MIN           : 1
  MAX           : 255
  DEFAULT       : 3
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_DELTA_RSSI_THRESHOLD 0x07DA

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanHighSnrThreshold
  PSID          : 2011 (0x07DB)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -128
  MAX           : 127
  DEFAULT       : 4
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_HIGH_SNR_THRESHOLD 0x07DB

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanLowSnrThreshold
  PSID          : 2012 (0x07DC)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -128
  MAX           : 127
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_LOW_SNR_THRESHOLD 0x07DC

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanDeltaSnrThreshold
  PSID          : 2013 (0x07DD)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : dB
  MIN           : 1
  MAX           : 255
  DEFAULT       : 2
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_DELTA_SNR_THRESHOLD 0x07DD

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanMaximumAge
  PSID          : 2014 (0x07DE)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 1
  MAX           : 2147
  DEFAULT       : 5
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_MAXIMUM_AGE 0x07DE

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanMaximumResults
  PSID          : 2015 (0x07DF)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_MAXIMUM_RESULTS 0x07DF

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAutonomousScanNoisy
  PSID          : 2016 (0x07E0)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_AUTONOMOUS_SCAN_NOISY 0x07E0

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeTriggeredGetMinInterval
  PSID          : 2017 (0x07E1)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 10
  MAX           : 65535
  DEFAULT       : 500
  DESCRIPTION   :
    This attribute specifies the minimum interval between two
    MLME-TRIGGERED-GET.indication primitives. For multiple triggers in this
    interval, only one MLME-TRIGGERED-GET.indication will be generated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_TRIGGERED_GET_MIN_INTERVAL 0x07E1

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeAllowPassiveScanDuringCoex
  PSID          : 2018 (0x07E2)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    This attribute specifies whether the passive scans are allowed when there
    is periodic BT activity.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_ALLOW_PASSIVE_SCAN_DURING_COEX 0x07E2

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeExcessScanThreshold
  PSID          : 2019 (0x07E3)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 1000
  DEFAULT       : 10
  DESCRIPTION   :
    This attribute specifies the time by which an autonomous scan on a
    particular channel can exceed the maximum channel time passed in the
    request. On exceeding this, the firmware attempts to stop the scan
    immediately.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_EXCESS_SCAN_THRESHOLD 0x07E3

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFirmwareBuildId
  PSID          : 2021 (0x07E5)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    Numeric build identifier for this firmware build. This should normally be
    displayed in decimal. The textual build identifier is available via the
    standard dot11manufacturerProductVersion MIB attribute.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FIRMWARE_BUILD_ID 0x07E5

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiChipVersion
  PSID          : 2022 (0x07E6)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Numeric identifier for the UniFi silicon revision (as returned by the
    GBL_CHIP_VERSION hardware register). Other than being different for each
    design variant (but not for alternative packaging options), the
    particular values returned do not have any significance.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_CHIP_VERSION 0x07E6

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFirmwarePatchBuildId
  PSID          : 2023 (0x07E7)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    Numeric build identifier for the patch set that has been applied to this
    firmware image. This should normally be displayed in decimal. For a
    patched ROM build there will be two build identifiers, the first will
    correspond to the base ROM image, the second will correspond to the patch
    set that has been applied.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FIRMWARE_PATCH_BUILD_ID 0x07E7

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMibFileId
  PSID          : 2024 (0x07E8)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    A string which identifies a CSR generated MIB file. Contact CSR if more
    information regarding a CSR generated MIB file is required.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MIB_FILE_ID 0x07E8

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiBasicCapabilities
  PSID          : 2030 (0x07EE)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 5
  MAX           : 5
  DEFAULT       : { 0X30, 0X8E, 0X00, 0X14, 0X98 }
  DESCRIPTION   :
    This MIB variable indicates basis capabilities of the chip. It includes
    both subfields that are chip implementation dependent from the IEEE
    802.11 Capability Information, and CSR defined subfields that the host
    requires for its operation. The two first octets follow the coding of
    IEEE 802.11 Capability Information, with spare subfields as required.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_BASIC_CAPABILITIES 0x07EE

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiExtendedCapabilities
  PSID          : 2031 (0x07EF)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 7
  MAX           : 7
  DEFAULT       : { 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00 }
  DESCRIPTION   :
    This MIB variable indicates extended capabilities of the chip. Bit field
    definition and coding follows IEEE 802.11 Extended Capability Information
    Element, with spare subfields for capabilities that are independent from
    chip/firmware implementation.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_EXTENDED_CAPABILITIES 0x07EF

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiHtCapabilities
  PSID          : 2032 (0x07F0)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 255
  DEFAULT       : { 0X30, 0X01, 0X1C, 0X01, 0X00, 0X04 }
  DESCRIPTION   :
    This MIB variable indicates the HT capabilities of the chip. Bit field
    definition and coding follows the HT Capabilities Info, A-MPDU Parameters
    field, HT Extended Capabilities field of IEEE 802.11 HT Capability
    Information Element, with spare subfields for capabilities that are
    independent from chip/ firmware implementation. A Tx MCS Set Info octet
    is defined replacing the Supported MCS Set field of the IEEE 802.11 HT
    Capability Information Element. Transmit Beamforming Capabilities is only
    included if the beamforming flag is set in unifiBasicCapabilities.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_HT_CAPABILITIES 0x07F0

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSupportedMcs
  PSID          : 2033 (0x07F1)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 255
  DEFAULT       : { 0XFF, 0X00, 0XFF, 0X00 }
  DESCRIPTION   :
    This MIB variable indicates both the supported Tx MCS set and Rx MCS set.
    Each subfield is encoded as bitmask, ordered by number of supported
    special stream.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SUPPORTED_MCS 0x07F1

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRsnCapabilities
  PSID          : 2034 (0x07F2)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 255
  DEFAULT       : { 0X2F, 0X11, 0X00, 0X24 }
  DESCRIPTION   :
    This MIB variable encodes both the supported cipher suite and the RSN
    Capabilities field of IEEE 802.11 RSN Information Element, with spare
    subfields for capabilities that are independent from chip/ firmware
    implementation.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RSN_CAPABILITIES 0x07F2

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSupportedDataRatesRx
  PSID          : 2040 (0x07F8)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  UNITS         : 500 kbps
  MIN           : 2
  MAX           : 16
  DEFAULT       : { 0X0C, 0X02, 0X04, 0X0B, 0X0C, 0X12, 0X16, 0X18, 0X24, 0X30, 0X48, 0X60, 0X6C }
  DESCRIPTION   :
    Defines the supported non-HT RX data rates. It is encoded as N+1 octets
    where the first octet is N and the subsequent octets each describe a
    single supported rate.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SUPPORTED_DATA_RATES_RX 0x07F8

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSupportedDataRatesTx
  PSID          : 2041 (0x07F9)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  UNITS         : 500 kbps
  MIN           : 2
  MAX           : 16
  DEFAULT       : { 0X0C, 0X02, 0X04, 0X0B, 0X0C, 0X12, 0X16, 0X18, 0X24, 0X30, 0X48, 0X60, 0X6C }
  DESCRIPTION   :
    Defines the supported non-HT RX data rates. It is encoded as N+1 octets
    where the first octet is N and the subsequent octets each describe a
    single supported rate.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SUPPORTED_DATA_RATES_TX 0x07F9

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioProtectMask
  PSID          : 2100 (0x0834)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Each of UniFi&apos;s 16 PIO lines may have special (hardware or software)
    functionality attached, thereby preventing its use for general purpose
    I/O. This attribute provides a bit mask indicating which PIOs are
    reserved in this way; a bit set to 1 cannot be set using the
    unifiPioDirectionMask or unifiPioLevelMask attributes.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_PROTECT_MASK 0x0834

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioDirectionMask
  PSID          : 2101 (0x0835)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Each of UniFi&apos;s 16 PIO lines may be configured as either an input or
    an output. This attribute sets or gets the current state as a bit mask; a
    bit set to 1 sets the corresponding PIO to be an output, otherwise it is
    set to be an input. The drive direction of PIOs marked as protected by
    unifiPioProtectMask cannot be modified; the corresponding bits are
    ignored when written and undefined when read. This attribute is not reset
    by an MLME-RESET.request.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_DIRECTION_MASK 0x0835

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioLevelMask
  PSID          : 2102 (0x0836)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    This attribute sets or gets the level of UniFi&apos;s 16 PIO lines as a
    bit mask; a bit set to 0 corresponds to a logic low level, and a bit set
    to 1 corresponds to a logic high level. Reading this attribute gives the
    current state of the lines (for outputs it is the level being driven, and
    for inputs it is the sampled levels). Writing this attribute sets the
    state of the lines (for outputs it sets the drive level, and for inputs
    it configures internal pull-ups or pull-downs). The drive level of PIOs
    marked as protected by unifiPioProtectMask cannot be modified; the
    corresponding bits are ignored when written. This attribute is not reset
    by an MLME-RESET.request.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_LEVEL_MASK 0x0836

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioHostWakeMode
  PSID          : 2105 (0x0839)
  PER INTERFACE?: NO
  TYPE          : unifiPioHostWakeMode
  MIN           : 0
  MAX           : 255
  DEFAULT       : 1
  DESCRIPTION   :
    If the host&apos;s interface is disabled to save power then it may not be
    possible to use the normal interrupt request to wake the host. This
    attribute enables a PIO line to be used as an alternative out-of-band
    signalling mechanism. Currently defined values are: wake-none (1) - no
    out-of-band wake-up mechanism. wake-pulse (2) - pulse a PIO line to wake
    the host with polarity specified by unifiPioHostWakePolarity.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_HOST_WAKE_MODE 0x0839

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioHostWakeOutput
  PSID          : 2106 (0x083A)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the number of the PIO line to use for waking the
    host if unifiPioHostWakeMode is not set to wake-none.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_HOST_WAKE_OUTPUT 0x083A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioHostWakePolarity
  PSID          : 2107 (0x083B)
  PER INTERFACE?: NO
  TYPE          : unifiPioHostWakePolarity
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the polarity of PIO signalling used to wake the
    host if unifiPioHostWakeMode is not set to wake-none.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_HOST_WAKE_POLARITY 0x083B

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioHostWakeZeal
  PSID          : 2108 (0x083C)
  PER INTERFACE?: NO
  TYPE          : unifiPioHostWakeZeal
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute controls the level of promiscuity of PIO wakeup signalling
    generated if unifiPioHostWakeMode is not set to wake-none. The available
    options are: wake-normal (0) - only generate a PIO wakeup signal if the
    host interface is idle and interrupts are masked. With an SDIO host
    interface this mechanism is invoked if either the IENM or IEN1 bit of the
    CCCR Int Enable register is not set. wake-always (1) - generate PIO
    wakeup signal regardless of host interface activity and interrupt mask
    status.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_HOST_WAKE_ZEAL 0x083C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPioHostWakePulseDuration
  PSID          : 2109 (0x083D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the length of the pulse signalled to wake the
    host on the PIO specified by unifiPioHostWakeOutput if
    unifiPioHostWakeMode is set to wake-pulse. The value of zero has a
    special meaning and instructs UniFi to toggle the wakeup signal as
    quickly as possible.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_PIO_HOST_WAKE_PULSE_DURATION 0x083D

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiUartConfigure
  PSID          : 2110 (0x083E)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    An MLME-SET.request of this attribute causes the UART to be configured
    using the values of the other unifiUart* attributes. The value supplied
    for this attribute is ignored.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_UART_CONFIGURE 0x083E

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiUartPios
  PSID          : 2111 (0x083F)
  PER INTERFACE?: NO
  TYPE          : unifiUartPios
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    Specification of which PIOs should be connected to the UART. Currently
    defined values are: 1 - UART not used; all PIOs are available for other
    uses. 2 - Data transmit and receive connected to PIO[12] and PIO[14]
    respectively. No hardware handshaking lines. 3 - Data and handshaking
    lines connected to PIO[12:15].
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_UART_PIOS 0x083F

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiClockFrequency
  PSID          : 2140 (0x085C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : kHz
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the nominal frequency of the external clock
    source or crystal oscillator used by UniFi. The following values are
    currently supported: 12000, 13000, 19200, 20000, 24000 and 26000.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_CLOCK_FREQUENCY 0x085C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCrystalFrequencyTrim
  PSID          : 2141 (0x085D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 63
  DEFAULT       : 31
  DESCRIPTION   :
    The IEEE 802.11 standard requires a frequency accuracy of either +/- 20
    ppm or +/- 25 ppm depending on the physical layer being used. If
    UniFi&apos;s frequency reference is a crystal then this attribute should
    be used to tweak the oscillating frequency to compensate for design- or
    device-specific variations. Each step change trims the frequency by
    approximately 2 ppm.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_CRYSTAL_FREQUENCY_TRIM 0x085D

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDeepSleepConfig
  PSID          : 2142 (0x085E)
  PER INTERFACE?: NO
  TYPE          : unifiDeepSleepConfig
  MIN           : 0
  MAX           : 255
  DEFAULT       : 1
  DESCRIPTION   :
    UniFi uses various sleep modes to save power. The lowest power mode is
    called deep sleep; this turns off the crystal oscillator or stops
    requesting an external clock. The resulting loss of responsiveness and
    timing accuracy is sometimes undesirable, so use of deep sleep can be
    disabled or restricted using this attribute. Other sleep modes are not
    affected. The possible values are: 0 - Deep sleep will not be used. 1 -
    Deep sleep will be used whenever possible, including when UniFi is in
    power save mode while in a BSS. 2 - Deep sleep will only be used when
    UniFi is not part of a BSS. It will not be used in the IEEE 802.11
    standard power save modes.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DEEP_SLEEP_CONFIG 0x085E

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiI2cConfig
  PSID          : 2143 (0x085F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The UniFi firmware can act as an I2C bus master. This attribute is
    reserved for configuring I2C bus operation. Do not set this attribute.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_I2C_CONFIG 0x085F

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiExternalClockDetect
  PSID          : 2146 (0x0862)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    If UniFi is running with an external fast clock source, i.e.
    unifiExternalFastClockRequest is set, it is common for this clock to be
    shared with other devices. Setting this attribute to true causes UniFi to
    detect when the clock is present (presumably in response to a request
    from another device), and to perform any pending activities at that time
    rather than requesting the clock again some time later. This is likely to
    reduce overall system power consumption by reducing the total time that
    the clock needs to be active.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_EXTERNAL_CLOCK_DETECT 0x0862

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiAnaIoSettingEnum
  PSID          : 2148 (0x0864)
  PER INTERFACE?: NO
  TYPE          : unifiAnaIOSettingEnum
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    The special function for which the analogue I/O (AIO) pin shall shall be
    used. The possible values are: 0 - AIO not used. 1 - AIO used to decouple
    an internal voltage reference; a capacitor should be connected between
    this pin and ground as described in the data sheet. 3 - AIO connected to
    the power detector output from an external 2.4 GHz PA, and to be used as
    the feedback mechanism when performing transmit power control for that
    band. In combination with settings in the config channel request and
    unifiDfyTransmitPowerCompensationTable, this allows for UniFi to
    calibrate transmit power such that actual output power is constant over
    temperature and frequency. 5 - AIO connected to a PA feedback line. When
    transmitting at high power levels, the voltage on the feedback line of an
    external PA can be excessive if not loaded. If the AIO is being used for
    closed-loop power control (see the description of 3 above) then this line
    will be suitably loaded, however if PA feedback is connected but is not
    used then this setting should be selected. 9 - AIO connected to
    battery(Vbatt) to allow the voltage to be monitored when powering an
    external front-end module.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_ANA_IO_SETTING_ENUM 0x0864

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiExternalFastClockRequest
  PSID          : 2149 (0x0865)
  PER INTERFACE?: NO
  TYPE          : unifiExternalFastClockRequest
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    It is possible to supply UniFi with an external fast reference clock, as
    an alternative to using a crystal. If such a clock is used then it is
    only required when UniFi is active. A signal can be output on PIO[2] or
    if the version of UniFi in use is the UF602x or later, any PIO may be
    used (see unifiExternalFastClockRequestPIO) to indicate when UniFi
    requires a fast clock. Setting this attribute makes this signal become
    active and determines the type of signal output. 0 - No clock request. 1
    - Non inverted, totem pole. 2 - Inverted, totem pole. 3 - Open drain. 4 -
    Open source.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_EXTERNAL_FAST_CLOCK_REQUEST 0x0865

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiWatchdogTimeout
  PSID          : 2152 (0x0868)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : ms
  MIN           : 1
  MAX           : 65535
  DEFAULT       : 1500
  DESCRIPTION   :
    This attribute specifies the maximum time the background may be busy or
    locked out for. If this time is exceeded, UniFi will reset. If this key
    is set to 65535 then the watchdog will be disabled.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_WATCHDOG_TIMEOUT 0x0868

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDeepSleepMaxHostLatency
  PSID          : 2153 (0x0869)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the maximum length of time that UniFi will
    remain in a low power state (deep sleep or shallow sleep) after the host
    has requested a wake-up. UniFi may wake more frequently than this if
    required for other purposes, such as receiving beacons. It may also take
    longer to respond than this value when busy. Larger values reduce power
    consumption by allowing UniFi to stay in low power modes for longer
    periods. Smaller values increase responsiveness by reducing host
    interface latency. Setting this attribute to 0 allows host interface
    activity to wake UniFi. This avoids needing a power-save state machine on
    the host, but typically results in increased power consumption.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DEEP_SLEEP_MAX_HOST_LATENCY 0x0869

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDeepSleepWakeupDelay
  PSID          : 2154 (0x086A)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 65535
  DEFAULT       : 8
  DESCRIPTION   :
    When UniFi wakes from deep sleep there is normally a need for a delay
    between UniFi waking up and the fast clock settling to the correct
    frequency. If UniFi is driving the crystal itself then this delay is the
    time needed for the crystal to settle. If UniFi is configured to use an
    external clock then this is the maximum time that it will take the system
    component that supplies the external clock to produce a stable output.
    This wakeup delay is configured by this MIB entry. The delay should
    include both the time for the crystal or external clock to settle and an
    additional time for the internal PLL to lock. The delay is specified in
    slow clock cycles. The slow clock is nominally 8 kHz giving a period of
    125 microseconds.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DEEP_SLEEP_WAKEUP_DELAY 0x086A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCrystalTrimTemperature
  PSID          : 2155 (0x086B)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : degrees Celsius
  MIN           : -256
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    The temperature of a trim value. This is the temperature that the trim
    value in the same row should be applied. See unifiCrystalTrimTable for a
    full description.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_CRYSTAL_TRIM_TEMPERATURE 0x086B

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCrystalTrimDelta
  PSID          : 2156 (0x086C)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -64
  MAX           : 63
  DEFAULT       :
  DESCRIPTION   :
    The delta for a trim value. This offset should be added to the value of
    unifiCrystalFrequencyTrim when the chip is at the matching temperature.
    See unifiCrystalTrimTable for a full description.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_CRYSTAL_TRIM_DELTA 0x086C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiExternalFastClockRequestPio
  PSID          : 2158 (0x086E)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       : 2
  DESCRIPTION   :
    If an external fast reference clock is being supplied to UniFi as an
    alternative to a crystal (see unifiExternalFastClockRequest) and the
    version of UniFi in use is the UF602x or later, any PIO may be used as
    the external fast clock request output from UniFi. This MIB key
    determines the PIO to use.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_EXTERNAL_FAST_CLOCK_REQUEST_PIO 0x086E

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiTxPowerCompFrequency
  PSID          : 2159 (0x086F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : MHz
  MIN           : 1
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The frequency of a TX power compensation table. This is the frequency
    where the external PA feedback voltage is known from the calibration.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_TX_POWER_COMP_FREQUENCY 0x086F

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiTxPowerCompTemperature
  PSID          : 2160 (0x0870)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : degrees Celsius
  MIN           : -256
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    The temperature of a TX power compensation table. This is the temperature
    where the external PA feedback voltage is known from the calibration.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_TX_POWER_COMP_TEMPERATURE 0x0870

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiTxPowerCompTargetVoltage
  PSID          : 2161 (0x0871)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : %
  MIN           : 1
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The percentage of ( needs input form radio guys ) of a TX power
    compensation table. This is the percentage of ( needs input form radio
    guys ) known from the calibration for the frequency and temperature .
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_TX_POWER_COMP_TARGET_VOLTAGE 0x0871

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdioInterruptPeriod
  PSID          : 2162 (0x0872)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The SDIO host interface can operate in a mode where the period between
    interrupts to the host can be forced to always be greater than a given
    time period. This entry gives the value of that delay. A value of zero
    disables this feature, in this mode the chip will interrupt the host
    whenever it requires attention. This mode (with zero period) should give
    the highest performance with a fast host platform. With a slower host
    platform performance might increase by enforcing a non-zero period for
    this key. Values of the order of 3000 have worked well for some
    customers.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIO_INTERRUPT_PERIOD 0x0872

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdioInterruptResourceLow
  PSID          : 2163 (0x0873)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : TRUE
  DESCRIPTION   :
    If the key unifiSDIOInterruptPeriod is non zero UniFi will interrupt the
    host with a period of a given number of microseconds. If this key is set
    to TRUE UniFi will ignore this period if the chip is running low on
    resources (memory) and interrupt the host anyway.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIO_INTERRUPT_RESOURCE_LOW 0x0873

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiVbattTrimThreshold
  PSID          : 2164 (0x0874)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : mV
  MIN           : 1
  MAX           : 10000
  DEFAULT       : 50
  DESCRIPTION   :
    Defines the change in battery voltage that gives rise to a TX power
    compensation trim.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_VBATT_TRIM_THRESHOLD 0x0874

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiVbattPotDivR1
  PSID          : 2165 (0x0875)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Defines the resistance of R1 (connected to Vbatt) in a potential divider
    connected to the Vbatt AIO. The units are not important as long as they
    are the same as those used for R2. Zero implies there is no potential
    divider.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_VBATT_POT_DIV_R1 0x0875

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiVbattPotDivR2
  PSID          : 2166 (0x0876)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 65535
  DEFAULT       : 1
  DESCRIPTION   :
    Defines the resistance of R2 (connected to ground) in a potential divider
    connected to the Vbatt AIO. The units are not important as long as they
    are the same as those used for R1. Note, when R1 is set to 0 to indicate
    there is no potential divider, the value of R2 does not matter.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_VBATT_POT_DIV_R2 0x0876

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiVbattNumberOfSamples
  PSID          : 2167 (0x0877)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 1000
  DEFAULT       : 5
  DESCRIPTION   :
    Defines the number of readings used for the weighted averaging of battery
    voltage values. The larger the value, the longer the period over which
    the averaging takes place.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_VBATT_NUMBER_OF_SAMPLES 0x0877

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdiothTime1stPacketInterval
  PSID          : 2168 (0x0878)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 1200
  DESCRIPTION   :
    The SDIO host interface can operate between two modes. The normal mode
    (a.k.a. non-bundled mode) will send whatever is available to the host
    straight away; while the special bundled-mode will try to hold the
    packets for some time, in an attempt to send some significant amount of
    data together in one go. Obviously this special mode is useful when in
    high to-host throughput conditions. This parameter is for the
    bundled-mode, and specifies the maximum time interval since the first
    held packet, so that held packets will not expire due to too much delay.
    A zero value will disable the timer functionality completely, i.e. no
    checks on the held packets delay will be done, so that in bundled-mode,
    packets will be sent only on a miss event (see the
    unifiSDIOthHoldNewPacketInterval), if the buffer gets full, or if
    unifiSDIOInterruptResourceLow is set to enabled (non-zero).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIOTH_TIME1ST_PACKET_INTERVAL 0x0878

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdiothHoldNewPacketInterval
  PSID          : 2169 (0x0879)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 1000
  DESCRIPTION   :
    The SDIO host interface can operate between two modes. The normal mode
    (a.k.a. non-bundled mode) will send whatever is available to the host
    straight away; while the special bundled-mode will try to hold the
    packets for some time, in an attempt to send some significant amount of
    data together in one go. Obviously this special mode is useful when in
    high to-host throughput conditions. This parameter is for the
    bundled-mode, and specifies the maximum time interval between packets
    that are being held, so that if the next arriving packet comes later than
    that all held packets will be sent, a miss counter will be increased, and
    the hold cycle starts again. If the continuous miss events reach certain
    threshold, then the bundled-mode is leaved, and the normal mode is
    operated. High values here will avoid leaving the bundled-mode, even when
    low throughput, which could be inefficient. Low values will cause the
    bundled-mode to repeatedly enter and exit when in high throughput, which
    is also inefficient. A zero value will disable the timer functionality
    completely, i.e. no miss events will be counted.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIOTH_HOLD_NEW_PACKET_INTERVAL 0x0879

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdiothSendNewPacketInterval
  PSID          : 2170 (0x087A)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 200
  DESCRIPTION   :
    The SDIO host interface can operate between two modes. The normal mode
    (a.k.a. non-bundled mode) will send whatever is available to the host
    straight away; while the special bundled-mode will try to hold the
    packets for some time, in an attempt to send some significant amount of
    data together in one go. Obviously this special mode is useful when in
    high to-host throughput conditions. This parameter is for the
    non-bundled-mode, and specifies the minimum time interval between packets
    while being sent straight away, so that if the next arriving packet comes
    sooner than that, a meet counter will be increased. If continuous meet
    events reach certain threshold, then the normal mode is leaved and the
    bundled-mode is operated. High values here will avoid entering the
    bundled-mode, even when high throughput, which could be inefficient. Low
    values will cause the bundled-mode to be operated even when low
    throughput, which is also inefficient. A zero value will disable the
    timer functionality completely, i.e. no meet events will be counted.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIOTH_SEND_NEW_PACKET_INTERVAL 0x087A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdiothMissNewPacketThreshold
  PSID          : 2171 (0x087B)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 20
  DESCRIPTION   :
    The SDIO host interface can operate between two modes. The normal mode
    (a.k.a. non-bundled mode) will send whatever is available to the host
    straight away; while the special bundled-mode will try to hold the
    packets for some time, in an attempt to send some significant amount of
    data together in one go. Obviously this special mode is useful when in
    high to-host throughput conditions. This parameter is for the
    bundled-mode, and specifies the count value of inter-packet timeouts in a
    row that will cause a transition to normal mode. It works together with
    unifiSDIOthHoldNewPacketInterval. High values here will delay leaving the
    bundled-mode, but will also filter out spurious inter-packet delays
    better. Low values will cause the bundled-mode to be leaved quicker, but
    will also cause it to be repeatedly leaved and entered when spurious
    inter-packet delays occur.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIOTH_MISS_NEW_PACKET_THRESHOLD 0x087B

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdiothMeetNewPacketThreshold
  PSID          : 2172 (0x087C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 20
  DESCRIPTION   :
    The SDIO host interface can operate between two modes. The normal mode
    (a.k.a. non-bundled mode) will send whatever is available to the host
    straight away; while the special bundled-mode will try to hold the
    packets for some time, in an attempt to send some significant amount of
    data together in one go. Obviously this special mode is useful when in
    high to-host throughput conditions. This parameter is for the
    non-bundled-mode, and specifies the count value of inter-packet in-time
    events in a row that will cause a transition to bundled-mode. It works
    together with unifiSDIOthSendNewPacketInterval. High values here will
    delay entering the bundled-mode, but will also filter out short burst of
    packets with low inter-packet delay. Low values will cause the
    bundled-mode to be entered quicker, but will also cause it to be
    repeatedly entered and leaved when short bursts of packets with low
    inter-packet delays occur.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIOTH_MEET_NEW_PACKET_THRESHOLD 0x087C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSdiothPushedClearSlotsHoldPercent
  PSID          : 2173 (0x087D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : %
  MIN           : 0
  MAX           : 100
  DEFAULT       :
  DESCRIPTION   :
    The SDIO host interface allows the host to push packets into the firmware
    before the firmware has a chance to decide if it wants these or not. As
    the firmware will make that decision when the packets are already in the
    chip, it has to send clear-slot commands for the pushed packets
    afterwards. In non-bundle mode, these clear-slot commands will occur at
    the firmware own pace for from-host signal processing, which will be
    sporadic, but continuous enough as to have a buzz of two or three
    commands per HIP cycle into the host. Those frequent HIP interrupts into
    the host could cause the host to increase the CPU load required to attend
    the HIP. This parameter aims to reduce the frequency with which the
    firmware tells the host to reuse pushed slots by holding on to those
    clear-slot commands in the firmware until either, there are more
    pending-to-clear slots than the percentage indicated by this parameter,
    or any other packet has to be sent to the host anyway.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SDIOTH_PUSHED_CLEAR_SLOTS_HOLD_PERCENT 0x087D

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRssi
  PSID          : 2200 (0x0898)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -32768
  MAX           : 32767
  DEFAULT       :
  DESCRIPTION   :
    This attribute provides a running average of the Received Signal Strength
    Indication (RSSI) for packets received by UniFi&apos;s radio. The value
    should only be treated as an indication of the signal strength; it is not
    an accurate measurement. The result is only meaningful if the
    unifiRSSIOffset attribute is set to the correct calibration value. If
    UniFi is part of a BSS, only frames originating from devices in the BSS
    are reported (so far as this can be determined). The average is reset
    when UniFi joins or starts a BSS or is reset.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RSSI 0x0898

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRssiOffset
  PSID          : 2201 (0x0899)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -32768
  MAX           : 32767
  DEFAULT       :
  DESCRIPTION   :
    This attribute provides a calibration factor to convert the signal
    strength measurements made by UniFi&apos;s radio into absolute power
    levels. It specifies the offset that is added to the raw radio
    measurement to give the value reported by unifiRSSI. This value should be
    set appropriately for each module design, and possibly for each device.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RSSI_OFFSET 0x0899

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSnr
  PSID          : 2202 (0x089A)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -32768
  MAX           : 32767
  DEFAULT       :
  DESCRIPTION   :
    This attribute provides a running average of the Signal to Noise Ratio
    (SNR) for packets received by UniFi&apos;s radio. If the dual receive
    chain is enabled then the average SNR for both antennas is used.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SNR 0x089A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRxRetryCount
  PSID          : 2203 (0x089B)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This is a counter that increments whenever an MPDU is successfully
    received that has the retry bit set in the frame control field,
    indicating that the MPDU is a retransmission of a unicast frame.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RX_RETRY_COUNT 0x089B

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRateStatsRxSuccessCount
  PSID          : 2206 (0x089E)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The number of successful receptions of complete management and data
    frames at the rate indexed by unifiRateStatsIndex. This number will wrap
    to zero after the range is exceeded.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RATE_STATS_RX_SUCCESS_COUNT 0x089E

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRateStatsTxSuccessCount
  PSID          : 2207 (0x089F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The number of successful (acknowledged) unicast transmissions of complete
    data or management frames the rate indexed by unifiRateStatsIndex. This
    number will wrap to zero after the range is exceeded.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RATE_STATS_TX_SUCCESS_COUNT 0x089F

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiSnrExtraOffsetCck
  PSID          : 2209 (0x08A1)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -32768
  MAX           : 32767
  DEFAULT       : 15
  DESCRIPTION   :
    This offset is added to SNR values received at 802.11b data rates. This
    accounts for differences in the RF pathway between 802.11b and 802.11g
    demodulators. The offset applies to values of unifiSNR as well as SNR
    values in scan and sniff indications. This attribute is not used in
    802.11a mode.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SNR_EXTRA_OFFSET_CCK 0x08A1

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRssiMaxAveragingPeriod
  PSID          : 2210 (0x08A2)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : TU
  MIN           : 1
  MAX           : 65535
  DEFAULT       : 1024
  DESCRIPTION   :
    This attribute limits the period over which the value of unifiRSSI is
    averaged. If no more than unifiRSSIMinReceivedFrames frames have been
    received in the period, then the value of unifiRSSI is reset to the value
    of the next measurement and the rolling average is restarted. This
    ensures that the value is timely (although possibly poorly averaged) when
    little data is being received.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RSSI_MAX_AVERAGING_PERIOD 0x08A2

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRssiMinReceivedFrames
  PSID          : 2211 (0x08A3)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 65535
  DEFAULT       : 50
  DESCRIPTION   :
    See the description of unifiRSSIMaxAveragingPeriod for how the
    combination of attributes is used.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RSSI_MIN_RECEIVED_FRAMES 0x08A3

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRateStatsRate
  PSID          : 2212 (0x08A4)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : 500 kbps
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    The rate corresponding to the current table entry. The value is rounded
    to the nearest number of units where necessary. Most rates do not require
    rounding, but when short guard interval is in effect the rates are no
    longer multiples of the base unit. Note that there may be two occurrences
    of the value 130: the first corresponds to MCS index 7, and the second,
    if present, to MCS index 6 with short guard interval.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RATE_STATS_RATE 0x08A4

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiBeaconsMissed
  PSID          : 2213 (0x08A5)
  PER INTERFACE?: NO
  TYPE          : INT64
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    This is a counter that increments whenever UniFi attempts to receive a
    beacon from a BSS but fails to receive a beacon with a correct frame
    check sequence. On an IBSS this is normal behaviour owing to the
    distributed beacon responsibility. Note this does not increment for
    beacons that UniFi did not attempt to receive, for example beacons
    skipped in power save because of a non-zero listen interval.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_BEACONS_MISSED 0x08A5

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDiscardedFrameCount
  PSID          : 2214 (0x08A6)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    This is a counter that indicates the number of data and management frames
    that have been processed by the UniFi hardware but were discarded before
    being processed by the firmware. It does not include frames not processed
    by the hardware because they were not addressed to the local device, nor
    does it include frames discarded by the firmware in the course of normal
    MAC processing (which include, for example, frames in an appropriate
    encryption state and multicast frames not requested by the host).
    Typically this counter indicates lost data frames for which there was no
    buffer space; however, other cases may cause the counter to increment,
    such as receiving a retransmitted frame that was already successfully
    processed. Hence this counter should not be treated as a reliable guide
    to lost frames. The counter wraps to 0 after 65535.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DISCARDED_FRAME_COUNT 0x08A6

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiTxPowerAdjustment
  PSID          : 2280 (0x08E8)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -128
  MAX           : 127
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_TX_POWER_ADJUSTMENT 0x08E8

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDigitalOfdmTxGain
  PSID          : 2290 (0x08F2)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 3
  DEFAULT       : 2
  DESCRIPTION   :
    This attribute controls the gain of the output of the interpolation
    filter in the OFDM signal path. The possible values are: 0 - 0 dB. 1 - 2
    dB. 2 - 6 dB. 3 - 8 dB. This MIB entry should only be altered after
    advice from CSR Applications Support.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DIGITAL_OFDM_TX_GAIN 0x08F2

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexScheme
  PSID          : 2300 (0x08FC)
  PER INTERFACE?: NO
  TYPE          : unifiCoexScheme
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    UniFi supports a variety of hardware signalling schemes to support
    coexistence with Bluetooth radios. This attribute selects the general
    class of scheme to use. The possible values are: 0 - Coexistence
    signalling disabled. 3 - PTA. On platforms where UniFi has its own
    exclusive antenna (unifiFrontEndControlMutualExclusion = 0x00), CDL
    arbitration is turned ON only when a collocated transceiver activity
    needs to be protected using MLME-ADD-BLACKOUT.req. This attribute may be
    dynamically changed by the host while UniFi is operating. This allows
    coexistence signalling to be disabled if the collocated Bluetooth radio
    has been de-powered. This attribute is not reset by an
    MLME-RESET.request. Not all chips support all of these values.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_SCHEME 0x08FC

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFrontEndControlConfigString
  PSID          : 2320 (0x0910)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 20
  MAX           : 20
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FRONT_END_CONTROL_CONFIG_STRING 0x0910

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFrontEndControlConfigSelect
  PSID          : 2321 (0x0911)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 1
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    This attribute selects a row from the table of
    unifiFrontEndControlConfigString values and applies the requested
    configuration.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FRONT_END_CONTROL_CONFIG_SELECT 0x0911

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFrontEndControlMutualExclusion
  PSID          : 2322 (0x0912)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FRONT_END_CONTROL_MUTUAL_EXCLUSION 0x0912

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTxPowerAioPowerDetectTarget
  PSID          : 2350 (0x092E)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 1023
  DEFAULT       :
  DESCRIPTION   :
    This entry controls whether output power servoing is used for this power
    level. Setting this attribute to zero disables servoing for this power
    level. A non-zero value gives the target level to read from the AIO pin
    to achieve the required output power level. This MIB entry should only be
    altered after advice from CSR Applications Support.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TX_POWER_AIO_POWER_DETECT_TARGET 0x092E

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTxPowerAioDriveLevel
  PSID          : 2351 (0x092F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    UniFi has digital to analogue converters, the output of which can be
    driven through AIO pins to control the bias of an external power
    amplifier (PA). This MIB attribute sets the voltage that is driven on any
    AIO assigned to function external-pa-bias-2g4 or external-pa-bias-5g
    (depending on the band of this power table entry) using the
    unifiAnaIOSettingTable when UniFi is transmitting. The output voltage is
    referenced to the internal bandgap reference voltage, and is nominally:
    3.0 V * (unifiDfyTxPowerAIODriveLevel / 256). This MIB entry should only
    be altered after advice from CSR Applications Support.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TX_POWER_AIO_DRIVE_LEVEL 0x092F

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTxPowerPredistortScale
  PSID          : 2352 (0x0930)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 1489
  DEFAULT       :
  DESCRIPTION   :
    This is the scaling for the transmit pre-distort table. It is stored as a
    fixed-point number with 10 bits to the right of the binary point, i.e. a
    value of 1024 corresponds to a scale factor of 1.0 = no scaling. A value
    of zero disables use of the predistort table for this power level. This
    MIB entry should only be altered after advice from CSR Applications
    Support.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TX_POWER_PREDISTORT_SCALE 0x0930

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTxPowerInternalPaBias
  PSID          : 2353 (0x0931)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 63
  DEFAULT       :
  DESCRIPTION   :
    This entry within the transmit power table controls the bias of the
    UF603x internal power amplifier (PA). This MIB entry should only be
    altered after advice from CSR Applications Support.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TX_POWER_INTERNAL_PA_BIAS 0x0931

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTxPowerInternalPaGain
  PSID          : 2354 (0x0932)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       :
  DESCRIPTION   :
    This entry within the transmit power table controls the gain of the
    UF603x internal power amplifier (PA). The step size is nominally 3 dB.
    This MIB entry should only be altered after advice from CSR Applications
    Support.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TX_POWER_INTERNAL_PA_GAIN 0x0932

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTxPowerMixerBias
  PSID          : 2355 (0x0933)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       :
  DESCRIPTION   :
    This entry within the transmit power table controls the bias of the
    UF603x transmit mixer. This MIB entry should only be altered after advice
    from CSR Applications Support.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TX_POWER_MIXER_BIAS 0x0933

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexUartBaudRate
  PSID          : 2420 (0x0974)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 189
  DESCRIPTION   :
    This attribute specifies the baud rate for the coexistence UART which is
    used when unifiCoexScheme is set to 4. The value provided is added to a
    16-bit counter on each cycle of a 40 MHz clock. The bit clock for the
    UART is then given by the most significant bit of this register. Hence
    the relationship between this attribute and the actual baud rate is: baud
    rate = unifiCoexUARTBaudRate * (40e6 / 2^16)
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_UART_BAUD_RATE 0x0974

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexUartTxPio
  PSID          : 2421 (0x0975)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -1
  MAX           : 15
  DEFAULT       : -1
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_UART_TX_PIO 0x0975

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexUartRxPio
  PSID          : 2422 (0x0976)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -1
  MAX           : 7
  DEFAULT       : -1
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_UART_RX_PIO 0x0976

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexCdlConfig
  PSID          : 2424 (0x0978)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 17
  MAX           : 17
  DEFAULT       : { 0X0A, 0X08, 0X06, 0XFF, 0XFF, 0XFF, 0X00, 0X00, 0X01, 0X02, 0X03, 0XFF, 0XF0, 0XFF, 0XF0, 0XFF, 0XF0 }
  DESCRIPTION   :
    This MIB entry is only valid for the UF602x family of chips. These
    contain the spectral thresholds corresponding to the absolute difference
    between channel values: octet 0 -
    collision_table.spectral_threshs.thresh_2 octet 1 -
    collision_table.spectral_threshs.thresh_1 octet 2 -
    collision_table.spectral_threshs.thresh_0 These correspond to the TX and
    RX collision table settings: octet 3 - collision_table.local_tx_col_table
    (lsb) octet 4 - collision_table.local_tx_col_table (msb) octet 5 -
    collision_table.local_rx_col_table (lsb) octet 6 -
    collision_table.local_rx_col_table (msb) These contain settings of the
    priority difference thresholding: octet 7 -
    priority_difference_table.thresh_neg octet 8 -
    priority_difference_table.thresh_0 octet 9 -
    priority_difference_table.thresh_1 octet 10 -
    priority_difference_table.thresh_2 And finally the following describes
    the action tables octet 11 - action_table.abort_table (lsb) octet 12 -
    action_table.abort_table (msb) octet 13 - action_table.lcl_table_1 (lsb)
    octet 14 - action_table.lcl_table_1 (msb) octet 15 -
    action_table.lcl_table_2 (lsb) octet 16 - action_table.lcl_table_2 (msb)
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_CDL_CONFIG 0x0978

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexTransmitPriorityLevels
  PSID          : 2426 (0x097A)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 30
  MAX           : 30
  DEFAULT       : { 0X88, 0X17, 0X88, 0X17, 0X88, 0X17, 0X88, 0X17, 0X8A, 0X17, 0X88, 0X17, 0X8A, 0X17, 0X88, 0X17, 0X8A, 0X17, 0X88, 0X10, 0X8A, 0X10, 0X88, 0X10, 0X8A, 0X10, 0X00, 0X00, 0X00, 0X00}
  DESCRIPTION   :
    This attribute controls the coexistence priorities used for WLAN transmit
    activity on UF602x ICs. The format of the attribute is an octet string
    where each consecutive pair of octets describes the attributes for a
    given radio activity or state. The first octet describes priority that
    should be used for a given radio activity or state, and the second octet
    describing the activity mask for the WLAN activity. The octets in the
    string are assigned as follows: 0 Priority of transmission of a data
    frame in AC_BK. 1 Activity bitmask for the transmission of a data frame
    in AC_BK. 2 Priority of transmission of a data frame in AC_BE. 3 Activity
    bitmask for the transmission of a data frame in AC_BE. 4 Priority of
    transmission of a data frame in AC_VI. 5 Activity bitmask for the
    transmission of data frame in AC_VI. 6 Priority of transmission of a data
    frame in AC_VO. 7 Activity bitmask for the transmission of data frame in
    AC_VO. 8 Priority of transmission of a high priority data frame. 9
    Activity bitmask for the transmission of a high priority data frame. 10
    Priority of transmission of a management frame. 11 Activity bitmask for
    transmission of management frame. 12 Priority of transmission of a high
    priority management frame. 13 Activity bitmask for transmission of high
    priority management frame. 14 Priority of transmission of a control
    frame. 15 Activity bitmask for transmission of a control frame. 16
    Priority of transmission of a high priority control frame. 17 Activity
    bitmask for transmission of a high priority control frame. 18 Priority of
    transmission of a broadcast or multicast frame (non-Beacon). 19 Activity
    bitmask for transmission of a broadcast or multicast frame (non-Beacon).
    20 Priority of transmission of a high priority broadcast or multicast
    frame (non-Beacon). 21 Activity bitmask for transmission of a high
    priority broadcast or multicast frame (non-Beacon). 22 Priority of
    transmission of a Beacon frame. 23 Activity bitmask for transmission of a
    beacon frame. 24 Priority of transmission of a high priority Beacon
    frame. 25 Activity bitmask for transmission of a high priority beacon
    frame. 26 Reserved for future use. 27 Activity bitmask for future use. 28
    Reserved for future use. 29 Activity bitmask for future use. The first
    octet contains the priority level for the occurrence of a WLAN transmit
    activity: In the occurrence of the WLAN transmit activity, priority of
    the activity may be fixed, or can take the form of a random distribution
    generated by UniFi for each consecutive occurrence of the same WLAN
    transmit activity. This is described below: In an octet there are three
    parameters, Base[0..3], Offset[4..6], Enabled[7]. Enabled[7] specifies if
    protection for an activity is: + Enabled (1) + Disabled (0) Offset[4..6]
    and Base[0..3] specify if WLAN activity priority is either: + Generated
    from a random distribution with a: + Minimum value (Base[0..3]) + Maximum
    value (Offset[4..6] + Base[0..3]) NOTE: The maximum allowed value of Base
    in the random distribution is 8. + Fixed + Base[0..3]. In this case the
    Offset [4..6] should be set to 0 NOTE: Priorities will saturate at the
    bounds of the priority range 0 and 15. All transmit activities must have
    the priority level always enabled. The second octet configures the
    activity bitmask for a transmit activity: bit 0: Receive active. bit 1:
    Receiving a packet. bit 2: Receive acknowledgement of a transmitted
    packet. bit 3: Transmitting acknowledgement of a received packet. bit 4:
    Transmission of a packet. bits 5 to 7: Reserved (must be set to zeros).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_TRANSMIT_PRIORITY_LEVELS 0x097A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexReceivePriorityLevels
  PSID          : 2427 (0x097B)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 14
  MAX           : 14
  DEFAULT       : { 0X88, 0X03, 0X8A, 0X03, 0X88, 0X03, 0X88, 0X03, 0X88, 0X0B, 0X00, 0X00, 0X00, 0X00}
  DESCRIPTION   :
    This attribute controls the coexistence priorities used for WLAN receive
    activity on UF602x ICs. The format of the attribute is an octet string
    where each consecutive pair of octets describes the attributes for a
    given radio activity or state. The first octet describes priority that
    should be used for a given radio activity or state, and the second octet
    describing the activity mask for the WLAN activity. The octets in the
    string are assigned as follows: 0 Priority of reception of a Beacon
    frame. 1 Activity bitmask for the reception of a Beacon frame. 2 High
    priority of reception of a Beacon frame. 3 Activity bitmask for the high
    priority reception of a Beacon frame. 4 Priority of passive scan. 5
    Activity bitmask for the passive scan. 6 Priority of broadcast or
    multicast traffic expected. 7 Activity bitmask for the Broadcast or
    multicast traffic expected. 8 Priority of ATIM window in IBSS. 9 Activity
    bitmask for the ATIM window in IBSS. 10 Reserved for future use. 11
    Activity bitmask for future use. 12 Reserved for future use. 13 Activity
    bitmask for future use. In the occurrence of the WLAN receive activity,
    priority of the activity may be fixed, or can take the form of a random
    distribution generated by UniFi for each consecutive occurrence of the
    same WLAN receive activity. This is described below: In an octet there
    are three parameters, Base[0..3], Offset[4..6], Enabled[7]. Enabled[7]
    specifies if protection for an activity is: + Enabled (1) + Disabled (0)
    Offset[4..6] and Base[0..3] specify if WLAN activity priority is either:
    + Generated from a random distribution with a: + Minimum value
    (Base[0..3]) + Maximum value (Offset[4..6] + Base[0..3]) NOTE: The
    maximum allowed value of Base in the random distribution is 8. + Fixed +
    Base[0..3]. In this case the Offset [4..6] should be set to 0 NOTE:
    Priorities will saturate at the bounds of the priority range 0 and 15.
    The second octet configures the activity bitmask for a receive activity:
    bit 0: Receive active. bit 1: Receiving a packet. bit 2: Receive
    acknowledgement of a transmitted packet. bit 3: Transmitting
    acknowledgement of a received packet. bit 4: Transmission of a packet.
    bits 5 to 7: Reserved (must be set to zeros).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_RECEIVE_PRIORITY_LEVELS  0x097B

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexTransactionPriorityLevels
  PSID          : 2428 (0x097C)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 24
  MAX           : 24
  DEFAULT       : { 0X88, 0X13, 0X88, 0X1F, 0X88, 0X1F, 0X88, 0X1F, 0X88, 0X15, 0X88, 0X1F, 0X88, 0X17, 0X88, 0X1F, 0X88, 0X1F, 0X88, 0X1F, 0X00, 0X00, 0X00, 0X00}
  DESCRIPTION   :
    This attribute controls the coexistence priorities used for WLAN
    transaction activity on UF602x ICs. The format of the attribute is an
    octet string where each consecutive pair of octets describes the
    attributes for a given radio activity or state. The first octet describes
    priority that should be used for a given radio activity or state, and the
    second octet describing the activity mask for the WLAN activity. The
    octets in the string are assigned as follows: 0 Priority of active scan.
    1 Activity bitmask for the Active scan. 2 Priority of connection setup in
    progress. 3 Activity bitmask for the connection setup in progress. NOTE:
    The protection of the above activity is currently not supported. 4
    Priority of security key exchange in progress. 5 Activity bitmask for the
    security key exchange in progress. NOTE: The protection of the above
    activity is currently not supported. 6 Priority of IP setup in progress.
    7 Activity bitmask for the IP setup in progress. NOTE: The protection of
    the above activity is currently not supported. 8 Priority of VIF switch
    phase. 9 Activity bitmask for the VIF de-scheduling phase. 10 Priority of
    PS-Poll exchange in progress. 11 Activity bitmask for the PS-poll
    exchange. 12 Priority of power management mode in progress. 13 Activity
    bitmask for the Power management mode in progress. 14 Priority of U-APSD
    down-link triggered. 15 Activity bitmask for the U-APSD down-link
    triggered. 16 Priority of CTWindow phase. 17 Activity bitmask for the
    CTWindow phase. 18 Generic higher layer protocol activity. 19 Activity
    bitmask for the higher layer activity. NOTE: The above activity is
    protected when the Host sets a non-zero value in the Min_VIF_Duration
    field of the MA-PACKET.request. The activity is unprotected either when
    the Host sets the above field to zero in the next MA-PACKET.request or
    when the Host issues a MLME-CANCEL-VIF-TIME.request. 20 Reserved for
    future use. 21 Reserved for future use. 22 Reserved for future use. 23
    Reserved for future use. In the occurrence of the WLAN transaction
    activity, priority of the activity may be fixed, or can take the form of
    a random distribution generated by UniFi for each consecutive occurrence
    of the same WLAN transaction activity. This is described below: In an
    octet there are three parameters, Base[0..3], Offset[4..6], Enabled[7].
    Enabled[7] specifies if protection for an activity is: + Enabled (1) +
    Disabled (0) Offset[4..6] and Base[0..3] specify if WLAN activity
    priority is either: + Generated from a random distribution with a: +
    Minimum value (Base[0..3]) + Maximum value (Offset[4..6] + Base[0..3])
    NOTE: The maximum allowed value of Base in the random distribution is 8.
    + Fixed + Base[0..3]. In this case the Offset [4..6] should be set to 0
    NOTE: Priorities will saturate at the bounds of the priority range 0 and
    15. The second octet configures the activity bitmask for a transaction
    activity: bit 0: Receive active. bit 1: Receiving a packet. bit 2:
    Receive acknowledgement of a transmitted packet. bit 3: Transmitting
    acknowledgement of a received packet. bit 4: Transmission of a packet.
    bits 5 to 7: Reserved (must be set to zeros).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_TRANSACTION_PRIORITY_LEVELS  0x097C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPeriodicBlackoutProtect
  PSID          : 2429 (0x097D)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 3
  MAX           : 3
  DEFAULT       : { 0X00, 0X60, 0X06 }
  DESCRIPTION   :
    This attribute specifies the level of protection required in the UniFi
    hardware during different coexistence blackout requests issued via
    MLME-ADD-BLACKOUT.request. The format of the attribute is an octet string
    where each nibble describes the level of blackout protection required for
    a given blackout source field in the MLME-ADD-BLACKOUT.request. The
    nibbles in the octet string are assigned as follows: 0 Dot11_Local
    Blackout Source in MLME-ADD-BLACKOUT.request. 1 Dot11_Remote Blackout
    Source in MLME-ADD-BLACKOUT.request. 2 Not_Linked Blackout Source in
    MLME-ADD-BLACKOUT.request. 3 Other_Radio Blackout Source with blackout
    duration equal to 1.5 ms in MLME-ADD-BLACKOUT.request. This blackout add
    request is issued during a Bluetooth SCO coexistence. 4 Other_Radio
    Blackout Source with blackout duration greater than 1.5 ms in
    MLME-ADD-BLACKOUT.request. This blackout add request is issued during a
    Bluetooth E-SCO coexistence. 5 Reserved for future use. In a nibble there
    are two parameters with the following bit positions: Blackout phase
    protection [0..1] Non-blackout phase protection [2..3] The available
    options for the blackout phase protection are as follows: 0
    (no-hardware-protection) - No special hardware protection required in the
    UniFi during the blackout duration. The CDL arbitration will decide
    whether the UniFi or the collocated transceiver will get the control of
    the front-end module. 1 (wlan-loses-coex-arbitration) - WLAN will
    unconditionally defer to collocated transceiver activity during the
    blackout duration. The front-end control is configured such that the WLAN
    loses the arbitration when the collocated transceiver is active. NOTE:
    This above setting should not be used as it completely stops WLAN receive
    during long blackouts. 2 (wlan-deferred-during-blackout) - WLAN will
    defer all of its activities during the blackout duration. NOTE: The above
    setting should be only used for Blackout protection during (e)SCO
    coexistence. The available options for the non-blackout phase protection
    are as follows: 0 (no-hardware-protection) - The CDL arbitration will
    decide whether the WLAN or the collocated transceiver will get the
    control of the front-end module when the periodic blackout is still
    active. 1 (wlan-wins-coex-arbitration) - WLAN will win the CDL
    arbitration during the non-blackout phase when the periodic blackout is
    still active. 2 (wlan-always-wins) - WLAN will get control of the
    front-end module during the non-blackout phase when the periodic blackout
    is still active. The nibbles are ordered in the following way: octet 0 :
    nibble 1 in the MS position, and nibble 0 in the LS position. octet 1 :
    nibble 3 in the MS position, and nibble 2 in the LS position. octet 2 :
    nibble 5 in the MS position, and nibble 4 in the LS position.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PERIODIC_BLACKOUT_PROTECT  0x097D

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTransmitPowerCompensationFrequency
  PSID          : 2440 (0x0988)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : MHz
  MIN           : 2400
  MAX           : 6000
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies a frequency at which transmit power calibration
    has been performed and for which adjustments to the base AIO power detect
    feedback target used in closed loop power control are defined in
    unifiDfyTransmitPowerCompensationTable for the same
    unifiDfyTransmitPowerCompensationFrequencyIndex and for all temperatures
    specified in the unifiDfyTransmitPowerCompensationTemperatureTable. This
    attribute is write-only before the first MLME-RESET.request, and is
    subsequently not accessible.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TRANSMIT_POWER_COMPENSATION_FREQUENCY 0x0988

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTransmitPowerCompensationTemperature
  PSID          : 2441 (0x0989)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : degrees Celsius
  MIN           : -256
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies a temperature at which transmit power
    calibration has been performed and for which adjustments to the base AIO
    power detect feedback target used in closed loop power control are
    defined in unifiDfyTransmitPowerCompensationTable for the same
    unifiDfyTransmitPowerCompensationTemperatureIndex and for all frequencies
    specified in the unifiDfyTransmitPowerCompensationFrequencyTable. This
    attribute is write-only before the first MLME-RESET.request, and is
    subsequently not accessible.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TRANSMIT_POWER_COMPENSATION_TEMPERATURE 0x0989

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyTransmitPowerCompensationTargetAdjustment
  PSID          : 2442 (0x098A)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : %
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies an element within the
    unifiDfyTransmitPowerCompensationTable which defines, for a given
    combination of band, frequency (index into
    unifiDfyTransmitPowerCompensationFrequencyTable), and temperature (index
    into unifiDfyTransmitPowerCompensationTemperatureTable), the adjustment
    to be applied to the base AIO power detect feedback target that is
    specified in the power table and used in closed loop power control. The
    adjustment is specified in units of a percentage of the base AIO target
    value. This attribute is write-only before the first MLME-RESET.request,
    and is subsequently not accessible.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_TRANSMIT_POWER_COMPENSATION_TARGET_ADJUSTMENT 0x098A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyVbattTransmitPowerCompensationVbatt
  PSID          : 2443 (0x098B)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : mV
  MIN           : 0
  MAX           : 10000
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies a voltage at which transmit power calibration
    has been performed and for which adjustments to the base AIO power detect
    feedback target used in closed loop power control are defined in
    unifiDfyVbattTransmitPowerCompensationTable for the same
    unifiDfyVbattTransmitPowerCompensationVbattIndex. This attribute is
    write-only before the first MLME-RESET.request, and is subsequently not
    accessible.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_VBATT_TRANSMIT_POWER_COMPENSATION_VBATT 0x098B

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyVbattTransmitPowerCompensationTargetAdjustment
  PSID          : 2444 (0x098C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : %
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies an element within the
    unifiDfyVbattTransmitPowerCompensationTable which defines, for a given
    band, Tx gain setting (unifiDfyVbattTransmitPowerCompensationTxGainIndex)
    and voltage (index into unifiDfyVbattTransmitPowerCompensationVbattTable,
    the adjustment to be applied to the base AIO power detect feedback target
    that is specified in the power table and used in closed loop power
    control. The adjustment is specified in units of a percentage of the base
    AIO target value. This attribute is write-only before the first
    MLME-RESET.request, and is subsequently not accessible.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_VBATT_TRANSMIT_POWER_COMPENSATION_TARGET_ADJUSTMENT 0x098C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDfyVbattTransmitPowerCompensationTxGain
  PSID          : 2445 (0x098D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the Tx gain value at which transmit power
    calibration has been performed and for which adjustments to the base AIO
    power detect feedback target used in closed loop power control are
    defined in unifiDfyVbattTransmitPowerCompensationTable for the same
    unifiDfyVbattTransmitPowerCompensationTxGainIndex. This attribute is
    write-only before the first MLME-RESET.request, and is subsequently not
    accessible.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DFY_VBATT_TRANSMIT_POWER_COMPENSATION_TX_GAIN 0x098D

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFastPowerSaveTimeout
  PSID          : 2500 (0x09C4)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 1000000
  DESCRIPTION   :
    UniFi implements a proprietary power management mode called Fast Power
    Save that balances network performance against power consumption. In this
    mode UniFi delays entering power save mode until it detects that there
    has been no exchange of data for the duration specified by this
    attribute.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FAST_POWER_SAVE_TIMEOUT 0x09C4

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFixMaxTxDataRate
  PSID          : 2510 (0x09CE)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FIX_MAX_TX_DATA_RATE 0x09CE

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPowerSaveExtraListenTime
  PSID          : 2512 (0x09D0)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 1000
  DESCRIPTION   :
    This attribute specifies an extra time during which UniFi will listen to
    transmissions in Power Save or Fast Power Save after transmission or
    reception of unicast frames and before returning to sleep. This ensures
    that the peer device has no further information to transmit, such as a
    retry of a frame from an access point with the More Data flag clear. This
    attribute may be set to zero, in which case UniFi will not stay awake for
    any extra period. As the extra listen time has implications for power
    saving, it is only applied when the device has not applied it and has not
    been in active mode within the last unifiPowerSaveExtraListenDelay
    microseconds. Changes to this attribute take effect when starting or
    joining a new BSS.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_POWER_SAVE_EXTRA_LISTEN_TIME 0x09D0

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPowerSaveExtraListenDelay
  PSID          : 2513 (0x09D1)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 1000000
  DESCRIPTION   :
    A timeout used after the logic described for
    unifiPowerSaveExtraListenTime has been applied during which it will not
    be applied again. This attribute should not be set to zero if
    unifiPowerSaveExtraListenTime is non-zero since UniFi will then be kept
    awake permanently. Changes to this attribute take effect when starting or
    joining a new BSS.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_POWER_SAVE_EXTRA_LISTEN_DELAY 0x09D1

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPowerManagementDelayTimeout
  PSID          : 2514 (0x09D2)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 10000
  DESCRIPTION   :
    When UniFi enters power save mode it signals the new state by setting the
    power management bit in the frame control field of a NULL frame. It then
    remains active for the period since the previous unicast reception, or
    since the transmission of the NULL frame, whichever is later, given by
    this attribute. This allows any buffered data on a remote device to be
    cleared. Changes to this attribute take effect when starting or joining a
    new BSS.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_POWER_MANAGEMENT_DELAY_TIMEOUT 0x09D2

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiApsdServicePeriodTimeout
  PSID          : 2515 (0x09D3)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : microseconds
  MIN           : 0
  MAX           : 2147483647
  DEFAULT       : 10000
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_APSD_SERVICE_PERIOD_TIMEOUT 0x09D3

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiAmpduMinAggregation
  PSID          : 2517 (0x09D5)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 3
  DESCRIPTION   :
    In UniFi hardware that supports the IEEE 802.11n Specification (High
    Throughput extensions), frames may be aggregated into a single
    transmission at the physical layer. If this attribute is greater than
    one, it specifies the minimum number of frames that are desired in each
    aggregated transmission. This is used to make more efficient use of the
    available bandwidth; the impact on the data rate is negligible. See also
    unifiAMPDUMaxDelay.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_AMPDU_MIN_AGGREGATION 0x09D5

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiAmpduMaxDelay
  PSID          : 2518 (0x09D6)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 2000
  DESCRIPTION   :
    This attribute is used in conjunction with unifiAMPDUMinAggregation. If
    the desired number of frames for an aggregation is not reached within
    unifiAMPDUMaxDelay microseconds of the point at which the first frame is
    available to be transmitted then any frames currently available are
    queued for transmission anyway. This provides a bound on the latency
    imposed by the mechanism. Note that the frame or frames will still be
    sent in the aggregated format.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_AMPDU_MAX_DELAY 0x09D6

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiKeepAlivePeriod
  PSID          : 2520 (0x09D8)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : s
  MIN           : 0
  MAX           : 2147
  DEFAULT       :
  DESCRIPTION   :
    This variable specifies the interval between sending keep-alive (Null
    frame) packets while associated to an access point during periods of
    idleness (i.e. when there is no unicast transmit or receive activity).
    Set to zero to disable keep-alive packets.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_KEEP_ALIVE_PERIOD 0x09D8

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRadioCalibrationMode
  PSID          : 2521 (0x09D9)
  PER INTERFACE?: NO
  TYPE          : unifiRadioCalibrationMode
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute is used to control the radio calibration operations
    performed by UniFi. If this key is left in the &apos;calibrate-auto&apos;
    state then the firmware will perform radio calibrations whenever they are
    required. In this mode a calibration is always performed after the first
    MLME-RESET - this calibration is required to enable the radio. This key
    can be set to the &apos;calibrate-now&apos; value to hint to the firmware
    that a calibration should be performed now. This can be useful if the
    host software knows that the radio has not been used for some time, but
    that it is about to be used. If this key is set to the
    &apos;no-calibrate&apos; setting then no radio calibrations will be
    performed by the firmware until it is commanded to (by setting the key to
    either &apos;calibrate-auto&apos; or &apos;calibrate-now&apos;. If this
    key is set to this state before the first MLME-RESET then the radio will
    not be able to be used. The &apos;no-calibrate&apos; mode will allow the
    fastest booting and will ensure that no RF power is emitted from the
    device. In this mode the radio will not work, even for receive.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RADIO_CALIBRATION_MODE 0x09D9

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiFragmentationDuration
  PSID          : 2524 (0x09DC)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    A limit on transmission time for a data frame. If the data payload would
    take longer than unifiFragmentationDuration to transmit, UniFi will
    attempt to fragment the frame to ensure that the data portion of each
    fragment is within the limit. The limit imposed by the fragmentation
    threshold is also respected, and no more than 16 fragments may be
    generated. If the value is zero no limit is imposed. The value may be
    changed dynamically during connections. Note that the limit is a
    guideline and may not always be respected. In particular, the data rate
    is finalised after fragmentation in order to ensure responsiveness to
    conditions, the calculation is not performed to high accuracy, and octets
    added during encryption are not included in the duration calculation.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_FRAGMENTATION_DURATION 0x09DC

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiNoLateAckWorkaround
  PSID          : 2526 (0x09DE)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    Testing has revealed that some non-CSR implementations of the IEEE 802.11
    Standard send response frames such as acknowledgement and clear-to-send
    later than allowed by the standard. If this attribute is FALSE, UniFi
    implements a workaround. If it is TRUE, the workaround is not used.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_NO_LATE_ACK_WORKAROUND 0x09DE

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMulticastRxMode
  PSID          : 2528 (0x09E0)
  PER INTERFACE?: NO
  TYPE          : unifiMulticastRxMode
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MULTICAST_RX_MODE 0x09E0

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiDtimWaitTimeout
  PSID          : 2529 (0x09E1)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 5000
  DESCRIPTION   :
    If UniFi is in power save and receives a Traffic Indication Map from its
    associated access point with a DTIM indication, it will wait a maximum
    time given by this attribute for succeeding broadcast or multicast
    traffic, or until it receives such traffic with the &apos;more data&apos;
    flag clear. Any reception of broadcast or multicast traffic with the
    &apos;more data&apos; flag set, or any reception of unicast data, resets
    the timeout. The timeout can be turned off by setting the value to zero;
    in that case UniFi will remain awake indefinitely waiting for broadcast
    or multicast data. Otherwise, the value should be larger than that of
    unifiPowerSaveExtraListenTime.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_DTIM_WAIT_TIMEOUT 0x09E1

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiIbssOmitBeaconPeriod
  PSID          : 2530 (0x09E2)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_IBSS_OMIT_BEACON_PERIOD 0x09E2

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiScanMaxProbeTransmitLifetime
  PSID          : 2531 (0x09E3)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  UNITS         : TU
  MIN           : 1
  MAX           : 4294967295
  DEFAULT       : 64
  DESCRIPTION   :
    If the value of this attribute is non zero, it is used during active
    scans as the maximum lifetime for probe requests instead of the value of
    dot11MaxTransmitMSDULifetime. It is the elapsed time after the initial
    transmission at which further attempts to transmit the probe are
    terminated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_SCAN_MAX_PROBE_TRANSMIT_LIFETIME 0x09E3

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPeriodicPio
  PSID          : 2600 (0x0A28)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -1
  MAX           : 15
  DEFAULT       : -1
  DESCRIPTION   :
    This attribute specifies the number of the PIO line to use as input for a
    signal indicating the timing of periodic activity on a collocated radio
    during which UniFi has been instructed to avoid transmission by the host
    using a MLME-ADD-BLACKOUT.request. The signal will normally be asserted
    for the duration of periodic high-priority activity such as SCO. The
    timing of this signal should be conveyed to UniFi through the setting of
    the attributes unifiCoexPeriodicPIOInputOffset. This attribute may be set
    to any value between 0 and 15 to use the specified PIO, or -1 to disable
    the signal. If the signal is disabled then the timing information is
    estimated from the other coexistence signals.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PERIODIC_PIO 0x0A28

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPeriodicPioPolarity
  PSID          : 2601 (0x0A29)
  PER INTERFACE?: NO
  TYPE          : unifiCoexPeriodicPIOPolarity
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the polarity of the signalling used to convey
    the timing of periodic activity for coexistence with a Bluetooth radio
    when enabled via MLME-ADD-PERIODIC.request. This setting only applies
    when the attribute unifiCoexPeriodicPIO is set to a value other than -1.
    A normally-low signal which is pulsed high to indicate activity is
    classed as having a positive polarity.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PERIODIC_PIO_POLARITY 0x0A29

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPeriodicPioInputOffset
  PSID          : 2602 (0x0A2A)
  PER INTERFACE?: NO
  TYPE          : CsrInt32
  UNITS         : microseconds
  MIN           : -65536
  MAX           : 65535
  DEFAULT       : -200
  DESCRIPTION   :
    This attribute allows configuration of the mechanism which supports
    signalling of the timing of periodic Bluetooth activity to UniFi when
    enabled using MLME-ADD-BLACKOUT.request. Specifically, this attribute
    represents the fixed time offset between the chosen edge of the PIO
    assigned as the coexistence periodic PIO (in unifiCoexPeriodicPIO) and
    the start of the corresponding blackout. If the blackout is to start
    before the chosen edge of the periodic PIO, then the value will be
    negative. Changes to this attribute are applied on setup of the
    coexistence protection mechanism by way of the MLME-ADD-BLACKOUT.request
    primitive.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PERIODIC_PIO_INPUT_OFFSET 0x0A2A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPeriodicPioInputReference
  PSID          : 2611 (0x0A33)
  PER INTERFACE?: NO
  TYPE          : unifiCoexPeriodicPIOInputReference
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies whether the signal driven into the periodic PIO
    (as specified by unifiCoexPeriodicPIO and associated MIB attributes) has
    fixed timing relationship to the start or end of the activity which
    should be protected. Changes to this attribute are applied on setup of
    the coexistence protection mechanism by way of the
    MLME-ADD-BLACKOUT.request primitive.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PERIODIC_PIO_INPUT_REFERENCE 0x0A33

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiReceiveTriggerPulsePio
  PSID          : 2614 (0x0A36)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the number of the PIO line to use for indicating
    reception of a WLAN packet matching a specification provided in an
    MLME-ADD-RX-TRIGGER.request. The signal will be pulsed after UniFi
    receives a packet matching a specified classifier. The timing of the
    pulse is controlled by unifiReceiveTriggerPulseOffset,
    unifiReceiveTriggerPulseMaxLateness, and
    unifiReceiveTriggerPulseDuration.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RECEIVE_TRIGGER_PULSE_PIO 0x0A36

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiReceiveTriggerPulseOffset
  PSID          : 2615 (0x0A37)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 1000
  DESCRIPTION   :
    This attribute allows configuration of the mechanism which supports
    signalling of the timing of down-link WLAN activity via a PIO.
    Specifically, this attribute specifies the time offset between the
    reception of a frame matching the down-link classifier provided with the
    MLME-ADD-RX-TRIGGER.request, and the start of the output pulse driven on
    the PIO specified in unifiReceiveTriggerPulsePIO. No frame matching can
    take place until the frame has been completely received by the radio and
    is available to the MAC software. For large frames at the lower data
    rates this may be multiple ms. Software scheduling delays may further
    impact the minimum achievable offset. The MIB attribute
    unifiReceiveTriggerPulseMaxLateness allows configuration of the tolerance
    allowed in scheduling the output pulse based on this offset. Changes to
    this attribute are applied on setup of the receive trigger mechanism by
    way of the MLME-ADD-RX-TRIGGER.request primitive.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RECEIVE_TRIGGER_PULSE_OFFSET 0x0A37

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiReceiveTriggerPulseDuration
  PSID          : 2616 (0x0A38)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 1000
  DESCRIPTION   :
    This attribute allows configuration of the mechanism which supports
    signalling of the timing of down-link WLAN activity via a PIO.
    Specifically, this attribute specifies the duration of the output pulse
    which is generated on the PIO specified by unifiReceiveTriggerPulsePIO
    when a frame is received which matching the specification provided in an
    MLME-ADD-RX-TRIGGER.request. Changes to this attribute are applied on
    setup of the receive trigger mechanism by way of the
    MLME-ADD-RX-TRIGGER.request primitive.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RECEIVE_TRIGGER_PULSE_DURATION 0x0A38

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiReceiveTriggerPulseMaxLateness
  PSID          : 2617 (0x0A39)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 65535
  DEFAULT       : 1000
  DESCRIPTION   :
    This attribute allows configuration of the mechanism which supports
    signalling of the timing of down-link WLAN activity via a PIO. UniFi will
    attempt to schedule the output pulse for unifiReceiveTriggerPulseOffset
    microseconds after the matching frame reception, however software
    scheduling delays may mean that the timing of the pulse is not precise.
    This attribute allows configuration of the maximum tolerable lateness of
    this pulse before it should be abandoned. This attribute only provides a
    guide, as software scheduling delays when UniFi is under load may prevent
    this being strictly enforced. Changes to this attribute are applied on
    setup of the receive trigger mechanism by way of the
    MLME-ADD-RX-TRIGGER.request primitive.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RECEIVE_TRIGGER_PULSE_MAX_LATENESS 0x0A39

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiReceiveTriggerPulsePolarity
  PSID          : 2618 (0x0A3A)
  PER INTERFACE?: NO
  TYPE          : unifiReceiveTriggerPulsePolarity
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the polarity of the signalling used to convey
    the timing of received frames matching a specification provided in an
    MLME-ADD-RX-TRIGGER.request. A normally-low signal which is pulsed high
    to indicate activity is classed as having a positive polarity.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RECEIVE_TRIGGER_PULSE_POLARITY 0x0A3A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiRadioTrimCache
  PSID          : 2700 (0x0A8C)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 0
  MAX           : 255
  DEFAULT       :
  DESCRIPTION   :
    Part of the radio trim calibration data. A particular version of firmware
    will always return the same length of data for a particular index
    (although it may associate different lengths of data with different index
    values). This may be used to determine how many rows can be retrieved
    using a single MLME-GET.request.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_RADIO_TRIM_CACHE 0x0A8C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiBlueCorePsKey
  PSID          : 2800 (0x0AF0)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 1
  MAX           : 128
  DEFAULT       : (Too Large to display)
  DESCRIPTION   :
    A BlueCore persistent store key. 64 words (128 octets) is the recommended
    maximum size for the key. The associated index is the same value as the
    persistent store key number.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_BLUE_CORE_PS_KEY 0x0AF0

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeTriggeredGetHighRssiThreshold
  PSID          : 2900 (0x0B54)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -128
  MAX           : 127
  DEFAULT       : -80
  DESCRIPTION   :
    This attribute specifies the upper limit of RSSI, which when crossed
    would result in a MLME-TRIGGERED-GET.indication primitive being
    generated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_TRIGGERED_GET_HIGH_RSSI_THRESHOLD 0x0B54

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeTriggeredGetLowRssiThreshold
  PSID          : 2901 (0x0B55)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dBm
  MIN           : -128
  MAX           : 127
  DEFAULT       : -85
  DESCRIPTION   :
    This attribute specifies the lower limit of RSSI, which when crossed
    would result in a MLME-TRIGGERED-GET.indication primitive being
    generated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_TRIGGERED_GET_LOW_RSSI_THRESHOLD 0x0B55

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeTriggeredGetHighSnrThreshold
  PSID          : 2902 (0x0B56)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -128
  MAX           : 127
  DEFAULT       : 4
  DESCRIPTION   :
    This attribute specifies the upper limit of SNR, which when crossed would
    result in a MLME-TRIGGERED-GET.indication primitive being generated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_TRIGGERED_GET_HIGH_SNR_THRESHOLD 0x0B56

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiMlmeTriggeredGetLowSnrThreshold
  PSID          : 2903 (0x0B57)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : dB
  MIN           : -128
  MAX           : 127
  DEFAULT       :
  DESCRIPTION   :
    This attribute specifies the lower limit of SNR, which when crossed would
    result in a MLME-TRIGGERED-GET.indication primitive being generated.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_MLME_TRIGGERED_GET_LOW_SNR_THRESHOLD 0x0B57

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiTxRxTokenBalance
  PSID          : 4132 (0x1024)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  UNITS         : pages
  MIN           : -32768
  MAX           : 32767
  DEFAULT       :
  DESCRIPTION   :
    This element adjusts the comparison between memory data pages used on the
    Tx direction and the ones used in the Rx direction to decide which
    direction should get new ones when contention happens. Usually the
    comparison aims to penalise the one that has more pages than than the
    other, if contention exists, but this mib will artificially penalise the
    to-host direction, if negative, or the from-host direction, if positive.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_TX_RX_TOKEN_BALANCE 0x1024

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiWmmMaxServicePeriod
  PSID          : 4191 (0x105F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 3
  DEFAULT       : 1
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_WMM_MAX_SERVICE_PERIOD 0x105F

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiPowerSaveDtimHeuristicEnabled
  PSID          : 4192 (0x1060)
  PER INTERFACE?: NO
  TYPE          : CsrBool
  MIN           : 0
  MAX           : 1
  DEFAULT       : FALSE
  DESCRIPTION   :
    UniFi supports use of a heuristic which improves reliability for
    down-link broadcast and multicast traffic after issue of an
    MLME-POWERMGT.request with the ReceiveDTIMs flag set false. This
    heuristic attempts to align timing of normal wakeup for beacon reception
    with arrival of the DTIM. With certain combinations of listen interval
    and DTIM interval, use of this heuristic can result in increased power
    consumption.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_POWER_SAVE_DTIM_HEURISTIC_ENABLED 0x1060

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiBeamformingPhaseQuantity
  PSID          : 4193 (0x1061)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -16
  MAX           : 16
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_BEAMFORMING_PHASE_QUANTITY 0x1061

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtawlanDenyPio
  PSID          : 5000 (0x1388)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       : 2
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTAWLAN_DENY_PIO 0x1388

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtStatusPio
  PSID          : 5001 (0x1389)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -1
  MAX           : 15
  DEFAULT       : 1
  DESCRIPTION   :
    The number of the PIO line to use as input for the BT_STATUS signal when
    unifiCoexScheme is set to pta (3). This must be 5 for current hardware. A
    value of -1 means that this signal is not used.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_STATUS_PIO 0x1389

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtInbandPio
  PSID          : 5002 (0x138A)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -1
  MAX           : 15
  DEFAULT       : -1
  DESCRIPTION   :
    The number of the PIO line to use as input for the BT_INBAND signal when
    unifiCoexScheme is set to pta (3). This must be 6 for current hardware. A
    value of -1 means that this signal is not used.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_INBAND_PIO 0x138A

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtActivePio
  PSID          : 5003 (0x138B)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 15
  DEFAULT       :
  DESCRIPTION   :
    The number of the PIO line to use as input for the BT_ACTIVE signal when
    unifiCoexScheme is set to pta (3). This must be 7 for current hardware.
    It is not possible to disable this signal when the unifiCoexScheme is set
    to 3.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_ACTIVE_PIO 0x138B

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtActiveLeadTime
  PSID          : 5004 (0x138C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 250
  DEFAULT       : 18
  DESCRIPTION   :
    This attribute specifies the duration by which the assertion of the
    BT_ACTIVE coexistence signal leads the start of the gain ramp for a
    transmission or the receiver being enabled. The value has effect only
    when unifiCoexScheme is set to pta (3).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_ACTIVE_LEAD_TIME 0x138C

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtStatusPrioritySampleTime
  PSID          : 5005 (0x138D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 15
  DEFAULT       : 2
  DESCRIPTION   :
    This attribute specifies the time after assertion of the BT_ACTIVE
    coexistence signal at which the BT_STATUS signal is sampled to determine
    activity priority. The value has effect only when unifiCoexScheme is set
    to pta (3).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_STATUS_PRIORITY_SAMPLE_TIME 0x138D

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtStatusDirectionSampleTime
  PSID          : 5006 (0x138E)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 30
  DEFAULT       : 17
  DESCRIPTION   :
    This attribute specifies the time after assertion of the BT_ACTIVE
    coexistence signal at which the BT_STATUS signal is sampled to determine
    activity direction. The value has effect only when unifiCoexScheme is set
    to pta (3).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_STATUS_DIRECTION_SAMPLE_TIME 0x138E

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtStatusDirectionPostSlotSampleTime
  PSID          : 5007 (0x138F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 625
  DEFAULT       : 617
  DESCRIPTION   :
    This attribute specifies the time after the BT_STATUS line changing to
    indicate a change of direction to that change happening on the air. This
    must be specified as t=625-x where t is the MIB value, and x is the
    desired time (this is for historical reasons). The value has effect only
    when unifiCoexScheme is set to pta (3).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_STATUS_DIRECTION_POST_SLOT_SAMPLE_TIME 0x138F

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtIdPacketDuration
  PSID          : 5008 (0x1390)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  UNITS         : microseconds
  MIN           : 0
  MAX           : 400
  DEFAULT       : 118
  DESCRIPTION   :
    Duration used for advertisement of Bluetooth ID packets in page or
    inquiry modes. This defines the duration of a Bluetooth ID packet plus a
    bit of slop to allow for timing misalignments. The value has effect only
    when unifiCoexScheme is set to pta (3).
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_ID_PACKET_DURATION 0x1390

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabttxEnablePio
  PSID          : 5009 (0x1391)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -1
  MAX           : 15
  DEFAULT       : -1
  DESCRIPTION   :
    The number of the PIO line the UF602x uses as input for the BT_TX_ENABLE
    signal when unifiCoexScheme is set to pta (3). If left at the default,
    the UF602x derives front end control logic from the BT_ACTIVE and
    BT_STATUS PIOs, otherwise it uses this PIO directly. If this attribute is
    set it must be even and unifiCoexPTABTRXEnablePIO must be set to a valid
    value or a fault will be raised.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABTTX_ENABLE_PIO 0x1391

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtrxEnablePio
  PSID          : 5010 (0x1392)
  PER INTERFACE?: NO
  TYPE          : CsrInt16
  MIN           : -1
  MAX           : 15
  DEFAULT       : -1
  DESCRIPTION   :
    The number of the PIO line the UF602x uses as input for the BT_RX_ENABLE
    signal when unifiCoexScheme is set to pta (3). If left at the default,
    the UF602x derives front end control logic from the BT_ACTIVE and
    BT_STATUS PIOs, otherwise it uses this PIO directly. If this attribute is
    set it must be odd and unifiCoexPTABTTXEnablePIO must be set to a valid
    value or a fault will be raised.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABTRX_ENABLE_PIO 0x1392

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtabtPriorityLevels
  PSID          : 5012 (0x1394)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 10
  MAX           : 10
  DEFAULT       : { 0X00, 0X05, 0X00, 0X09, 0X00, 0X0B, 0X00, 0X0D, 0X00, 0X00 }
  DESCRIPTION   :
    This attribute controls the assignment of coexistence priorities to
    Bluetooth activities when unifiCoexScheme is set to pta (3). The elements
    of this octet string define a mapping from four possible levels given by
    the sampling of the PIOs specified by unifiCoexPTABTStatusPIO (the
    BT_STATUS signal) and unifiCoexPeriodicPIO (the BT_PERIODIC signal) at
    the point defined by unifiCoexPTABTStatusPrioritySampleTime after
    assertion of the PIO specified by unifiCoexPTABTActivePIO (the BT_ACTIVE
    signal), to the 16 levels of priority used internally by UF602x
    Coexistence Decision Logic. Each consecutive pair of octets defines the
    priority used for a given combination of BT_STATUS and BT_PERIODIC. The
    first octet of each pair must be zero, and the second octet of each pair
    should contain the required priority in the least significant nibble. The
    most significant nibble of the second octet must be set to zero. The
    octets within the string are assigned as follows. 0-1 Both BT_STATUS and
    BT_PERIODIC low 2-3 BT_STATUS high and BT_PERIODIC low 4-5 BT_STATUS low
    and BT_PERIODIC high 6-7 Both BT_STATUS and BT_PERIODIC high 8-9 Unused.
    Reserved for future use. The last two octets in the string are reserved
    for future extension and must be set to zero. Changes to this MIB
    attribute take effect when unifiCoexScheme is next written.
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTABT_PRIORITY_LEVELS 0x1394

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCoexPtacdlConfig
  PSID          : 5013 (0x1395)
  PER INTERFACE?: NO
  TYPE          : CsrUint8
  MIN           : 17
  MAX           : 17
  DEFAULT       : { 0X0A, 0X08, 0X06, 0XFF, 0XFF, 0XFF, 0X00, 0X00, 0X01, 0X02, 0X03, 0XFF, 0XF0, 0XFF, 0XF0, 0XFF, 0XF0 }
  DESCRIPTION   :
    This string contains the UF602x coexistence configuration for the BT CDL
    when unifiCoexScheme is set to pta (3). Description: octet 0 -
    collision_table.spectral_threshs.thresh_2 octet 1 -
    collision_table.spectral_threshs.thresh_1 octet 2 -
    collision_table.spectral_threshs.thresh_0 octet 3 -
    collision_table.local_tx_col_table (msw) octet 4 -
    collision_table.local_tx_col_table (lsw) octet 5 -
    collision_table.local_rx_col_table (msw) octet 6 -
    collision_table.local_rx_col_table (lsw) octet 7 -
    priority_difference_table.thresh_neg octet 8 -
    priority_difference_table.thresh_0 octet 9 -
    priority_difference_table.thresh_1 octet 10 -
    priority_difference_table.thresh_2 octet 11 - action_table.abort_table
    (msw) octet 12 - action_table.abort_table (lsw) octet 13 -
    action_table.lcl_table_1 (msw) octet 14 - action_table.lcl_table_1 (lsw)
    octet 15 - action_table.lcl_table_1 (msw) octet 16 -
    action_table.lcl_table_1 (lsw)
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_COEX_PTACDL_CONFIG 0x1395

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCcxVersionImplemented
  PSID          : 6000 (0x1770)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 5
  DEFAULT       : 5
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_CCX_VERSION_IMPLEMENTED 0x1770

/*******************************************************************************
  NAME          : CsrWifiHipPsidUnifiCcxtsMetricsValue
  PSID          : 6013 (0x177D)
  PER INTERFACE?: NO
  TYPE          : CsrUint32
  MIN           : 0
  MAX           : 4294967295
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_UNIFI_CCXTS_METRICS_VALUE 0x177D

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsTkipicvErrors
  PSID          : 6038 (0x1796)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_TKIPICV_ERRORS 0x1796

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsTkipNoEncryptionErrors
  PSID          : 6039 (0x1797)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_TKIP_NO_ENCRYPTION_ERRORS 0x1797

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsTkipLocalMicFailures
  PSID          : 6040 (0x1798)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_TKIP_LOCAL_MIC_FAILURES 0x1798

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsTkipmhdrErrors
  PSID          : 6041 (0x1799)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_TKIPMHDR_ERRORS 0x1799

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsTkipReplays
  PSID          : 6042 (0x179A)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_TKIP_REPLAYS 0x179A

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsCcmpDecryptErrors
  PSID          : 6043 (0x179B)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_CCMP_DECRYPT_ERRORS 0x179B

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsCcmpNoEncryptErrors
  PSID          : 6044 (0x179C)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_CCMP_NO_ENCRYPT_ERRORS 0x179C

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsCcmpReplays
  PSID          : 6045 (0x179D)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_CCMP_REPLAYS 0x179D

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaMgmtStatsBroadcastDisassociateCount
  PSID          : 6046 (0x179E)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_MGMT_STATS_BROADCAST_DISASSOCIATE_COUNT 0x179E

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsBroadcastDeauthenticateCount
  PSID          : 6047 (0x179F)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_BROADCAST_DEAUTHENTICATE_COUNT 0x179F

/*******************************************************************************
  NAME          : CsrWifiHipPsidDot11RsnaStatsBroadcastActionFrameCount
  PSID          : 6048 (0x17A0)
  PER INTERFACE?: NO
  TYPE          : CsrUint16
  MIN           : 0
  MAX           : 65535
  DEFAULT       :
  DESCRIPTION   :
    Not supported
 *******************************************************************************/
#define CSR_WIFI_HIP_PSID_DOT11_RSNA_STATS_BROADCAST_ACTION_FRAME_COUNT 0x17A0


#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_MIB_H__ */
