/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/
#ifndef CSR_WIFI_LIB_H__
#define CSR_WIFI_LIB_H__

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_wifi_fsm_event.h"


#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 *  CsrWifiFsmEventInit
 *
 *  DESCRIPTION
 *      Macro to initialise the members of a CsrWifiFsmEvent.
 *----------------------------------------------------------------------------*/
#define CsrWifiFsmEventInit(evt, p_primtype, p_msgtype, p_dst, p_src) \
    (evt)->primtype = p_primtype; \
    (evt)->type = p_msgtype; \
    (evt)->destination = p_dst; \
    (evt)->source = p_src

typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint8        value;
} CsrWifiEventCsrUint8;

typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       value;
} CsrWifiEventCsrUint16;

typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint32       value;
} CsrWifiEventCsrUint32;

typedef struct
{
    CsrWifiFsmEvent common;
    CsrUint16       value16;
    CsrUint8        value8;
} CsrWifiEventCsrUint16CsrUint8;

#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_LIB_H__ */
