/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __LINUX_UNIFI_CLIENTS_H__
#define __LINUX_UNIFI_CLIENTS_H__ 1

#include "csr_synergy.h"

#include <linux/kernel.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_UDI_CLIENTS 8

/* The start of the range of process ids allocated for ul clients */
#define UDI_SENDER_ID_BASE      0xC000
#define UDI_SENDER_ID_SHIFT     8


/* Structure to hold a UDI logged signal */
typedef struct
{
    /* List link structure */
    struct list_head q;

    /* The message that will be passed to the user app */
    udi_msg_t msg;

    /* Signal body and data follow */
} udi_log_t;


typedef struct ul_client ul_client_t;

typedef void (*udi_event_t)(ul_client_t *client,
                            const u8 *sigdata, int signal_len,
                            const CsrWifiHipBulkDataParam *bulkdata,
                            int dir);

void logging_handler(void *ospriv,
                     CsrUint8 *sigdata, CsrUint32 signal_len,
                     const CsrWifiHipBulkDataParam *bulkdata,
                     CsrWifiHipLogUdiDirection direction);


struct ul_client
{
    /* Index of this client in the ul_clients array. */
    int client_id;

    /* Index of UniFi device to which this client is attached. */
    int instance;

    /* Flag to say whether this client has been enabled. */
    int udi_enabled;

    /* Value to use in signal->SenderProcessId */
    int sender_id;

    /* Configuration flags, e.g blocking, logging, etc. */
    unsigned int configuration;

    udi_event_t event_hook;

    /* A list to hold signals received from UniFi for reading by read() */
    struct list_head udi_log;

    /* Semaphore to protect the udi_log list */
    struct semaphore udi_sem;

    /*
     * Linux waitqueue to support blocking read and poll.
     * Logging clients should wait on udi_log. while
     * blocking clients should wait on wake_up_wq.
     */
    wait_queue_head_t udi_wq;
    CsrUint16 signal_filter[SIG_FILTER_SIZE];
}; /* struct ul_client */

#define OS_LINUX_SIGNAL_RECEIVER_PROCESS_ID_OFFSET 2
#define OS_LINUX_MA_PACKET_CFM_EXTRACT_DEST_SCHED_TASK_ID(signal) signal[OS_LINUX_SIGNAL_RECEIVER_PROCESS_ID_OFFSET] /* The task ID is stored in the receiver process id */

#ifdef __cplusplus
}
#endif
#endif /* __LINUX_UNIFI_CLIENTS_H__ */
