/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#include "csr_synergy.h"
#include "csr_wifi_hip_log_text.h"
#include "csr_wifi_nme_ap_sef.h"
#include "os_linux_priv.h"
#include "csr_wifi_nme_ap_prim.h"

void CsrWifiNmeApUpstreamStateHandlers(void *drvpriv, CsrWifiFsmEvent *msg)
{
    switch (msg->type)
    {
        case CSR_WIFI_NME_AP_START_CFM:
            CsrWifiNmeApStartCfmHandler(drvpriv, msg);
            break;
        case CSR_WIFI_NME_AP_STOP_CFM:
            CsrWifiNmeApStopCfmHandler(drvpriv, msg);
            break;
        default:
            CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID,
                                   CSR_WIFI_HIP_LOG_DEF,
                                   "unifi : CsrWifiNmeApUpstreamStateHandlers: unhandled NME_AP message type 0x%.4X\n", msg->type));
            break;
    }
}
