/****************************************************************************
 *
 *       (c) Cambridge Silicon Radio Limited 2011
 *
 *       All rights reserved
 *
 ****************************************************************************/

#ifndef CSR_WIFI_CONFIG_H__
#define CSR_WIFI_CONFIG_H__

/*--------------------------------------------------------------------------
 * Version info
 *--------------------------------------------------------------------------*/
#define CSR_WIFI_VERSION_MAJOR    6
#define CSR_WIFI_VERSION_MINOR    1
#define CSR_WIFI_VERSION_FIXLEVEL 1
#define CSR_WIFI_VERSION_BUILD    ALPS007
#define CSR_WIFI_RELEASE_TYPE_ENG
#ifdef CSR_WIFI_RELEASE_TYPE_ENG
#define CSR_WIFI_VERSION "6.1.1.ALPS007"
#else
#define CSR_WIFI_VERSION "6.1.1"
#endif

#define CSR_WIFI_VERSION_NUMBER CSR_VERSION_NUMBER(6, 1, 1)
#define CSR_WIFI_VERSION_CHECK(major,minor,fix) (CSR_WIFI_VERSION_NUMBER >= CSR_VERSION_NUMBER(major,minor,fix))

#define CSR_WIFI_LOG_VERSION "611"

/*--------------------------------------------------------------------------
 * Csr Wifi Chip Options
 *--------------------------------------------------------------------------*/
/* Enable/Disable features based on CSR603X Chip Type  */
#ifndef CSR_WIFI_CHIP_TYPE_CSR603X
#define CSR_WIFI_CHIP_TYPE_CSR603X
#endif

/*--------------------------------------------------------------------------
 * Csr Wifi Component Options
 *--------------------------------------------------------------------------*/
/* Enable CSR Network Management Entity (NME) Support. The NME is the CSR supplicant.  */
#ifndef CSR_WIFI_NME_ENABLE
#define CSR_WIFI_NME_ENABLE
#endif

/* Enable Ptest Support */
#ifndef CSR_WIFI_PTEST_ENABLE
/* #undef CSR_WIFI_PTEST_ENABLE */
#endif

/* Enable Ptest CPP version */
/* #undef CSR_WIFI_PTEST_CPP_VERSION_ENABLE */
/* Enable Ptest Persistent Store Operations (cpp_version only) */
/* #undef CSR_WIFI_PTEST_PS_ENABLE */

/* Csr Wifi Amp Api for external BT Stacks and Unit Test support */
#ifndef CSR_WIFI_PORTING_EXTERNAL_AMP_ENABLE
/* #undef CSR_WIFI_PORTING_EXTERNAL_AMP_ENABLE */
#endif

#ifdef CSR_WIFI_PORTING_EXTERNAL_AMP_ENABLE
/* Enable the WPA security features required for the AMP */
#define CSR_WIFI_SECURITY_ENABLE
#define CSR_WIFI_SECURITY_WPA_PERSONAL_SUPPLICANT_ENABLE
#define CSR_WIFI_SECURITY_WPA_PERSONAL_AUTHENTICATOR_ENABLE
#endif
/* Enable Bt Coexistence Support */
/* #undef CSR_WIFI_COEX_ENABLE */

/* 80211k Radio Measurement Functionality */
/* #undef CSR_WIFI_80211_K_ENABLE */

/* 80211R Fast Roaming Functionality */
/* #undef CSR_WIFI_80211_R_ENABLE */

/* AccessPoint and Wifi Direct Functionality */
#ifndef CSR_WIFI_AP_ENABLE
#define CSR_WIFI_AP_ENABLE
#endif

/* Shim for open source Application */
#ifndef CSR_WIFI_SHIM_ENABLE
/* #undef CSR_WIFI_SHIM_ENABLE */
#endif

/* #undef CSR_WIFI_AP_USE_PSCHED_MCAST_BURST_MODE */

/* Max interfaces supported.
 * - Must be at least 1
 * - CsrWifiSmeInterfaceAddReq will be rejected when the max value is reached */
#define CSR_WIFI_MAX_INTERFACES 3

/*--------------------------------------------------------------------------
 * Csr Wifi Hip Options
 *--------------------------------------------------------------------------*/
/* Enable this option to generate trace output from the HIP. */
/* #undef CSR_WIFI_HIP_TRACE_LEVEL */

/* Set the SDIO block size
 *   0: Use recommended SDIO block size.
 */
#define CSR_WIFI_HIP_SDIO_BLOCK_SIZE 64

/* Thread priority of HIP.
 *   0: Highest priority
 *   1: High priority
 *   2: Normal priority
 *   3: Low priority
 *   4: Lowest priority
 */
#define CSR_WIFI_HIP_PRIORITY 2

/* HIP offline profiling. Offline profiling will have minimum impact on timing as profiling
 * logs will be printed after the measurements have been performed.
 *
 * Please note that it is a requirement that CSR_WIFI_HIP_TRACE_LEVEL is enabled for offline profiling
 * to work.
 */
/* #undef CSR_WIFI_HIP_DEBUG_OFFLINE_ENABLE */

/* SDIO Trace.
 * SDIO transactions are recorded into an offline debug buffer.
 */
/* #undef CSR_WIFI_HIP_SDIO_TRACE_ENABLE */

/* Data Plane Profile.
 * Add extra information to offline debug buffer. Additional stats.
 */
/* #undef CSR_WIFI_HIP_DATA_PLANE_PROFILE_ENABLE */

/* Enables HIP support of suspend/resume.
 *
 * If HIP suspend support is enabled, it is possible for the operating system
 * to request a suspend through the CSR SDIO API.
 * The other macros then determine whether WOL (Wake On Lan) is supported and if so how
 * wake is triggered.
 *
 */
#define CSR_WIFI_HIP_SUSPEND_ENABLE

#ifdef CSR_WIFI_HIP_SUSPEND_ENABLE
/* Keep the wifi chip powered during suspend */
/* #undef CSR_WIFI_HIP_SUSPEND_WOL */

#ifdef CSR_WIFI_HIP_SUSPEND_WOL
/* Wake the host using PIO */
/* #undef CSR_WIFI_HIP_SUSPEND_WAKE_PIO */
#endif /* CSR_WIFI_HIP_SUSPEND_WOL */

#endif /* CSR_WIFI_HIP_SUSPEND_ENABLE */

/* Define the number of mini-coredump buffers to allocate at startup. These are
 * used to record chip status for the last n unexpected resets.
 */
#define CSR_WIFI_HIP_NUM_COREDUMP_BUFFERS 5

/* Spinlock support
 *
 * Some operating systems requires spinlock (e.g Linux), which can be enabled
 * by using this option.
 * The Wi-Fi implementation of spinlocks is only available in a Linux kernel
 * version, which can be found under the linux driver folder.
 */
#define CSR_WIFI_SPINLOCK_SUPPORT

#define CSR_WIFI_HIP_PSCHED_MOD 32
#define CSR_WIFI_HIP_PSCHED_MOD_ALGO 2
#define CSR_WIFI_HIP_PSCHED_SMOD_HIST 20

/* #undef CSR_WIFI_HIP_EMULATE_SDIO_ERRORS */

/*--------------------------------------------------------------------------
 * Csr Wifi Security Options
 *--------------------------------------------------------------------------*/
 /* Enable Security */
#ifndef CSR_WIFI_SECURITY_ENABLE
#define CSR_WIFI_SECURITY_ENABLE
#endif

#ifdef CSR_WIFI_SECURITY_ENABLE

/* Allow PMK_CACHING for Faster WPA2 Enterprise roaming */
#define CSR_WIFI_SECURITY_PMK_CACHING_ENABLE

/* Enable Security Wpa/Wpa2 Personel Supplicant */
#ifndef CSR_WIFI_SECURITY_WPA_PERSONAL_SUPPLICANT_ENABLE
#define CSR_WIFI_SECURITY_WPA_PERSONAL_SUPPLICANT_ENABLE
#endif

/* Enable Security Wpa/Wpa2 Personel Authenicator */
#ifndef CSR_WIFI_SECURITY_WPA_PERSONAL_AUTHENTICATOR_ENABLE
#define CSR_WIFI_SECURITY_WPA_PERSONAL_AUTHENTICATOR_ENABLE
#endif

/* Enable 802.11 W Management Frame Protection */
/* #undef CSR_WIFI_80211_W_ENABLE */

/* Enable Security WPS */
#define CSR_WIFI_SECURITY_WPS_ENABLE

/* Enable Security Wapi */
/* #undef CSR_WIFI_SECURITY_WAPI_ENABLE */

#ifdef CSR_WIFI_SECURITY_WAPI_ENABLE
/* Enable Security Wapi Authenticator */
/* #undef CSR_WIFI_SECURITY_WAPI_AUTHENTICATOR_ENABLE */
#endif

/* Enable Security EAP plugins */
#define CSR_WIFI_SECURITY_EAP_ENABLE

/* Enable Security plugin TLS */
#define CSR_WIFI_SECURITY_TLS_ENABLE

/* Enable Security plugin TTLS */
#define CSR_WIFI_SECURITY_TTLS_ENABLE

/* Enable Security plugin LEAP */
#define CSR_WIFI_SECURITY_LEAP_ENABLE

/* Enable Security plugin FAST */
#define CSR_WIFI_SECURITY_FAST_ENABLE

/* Enable Security plugin SIM */
#define CSR_WIFI_SECURITY_SIM_ENABLE

/* Enable Security plugin AKA */
#define CSR_WIFI_SECURITY_AKA_ENABLE

/* Enable Security plugin PEAP */
#define CSR_WIFI_SECURITY_PEAP_ENABLE

#endif /* CSR_WIFI_SECURITY_ENABLE */

/*--------------------------------------------------------------------------
 * Csr Wifi Porting Options
 *--------------------------------------------------------------------------*/
/*
 * Only use the file system when loading files.
 * Used to load patches and mib files
 */
/* #undef CSR_WIFI_PORTING_FILE_FS_ONLY */

/*
 * Only use the static compiled in files when loading files.
 * Used to load patches and mib files
 */
/* #undef CSR_WIFI_PORTING_FILE_STATIC_ONLY */

/* Defines the default patch file to use
 * The default files to load for patches is:
 * sta.xbv
 */
/* #undef CSR_WIFI_PORTING_PATCH_FILE */

/* Flush is not supported in BDB Nucleus, enabled by default */
#define CSR_WIFI_PORTING_LOG_PRINTF_FLUSH_ENABLE

/* Formatted time stamps are not supported in Windows, enabled by default */
#define CSR_WIFI_PORTING_LOG_PRINTF_FORMATTED_TIMESTAMP_ENABLE

/* When using the Remote Router with a Linux Char device use a
 thread when sending data to the chardevice */
#define CSR_WIFI_PORTING_ROUTER_IPC_TX_THREAD_ENABLE

/* Are we using the Remote Router (Linux) */
#define CSR_WIFI_REMOTE_ROUTING_ENABLE

/* Enable the Mib PSID name lookup functions
   Useful for Debug but has a performance and Code Size Hit */
#define CSR_WIFI_PORTING_MIB_TEXT_NAME_LOOKUP_ENABLE

/*--------------------------------------------------------------------------
 * Csr Wifi Linux Driver Options
 *--------------------------------------------------------------------------*/
/* #undef CSR_WIFI_DRIVER_DEFER_TH_PROCESSING */
#define CSR_WIFI_DRIVER_USE_NETIF_RX
/* #undef CSR_WIFI_DRIVER_COMPAT_OLD_USERMODEHELPER_API */
/* #undef CSR_WIFI_DRIVER_COMPAT_NEW_USERMODEHELPER_API */

#ifdef CSR_WIFI_DRIVER_SDIO_DEBUG_CMD_LOG_LENGTH
#define SDIO_DEBUG_CMD_LOG_LEN CSR_WIFI_DRIVER_SDIO_DEBUG_CMD_LOG_LENGTH
#endif

/* #undef CSR_WIFI_DRIVER_HYDRA */
#define CSR_WIFI_DRIVER_USE_HYDRA_DRIVER
/* #undef CSR_WIFI_SINGLE_FUNCTION */

/*--------------------------------------------------------------------------
 * Csr Wifi Test Engine Options
 *--------------------------------------------------------------------------*/
/* Enable the Test Engine to provide support for WFA testing
 * and other CSR Test engine commands.
 */
#ifndef CSR_WIFI_TE_ENABLE
/* #undef CSR_WIFI_TE_ENABLE */
#endif

/* Enable Test Engine Socket support to communicate with the TE on platforms
 * where socket support is available. See the --wifi-te-sock command line option.
 */
#ifndef CSR_WIFI_TE_SOCK_ENABLE
/* #undef CSR_WIFI_TE_SOCK_ENABLE */
#endif

/*--------------------------------------------------------------------------
 * Debug Options
 *--------------------------------------------------------------------------*/
#ifdef CSR_LOG_ENABLE
/* Enable the WiFi FSM dump feature
 * Switches in FSM Dump functions that will log local variable used by
 * individual FSMs.
 */
/* #undef CSR_WIFI_FSM_DUMP_ENABLE */

/* Enable this to enable logging.
 * 0 -> 5
 * 0 == No  Logging
 * 5 == All Logging
 */
#ifndef CSR_LOG_TEXT_LEVEL
#define CSR_LOG_TEXT_LEVEL 5
#endif

#endif /* CSR_LOG_ENABLE */

/* #undef CSR_WIFI_PBC_ENABLE */
#ifdef CSR_WIFI_PBC_ENABLE
/* Programming by contract
 * Use the following to disable specific assertion types
 */
/* #define CSR_WIFI_PBC_NO_ASSERTS   */
/* #define CSR_WIFI_PBC_NO_REQUIRE   */
/* #define CSR_WIFI_PBC_NO_VERIFY    */
/* #define CSR_WIFI_PBC_NO_ENSURE    */
/* #define CSR_WIFI_PBC_NO_INVARIANT */
#else /* CSR_WIFI_PBC_ENABLE */
#define CSR_WIFI_PBC_NO_ASSERTS
#endif /* CSR_WIFI_PBC_ENABLE */

/* Enables support functions that allow individual components to instrument
 * code for the purpose of profiling.
 * Results are calculated and displayed via the logging mechanisum
 */
/* #undef CSR_WIFI_PROFILING_ENABLE */
/* Enables profiling functionality for blocking crypto algorithms */
/* #undef CSR_WIFI_PROFILING_CRYPTO_ENABLE */
/* Enables profiling functionality for security packet processing routines */
/* #undef CSR_WIFI_PROFILING_SECURITY_ENABLE */

/*--------------------------------------------------------------------------
 * Android Options
 *--------------------------------------------------------------------------*/
#ifdef ANDROID_BUILD
#define UNIFI_NET_NAME "wlan"
#endif

/*--------------------------------------------------------------------------
 * Csr Wifi App Options
 *--------------------------------------------------------------------------*/
/* Enable external application control signalling (serialised primitives) via a control socket. */
/* #undef CSR_WIFI_APP_CONTROL_SOCKET_ENABLE */

/* Application support for using an external Bt stack (like Bluez).
 * Must also have CSR_WIFI_APP_CONTROL_SOCKET_ENABLE enabled.
 */
/* #undef CSR_WIFI_APP_EXTERNAL_BT_ENABLE */

/* Enable Ip Stack support
 * Start the Synergy IPStack and automatically bring up the interfaces using DHCP (Mainly for use on BDBs)
 */
#define CSR_WIFI_APP_IP_TASK_ENABLE

/* Enable Pcap logging within code. Must also have CSR_LOG_ENABLE enabled. */
/* #undef CSR_WIFI_APP_LOG_PCAP_ENABLE */

/* Enable Wifi Porting Printf implementation
 * Use Wifi Porting printf implementation to output log text to stdout.
 * (Much faster than the cleartext provided by the Framework)
 */
#define CSR_WIFI_APP_PORTING_LOG_PRINTF_ENABLE

/* Enables CsrPmemAlloc and CsrPmemFree tracking and reporting (Requires CSR_MEMALLOC_PROFILING) */
/* #undef CSR_WIFI_PORTING_PMEM_DEBUG_ENABLE */

/* Bring up the FW Ethernet task so we have Network connectivity.
 * Used on BDB to enable the Lan interface.
 */
/* #undef CSR_WIFI_APP_ETHERNET_ENABLE */

/*--------------------------------------------------------------------------
 * Include csr_wifi_devel_config.h if the development Configuration is available
 *--------------------------------------------------------------------------*/
/* #undef CSR_WIFI_DEVEL_CONFIG_ENABLE */
#ifdef CSR_WIFI_DEVEL_CONFIG_ENABLE
#include "csr_wifi_devel_config.h"
#endif

#endif /* CSR_WIFI_CONFIG_H__ */
