/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef __MASCA_SPIDEV_H_
#define __MASCA_SPIDEV_H_
#include <linux/spi/spi.h>

extern struct spi_device *ptr;

/*MASCA SPI functions*/
extern int masca_spi_init(void);
extern void masca_spi_exit(void);
extern int masca_spi_open(void);
extern int masca_spi_write(const char *p, int len);
extern int masca_spi_read(char q[], int len);
extern void masca_spi_lock_bus(void);

#endif /* __MASCA_SPIDEV_H_ */
