/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef __MASCA_SCSI_HANDLER_H_
#define __MASCA_SCSI_HANDLER_H_

#include "masca_common_types.h"
#include "masca_dispatch.h"

#define APP_BUF_SZ	(64*1024)
#define MASCA_COMMAND		0x01

struct masca_rcvr {
	struct scsi_cmnd *a_cmnd;
	bool evtflag;
	bool is_cmd_done;
	int replyid;
	struct list_head list;
};

extern int masca_core_init(void);
extern int masca_core_deinit(void);
extern int masca_recvthrd(void *thr_data) ;
extern struct masca_rcvr *masca_get_aborted_cmd_from_que(struct
						scsi_cmnd * scpnt);
extern void masca_add_rcvr_que(struct scsi_cmnd *scmdp, bool evtflag);
extern void masca_rmv_rcvr_que(struct masca_rcvr *cmd_evt);
extern struct masca_rcvr *masca_get_rcvr_que_indx(int repid);
extern void masca_set_recvr_waitcondition(unsigned char evt);
extern struct masca_configuration     masca_config;
int initialize_masca_receiver(void);
int deinitialize_masca_receiver(void);
void masca_handle_scsi_cmd(struct masca_rcvr *rcvr);
void process_statmsg(void);
void process_event(int flag_pattern);

#endif /* __MASCA_SCSI_HANDLER_H_ */
