/*
 * Header file to export API's to Encode/Decode - masca Command/Message.
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_INTERPRETER_I_H
#define MASCA_INTERPRETER_I_H

#include "linux/bitops.h"
#include "masca_common_types.h"
#include "masca_drv_mngr.h"

#define BIT_BYTE_INVALID		0xFF

#define MAX_DRIVE_DECODE_MSG	100
#define MAX_REJECT_CMDS		2
#define COMMAND_MAX_LENGTH	11

/* CD drive track text response messgages parameter_1::bit
 * enumerator assignment = (Parameter_no * 8 bit) + Param_bit_pos(bit0-7) */
enum track_text_info {
	TEXT_NAME = (1 * 8) + 0,
	TEXT_AUTHOR,
	TEXT_ALBUM,
	TEXT_DIR_NAME,
	TEXT_FILE_NAME
};

/* CD drive status message
 * enumerator assignment = (Parameter_no * 8 bit) + Param_bit_pos(bit0-7) */
enum drive_msg_status {
	/* Drive message status – Parameter_1::bits */
	MSG_STATUS_NO_DISC = (1 * 8) + 0,
	MSG_STATUS_LOADING_ERROR,
	MSG_STATUS_DISC_DEFECT,
	MSG_STATUS_CDROM,
	MSG_STATUS_MULTISESSION,
	MSG_STATUS_IIS_OFF_REQESTED,
	MSG_STATUS_GENERAL_ERROR = (1 * 8) + 7,
	/* Drive message status – Parameter_2::bits */
	MSG_STATUS_REJECT = (2 * 8) + 0,
	MSG_STATUS_DISC_INSERTED,
	MSG_STATUS_EJECT_BUSY,
	MSG_STATUS_INSERT_BUSY,
	MSG_STATUS_READING_CD,
	MSG_STATUS_TOC_READY,
	MSG_STATUS_INIT_READY,
	MSG_STATUS_STOP,
	/* Drive message status – Parameter_3::bits */
	MSG_STATUS_POWER_OFF = (3 * 8) + 0,
	MSG_STATUS_VERSION_ERROR,
	MSG_STATUS_CD_TEXT_AVAIL,
	/* Drive message status – Parameter_4::bits */
	MSG_STATUS_LAST_SESSION = (4 * 8) + 0,
	MSG_STATUS_POWER_FAIL,
	MSG_STATUS_PLAY_MODE,
	MSG_STATUS_PAUSE_MODE,
	MSG_STATUS_SEARCH_MODE,
	MSG_STATUS_TRACK_END,
	MSG_STATUS_CONT_PLAY,
	MSG_STATUS_TOC_ERROR,
	/* Drive message status – Parameter_5::bits */
	MSG_STATUS_FRAME_ERROR = (5 * 8) + 0,
	MSG_STATUS_DSP_INIT_ERROR,
	MSG_STATUS_MUTE_ON = (5 * 8) + 5,
	MSG_STATUS_MULTISESSION_ON,
	MSG_STATUS_DURATION_AVAIL,
	/* Drive message status – Parameter_6::bits */
	MSG_STATUS_IGNORE_AUDIO = (6 * 8) + 0,
	MSG_STATUS_HIGH_ROTATION_ON = (6 * 8) + 3,
	MSG_STATUS_HALF_HIGH_ROTATION,
	/* Drive message status – Parameter_7::bits */
	MSG_STATUS_CM_8_REJECTED = (7 * 8) + 0,
	MSG_STATUS_TEMP_ERROR
};

/* CD drive diagnostic response parameters */
enum diag_response_params {
	diag_res_param1 = 1,
	diag_res_param2,
	diag_res_param3,
	diag_res_param4
};

enum masca_intrptr_decode_msg {
	VERSION_INFO,
	FEATURE_INFO,
	SYS_TOC,
	TRACK_AUDIO,
	TRACK_START,
	TRACK_ATTRIBUTES,
	TRACK_DURATION,
	TRACK_NAME,
	AUTHOR_NAME,
	ALBUM_NAME,
	DIR_NAME,
	FILE_NAME,
	DISC_ABSENT,
	DISC_INSERTING,
	DISC_INSERTED,
	DISC_STOPPED,
	DISC_PLAYING,
	DISC_SEARCHING,
	DISC_PAUSED,
	DISC_EJECTING,
	DISC_IN_SLOT,
	DISC_LOAD_ERROR,
	TOC_READING_IN_PROGRESS,
	TOC_READY,
	TOC_UNREADABLE,
	TRACK_END_NOT_REACHED,
	TRACK_END_REACHED,
	DRIVE_POWER_OK,
	DRIVE_POWER_FAIL,
	TEMPERATURE_OK,
	TEMPERATURE_LIMIT_REACHED,
	PLAY_INFO,
	TRACKS_CD_ROM_ONLY,
	MULTISESSION_PLAYBACK_DISABLED,
	DISC_MULTISESSION,
	DISC_SINGLE_SESSION,
	MULTISESSION_PLAYBACK_ENABLED,
	TRACKS_COPA_AVAILABLE,
	TRACKS_AUDIO_ONLY,
	IIS_OFF_REQUEST,
	DISC_DEFECTIVE,
	DISC_NOT_DEFECTIVE,
	DRIVE_MECHANICAL_FAILURE,
	COMMAND_ACCEPTED,
	COMMAND_REJECTED,
	MECHANICAL_INIT_PENDING,
	MECHANICAL_INIT_COMPLETE,
	DRIVE_POWEROFF_NOT_ALLOWED,
	DRIVE_POWEROFF_ALLOWED,
	HW_SW_VERSIONS_COMPATIBLE,
	HW_SW_VERSIONS_INCOMPATIBLE,
	CD_TEXT_UNAVAILABLE,
	CD_TEXT_AVAILABLE,
	ID3_TITLE_AVAILABLE,
	ID3_TITLE_UNAVAILABLE,
	ID3_ALBUM_AVAILABLE,
	ID3_ALBUM_UNAVAILABLE,
	ID3_AUTHOR_AVAILABLE,
	ID3_AUTHOR_UNAVAILABLE,
	DIR_NAME_AVAILABLE,
	DIR_NAME_UNAVAILABLE,
	FILE_NAME_AVAILABLE,
	FILE_NAME_UNAVAILABLE,
	LAST_SESSION_READABLE,
	LAST_SESSION_UNREADABLE,
	DISC_PLAYMODE_CONTINOUS,
	DISC_PLAYMODE_NON_CONTINOUS,
	BLOCK_READABLE,
	BLOCK_UNREADABLE,
	AUDIO_READABLE,
	AUDIO_UNREADABLE_5S,
	DSP_INIT_SUCCESSFUL,
	DSP_INIT_FAILURE,
	DISC_COPA_UNSUPPORTED,
	DISC_COPA_SUPPORTED,
	WMA_PLAYBACK_ENABLED,
	WMA_PLAYBACK_DISABLED,
	DRIVE_IN_SPI_MODE,
	DRIVE_IN_I2S_MODE,
	MUTE_ON,
	MUTE_OFF,
	TRACK_DURATION_AVAILABLE,
	TRACK_DURATION_UNAVAILABLE,
	AUDIO_TRACKS_IGNORED,
	AUDIO_TRACKS_CONSIDERED,
	WMA_TRACKS_AVAILABLE,
	WMA_TRACKS_UNAVAILABLE,
	PLAYLIST_AVAILABLE,
	PLAYLIST_UNAVAILABLE,
	DRIVE_SPEED_HIGH,
	DRIVE_SPEED_1X,
	DRIVE_SPEED_HALF_MAXIMUM,
	PLAYLIST_ANALYSIS_IN_PROGRESS,
	PLAYLIST_ANALYSIS_DONE,
	AAC_PLAYBACK_DISABLED,
	AAC_PLAYBACK_ENABLED,
	AAC_TRACKS_AVAILABLE,
	AAC_TRACKS_UNAVAILABLE,
	DISC_8CM_SUPPORTED,
	DISC_8CM_UNSUPPORTED,
	DIAG_TEMPERATURE,
	DIAG_LASER_CURRENT,
	DIAG_SWITCH_STATUS,
	DIAG_ADJUSTMENT,
	DIAG_C1C2_ERR_COUNT_ON,
	DIAG_CD_TEXT_OFF,
	DIAG_CD_TEXT_MODE2,
	DIAG_CMD_RECEVIED,
	DIAG_TIME_READOUT,
	DIAG_EJECT_LOAD_CYCLES,
	DIAG_JUMP_COUNTER,
	DIAG_EEPROM_READOUT,
	DIAG_WRITE_STICKER,
	DIAG_READ_STICKER,
	DIAG_JITTER_MEASURE,
	DIAG_VERTICAL_DEV_MEASURE,
	DIAG_ECCENTRIC_MEASURE,
	DIAG_REFLECTIVE_MEASURE,
	DIAG_INTERNAL_SELF_TEST,
	DIAG_EXTERNAL_SDRAM_TEST,
	DIAG_INIT_LASER_CURRENT,
	DIAG_NUM_READ_ERRS,
	DIAG_DATE_PRODUCTION_READ,
	DIAG_DATE_INSTALL_WRITE,
	DIAG_DATE_INSTALL_READ,
	DIAG_SERIAL_NO_READ,
	DIAG_STATUS_MSG_ERR_HISTROY,
	DIAG_STATUS_MSG_LAST_ERRS,
	DIAG_USED_CD_TYPE_COUNT,
	DIAG_USER_PROFILE_USED_CDS,
	MESSAGE_MAX
};

enum masca_drv_msg {
	MSG_STATUS,
	MSG_PLAY_POSITION,
	MSG_TRACK_DATA,
	MSG_TRACK_TEXT,
	MSG_TRACK_INFO,
	MSG_TOC_DATA,
	MSG_VERSION_INFO,
	MSG_TEMPERATURE,
	MSG_LASER_CURRENT,
	MSG_SWITCH_STATUS,
	MSG_ADJUSTMENT,
	MSG_C1C2_ERR_COUNT_ON,
	MSG_CMD_RECEVIED,
	MSG_TIME_READOUT,
	MSG_EJECT_LOAD_CYCLES,
	MSG_JUMP_COUNTER,
	MSG_EEPROM_READOUT,
	MSG_WRITE_STICKER,
	MSG_READ_STICKER,
	MSG_JITTER_MEASURE,
	MSG_VERTICAL_DEV_MEASURE,
	MSG_ECCENTRIC_MEASURE,
	MSG_REFLECTIVE_MEASURE,
	MSG_INTERNAL_SELF_TEST,
	MSG_EXTERNAL_SDRAM_TEST,
	MSG_INIT_LASER_CURRENT,
	MSG_NUM_READ_ERRS,
	MSG_DATE_PRODUCTION_INSTALL_READ,
	MSG_SERIAL_NO_READ,
	MSG_STATUS_MSG_ERR_HISTROY,
	MSG_STATUS_MSG_LAST_ERRS,
	MSG_USED_CD_TYPE_COUNT,
	MSG_USER_PROFILE_USED_CDS,
	MSG_MAX
};

/*!!!!!!!!!!!!!!!!!!!!CAUTION!!!!!!!!!!!!!!!!!!!!!!!*/
/*if you change the position of below enums make    */
/*sure to match with respective masca_commands array*/
/*in msg_interpreter.c                              */
/*!!!!!!!!!!!!!!!!!!!!CAUTION!!!!!!!!!!!!!!!!!!!!!!!*/
enum masca_intrptr_cmd {
	CMD_VERSION_INFO = 0,
	CMD_FEATURE_INFO,
	CMD_SYS_STAT,
	CMD_SYS_TOC,
	CMD_MULTISESSION_ON,
	CMD_MULTISESSION_OFF,
	CMD_IIS_SW_OFF_DISABLE,
	CMD_IIS_SW_OFF_ENABLE,
	CMD_TRACK_AUDIO,
	CMD_TRACK_START,
	CMD_POWER_DOWN,
	CMD_CLEAR_RAM,
	CMD_EN_IGN_AUDIO,
	CMD_DIS_IGN_AUDIO,
	CMD_TRACK_NAME,
	CMD_AUTHOR_NAME,
	CMD_ALBUM_NAME,
	CMD_TRACK_DURATION,
	CMD_TRACK_ATTRIBUTES,
	CMD_PAUSE_MUTE,
	CMD_PAUSE,
	CMD_STOP,
	CMD_SEARCH_FWD,
	CMD_SEARCH_BWD,
	CMD_FAST_SEARCH_FWD,
	CMD_FAST_SEARCH_BWD,
	CMD_INSERT,
	CMD_EJECT,
	CMD_PLAY,
	CMD_PLAY_CONTINUOUS,
	CMD_PLAY_CONTINUOUS_HALFMAX,
	CMD_PLAY_CONTINUOUS_MAX,
	CMD_CONTINOUS,
	CMD_PLAY_NON_CONTINUOUS,
	CMD_DRIVE_HIGH_SPEED,
	CMD_DRIVE_HALF_MAXSPEED,
	CMD_RESUME,
	CMD_GET_TEMPERATURE,
	CMD_GET_LASER_CURRENT,
	CMD_GET_SWITCH_STATUS,
	CMD_ADJUSTMENT,
	CMD_C1C2_ERR_COUNT_ON,	/*40*/
	CMD_CD_TEXT_OFF,
	CMD_CD_TEXT_MODE2,
	CMD_TIME_READOUT,
	CMD_EJECT_LOAD_CYCLES,
	CMD_JUMP_COUNTER,
	CMD_EEPROM_READOUT,
	CMD_WRITE_STICKER,
	CMD_READ_STICKER,
	CMD_JITTER_MEASURE,
	CMD_VERTICAL_DEV_MEASURE,/*50*/
	CMD_ECCENTRIC_MEASURE,
	CMD_REFLECTIVE_MEASURE,
	CMD_INTERNAL_SELF_TEST,
	CMD_EXTERNAL_SDRAM_TEST,
	CMD_INIT_LASER_CURRENT,
	CMD_NUM_READ_ERRS,
	CMD_DATE_PRODUCTION_READ,
	CMD_DATE_INSTALL_WRITE,
	CMD_DATE_INSTALL_READ,
	CMD_SERIAL_NO_READ,	/*60*/
	CMD_STATUS_MSG_ERR_HISTROY,
	CMD_STATUS_MSG_LAST_ERRS,
	CMD_USED_CD_TYPE_COUNT,
	CMD_USER_PROFILE_USED_CDS,
	CMD_MAX
};

struct masca_intrptr_cmd_info {
	enum masca_intrptr_cmd command;
	unsigned char dir_number;
	unsigned char track_number;
	unsigned char minute;
	unsigned char second;
	unsigned char frame;
	unsigned char block_count;
	unsigned char date_write_sticker[DIAG_CMD_WIRTE_STICKER];
	unsigned int instll_dat_write;
};

/* MSG Mode1_Data parameters */
enum msg_mode1_data {
	MODE1_ADR_CTRL = 1,
	MODE1_TRK_NO,
	MODE1_IDX_INFO,
	MODE1_MIN,
	MODE1_SEC,
	MODE1_ABS_MIN,/*Absolute minute*/
	MODE1_ABS_SEC /*Absolute second*/
};

/* MSG Track data parameters */
enum msg_track_data {
	TRK_ADR_CTRL = 1,
	TRK_TRK_NO,
	TRK_MIN,
	TRK_SEC
};

/* MSG Track Text parameters */
enum msg_track_text {
	TXT_NAME = 1,
	TXT_CODE,
	TXT_DIR_NO,
	TXT_TRK_NO,
	TXT_INFO
};

/* MSG Track info parameters */
enum msg_track_info {
	TRK_INFO_1 = 1,
	TRK_INFO_2,
	TRK_INFO_DIR,
	TRK_INFO_TRK_NO,
	TRK_INFO_MIN,
	TRK_INFO_SEC
};

/* MSG TOC-Data parameters */
enum msg_toc_data {
	TOC_MIN_TRK_NO = 1,
	TOC_MAX_TRK_NO,
	TOC_TOTAL_MIN,
	TOC_TOTAL_SEC,
	TOC_LAST_TRK_MIN,
	TOC_LAST_TRK_SEC,
	TOC_LAST_TRK_FRM
};

/* MSG Version parameters */
enum msg_version {
	VER_SOFT_NO = 1,
	VER_HARD_NO,
	VER_FEATURE
};
#define VENDOR_ID_MASK 0x03 /* typecast 2 lower bits for Vendor id */

struct masca_intrptr_msg_info_list {
	enum masca_intrptr_decode_msg decoded_messages[MAX_DRIVE_DECODE_MSG];
	enum masca_drv_msg	msg_group;
	unsigned char		num_of_msgs;
};

struct masca_intrptr_rjt_cmd_list {
	enum masca_intrptr_cmd reject_cmds[MAX_REJECT_CMDS];
	unsigned char num_of_rejected_cmds;
};

struct masca_intrptr_version_info {
	unsigned char vendors_id;
	unsigned char sw_version;
	unsigned char hw_version;
};

struct masca_intrptr_sys_toc {
	unsigned char minimum_track_num;
	unsigned char maximum_track_num;
	unsigned char max_cd_min;
	unsigned char max_cd_sec;
	unsigned char last_toc_min;
	unsigned char last_toc_sec;
	unsigned char last_toc_frame;
};

struct masca_intrptr_track_info {
	unsigned char adr_control;
};

struct masca_intrptr_track_start {
	unsigned char track_number;
	unsigned char start_min;
	unsigned char start_sec;
};

/*Currently these parameters are not used*/
struct masca_intrptr_track_attribute {
	unsigned short	bit_rate;
	unsigned char	audio_mode;
	unsigned char	sampling_rate;
};

struct masca_intrptr_track_duration {
	unsigned char directory_num;
	unsigned char trk_num;
	unsigned char duration_minutes;
	unsigned char duration_seconds;
};

struct masca_intrptr_track_text {
	const unsigned char *p_name;
	unsigned char name_length;
	unsigned char dir_number;
	unsigned char track_number;
	unsigned char char_encoding;
};

struct masca_intrptr_track_play_pos {
	unsigned char track_num;
	unsigned char track_subindex;
	unsigned char min_relative;
	unsigned char sec_relative;
	unsigned char min_absolute;
	unsigned char sec_absolute;
};

struct masca_intrptr_drv_feature {
	bool has_MP3_support;
	bool has_wma_support;
	bool has_aac_support;
	bool has_esp_memory_support;
	bool has_playlist_functionality;
};

/* drive feature::bit
 * enumerator assignment = (Parameter_no * 8 bit) + Param_bit_pos(bit0-7) */
enum drive_feature {
	VER_FEATURE_PLAYLIST = (3 * 8) + 3,
	VER_FEATURE_ESP,
	VER_FEATURE_AAC,
	VER_FEATURE_WMA,
	VER_FEATURE_MP3
};

struct masca_intrptr_diag_msg_list {
	unsigned char  drv_cmd_recevied;
	unsigned char  drv_laser_current[MAX_LASER_CUR_SIZE];
	struct masca_adjustment drv_diag_adjust;
	unsigned char  drv_c1c2_err_count[MAX_C1C2_ERR_CNT_SIZE];
	unsigned char  drv_temperature[MAX_TEMPERATURE_SIZE];
	unsigned char  drv_switch_status;
	unsigned char  drv_time_readout[MAX_DIAG_TIME_READOUT_SIZE];
	unsigned char  drv_eject_load_cycles[MAX_EJT_LD_CYC_SIZE];
	struct masca_jump_counter drv_jump_cnt;
	unsigned char  drv_eeprom_readout[MAX_EEPROM_READOUT_SIZE];
	unsigned char  drv_write_sticker_no[MAX_WRITE_STICKER_SIZE];
	unsigned char  drv_read_sticker_no[MAX_READ_STICKER_SIZE];
	unsigned char  drv_jitter_measure;
	unsigned char  drv_vertical_dev_measure[MAX_VER_DEV_SIZE];
	unsigned char  drv_eccentric_measure[MAX_ECCENTRICITY_SIZE];
	unsigned char  drv_reflective_measure;
	unsigned char  drv_internal_self_test;
	unsigned char  drv_external_sdram_test;
	unsigned char  drv_init_laser_current[MAX_INTI_LASER_CUR_SIZE];
	unsigned char  drv_num_read_errs[MAX_NO_READ_ERRS_SIZE];
	unsigned char  drv_date_product_install_read
						[MAX_DATE_PROD_INSTALL_SIZE];
	unsigned char  drv_serial_no_read[MAX_SERIAL_NO_SIZE];
	unsigned char  drv_status_msg_err_histroy[MAX_MSG_ERR_HIS_SIZE];
	unsigned char  drv_status_msg_last_errs[MAX_MSG_LAST_ERRS_SIZE];
	unsigned char  drv_used_cd_type_cnt[MAX_CD_TYPE_CNT_SIZE];
	unsigned char  drv_user_profile_used_cds[MAX_PROFIL_USED_CD_SIZE];
};

union masca_intrptr_decode_info {
	struct masca_intrptr_track_play_pos    play_pos;
	struct masca_intrptr_sys_toc           sys_toc;
	struct masca_intrptr_track_info        track_info;
	struct masca_intrptr_track_start       track_start;
	struct masca_intrptr_track_attribute   track_attr;
	struct masca_intrptr_track_duration    track_length;
	struct masca_intrptr_track_text        track_text;
	struct masca_intrptr_version_info      ver_info;
	struct masca_intrptr_drv_feature       feature_info;
	struct masca_intrptr_rjt_cmd_list      reject_cmds;
	struct masca_intrptr_diag_msg_list     diag_info;
};

struct masca_intrptr_msg_info {
	unsigned char *p_buffer;
	unsigned char msg_length;
};

extern bool is_multisession_on;

extern void masca_intrptr_init(const struct
				masca_configuration * const p_config);

extern void masca_intrptr_deinit(void);

extern enum masca_error
masca_intrptr_decode_msg_info(const enum masca_intrptr_decode_msg decoded_msg,
			union masca_intrptr_decode_info * const p_decode_info,
			const struct masca_intrptr_msg_info * const p_msg);

extern enum masca_error masca_intrptr_decode_msg_list(
			struct masca_intrptr_msg_info_list * const p_msg_info,
			const struct masca_intrptr_msg_info * const p_msg);

extern enum masca_error
masca_intrptr_encode_cmd(const struct masca_intrptr_cmd_info * const p_cmd_info,
			 unsigned char * const p_encode_buffer,
			 unsigned char * const p_length);

#endif /*end of MASCA_INTERPRETER_I_H*/

