/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef __MASCA_DMA_H_
#define __MASCA_DMA_H_

#include <linux/version.h>
#include <linux/dma-mapping.h>
#include <linux/kthread.h>
#include <linux/platform_data/dma-imx.h>

#define FRAME_SZ	(2352)
#define PERIOD_SZ	(6)
#define DMA_PERIOD_SZ	(6 * FRAME_SZ)
#define DMA_NUM_PERIODS	(128)
#define DMA_BUF_SZ	(DMA_PERIOD_SZ * DMA_NUM_PERIODS)
#define DMA_MAX_FRAMES	(DMA_NUM_PERIODS * PERIOD_SZ)

struct dma_cycle_config {
	unsigned int		dma_period_size;
	unsigned int		num_periods;
	dma_addr_t		dma_paddr;
	char			*dma_vaddr;
	dma_async_tx_callback	callback;
};

struct dma_mode_config {
	struct imx_dma_data	data;
	struct dma_slave_config slave;
	struct dma_cycle_config cyclic;
};

struct dma_mgr {
	bool init;
	dma_cookie_t cookie;
	struct dma_chan *chan;
	struct dma_async_tx_descriptor *desc;
	void (*blk_evnt_clbk)(const unsigned char evt_pattern);
	void (*data_evnt_clbk)(const unsigned char evt_pattern);
};

struct buf_water_mark {
	unsigned int pro_st_sct;	/*processed start sector*/
	unsigned int pro_st_idx;	/*processed start sector index*/
	unsigned int pro_end_sct;	/*processed end sector*/
	unsigned int pro_end_idx;	/*processed start sector index*/

	unsigned int unpro_end_sct;	/*unprocessed end sector index*/
};

struct dma_buffer {
	unsigned char	*buf;
	atomic_t	rd_idx;
	atomic_t	wr_idx;
	struct buf_water_mark  wmark;
	spinlock_t	lock;
	unsigned int	cb_cnt;
	bool		prefetch;
};

extern int masca_dma_start(void);
extern int masca_dma_stop(void);
extern int masca_dma_init(void);
extern int masca_dma_deinit(void);
extern struct dma_buffer *masca_dma_get_buffer(void);
extern void masca_dma_set_clbks(void (*blk_clbk)
				(const unsigned char evt_pattern));
extern void mascassi_dma_init_buf_idx(void);

#endif /* __MASCA_DMA_H_ */
