/*
 * masca_blkdev.h file exports API's to copy data/sense buffer to scsi.
 * Also provides API's to set/clear internal events.
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef __MASCA_BLKDEV_H_
#define __MASCA_BLKDEV_H_

#include <scsi/scsi_cmnd.h>
#include <scsi/scsi_device.h>
#include <scsi/scsi_host.h>
#include "masca_common_types.h"

/* Update Sense keys asynchronously */
#define SENSE_VOLT_ERR		0x01
#define SENSE_TEMP_ERR		0x02
#define SENSE_LOAD_ERR		0x04
#define SENSE_TOC_ERR		0x08
#define SENSE_CDEND_ERR		0x10
#define SENSE_DRIVER_ERR	0x20
#define SENSE_DRIVE_ERR		0x40
#define SENSE_DISC_ERR		0x80
#define SENSE_UNKNOWNFORM_ERR	0x100
#define SENSE_DRV_DISCONNECT	0x200

#define ROOT_DEVICE_NAME "masca"

int masca_scsi_init(void);
int masca_scsi_deinit(void);

struct scsi_queued_cmd {

	struct scsi_cmnd *a_cmnd;
	int scsi_result;
};

struct masca_sense_info {
	char key;
	char asc;
	char ascq;
};

struct masca_sense_buf {
	bool is_sense_buf_free;
	struct masca_sense_info sense_info;
};

int schedule_resp(struct scsi_cmnd *cmnd,
			void (*done)(struct scsi_cmnd *), int scsi_result,
			int delta_jiff);
void masca_fill_scsi_buffer(struct scsi_cmnd *scp, void *arr, int arr_len);
void masca_update_global_sense_buffer(char key, char asc, char ascq);
int masca_get_cmdindx(void);
struct scsi_queued_cmd *masca_scsicmd_get_queue(int index);
void masca_fill_sense_buffer(struct scsi_cmnd *scp, struct masca_sense_info si);
struct masca_sense_buf masca_get_global_sense_buff(void);
struct masca_sense_info masca_get_sense_value(int err);
void masca_set_async_sense(int sense);
void masca_clr_async_sense(int sense);
enum masca_error masca_check_async_sense(void);
enum masca_error masca_resp_sense(struct scsi_cmnd *scp);

#endif /* __MASCA_BLKDEV_H_ */
