/*
 * masca_atapi_bridge.h file exports API's to map scsi commands to
 * internal commands.
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_ATAPI_BRIDGE_I_H
#define MASCA_ATAPI_BRIDGE_I_H

#define ATAPI_DEVICE_RESET	0x08/* Device reset */
#define PHERIPHERAL_TYPE_CDROM	0x05

#define FIRST_TRK_LAST_TRK_NUM	2
#define TRACK_TOC_SZ	8
#define LEAD_OUT_SZ	8
#define TOC_DATA_LENGTH 2
#define LEAD_OUT_BUFF_LEN 12
#define VENDOR_ID_SIZE		8
#define PRODUCT_ID_SIZE		16
#define PROD_REV_LEVEL		4

struct masca_drive_info {
	unsigned char peripheral_device_type; /* resp[0]*/
	unsigned char rmb;
	unsigned char iso_version;
	unsigned char atapi_version;
	unsigned char additional_length;
	unsigned char reserved_1[3];
	unsigned char  vendor_id[VENDOR_ID_SIZE];/* T10 VENDOR IDENTIFICATION */
	unsigned char  product_id[PRODUCT_ID_SIZE];/* PRODUCT IDENTIFICATION */
	unsigned char  prod_rev_level[PROD_REV_LEVEL]; /* PRODUCT REV LEVEL*/
};

enum masca_error masca_atapi_decode(
			const struct masca_output * const output,
			struct masca_cmd_params * const p_decode_params);

enum masca_error
masca_atapi_convert_cd_text(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					unsigned int buf_length);

enum masca_error
masca_atapi_convert_toc(const struct masca_output * const p_output,
					unsigned char * const p_buff,
					unsigned int buf_length);

enum masca_error
masca_atapi_convert_session_info(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					unsigned int buf_length);

enum masca_error
masca_atapi_convert_inquiry(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					unsigned int buf_length);

enum masca_error
masca_atapi_convert_read_capacity(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					const unsigned int buf_length);

enum masca_error
masca_atapi_convert_media_stat(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					const unsigned int buf_length);
enum masca_error
masca_log_sense_get_temp(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					unsigned int buf_length);
enum masca_error
masca_read_disk_info(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					const unsigned int buf_length);
enum masca_error
masca_send_diagnostic(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					const unsigned int buf_length);
enum masca_error
masca_receive_diagnostic(const struct masca_output * const p_output,
					unsigned char * const p_buffer,
					const unsigned int buf_length);

extern struct masca_drive_info version_info;
extern unsigned char *g_app_buf;
extern unsigned char *spi_hist_buff;
#endif/*end of MASCA_ATAPI_BRIDGE_I_H*/
