/*
 * Copyright (c) 2012-2014 Mentor Graphics Inc.
 * Copyright 2004-2011 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

/*!
 * @file ipu_prp_sw.h
 *
 * @brief This file contains the IPU PRP use case driver header.
 *
 * @ingroup IPU
 */

#ifndef _INCLUDE_IPU__PRP_SW_H_
#define _INCLUDE_IPU__PRP_SW_H_

int prp_still_init(struct mx6_camera_dev *cam);
void prp_still_exit(struct mx6_camera_dev *cam);
int prp_still_select(struct mx6_camera_dev *cam);
int prp_still_deselect(struct mx6_camera_dev *cam);

int csi_enc_init(struct mx6_camera_dev *cam);
void csi_enc_exit(struct mx6_camera_dev *cam);
int csi_enc_select(struct mx6_camera_dev *cam);
int csi_enc_deselect(struct mx6_camera_dev *cam);

int prp_enc_init(struct mx6_camera_dev *cam);
void prp_enc_exit(struct mx6_camera_dev *cam);
int prp_enc_select(struct mx6_camera_dev *cam);
int prp_enc_deselect(struct mx6_camera_dev *cam);

int prp_vf_sdc_init(struct mx6_camera_dev *cam);
void prp_vf_sdc_exit(struct mx6_camera_dev *cam);
int prp_vf_sdc_select(struct mx6_camera_dev *cam);
int prp_vf_sdc_deselect(struct mx6_camera_dev *cam);
int prp_vf_sdc_select_bg(struct mx6_camera_dev *cam);
int prp_vf_sdc_deselect_bg(struct mx6_camera_dev *cam);

#endif
