#ifndef _ASM_UPROBES_H
#define _ASM_UPROBES_H
/*
 * user-space probes (uprobes) for ARM
 *
 * Copyright (C) 2012, 2013 Torsten Polle
 *
 * Based on ARM kprobes which is
 * Copyright (C) 2011 Jon Medhurst <tixy@yxit.co.uk>.
 * Copyright (C) 2006, 2007 Motorola Inc.
 *
 * and SystemTap uprobe which is
 * Copyright (C) 2011 Mentor Graphics Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <linux/notifier.h>

/* TBD */
#define CONFIG_URETPROBES 1

typedef u32 uprobe_opcode_t;
#define UPROBE_SWBP_INSN          0xe7ffdefe
#define UPROBE_SWBP_INSN_SIZE		   4

#define BP_INSN_SIZE 4
#define MAX_UINSN_BYTES 8

#define UPROBE_XOL_SLOT_BYTES		 32	/* to keep it cache aligned */

#define BREAKPOINT_SIGNAL SIGILL
#define SSTEP_SIGNAL SIGILL

/* Architecture specific switch for where the IP points after a bp hit */
#define ARCH_BP_INST_PTR(inst_ptr)	(inst_ptr)

struct arch_uprobe;

typedef void (uprobe_insn_handler_t)(struct arch_uprobe *, struct pt_regs *);
typedef unsigned long (uprobe_check_cc)(unsigned long);
typedef void (uprobe_insn_fn_t)(void);

struct arch_uprobe {
	uprobe_opcode_t                  opcode;
	union {
		u8              insn[MAX_UINSN_BYTES];
		uprobe_opcode_t _insn[MAX_UINSN_BYTES/sizeof(uprobe_opcode_t)];
	};
	uprobe_insn_handler_t		*insn_handler;
	uprobe_check_cc			*insn_check_cc;
	uprobe_insn_fn_t		*insn_fn;
};

struct arch_uprobe_task {
};

extern int  arch_uprobe_analyze_insn(struct arch_uprobe *aup,
				     struct mm_struct *mm,
				     unsigned long addr);
extern int  arch_uprobe_pre_xol(struct arch_uprobe *aup, struct pt_regs *regs);
extern int  arch_uprobe_post_xol(struct arch_uprobe *aup, struct pt_regs *regs);
extern bool arch_uprobe_xol_was_trapped(struct task_struct *tsk);
extern int  arch_uprobe_exception_notify(struct notifier_block *self,
					 unsigned long val,
					 void *data);
extern void arch_uprobe_abort_xol(struct arch_uprobe *aup,
				  struct pt_regs *regs);
extern unsigned long
arch_uretprobe_hijack_return_addr(unsigned long rp_trampoline_vaddr,
				  struct pt_regs *regs);

static inline unsigned long
arch_uretprobe_predict_sp_at_return(struct pt_regs *regs)
{
	return regs->ARM_sp;
}

static inline unsigned long arch_uretprobe_get_sp(struct pt_regs *regs)
{
	return regs->ARM_sp;
}

#endif	/* _ASM_UPROBES_H */
