/*
 * Copyright (C) 2013 Mentor Graphics Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Module Name:    mfw_gst_drm_plane.h
 *
 * Description:    Declaration of DRM Plane FB operations.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */

/*
 * Changelog:
 *
 */

/*=============================================================================
                                INCLUDE FILES
=============================================================================*/

#ifndef _MFW_GST_DRM_PLANE_H_
#define _MFW_GST_DRM_PLANE_H_

#include <gst/gst.h>

typedef struct drm_plane_priv drm_plane_priv_t;

drm_plane_priv_t *mfw_gst_drm_plane_init(void);
void mfw_gst_drm_plane_release(drm_plane_priv_t *priv);
gboolean mfw_gst_drm_plane_open(drm_plane_priv_t *priv, gchar *disp_type,
				gint min_xres, gint min_yres);
gboolean mfw_gst_drm_plane_close(drm_plane_priv_t *priv);
gboolean mfw_gst_drm_plane_set_global_alpha(drm_plane_priv_t *priv,
					    gint alphaVal,
					    gboolean enable);
gboolean mfw_gst_drm_plane_set_colorkey(drm_plane_priv_t *priv,
					gulong *colorSrc,
					gboolean enable);
gboolean mfw_gst_drm_plane_get_bounds(drm_plane_priv_t *priv,
				      gint *fullscreen_width,
				      gint *fullscreen_height);
gboolean mfw_gst_drm_plane_setup(drm_plane_priv_t *priv,
				 gboolean v4l_output,
				 gint v4l_id,
				 struct v4l2_crop *crop);

#endif	/* _MFW_GST_DRM_PLANE_H_ */
