
message("Configuring FreeType 2.")

#create proper place for configuration files

set(PRV_GENERATED_SRC_ROOT_DIR "${PUB_CGI_BINARY_ROOT_DIR}/gensrc")
file(MAKE_DIRECTORY ${PRV_GENERATED_SRC_ROOT_DIR})
set(PRV_GENERATED_FREETYPE2_DIR "${PRV_GENERATED_SRC_ROOT_DIR}/FreeType2Gen")
file(MAKE_DIRECTORY ${PRV_GENERATED_FREETYPE2_DIR})

#locate template files

set(PRV_TEMPLATE_FREETYPE2_DIR "${PUB_CGI_CANDERA_PATH}/Candera/TextEngine/Freetype/")

CgiAddIncludeDirs("${PRV_GENERATED_FREETYPE2_DIR}")

SET(FREETYPE2_FORCE_EMPTY_CONFIG OFF CACHE BOOL "Reset all configuration flags.")
SET(FREETYPE2_FORCE_LIGHT_CONFIG OFF CACHE BOOL "Set configuration flags to a light configuration using only TrueType fonts (target 40k lib).")
SET(FREETYPE2_FORCE_DEFAULT_CONFIG OFF CACHE BOOL "Set configuration to FreeType2 default.")
SET(FREETYPE2_FORCE_CANDERA_CONFIG OFF CACHE BOOL "Set configuration to Candera default.")

if(NOT DEFINED FREETYPE2_OPT_FT_RENDER_POOL_SIZE)
    include("empty_config.cmake")
endif(NOT DEFINED FREETYPE2_OPT_FT_RENDER_POOL_SIZE)

if(FREETYPE2_FORCE_EMPTY_CONFIG)
    include("empty_config.cmake")
endif(FREETYPE2_FORCE_EMPTY_CONFIG)

if(FREETYPE2_FORCE_LIGHT_CONFIG)
    include("light_config.cmake")
endif(FREETYPE2_FORCE_LIGHT_CONFIG)

if(FREETYPE2_FORCE_DEFAULT_CONFIG)
    include("default_config.cmake")
endif(FREETYPE2_FORCE_DEFAULT_CONFIG)

if(FREETYPE2_FORCE_CANDERA_CONFIG)
    include("candera_config.cmake")
endif(FREETYPE2_FORCE_CANDERA_CONFIG)

include("variable_map.cmake")


SET(FREETYPE2_FORCE_EMPTY_CONFIG OFF CACHE BOOL "Reset all configuration flags." FORCE)
SET(FREETYPE2_FORCE_LIGHT_CONFIG OFF CACHE BOOL "Set configuration flags to a light configuration using only TrueType fonts (target 40k lib)." FORCE)
SET(FREETYPE2_FORCE_DEFAULT_CONFIG OFF CACHE BOOL "Set configuration to FreeType2 default." FORCE)
SET(FREETYPE2_FORCE_CANDERA_CONFIG OFF CACHE BOOL "Set configuration to Candera default." FORCE)


configure_file(
	"${PRV_TEMPLATE_FREETYPE2_DIR}/FtCdaCustomOptions.h.template" 
	"${PRV_GENERATED_FREETYPE2_DIR}/FtCdaCustomOptions.h")
configure_file(
	"${PRV_TEMPLATE_FREETYPE2_DIR}/FtCdaCustomModules.h.template" 
	"${PRV_GENERATED_FREETYPE2_DIR}/FtCdaCustomModules.h")
configure_file(
	"${PRV_TEMPLATE_FREETYPE2_DIR}/FtCdaCustomSystem.h.template"
	"${PRV_GENERATED_FREETYPE2_DIR}/FtCdaCustomSystem.h")
configure_file(
	"${PRV_TEMPLATE_FREETYPE2_DIR}/FtCdaCustomConfig.h.template"
	"${PRV_GENERATED_FREETYPE2_DIR}/FtCdaCustomConfig.h")
