/*
* Copyright (c) 1997
* Silicon Graphics Computer Systems, Inc.
*
* Permission to use, copy, modify, distribute and sell this software
* and its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and
* that both that copyright notice and this permission notice appear
* in supporting documentation.  Silicon Graphics makes no
* representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
*/

#ifndef __STL_SGI_STDEXCEPT
#define __STL_SGI_STDEXCEPT

//__STL_BEGIN_NAMESPACE
namespace bpstl
{

   class logic_error : public exception
   {
   public:
      logic_error(tU32 u32Error = 0)
         : exception("logic_error", u32Error)
      {
         oThisType.pParent = &exception::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }
      logic_error(const tChar* coszDescription, tU32 u32Error = 0)
         : exception(coszDescription, u32Error)
      {
         oThisType.pParent = &exception::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }

      static tclTypeInfo* poGetClassTypeInfo()
      { /*lint !e1511*//* hiding the member of base class is the trick behind the rtti emulation */
         return &oThisType;
      }

   protected:
      virtual tclTypeInfo* poGetTypeInfo()
      {
         return &oThisType;
      }

      static tclTypeInfo oThisType;
   };

   class runtime_error : public exception
   {
   public:
      runtime_error(tU32 u32Error = 0)
         : exception("runtime_error", u32Error)
      {
         oThisType.pParent = &exception::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }
      runtime_error(const tChar* coszDescription, tU32 u32Error = 0)
         : exception(coszDescription, u32Error)
      {
         oThisType.pParent = &exception::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }

      static tclTypeInfo* poGetClassTypeInfo()
      { /*lint !e1511*//* hiding the member of base class is the trick behind the rtti emulation */
         return &oThisType;
      }

   protected:
      virtual tclTypeInfo* poGetTypeInfo()
      {
         return &oThisType;
      }

      static tclTypeInfo oThisType;
   };

   class invalid_argument : public logic_error
   {
   public:
      invalid_argument(tU32 u32Error = 0)
         : logic_error("invalid_argument", u32Error)
      {
         oThisType.pParent = &logic_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }
      invalid_argument(const tChar* coszDescription, tU32 u32Error = 0)
         : logic_error(coszDescription, u32Error)
      {
         oThisType.pParent = &logic_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }

      static tclTypeInfo* poGetClassTypeInfo()
      { /*lint !e1511*//* hiding the member of base class is the trick behind the rtti emulation */
         return &oThisType;
      }

   protected:
      virtual tclTypeInfo* poGetTypeInfo()
      {
         return &oThisType;
      }

      static tclTypeInfo oThisType;
   };

   class length_error : public logic_error
   {
   public:
      length_error(tU32 u32Error = 0)
         : logic_error("out_of_range", u32Error)
      {
         oThisType.pParent = &logic_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }
      length_error(const tChar* coszDescription, tU32 u32Error = 0)
         : logic_error(coszDescription, u32Error)
      {
         oThisType.pParent = &logic_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }

      static tclTypeInfo* poGetClassTypeInfo()
      { /*lint !e1511*//* hiding the member of base class is the trick behind the rtti emulation */
         return &oThisType;
      }

   protected:
      virtual tclTypeInfo* poGetTypeInfo()
      {
         return &oThisType;
      }

      static tclTypeInfo oThisType;
   };

   class out_of_range : public logic_error
   {
   public:
      out_of_range(tU32 u32Error = 0)
         : logic_error("out_of_range", u32Error)
      {
         oThisType.pParent = &logic_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }
      out_of_range(const tChar* coszDescription, tU32 u32Error = 0)
         : logic_error(coszDescription, u32Error)
      {
         oThisType.pParent = &logic_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }

      static tclTypeInfo* poGetClassTypeInfo()
      { /*lint !e1511*//* hiding the member of base class is the trick behind the rtti emulation */
         return &oThisType;
      }

   protected:
      virtual tclTypeInfo* poGetTypeInfo()
      {
         return &oThisType;
      }

      static tclTypeInfo oThisType;
   };

   class range_error : public runtime_error
   {
   public:
      range_error(tU32 u32Error = 0)
         : runtime_error("range_error", u32Error)
      {
         oThisType.pParent = &runtime_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }
      range_error(const tChar* coszDescription, tU32 u32Error = 0)
         : runtime_error(coszDescription, u32Error)
      {
         oThisType.pParent = &runtime_error::oThisType;
         ERR_M_ASSERT(sizeof(*this) == sizeof(exception)); //lint !e774 hopefully lint is right, otherwise we have a problem
      }

      static tclTypeInfo* poGetClassTypeInfo()
      { /*lint !e1511*//* hiding the member of base class is the trick behind the rtti emulation */
         return &oThisType;
      }

   protected:
      virtual tclTypeInfo* poGetTypeInfo()
      {
         return &oThisType;
      }

      static tclTypeInfo oThisType;
   };

} // _BP_STL_END_NAMESPACE

#endif /* __STL_SGI_STDEXCEPT */

// Local Variables:
// mode:C++
// End:
