/*
 * Copyright (c) 1999
 * Silicon Graphics
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef __STL_RANGE_ERRORS_H
#define __STL_RANGE_ERRORS_H

// A few places in the STL throw range errors, using standard exception
// classes defined in <stdexcept>.  This header file provides functions
// to throw those exception objects.

// __STL_DONT_THROW_RANGE_ERRORS is a hook so that users can disable
// this exception throwing.

#include "stl_config.h"
#include "bp_stdexcept"

_BP_STL_BEGIN_NAMESPACE
inline void __stl_throw_range_error(const tChar* __msg) 
  { _BP_THROW(range_error, __msg); }
inline void __stl_throw_length_error(const tChar* __msg)
  { _BP_THROW(length_error, __msg); }
_BP_STL_END_NAMESPACE

#endif /* __STL_RANGE_ERRORS_H */

// Local Variables:
// mode:C++
// End:
