/*
 * Copyright (c) 1997-1999
 * Silicon Graphics Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef __SGI_STL_MEMORY
#define __SGI_STL_MEMORY

#include "stl_algobase.h"
#include "stl_alloc.h"
#include "stl_construct.h"
#include "stl_tempbuf.h"
#include "stl_uninitialized.h"
#include "stl_raw_storage_iter.h"


_BP_STL_BEGIN_NAMESPACE

template <class _Tp> class auto_ptr {
private:
  _Tp* _M_ptr;

public:
  typedef _Tp element_type;

  explicit auto_ptr(_Tp* __p = 0) _BP_STL_NOTHROW : _M_ptr(__p) {}
  auto_ptr(auto_ptr& __a) _BP_STL_NOTHROW : _M_ptr(__a.release()) {}

  auto_ptr& operator=(auto_ptr& __a) _BP_STL_NOTHROW {
    if (&__a != this) {
      delete _M_ptr;
      _M_ptr = __a.release();
    }
    return *this;
  }

  // Note: The C++ standard says there is supposed to be an empty throw
  // specification here, but omitting it is standard conforming.  Its 
  // presence can be detected only if _Tp::~_Tp() throws, but (17.4.3.6/2)
  // this is prohibited.
  ~auto_ptr() { delete _M_ptr; }

  _Tp& operator*() const _BP_STL_NOTHROW {
    return *_M_ptr;
  }
  _Tp* operator->() const _BP_STL_NOTHROW {
    return _M_ptr;
  }
  _Tp* get() const _BP_STL_NOTHROW {
    return _M_ptr;
  }
  _Tp* release() _BP_STL_NOTHROW {
    _Tp* __tmp = _M_ptr;
    _M_ptr = 0;
    return __tmp;
  }
  void reset(_Tp* __p = 0) _BP_STL_NOTHROW {
    if (__p != _M_ptr) {
      delete _M_ptr;
      _M_ptr = __p;
    }
  }
};

_BP_STL_END_NAMESPACE

#endif /* __SGI_STL_MEMORY */


// Local Variables:
// mode:C++
// End:
