/**************************************************************** +MHDR * .MA *
    
 .FILE            [ExhMacros.h]

 .SW-COMPONENT    [SXL\EXH]

 .DESCRIPTION                                                          
  This file contains the Macros to emulate the c++ exception handling
   
 .AUTOR           [ CM-DI/ENS51 F. Wiedemann                            ]          
 .COPYRIGHT       [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]

 .HISTORY 
   
  Initial revision.
   
**************************************************************** -MHDR * .ME */

// Exception handling with longjmp

#ifndef EXHMACROS_H
#define EXHMACROS_H

#ifdef VARIANT_S_FTR_ENABLE_EXH_EXCEPTIONS

#define TRACE_S_IMPORT_INTERFACE_TRCSTDTEXT
#include <trace_if.h>

#define EXCEPTIONHANDLING "Exception handling: longjmp\n"

// Macro to start a try-block

   /*****************************************************************/
   /* For ADITGen2 based products, eSOL has patched the setjmp.h in */
   /* a way that setjmp is compiled using the namespace 'std'      */
#if VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_STD || VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_NONE
#ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_STD
#define _EXHMACROS_H_SET_JMP  std::setjmp
#endif // #ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_STD
#ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_NONE
#define _EXHMACROS_H_SET_JMP  setjmp
#endif // #ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_NONE
#else
#error you have to define a namespace usage
#endif

   /*****************************************************************/
   /* For ADITGen2 based products, eSOL has patched the setjmp.h in */
   /* a way that setjmp is compiled using the namespace 'std'      */
#define _BP_TRY_BEGIN        {\
                             exh_tclTryContext ReturnMark;\
                             ReturnMark.oTrace.coszFile  = TRC_M_FILE; \
                             ReturnMark.oTrace.cou32Line = TRC_M_LINE; \
                             tBool   bCaught = FALSE;\
                             exh_tclExceptionContext* pECT = exh_GetExceptionContext();\
                             int jmp_ret = _EXHMACROS_H_SET_JMP(ReturnMark.JumpBuffer);\
                             if(!jmp_ret)\
                             {\
                                exh_vSaveJumpMark(pECT, ReturnMark);



// Macro to catch an exception of a certain class
#define _BP_CATCH(excType)         }\
                          else if(TRUE == ((bpstl::exception*)jmp_ret)->bIsOfType(excType::poGetClassTypeInfo()))\
                          {\
                             bCaught = TRUE;

#define _BP_CATCH_OBJ(excType, objName)    }\
                                        else if(TRUE == ((bpstl::exception*)jmp_ret)->bIsOfType(excType::poGetClassTypeInfo()))\
                                        {\
                                           excType objName(*((excType*)jmp_ret));\
                                           bCaught = TRUE;

#define _BP_CATCH_OBJREF(excType, objName) }\
                                        else if(TRUE == ((bpstl::exception*)jmp_ret)->bIsOfType(excType::poGetClassTypeInfo()))\
                                        {\
                                           excType& objName = *((excType*)jmp_ret);\
                                           bCaught = TRUE;

// Macro to catch any exception
#define _BP_CATCH_ALL        }\
                          else\
                          {\
                             bCaught = TRUE;

// Macro to mark the end of a try-block
#define _BP_CATCH_END           }\
                             exh_vCatchEnd(pECT, (bpstl::exception*) jmp_ret, bCaught);\
                          }

// empty definition don't use _RAISE
#define _BP_RAISE(x)         

// Macro to rethrow the current exception
#define _BP_RERAISE		{\
                           exh_tclExceptionContext* pECT = exh_GetExceptionContext();\
                           exh_vThrowException(pECT->poCurrentException, pECT);\
                     }

// Don't use this Macro. This Macro is only provided for SXL internal use
#define _BP_THROW1(x)      {x* pe = new x;exh_vThrowException(pe, exh_GetExceptionContext());}

// Macro to throw an exception of type x with description y
#define _BP_THROW(x, y)    {x* pe = new x(y);exh_vThrowException(pe, exh_GetExceptionContext());}  

// Macro to throw an exception of type x with description y and error code
#define _BP_THROW_EC(x, y, u32ErrorCode) {\
                                         x* pe = new x(y, u32ErrorCode);\
                                         exh_vThrowException(pe, exh_GetExceptionContext());\
                                      }  

#define _BP_THROW_SPEC()
#define _BP_THROW_SPEC1(a)
#define _BP_THROW_SPEC2(a,b)
#define _BP_THROW_SPEC3(a,b,c)
#define _BP_THROW_SPEC4(a,b,c,d)
#define _BP_THROW_SPEC5(a,b,c,d,e)

#else

#define _BP_TRY_BEGIN            try

// Macro to catch an exception of a certain class
#define _BP_CATCH(excType)       catch(excType)

#define _BP_CATCH_OBJ(excType, objName)      catch(excType objName)

#define _BP_CATCH_OBJREF(excType, objName)   catch(excType& objName)

// Macro to catch any exception
#define _BP_CATCH_ALL                        catch(...)

// Macro to mark the end of a try-block
#define _BP_CATCH_END

// empty definition don't use _RAISE
#define _BP_RAISE(x)

// Macro to rethrow the current exception
#define _BP_RERAISE                       throw

// Don't use this Macro. This Macro is only provided for SXL internal use
#define _BP_THROW1(x)                     throw x()

// Macro to throw an exception of type x with description y
#define _BP_THROW(x, y)                   throw x(y)

// Macro to throw an exception of type x with description y and error code
#define _BP_THROW_EC(x, y, u32ErrorCode)  throw x(y, u32ErrorCode)

#define _BP_THROW_SPEC()               throw()
#define _BP_THROW_SPEC1(a)             throw(a)
#define _BP_THROW_SPEC2(a,b)           throw(a,b)
#define _BP_THROW_SPEC3(a,b,c)         throw(a,b,c)
#define _BP_THROW_SPEC4(a,b,c,d)       throw(a,b,c,d)
#define _BP_THROW_SPEC5(a,b,c,d,e)     throw(a,b,c,d,e)

#endif

#endif
