/**************************************************************** +MHDR * .MA *
    
 .FILE            [Except.h]

 .SW-COMPONENT    [SXL\EXH]

 .DESCRIPTION                                                          
  This file specifies some helper functions for the exception handling.
   
 .AUTOR           [ CM-DI/ENS51 F. Wiedemann                            ]          
 .COPYRIGHT       [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]

 .HISTORY 
   
  Initial revision.
   
**************************************************************** -MHDR * .ME */
// Exception handling with longjmp

#ifndef EXCEPT_H
#define EXCEPT_H

#ifdef VARIANT_S_FTR_ENABLE_EXH_EXCEPTIONS

#include <setjmp.h>

#include "ExceptOSIF.h"
       
tVoid exh_vThrowException(bpstl::exception* poException, exh_tclExceptionContext* pECT);

inline tVoid exh_vSaveJumpMark(exh_tclExceptionContext* pECT, exh_tclTryContext& rfoTryContext)
{
   // this function only works if you provide a valid exception context.
   if(pECT != NULL)
   {
      // save the jump-mark to the jump-stack of the current exception context
      pECT->oTryStack.vPush(rfoTryContext);
   }
}

tVoid exh_vCatchEnd(exh_tclExceptionContext* pECT, bpstl::exception* poException, tBool bCaught);

#endif

#endif
