/*
 * debug handling for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

/* the debug log level */
extern gint btd_debug_level;

/* macros */

/* debug log level definitions */
#define BTD_DBG_NONE_LEV	0	/* no logging */
#define BTD_DBG_ERR_LEV		1	/* log errors */
#define BTD_DBG_WARN_LEV	2	/* log warnings */
#define BTD_DBG_INFO_LEV	3	/* log low-frequency informational messages */
#define BTD_DBG_FUNC_LEV	4	/* log function entry and exit */
#define BTD_DBG_HIGH_LEV	5	/* log high-frequency debug */
#define BTD_DBG_MAX_LEV		5	/* maximum log level */

extern guint8 get_btd_debug_level(void);

#define DBG_ENABLED

#ifdef DBG_ENABLED
extern void btd_debug_log(gint level, const gchar *func, const gchar *fmt, ...);
#define DEBUG_ERROR(fmtstr, args...) \
	btd_debug_log(BTD_DBG_ERR_LEV, __func__, fmtstr, ##args)

#define DEBUG_WARN(fmtstr, args...) \
	btd_debug_log(BTD_DBG_WARN_LEV, __func__, fmtstr, ##args)

#define DEBUG_INFO(fmtstr, args...) \
	btd_debug_log(BTD_DBG_INFO_LEV, __func__, fmtstr, ##args)

#define DEBUG(fmtstr, args...) \
	btd_debug_log(BTD_DBG_INFO_LEV, __func__, fmtstr, ##args)

#define DEBUG_FUNC(fmtstr, args...) \
	btd_debug_log(BTD_DBG_FUNC_LEV, __func__, fmtstr, ##args)

#define DEBUG_HIGH(fmtstr, args...) \
	btd_debug_log(BTD_DBG_HIGH_LEV, __func__, fmtstr, ##args)

extern void debug_dump_array(guint32 len, guint8 *data);
#define DEBUG_DUMP_ARRAY(len, data) \
do { \
	if (btd_debug_level >= BTD_DBG_HIGH_LEV) { \
		debug_dump_array(len, data); \
	} \
} while (0)

extern gchar *bd_addr_to_str(const BD_ADDRESS bd_addr);

#else
#define DEBUG_ERROR(fmtstr, args...)

#define DEBUG_WARN(fmtstr, args...)

#define DEBUG_INFO(fmtstr, args...)

#define DEBUG(fmtstr, args...)

#define DEBUG_FUNC(fmtstr, args...)

#define DEBUG_HIGH(fmtstr, args...)

#define DEBUG_DUMP_ARRAY(len, data)
#endif


