/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "udp_send.h"
#include "arp.h"

/* The ip address to ping */
int NetUdpSendNUmBytes = -1;
char NetUdpSendPayloadBuffer[NET_UDP_SEND_MAX_NUM_BYTES] = {-1};
int      NetUdpSendPort = -1;
IPaddr_t NetUdpSendIP   = -1;

/**********************************************************************/
/*
 *       The send function ...
 *
 */
static int udp_send(void)
{
	uchar *pkt;
	uchar UdpHostEther[6] = {0};

	pkt = NetTxPacket + NetEthHdrSize() + IP_UDP_HDR_SIZE;
	memcpy(pkt, NetUdpSendPayloadBuffer, NetUdpSendNUmBytes);

	return NetSendUDPPacket(UdpHostEther,
				NetUdpSendIP,
				NetUdpSendPort,
				70,
				NetUdpSendNUmBytes);

}

/**********************************************************************/
/*
 *       Timeout Callback ...
 *
 */
static void udp_send_timeout(void)
{
	eth_halt();
	net_set_state(NETLOOP_FAIL);	/* we did not get the reply */
}

/**********************************************************************/
/*
 *	The only external visible function.
 *          starts the transmission of the UDP packet based
 *          on the values given in the global variable
 *
 */
void udp_send_packet(void)
{
	printf("Using %s device\n", eth_get_name());
	NetSetTimeout(3000UL, udp_send_timeout);

	udp_send();
}
