/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * Configuration settings for the Bosch i.MX6DL GM MY16 A sample board.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CONFIG_MX6
#define CONFIG_BOARD_MY16_A_MX6DL
#define CONFIG_DISPLAY_CPUINFO
#define CONFIG_DISPLAY_BOARDINFO

#include <asm/arch/imx-regs.h>

#define CONFIG_CMDLINE_TAG
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_INITRD_TAG

/* Size of malloc() pool */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + 2 * 1024 * 1024)

#define CONFIG_ARCH_CPU_INIT
#define CONFIG_BOARD_EARLY_INIT_F
#define CONFIG_MXC_GPIO

#define CONFIG_MXC_UART
#define CONFIG_MXC_UART_BASE		UART4_BASE

/* OCOTP Configs */
#define CONFIG_CMD_IMXOTP
#ifdef CONFIG_CMD_IMXOTP
#define CONFIG_IMX_OTP
#define IMX_OTP_BASE			OCOTP_BASE_ADDR
#define IMX_OTP_ADDR_MAX		0x7F
#define IMX_OTP_DATA_ERROR_VAL		0xBADABADA
//#define IMX_OTPWRITE_ENABLED
#endif

/* MMC Configs */
#define CONFIG_FSL_ESDHC
#define CONFIG_FSL_USDHC
#define CONFIG_SYS_FSL_ESDHC_ADDR	0
#define CONFIG_SYS_FSL_USDHC_NUM	1

#define CONFIG_MMC
#define CONFIG_CMD_MMC
#define CONFIG_GENERIC_MMC
#define CONFIG_BOUNCE_BUFFER

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE
#define CONFIG_CONS_INDEX		1
#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{9600, 19200, 38400, 57600, 115200}

/* Ethernet */
#define CONFIG_FEC_MXC
#define CONFIG_MII
#define IMX_FEC_BASE			ENET_BASE_ADDR
#define CONFIG_FEC_XCV_TYPE		RGMII
#define CONFIG_ETHPRIME			"FEC"
#define CONFIG_FEC_MXC_PHYADDR	0 /* not used */

/* Phy */
#define CONFIG_PHY_GIGE

/* Command definition */
#include <config_cmd_default.h>

/* Network commands (ethernet and usb host network interface) */
#define CONFIG_CMD_NET
#define CONFIG_CMD_PING
#define CONFIG_CMD_DHCP

/* select type of flash device */
#define CONFIG_CMD_FLASH		/* for parallel flash */

#define CONFIG_CMD_USB
/*
 * Common USB/EHCI configuration
 */
#ifdef CONFIG_CMD_USB
#define CONFIG_USB_EHCI
#define CONFIG_USB_EHCI_MX6

#define CONFIG_MXC_USB_PORT	1
#define CONFIG_MXC_USB_PORTSC	(PORT_PTS_UTMI | PORT_PTS_PTW)
#define CONFIG_MXC_USB_FLAGS	0

#define CONFIG_USB_HOST_ETHER
#define CONFIG_USB_ETHER_ASIX
#endif /* CONFIG_CMD_USB */


#undef CONFIG_CMD_IMLS

#define CONFIG_BOOTDELAY		1

#define CONFIG_TIMER_MX6_HCLK
#define CONFIG_PRINT_STARTTIME
/* #define CONF_SHOW_TIMESTAMPS */
/* #define CONFIG_TIMESTAMP */
/* #define CONFIG_CMD_TIME */

#define CONFIG_LOADADDR			0x10800000
#define CONFIG_SYS_TEXT_BASE		0x17800000

/*
 * The boot ROM code copies U-Boot already into the RAM at
 * address CONFIG_SYS_TEXT_BASE.  To improve the boot time,
 * skip the relocation (i.e. the copy RAM -> RAM).
 *
 * ATTENTION: Please read
 *
 * http://lists.denx.de/pipermail/u-boot/2012-February/117140.html
 *
 * why you normally don't want this!
 */
#define CONFIG_SYS_SKIP_ARM_RELOCATION

#define	CONFIG_EXTRA_ENV_SETTINGS	\
	"kerneladdr=0x08420000\0"	\
	"dtbsrc=0x08400000\0"	\
	"dtbaddr=0x11ff0000\0"	\
	"dtbsize=0x8000\0"	\
	"console=ttymxc3\0"	\
	"baudrate=115200n8\0"	\
	"fdt_high=0xffffffff\0"	\
	"verify=no\0"		\
	"xtargs=ip=off\0"	\
	"mmcroot=/dev/mmcblk1p1 rootwait rw\0"	\
	"loaddtb=cp.b ${dtbsrc} ${dtbaddr} ${dtbsize}\0"	\
	"kernelargs=setenv bootargs console=${console},${baudrate} "	\
		"root=${mmcroot} maxcpus=2 printk.time=1 "	\
		"${xtargs} lpj=7905280 quiet "	\
		"oops=panic panic=1\0"		\
	"norboot=echo Booting from parallel NOR ...; "	\
		"run kernelargs; "	\
		"run loaddtb; "	\
		"bootm ${kerneladdr} - ${dtbaddr}\0"	\

#define CONFIG_BOOTCOMMAND	\
	"run norboot;"

/* Miscellaneous configurable options */
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_SYS_PROMPT		"MX6DL MY16A U-Boot> "
#define CONFIG_AUTO_COMPLETE
#define CONFIG_SYS_CBSIZE		256

/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE (CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS	16
#define CONFIG_SYS_BARGSIZE CONFIG_SYS_CBSIZE

#define CONFIG_SYS_MEMTEST_START	0x10000000
#define CONFIG_SYS_MEMTEST_END		0x10010000

#define CONFIG_SYS_LOAD_ADDR		CONFIG_LOADADDR
#define CONFIG_SYS_HZ			1000

#define CONFIG_CMDLINE_EDITING
#define CONFIG_STACKSIZE		(128 * 1024)

#define CONFIG_USE_ARCH_MEMSET
#define CONFIG_USE_ARCH_MEMCPY
#define CONFIG_USE_ARCH_MEMMOVE

/* Physical Memory Map */
#define CONFIG_NR_DRAM_BANKS		1
#define PHYS_SDRAM			MMDC0_ARB_BASE_ADDR
#define PHYS_SDRAM_SIZE			(1024 * 1024 * 1024)

#define CONFIG_SYS_SDRAM_BASE		PHYS_SDRAM
#define CONFIG_SYS_INIT_RAM_ADDR	IRAM_BASE_ADDR
#define CONFIG_SYS_INIT_RAM_SIZE	IRAM_SIZE

#define CONFIG_SYS_INIT_SP_OFFSET	\
	(CONFIG_SYS_INIT_RAM_SIZE - GENERATED_GBL_DATA_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR		\
	(CONFIG_SYS_INIT_RAM_ADDR + CONFIG_SYS_INIT_SP_OFFSET)

/* FLASH and environment organization */
#define CONFIG_SYS_FLASH_CFI
#define CONFIG_FLASH_CFI_DRIVER
#define CONFIG_SYS_FLASH_BASE		WEIM_ARB_BASE_ADDR
#define CONFIG_SYS_FLASH_CFI_WIDTH	FLASH_CFI_16BIT
#define CONFIG_SYS_MAX_FLASH_BANKS	1
#define CONFIG_SYS_MAX_FLASH_SECT	512
#define CONFIG_SYS_FLASH_USE_BUFFER_WRITE
#define CONFIG_SYS_MONITOR_BASE		CONFIG_SYS_FLASH_BASE
#define CONFIG_SYS_MONITOR_LEN		(384 * 1024)

#define CONFIG_ENV_SECT_SIZE	(128 * 1024)
#define CONFIG_ENV_ADDR	(CONFIG_SYS_FLASH_BASE + CONFIG_SYS_MONITOR_LEN)
#define CONFIG_ENV_SIZE	CONFIG_ENV_SECT_SIZE
#define CONFIG_ENV_IS_IN_FLASH

#define CONFIG_OF_LIBFDT

#endif	/* __CONFIG_H */
