/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>

#if defined(CONFIG_BOARD_VRNS_B1_MX6Q) || defined(CONFIG_BOARD_VRNS_B1_MX6S)
static const sf_spi sf_spi_vrns_b1 = {
	.bus = 3,
	.cs = (0|(IMX_GPIO_NR(3, 20)<<8)), /* GPIO port 3, pin 20 */
};
#endif

#ifdef CONFIG_BOARD_VRNS_B1_MX6Q
static const dcd_config dcd_vrnsb1[] = {
	/* {<u32 address>, <u32 value>}, */
	/* iomux */
	{0x020E01F8, 0x00000004}, /* UART/Console */
	{0x020E05C8, 0x0001B0B1},
	{0x020E01FC, 0x00000004},
	{0x020E0938, 0x00000001},
	{0x020E05CC, 0x0001B0B1},
	{0x020E0254, 0x00000005}, /* misc: ADR3, SD power, .... */
	{0x020E0624, 0x0001B058},
	{0x020E0228, 0x00000005},
	{0x020E05F8, 0x0001B058},
	{0x020E0224, 0x00000005},
	{0x020E05F4, 0x0001B058},
	{0x020E016C, 0x00000005},
	{0x020E0480, 0x0000B0B9},
	{0x020E00A0, 0x00000005}, /* SPI NOR */
	{0x020E03B4, 0x0001B058},
	{0x020E00A8, 0x00000001},
	{0x020E03BC, 0x0000B0F9},
	{0x020E00C4, 0x00000002},
	{0x020E03D8, 0x0000B0F9},
	{0x020E00A4, 0x00000001},
	{0x020E03B8, 0x0000B0F9},
	{0x020E02BC, 0x00000000}, /* eMMC USDHC 3*/
	{0x020E06A4, 0x0000B0F9},
	{0x020E02B8, 0x00000010},
	{0x020E06A0, 0x0000B0F9},
	{0x020E02C0, 0x00000000},
	{0x020E06A8, 0x0000B0F9},
	{0x020E02C4, 0x00000000},
	{0x020E06AC, 0x0000B0F9},
	{0x020E02C8, 0x00000000},
	{0x020E06B0, 0x0000B0F9},
	{0x020E02CC, 0x00000000},
	{0x020E06B4, 0x0000B0F9},
	{0x020E02B4, 0x00000000},
	{0x020E069C, 0x0000B0F9},
	{0x020E02B0, 0x00000000},
	{0x020E0698, 0x0000B0F9},
	{0x020E02AC, 0x00000000},
	{0x020E0694, 0x0000B0F9},
	{0x020E02A8, 0x00000000},
	{0x020E0690, 0x0000B0F9},
	{0x020E0350, 0x00000000}, /* SD USDHC 1*/
	{0x020E0738, 0x0000B0F9},
	{0x020E0348, 0x00000010},
	{0x020E0730, 0x0000B0F9},
	{0x020E0340, 0x00000000},
	{0x020E0728, 0x0000B0F9},
	{0x020E033C, 0x00000000},
	{0x020E0724, 0x0000B0F9},
	{0x020E034C, 0x00000000},
	{0x020E0734, 0x0000B0F9},
	{0x020E0344, 0x00000000},
	{0x020E072C, 0x0000B0F9},
	{0x020E00BC, 0x00000005}, /* from kernel board file */
	{0x020E00C0, 0x00000005},
	{0x020E01D0, 0x00000005},
	{0x020E01D4, 0x00000005},
	{0x020E0090, 0x00000005},
	{0x020E0098, 0x00000005},
	{0x020E009C, 0x00000005},
	{0x020E0094, 0x00000005},
	{0x020E01D8, 0x00000005},
	{0x020E0278, 0x00000002},
	{0x020E0810, 0x00000002},
	{0x020E027C, 0x00000002},
	{0x020E0818, 0x00000002},
	{0x020E0280, 0x00000002},
	{0x020E0814, 0x00000002},
	{0x020E0284, 0x00000005},
	{0x020E081C, 0x00000002},
	{0x020E0358, 0x00000005},
	{0x020E01DC, 0x00000002},
	{0x020E0870, 0x00000000},
	{0x020E01E0, 0x00000002},
	{0x020E0860, 0x00000000},
	{0x020E01F0, 0x00000002},
	{0x020E0884, 0x00000000},
	{0x020E01F4, 0x00000002},
	{0x020E0888, 0x00000000},
	{0x020E0250, 0x00000000},
	{0x020E0878, 0x00000000},
	{0x020E02EC, 0x00000002},
	{0x020E0874, 0x00000001},
	{0x020E0338, 0x00000002},
	{0x020E0720, 0x0001B0B1},
	{0x020E0334, 0x00000002},
	{0x020E071C, 0x0001B0B1},
	{0x020E0330, 0x00000002},
	{0x020E0924, 0x00000004},
	{0x020E0718, 0x0001B0B1},
	{0x020E032C, 0x00000002},
	{0x020E0928, 0x00000006},
	{0x020E0714, 0x0001B0B1},
	{0x020E0268, 0x00000002},
	{0x020E07F4, 0x00000003},
	{0x020E026C, 0x00000002},
	{0x020E07FC, 0x00000003},
	{0x020E0270, 0x00000002},
	{0x020E07F8, 0x00000003},
	{0x020E0274, 0x00000005},
	{0x020E0644, 0x00000010},
	{0x020E0208, 0x00000005},
	{0x020E00B4, 0x00000004},
	{0x020E0088, 0x00000005},
	{0x020E00B8, 0x00000005},
	{0x020E00D0, 0x00000005},
	{0x020E0210, 0x00000014},
	{0x020E08A0, 0x00000001},
	{0x020E05E0, 0x0001B8B1},
	{0x020E0214, 0x00000014},
	{0x020E08A4, 0x00000001},
	{0x020E05E4, 0x0001B8B1},
	{0x020E023C, 0x00000016},
	{0x020E08A8, 0x00000002},
	{0x020E060C, 0x0001B8B1},
	{0x020E0248, 0x00000016},
	{0x020E08AC, 0x00000002},
	{0x020E0618, 0x0001B8B1},
	{0x020E02D8, 0x00000005},
	{0x020E0314, 0x00000005},
	{0x020E0318, 0x00000005},
	{0x020E0700, 0x00003000},
	{0x020E015C, 0x00000000},
	{0x020E0470, 0x00000010},
	{0x020E0160, 0x00000000},
	{0x020E0474, 0x00000010},
	{0x020E0164, 0x00000000},
	{0x020E0478, 0x00000010},
	{0x020E0168, 0x00000000},
	{0x020E047C, 0x00000010},
	{0x020E0170, 0x00000000},
	{0x020E0484, 0x00000010},
	{0x020E0174, 0x00000000},
	{0x020E0488, 0x00000010},
	{0x020E0178, 0x00000000},
	{0x020E048C, 0x00000010},
	{0x020E017C, 0x00000000},
	{0x020E0490, 0x00000010},
	{0x020E0180, 0x00000000},
	{0x020E0494, 0x00000010},
	{0x020E0184, 0x00000000},
	{0x020E0498, 0x00000010},
	{0x020E0188, 0x00000000},
	{0x020E049C, 0x00000010},
	{0x020E018C, 0x00000000},
	{0x020E04A0, 0x00000010},
	{0x020E0190, 0x00000000},
	{0x020E04A4, 0x00000010},
	{0x020E0194, 0x00000000},
	{0x020E04A8, 0x00000010},
	{0x020E0198, 0x00000000},
	{0x020E04AC, 0x00000010},
	{0x020E019C, 0x00000000},
	{0x020E04B0, 0x00000010},
	{0x020E01A0, 0x00000000},
	{0x020E04B4, 0x00000010},
	{0x020E01A4, 0x00000000},
	{0x020E04B8, 0x00000010},
	{0x020E01A8, 0x00000000},
	{0x020E04BC, 0x00000010},
	{0x020E01AC, 0x00000000},
	{0x020E04C0, 0x00000010},
	{0x020E01B0, 0x00000000},
	{0x020E04C4, 0x00000010},
	{0x020E01B4, 0x00000000},
	{0x020E04C8, 0x00000010},
	{0x020E01B8, 0x00000000},
	{0x020E04CC, 0x00000010},
	{0x020E01BC, 0x00000000},
	{0x020E04D0, 0x00000010},
	{0x020E01C0, 0x00000000},
	{0x020E04D4, 0x00000010},
	{0x020E01C4, 0x00000000},
	{0x020E04D8, 0x00000010},
	{0x020E01C8, 0x00000000},
	{0x020E04DC, 0x00000010},
	{0x020E01CC, 0x00000000},
	{0x020E04E0, 0x00000010},
	{0x020E02FC, 0x00000005},
	{0x020E06E4, 0x00007000},
	{0x020E0300, 0x00000005},
	{0x020E06E8, 0x00003000},
	{0x020E0304, 0x00000005},
	{0x020E06EC, 0x00007000},
	{0x020E0308, 0x00000005},
	{0x020E06F0, 0x00003000},
	{0x020E02DC, 0x00000005},
	{0x020E02F0, 0x00000005},
	{0x020E0220, 0x00000005},
	{0x020E05F0, 0x0000B080},
	{0x020E024C, 0x00000005},
	{0x020E061C, 0x0000B080},
	{0x020E03D0, 0x000170B1},
	{0x020E00C8, 0x00000005},
	{0x020E00CC, 0x00000005},
	{0x020E00D4, 0x00000005},
	{0x020E00D8, 0x00000005},
	{0x020E00DC, 0x00000005},
	{0x020E00E0, 0x00000005},
	{0x020E00E4, 0x00000005},
	{0x020E00E8, 0x00000005},
	{0x020E00EC, 0x00000005},
	{0x020E00F0, 0x00000005},
	{0x020E00F4, 0x00000005},
	{0x020E0104, 0x00000005},
	{0x020E0108, 0x00000005},
	{0x020E010C, 0x00000005},
	{0x020E0110, 0x00000005},
	{0x020E0114, 0x00000005},
	{0x020E0118, 0x00000005},
	{0x020E011C, 0x00000005},
	{0x020E0120, 0x00000005},
	{0x020E0124, 0x00000005},
	{0x020E0128, 0x00000005},
	{0x020E012C, 0x00000005},
	{0x020E0130, 0x00000005},
	{0x020E0134, 0x00000005},
	{0x020E0138, 0x00000005},
	{0x020E013C, 0x00000005},
	{0x020E0140, 0x00000005},
	{0x020E0144, 0x00000005},
	{0x020E0148, 0x00000005},
	{0x020E014C, 0x00000005},
	{0x020E0150, 0x00000005},
	{0x020E0154, 0x00000005},
	{0x020E0468, 0x00000010},
	{0x020E03B0, 0x000100B1},
	{0x020E0054, 0x00000003},
	{0x020E07B4, 0x00000000},
	{0x020E004C, 0x00000003},
	{0x020E07C8, 0x00000000},
	{0x020E0050, 0x00000003},
	{0x020E07B8, 0x00000000},
	{0x020E035C, 0x00000003},
	{0x020E07C4, 0x00000001},
	{0x020E031C, 0x00000001},
	{0x020E0704, 0x000170B1},
	{0x020E0320, 0x00000001},
	{0x020E0708, 0x000170B1},
	{0x020E0324, 0x00000001},
	{0x020E070C, 0x000170B1},
	{0x020E0328, 0x00000001},
	{0x020E0710, 0x000170B1},
	{0x020E02F8, 0x00000000},
	{0x020E06E0, 0x000170B1},
	{0x020E02F4, 0x00000010},
	{0x020E06DC, 0x000170B1},
	{0x020E030C, 0x00000005},
	{0x020E06F4, 0x00003000},
	{0x020E0310, 0x00000005},
	{0x020E06F8, 0x00003000},
	{0x020E022C, 0x00000005},
	{0x020E0230, 0x00000005},
	{0x020E0288, 0x00000000},
	{0x020E028C, 0x00000000},
	{0x020E0290, 0x00000000},
	{0x020E0294, 0x00000000},
	{0x020E0298, 0x00000000},
	{0x020E029C, 0x00000000},
	{0x020E02A0, 0x00000000},
	{0x020E02A4, 0x00000000},
	{0x020E0258, 0x00000000},
	{0x020E025C, 0x00000000},
	{0x020E0264, 0x00000000},
	{0x020E0260, 0x00000000},
	{0x020E0218, 0x00000005},
	{0x020E021C, 0x00000005},
	{0x020E04F4, 0x0001B030},
	{0x020E04F0, 0x0001B0B0},
	{0x020E06D4, 0x0001B030},
	{0x020E0504, 0x0001B030},
	{0x020E0508, 0x0001B030},
	{0x020E02E4, 0x00000005},
	{0x020E06CC, 0x00017059},
	{0x020E02E8, 0x00000005},
	{0x020E06D0, 0x00017059},
	{0x020E00AC, 0x00000005},
	{0x020E0354, 0x00000005},
	{0x020E01E8, 0x00000005},
	{0x020E02D4, 0x00000005},
	{0x020E02E0, 0x00000005},
	{END_OF_TABLE},
};

static const env_entry board_env_vrnsb1q[] = {
	{"kerneladdr", "0x12000000"},	
	{"kernelsize", "0x2000"},
	{"dtbsrc", "0x500"},
	{"dtbsize", "0x40"},
	{"cpucount", "maxcpus=2"},
	{"console", "ttymxc3"},
	{"loadkernel", "mmc dev ${mmcdev}; mmc rescan; mmc read ${kerneladdr} 0x800 ${kernelsize}"},
	{"loaddtb", "mmc dev ${mmcdev}; mmc rescan; mmc read ${dtbaddr} ${dtbsrc} ${dtbsize}"},
	{"gen3boot", "echo Booting from mmc ...; "			\
		"run kernelargs; "					\
	 	"run loadkernel; run loaddtb; "				\
	 	"bootm ${kerneladdr} - ${dtbaddr}"},
	{0, 0}
};

#define VRNSB1_GPIO_SD_MPWR		IMX_GPIO_NR(4, 20)
#define VRNSB1_GPIO_ADR_RESET		IMX_GPIO_NR(4,  5)
#define VRNSB1_GPIO_ADR_BOOT_SELECT0	IMX_GPIO_NR(1,  9)
#define VRNSB1_GPIO_ADR_BOOT_SELECT1	IMX_GPIO_NR(1,  1)
#define VRNSB1_GPIO_DISP_STBYB		IMX_GPIO_NR(2,  7)

static void board_init_vrnsb1(void)
{
	/* switch on eMMC/SD power */
	gpio_direction_output(VRNSB1_GPIO_SD_MPWR, 1);

	/*
	 * activate ADR3
	 * ADR_RESET
	 */
	gpio_direction_output(VRNSB1_GPIO_ADR_RESET, 0);
	/* ADR_BOOT_SELECT0 = 0, ADR_BOOT_SELECT1 = 0 */
	gpio_direction_output(VRNSB1_GPIO_ADR_BOOT_SELECT0, 0);
	gpio_direction_output(VRNSB1_GPIO_ADR_BOOT_SELECT1, 0);
	/* ADR_RESET disable */
	udelay(10000);
	gpio_set_value(VRNSB1_GPIO_ADR_RESET, 1);

	/* Display standby disable */
	gpio_direction_output(VRNSB1_GPIO_DISP_STBYB, 1);
}

const board_config board_data_vrnsb1q = {
	.name = "MX6Q-VRNS-B1",
	.dcd = dcd_vrnsb1,
	/*
	 * Below definitions are used only with the generic mx6gen3 build.
	 * The mx6xvrnsb1 builds will use the hard coded defines from
	 * include/configs/mx6vrnsb1.h, instead.
	 */
	.env = board_env_vrnsb1q,
	.ram_size = 512u * 1024 * 1024,
	.board_init = board_init_vrnsb1,
	.sf = &sf_spi_vrns_b1,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_MMC,
};
#endif

#ifdef CONFIG_BOARD_VRNS_B1_MX6S
static const dcd_config dcd_vrnsb1_solo[] = {
	/* {<u32 address>, <u32 value>}, */
	/* iomux */
	{0x020E0244, 0x00000004}, /* UART4 */
	{0x020E062C, 0x0001B0B1},
	{0x020E0258, 0x00000004},
	{0x020E0914, 0x00000003},
	{0x020E0640, 0x0001B0B1},
	{0x020E00AC, 0x00000005},
	{0x020E016C, 0x00000005}, /* misc: ADR3, SD power, .... */
	{0x020E0170, 0x00000005},
	{0x020E01EC, 0x00000005},
	{0x020E01F0, 0x00000005},
	{0x020E0144, 0x00000005},
	{0x020E014C, 0x00000005},
	{0x020E0150, 0x00000005},
	{0x020E0520, 0x000100B1},
	{0x020E0148, 0x00000005},
	{0x020E01F4, 0x00000005},
	{0x020E0084, 0x00000002},
	{0x020E07F4, 0x00000000},
	{0x020E0088, 0x00000002},
	{0x020E07FC, 0x00000000},
	{0x020E004C, 0x00000002},
	{0x020E07F8, 0x00000000},
	{0x020E0050, 0x00000005},
	{0x020E0800, 0x00000000},
	{0x020E02F8, 0x00000005},
	{0x020E01E4, 0x00000002},
	{0x020E0840, 0x00000000},
	{0x020E05B4, 0x0001B030},
	{0x020E01FC, 0x00000002},
	{0x020E0830, 0x00000000},
	{0x020E05CC, 0x0001B030},
	{0x020E0204, 0x00000002},
	{0x020E0854, 0x00000000},
	{0x020E05D4, 0x0001B030},
	{0x020E01E8, 0x00000002},
	{0x020E0858, 0x00000000},
	{0x020E05B8, 0x0001B030},
	{0x020E021C, 0x00000000},
	{0x020E0848, 0x00000000},
	{0x020E027C, 0x00000002},
	{0x020E0844, 0x00000001},
	{0x020E0664, 0x0001B030},
	{0x020E02DC, 0x00000000},
	{0x020E0928, 0x00000001},
	{0x020E06C4, 0x00017059},
	{0x020E02E0, 0x00000010},
	{0x020E06C8, 0x00017059},
	{0x020E02E4, 0x00000000},
	{0x020E06CC, 0x00017059},
	{0x020E02E8, 0x00000000},
	{0x020E06D0, 0x00017059},
	{0x020E02EC, 0x00000000},
	{0x020E06D4, 0x00017059},
	{0x020E02F0, 0x00000000},
	{0x020E06D8, 0x00017059},
	{0x020E030C, 0x00000000}, /* USDHC3 */
	{0x020E0934, 0x00000001},
	{0x020E06F4, 0x00017059},
	{0x020E0310, 0x00000010},
	{0x020E06F8, 0x00017059},
	{0x020E0314, 0x00000000},
	{0x020E06FC, 0x00017059},
	{0x020E0318, 0x00000000},
	{0x020E0700, 0x00017059},
	{0x020E031C, 0x00000000},
	{0x020E0704, 0x00017059},
	{0x020E0320, 0x00000000},
	{0x020E0708, 0x00017059},
	{0x020E0324, 0x00000000},
	{0x020E070C, 0x00017059},
	{0x020E0328, 0x00000000},
	{0x020E0710, 0x00017059},
	{0x020E032C, 0x00000000},
	{0x020E0714, 0x00017059},
	{0x020E0330, 0x00000000},
	{0x020E0718, 0x00017059},
	{0x020E035C, 0x00000002}, /* Kernel */
	{0x020E0744, 0x0001B0B1},
	{0x020E0358, 0x00000002},
	{0x020E0740, 0x0001B0B1},
	{0x020E0354, 0x00000002},
	{0x020E0900, 0x00000004},
	{0x020E073C, 0x0001B0B1},
	{0x020E0350, 0x00000002},
	{0x020E0904, 0x00000006},
	{0x020E0738, 0x0001B0B1},
	{0x020E0074, 0x00000002},
	{0x020E07D8, 0x00000000},
	{0x020E0078, 0x00000002},
	{0x020E07E0, 0x00000000},
	{0x020E007C, 0x00000002},
	{0x020E07DC, 0x00000000},
	{0x020E0080, 0x00000005},
	{0x020E024C, 0x00000005},
	{0x020E0164, 0x00000004},
	{0x020E0158, 0x00000001},
	{0x020E015C, 0x00000001},
	{0x020E0174, 0x00000002},
	{0x020E0154, 0x00000005},
	{0x020E0134, 0x00000005},
	{0x020E0168, 0x00000005},
	{0x020E0180, 0x00000005},
	{0x020E0240, 0x00000001},
	{0x020E0250, 0x00000014},
	{0x020E0870, 0x00000001},
	{0x020E0638, 0x0001B8B1},
	{0x020E0264, 0x00000014},
	{0x020E0874, 0x00000001},
	{0x020E064C, 0x0001B8B1},
	{0x020E0230, 0x00000016},
	{0x020E0878, 0x00000002},
	{0x020E0600, 0x0001B8B1},
	{0x020E0214, 0x00000016},
	{0x020E087C, 0x00000001},
	{0x020E05E4, 0x0001B8B1},
	{0x020E026C, 0x00000005},
	{0x020E029C, 0x00000005},
	{0x020E02A0, 0x00000005},
	{0x020E0688, 0x00003000},
	{0x020E009C, 0x00000000},
	{0x020E03B0, 0x00000010},
	{0x020E00A0, 0x00000000},
	{0x020E03B4, 0x00000010},
	{0x020E00A4, 0x00000000},
	{0x020E03B8, 0x00000010},
	{0x020E00A8, 0x00000000},
	{0x020E03BC, 0x00000010},
	{0x020E00B0, 0x00000000},
	{0x020E03C4, 0x00000010},
	{0x020E00B4, 0x00000000},
	{0x020E03C8, 0x00000010},
	{0x020E00E0, 0x00000000},
	{0x020E00F4, 0x00000000},
	{0x020E0408, 0x00000010},
	{0x020E00F8, 0x00000000},
	{0x020E040C, 0x00000010},
	{0x020E00FC, 0x00000000},
	{0x020E0410, 0x00000010},
	{0x020E0100, 0x00000000},
	{0x020E0414, 0x00000010},
	{0x020E0104, 0x00000000},
	{0x020E0418, 0x00000010},
	{0x020E0108, 0x00000000},
	{0x020E041C, 0x00000010},
	{0x020E010C, 0x00000000},
	{0x020E0420, 0x00000010},
	{0x020E00B8, 0x00000000},
	{0x020E00BC, 0x00000000},
	{0x020E03D0, 0x00000010},
	{0x020E00C0, 0x00000000},
	{0x020E03D4, 0x00000010},
	{0x020E00C4, 0x00000000},
	{0x020E03D8, 0x00000010},
	{0x020E00C8, 0x00000000},
	{0x020E03DC, 0x00000010},
	{0x020E00CC, 0x00000000},
	{0x020E03E0, 0x00000010},
	{0x020E00D0, 0x00000000},
	{0x020E03E4, 0x00000010},
	{0x020E00D4, 0x00000000},
	{0x020E03E8, 0x00000010},
	{0x020E00D8, 0x00000000},
	{0x020E03EC, 0x00000010},
	{0x020E00DC, 0x00000000},
	{0x020E03F0, 0x00000010},
	{0x020E00E4, 0x00000000},
	{0x020E03F8, 0x00000010},
	{0x020E00E8, 0x00000000},
	{0x020E03FC, 0x00000010},
	{0x020E00EC, 0x00000000},
	{0x020E0400, 0x00000010},
	{0x020E00F0, 0x00000000},
	{0x020E0404, 0x00000010},
	{0x020E0790, 0x00000001},
	{0x020E0284, 0x00000005},
	{0x020E066C, 0x00007000},
	{0x020E0288, 0x00000005},
	{0x020E0670, 0x00003000},
	{0x020E028C, 0x00000005},
	{0x020E0674, 0x00007000},
	{0x020E0290, 0x00000005},
	{0x020E0678, 0x00003000},
	{0x020E02A8, 0x00000005},
	{0x020E0280, 0x00000005},
	{0x020E020C, 0x00000005},
	{0x020E05DC, 0x0000B000},
	{0x020E0218, 0x00000005},
	{0x020E05E8, 0x0000B000},
	{0x020E0178, 0x00000005},
	{0x020E017C, 0x00000005},
	{0x020E0130, 0x00000005},
	{0x020E012C, 0x00000005},
	{0x020E0128, 0x00000005},
	{0x020E0124, 0x00000005},
	{0x020E0120, 0x00000005},
	{0x020E011C, 0x00000005},
	{0x020E0118, 0x00000005},
	{0x020E0114, 0x00000005},
	{0x020E0110, 0x00000005},
	{0x020E01DC, 0x00000005},
	{0x020E01D4, 0x00000005},
	{0x020E01C4, 0x00000005},
	{0x020E01C8, 0x00000005},
	{0x020E0184, 0x00000005},
	{0x020E0188, 0x00000005},
	{0x020E01A4, 0x00000005},
	{0x020E01A8, 0x00000005},
	{0x020E01AC, 0x00000005},
	{0x020E01B0, 0x00000005},
	{0x020E01B4, 0x00000005},
	{0x020E01B8, 0x00000005},
	{0x020E01BC, 0x00000005},
	{0x020E01C0, 0x00000005},
	{0x020E018C, 0x00000005},
	{0x020E0190, 0x00000005},
	{0x020E0194, 0x00000005},
	{0x020E0198, 0x00000005},
	{0x020E019C, 0x00000005},
	{0x020E01A0, 0x00000005},
	{0x020E01E0, 0x00000005},
	{0x020E02FC, 0x00000003},
	{0x020E0798, 0x00000001},
	{0x020E0300, 0x00000003},
	{0x020E07AC, 0x00000001},
	{0x020E0304, 0x00000003},
	{0x020E079C, 0x00000001},
	{0x020E0308, 0x00000003},
	{0x020E07A8, 0x00000001},
	{0x020E0340, 0x00000001},
	{0x020E0728, 0x000170B1},
	{0x020E0344, 0x00000001},
	{0x020E072C, 0x000170B1},
	{0x020E0348, 0x00000001},
	{0x020E0730, 0x000170B1},
	{0x020E034C, 0x00000001},
	{0x020E0734, 0x000170B1},
	{0x020E0338, 0x00000000},
	{0x020E0938, 0x00000001},
	{0x020E0720, 0x000170B1},
	{0x020E033C, 0x00000010},
	{0x020E0724, 0x000170B1},
	{0x020E0294, 0x00000005},
	{0x020E067C, 0x00003000},
	{0x020E0298, 0x00000005},
	{0x020E0680, 0x00003000},
	{0x020E0228, 0x00000005},
	{0x020E0234, 0x00000005},
	{0x020E0220, 0x00000004},
	{0x020E0054, 0x00000000},
	{0x020E0058, 0x00000000},
	{0x020E005C, 0x00000000},
	{0x020E0060, 0x00000000},
	{0x020E0064, 0x00000000},
	{0x020E0068, 0x00000000},
	{0x020E006C, 0x00000000},
	{0x020E0070, 0x00000000},
	{0x020E0094, 0x00000000},
	{0x020E0090, 0x00000000},
	{0x020E0098, 0x00000000},
	{0x020E008C, 0x00000000},
	{0x020E0254, 0x00000005},
	{0x020E0268, 0x00000005},
	{0x020E0274, 0x00000005},
	{0x020E0278, 0x00000005},
	{0x020E0160, 0x00000005},
	{0x020E02F4, 0x00000005},
	{0x020E0200, 0x00000005},
	{0x020E0270, 0x00000005},
	{0x020E02A4, 0x00000005},
	{0x020E0210, 0x00000005},
	{0x020E05E0, 0x00000030},
	{END_OF_TABLE},
};

static const env_entry board_env_vrnsb1s[] = {
	{"kerneladdr", "0x12000000"},	
	{"kernelsize", "0x2000"},
	{"dtbsrc", "0x5C0"},
	{"dtbsize", "0x40"},
	{"cpucount", "maxcpus=2"},
	{"console", "ttymxc3"},
	{"loadkernel", "mmc dev ${mmcdev}; mmc rescan; mmc read ${kerneladdr} 0x800 ${kernelsize}"},
	{"loaddtb", "mmc dev ${mmcdev}; mmc rescan; mmc read ${dtbaddr} ${dtbsrc} ${dtbsize}"},
	{"gen3boot", "echo Booting from mmc ...; "			\
		"run kernelargs; "					\
	 	"run loadkernel; run loaddtb; "				\
	 	"bootm ${kerneladdr} - ${dtbaddr}"},
	{0, 0}
};

extern void board_init_vrnsb1(void);

const board_config board_data_vrnsb1s = {
	.name = "MX6S-VRNS-B1",
	.dcd = dcd_vrnsb1_solo,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 * The mx6xvrnsb1 builds will use the hard coded defines from
	 * include/configs/mx6vrnsb1.h, instead.
	 */
	.env = board_env_vrnsb1s,
	.ram_size = 512u * 1024 * 1024,
	.board_init = board_init_vrnsb1,
	.sf = &sf_spi_vrns_b1,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_MMC,
};
#endif
