/*
 * Copyright (C) 2015 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>

#ifdef CONFIG_BOARD_ENA_A
/* Same pin mux */
static const dcd_config dcd_enaa[] = {
	/* {<u32 address>, <u32 value>}, */
	/* iomux */
	{0x20E07C4, 0x00000001},
	{0x20E07F8, 0x00000003},
	{0x20E0814, 0x00000002},
	{0x20E08A0, 0x00000001},
	{0x20E08A4, 0x00000001},
	{0x20E08A8, 0x00000002},
	{0x20E08AC, 0x00000002},
	{0x20E0268, 0x00000002},
	{0x20E026C, 0x00000002},
	{0x20E0270, 0x00000002},
	{0x20E0278, 0x00000002},
	{0x20E027C, 0x00000002},
	{0x20E0280, 0x00000002},
	{0x20E0288, 0x00000000},
	{0x20E028C, 0x00000000},
	{0x20E0290, 0x00000000},
	{0x20E0294, 0x00000000},
	{0x20E0298, 0x00000000},
	{0x20E029C, 0x00000000},
	{0x20E02A0, 0x00000000},
	{0x20E02A4, 0x00000000},
	{0x20E0260, 0x00000000},
	{0x20E025C, 0x00000000},
	{0x20E0258, 0x00000000},
	{0x20E0264, 0x00000000},
	{0x20E0088, 0x00000005},
	{0x20E0158, 0x00000005},
	{0x20E00FC, 0x00000005},
	{0x20E00A0, 0x00000005},
	{0x20E00A4, 0x00000001},
	{0x20E00A8, 0x00000001},
	{0x20E00C4, 0x00000002},
	{0x20E0100, 0x00000005},
	{0x20E01DC, 0x00000002},
	{0x20E01F4, 0x00000002},
	{0x20E01E0, 0x00000002},
	{0x20E0224, 0x00000003},
	{0x20E0234, 0x00000005},
	{0x20E0238, 0x00000005},
	{0x20E023C, 0x00000016},
	{0x20E0248, 0x00000016},
	{0x20E01F8, 0x00000004},
	{0x20E0200, 0x00000004},
	{0x20E0210, 0x00000014},
	{0x20E0218, 0x00000002},
	{0x20E01FC, 0x00000004},
	{0x20E0204, 0x00000004},
	{0x20E0214, 0x00000014},
	{0x20E021C, 0x00000002},
	{0x20E02EC, 0x00000002},
	{0x20E0350, 0x00000005},
	{0x20E0348, 0x00000005},
	{0x20E0340, 0x00000005},
	{0x20E033C, 0x00000005},
	{0x20E034C, 0x00000005},
	{0x20E0344, 0x00000005},
	{0x20E0354, 0x00000005},
	{0x20E0358, 0x00000005},
	{0x20E0054, 0x00000003},
	{0x20E004C, 0x00000003},
	{0x20E0050, 0x00000003},
	{0x20E035C, 0x00000003},
	{0x20E02BC, 0x00000000},
	{0x20E02B8, 0x00000000},
	{0x20E02C0, 0x00000000},
	{0x20E02C4, 0x00000000},
	{0x20E02C8, 0x00000000},
	{0x20E02CC, 0x00000000},
	{0x20E02B4, 0x00000000},
	{0x20E02B0, 0x00000000},
	{0x20E02AC, 0x00000000},
	{0x20E02A8, 0x00000000},
	{0x20E02D0, 0x00000000},
	{0x20E02F8, 0x00000000},
	{0x20E02F4, 0x00000000},
	{0x20E031C, 0x00000001},
	{0x20E0320, 0x00000001},
	{0x20E0324, 0x00000001},
	{0x20E0328, 0x00000001},
	{0x20E032C, 0x00000002},
	{0x20E0330, 0x00000002},
	{0x20E0334, 0x00000002},
	{0x20E0338, 0x00000002},
	{0x20E0644, 0x0001B8B0},
	{0x20E03BC, 0x000130B0},
	{0x20E03E4, 0x000130B0},
	{0x20E05F0, 0x000130B0},
	{0x20E05F4, 0x0001B0B0},
	{0x20E0608, 0x0001B0B0},
	{0x20E0610, 0x000130B0},
	{0x20E05D8, 0x0001B8B0},
	{0x20E05DC, 0x0001B8B0},
	{0x20E05EC, 0x000130B0},
	{0x20E06A4, 0x0001B0A8},
	{0x20E06A0, 0x0001B098},
	{0x20E06A8, 0x0001B098},
	{0x20E06AC, 0x0001B098},
	{0x20E06B0, 0x0001B098},
	{0x20E06B4, 0x0001B098},
	{0x20E069C, 0x0001B098},
	{0x20E0698, 0x0001B098},
	{0x20E0694, 0x0001B098},
	{0x20E0690, 0x0001B098},
	{0x20E06B8, 0x0001B098},
	{0x20E0924, 0x00000004},
	{0x20E0928, 0x00000006},
	{0x20E0938, 0x00000001},
	{0x20E0940, 0x00000001},
	{0x20E0944, 0x00000001},
	/*GPIO settings*/
	{0x0209C000, 0x10000000},
	{0x0209C004, 0x10000E00},
	{0x020A0000, 0x03000025},
	{0x020A0004, 0x430000BD},
	{0x020A4000, 0x00100000},
	{0x020A4004, 0x00100000},
	{0x020A8000, 0x00000C00},
	{0x020A8004, 0x00000C00},
	{0x020AC000, 0x22000000},
	{0x020AC004, 0x22000000},
	{0x020B0000, 0x00000000},
	{0x020B0004, 0x00004000},
	{0x020B4000, 0x00000000},
	{0x020B4004, 0x00000000},
	{END_OF_TABLE},
};

static const env_entry board_env_enaa[] = {
		{"cpucount", "maxcpus=4"},
		{"console", "ttymxc3"},
		{0, 0}
};
static const sf_spi sf_spi_enaa = {
		.bus = 3,
		.cs = (0|(IMX_GPIO_NR(3, 20)<<8)), /* GPIO port 3, pin 20 */
};

static const struct sw_opt_gpio sw_opt_gpio_enaa = {
	.sw_opt = { IMX_GPIO_NR(1, 8), IMX_GPIO_NR(4, 5) },
};

const board_config board_data_enaa = {
	.name = "MX6Q-ENA-A",
	.dcd = dcd_enaa,
	.env = board_env_enaa,
	.ram_size = 1024u * 1024 * 1024,
	.sf = &sf_spi_enaa,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_SPI_FLASH,
	.sw_opt = &sw_opt_gpio_enaa,
};
#endif
