/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _BOARD_ID_H_
#define _BOARD_ID_H_

/* Freescale */
#define BOARD_ID_FSL_ARM2		0x081
#define BOARD_ID_FSL_SABRELITE		0x082
#define BOARD_ID_FSL_SABREAI_MX6Q	0x083
#define BOARD_ID_FSL_SABREAI_MX6S	0x084
#define BOARD_ID_FSL_SABREAI_MX6DL	0x085
/* VRNS */
#define BOARD_ID_VRNS_A2_PCB1		0x101
#define BOARD_ID_VRNS_A2_PCB2		0x102
#define BOARD_ID_VRNS_B1_MX6Q		0x103
#define BOARD_ID_VRNS_B1_MX6S		0x104
#define BOARD_ID_VRNS_B2_MX6Q		0x105
#define BOARD_ID_VRNS_B2_MX6S		0x106
#define BOARD_ID_VRNS_B2_MX6Q_1GB	0x107
#define BOARD_ID_VRNS_B2_MX6S_1GB	0x108
/* Bosch ENA A */
#define BOARD_ID_ENA_A		0x111
/* NGI */
#define BOARD_ID_E1			0x181
#define BOARD_ID_E2			0x182
/* eBike */
#define BOARD_ID_EBIKE			0x201
/* iCAM */
#define BOARD_ID_ICAMA1			0x281
#define BOARD_ID_ICAMB1_MX6D		0x283
#define BOARD_ID_ICAMB2_MX6D		0x284
#define BOARD_ID_ICAMC1_MX6D		0x285
#define BOARD_ID_ICAMC3_MX6D		0x286
/* JAC C2 */
#define BOARD_ID_JACC2B3		0x304
#define BOARD_ID_JACC2C			0x305
#define BOARD_ID_JACC2D			0x306
#define BOARD_ID_JACC2D_MX6DL	       	0x307
/* JAC M6 */
#define BOARD_ID_JACM6B0		0x311
/* PSA RCC */
#define BOARD_ID_PSARCCA1_B2		0x404
#define BOARD_ID_PSARCCA2_B2		0x405
#define BOARD_ID_PSARCCA1_B3		0x406
#define BOARD_ID_PSARCCA2_B3		0x407
/* GM MY16 */
#define BOARD_ID_MY16_A_MX6DL			0x501
#define BOARD_ID_MY16_B1_G02_MX6DL		0x502
#define BOARD_ID_MY16_B1_G03_G04_MX6DL	0x503
#define BOARD_ID_MY16_B3_G05_MX6DL	0x504
#define BOARD_ID_MY16_B3_G01_MX6DL	0x505 /* 6081g01 */
#define BOARD_ID_MY16_B3_G01_MX6DL5845	0x506 /* 5845g01 */

/* VM MIB */
#define BOARD_ID_VWMIB_B0			0x602
#define BOARD_ID_VWMIB_B			0x603
#define BOARD_ID_VWMIB_C0			0x604
/* Suzuki SLN */
#define BOARD_ID_SUZUKISLN_C		0x382
#define BOARD_ID_SUZUKISLN_C_MX6DL	0x383
/* Nissan A-IVI */
#define BOARD_ID_NISSAN_AIVI_A		0x681

#endif /* BOARD_ID */
