#include <lttng/tracepoint.h>

#define met_tp_location ctf_integer_hex( void*, mettools_loc, _met_tp_loc )

#define MET_TP_ARGS(...) TP_ARGS( void*, _met_tp_loc, ##__VA_ARGS__ )
#define MET_TP_FIELDS(...) \
    TP_FIELDS(             \
	met_tp_location    \
	__VA_ARGS__        \
    )

#ifndef _METTOOLS_GET_CURRENT_LOCATION
#define _METTOOLS_GET_CURRENT_LOCATION
static void* mettools_get_current_location(void) __attribute__ ((__no_instrument_function__, __noinline__));
static void* mettools_get_current_location(void) {
    return __builtin_return_address(0);
}
#endif

#define met_tracepoint(provider, name, ...) \
  do { \
    void* mettools_get_current_location_tmp = mettools_get_current_location(); \
    tracepoint( provider, name, mettools_get_current_location_tmp, ##__VA_ARGS__ ); \
  } while(0)
