/*
 * Copyright 2004-2012 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU Lesser General
 * Public License.  You may obtain a copy of the GNU Lesser General
 * Public License Version 2.1 or later at the following locations:
 *
 * http://www.opensource.org/licenses/lgpl-license.html
 * http://www.gnu.org/copyleft/lgpl.html
 */

#ifndef __IMX6_V4L2_H__
#define __IMX6_V4L2_H__

/*
 * This is a private ioctl in imx6 v4l2 drivers, to retrieve the physical
 * address of a v4l2 buffer. It should be removed once userland apps
 * (Freescale gstreamer plugins and others) are converted to use
 * VIDIOC_EXPBUF and pass around dmabuf file descriptors.
 */
#define VIDIOC_IMX6_GET_PHYS \
	_IOWR('i', BASE_VIDIOC_PRIVATE+0, struct v4l2_buffer)

#define V4L2_CID_MXC_VF_ROT		(V4L2_CID_PRIVATE_BASE + 2)
#define V4L2_CID_OV5642_TEST_PATTERN    (V4L2_CID_PRIVATE_BASE + 4)
#define V4L2_CID_OV5642_GREEN_BALANCE   (V4L2_CID_PRIVATE_BASE + 5)

#define V4L2_CID_IMX6_MOTION		(V4L2_CID_USER_BASE + 0x1000)

struct v4l2_mxc_offset {
	uint32_t u_offset;
	uint32_t v_offset;
};

/*
 * Video decoder status change notifications
 */
#define DECODER_STATUS_CHANGE_NOTIFY  _IO('7', 0)

#endif
