/*
 * linux/dgram_service.h
 *
 * Definitions for Inter Node Communication - datagram service
 *
 *   Copyright (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef DGRAM_SERVICE__H
#define DGRAM_SERVICE__H

/*standard header for datagram service*/
struct dgram_header_std {
	unsigned short dglen;	/*2byte-length of dgram*/
};

/*maximum size of datagram*/
#define DGRAM_MAX (0xffff - sizeof(struct dgram_header_std))

struct sk_dgram {
	struct socket *sk;		/*socket descriptor*/
	char *buf;			/*receive buffer*/
	int len;			/*len of receive buffer*/
	int proto;			/*used protocol*/
	int hlen;			/*size of used dgram header*/
	int received;			/*received bytes*/
	struct dgram_header_std h;	/*copy of received header*/
};

struct sk_dgram *dgram_init(struct socket *, int, void *);
int dgram_exit(struct sk_dgram *);
int dgram_send(struct sk_dgram *, void *, size_t);
int dgram_recv(struct sk_dgram *, void *, size_t);

#endif /* DGRAM_SERVICE__H */
